/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.print.AlkisPrintListener;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class ButlerGeometryComboBox
extends JComboBox {
    private final GEOM_FILTER_TYPE filter;

    public ButlerGeometryComboBox(GEOM_FILTER_TYPE filter) {
        this.filter = filter;
        this.setRenderer(new ButlerCbRenderer(filter));
        this.refresh();
    }

    public void refresh() {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        FeatureCollection fc = mc.getFeatureCollection();
        ArrayList<Geometry> objects = new ArrayList<Geometry>();
        objects.add(null);
        for (Feature f : fc.getAllFeatures()) {
            if (f instanceof AlkisPrintListener.PrintFeature) continue;
            Geometry g = CrsTransformer.transformToGivenCrs((Geometry)f.getGeometry(), (String)ClientAlkisConf.getInstance().getSrsService());
            if (this.filter != null && !this.validatesFilter(g, this.filter)) continue;
            objects.add(g);
        }
        this.setModel(new DefaultComboBoxModel<Object>(objects.toArray()));
    }

    private boolean validatesFilter(Geometry g, GEOM_FILTER_TYPE filter) {
        boolean isPoint = g instanceof Point;
        boolean isRect = g.isRectangle();
        if (filter == GEOM_FILTER_TYPE.POINT) {
            return isPoint;
        }
        if (filter == GEOM_FILTER_TYPE.RECTANGLE) {
            return g.isRectangle();
        }
        if (filter == GEOM_FILTER_TYPE.BOTH) {
            return isPoint || isRect;
        }
        return false;
    }

    private final class ButlerCbRenderer
    extends DefaultListCellRenderer {
        GEOM_FILTER_TYPE filter;

        public ButlerCbRenderer(GEOM_FILTER_TYPE filter) {
            this.setVerticalAlignment(0);
            this.filter = filter;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Geometry) {
                Geometry g = (Geometry)value;
                if (g instanceof Point) {
                    Point p = (Point)value;
                    double x = p.getX();
                    double y = p.getY();
                    DecimalFormat myFormatter = new DecimalFormat("#.###");
                    text = "Punkt " + myFormatter.format(x) + "/" + myFormatter.format(y);
                } else if (g.isRectangle()) {
                    Envelope env = ((Geometry)value).getEnvelopeInternal();
                    DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
                    formatSymbols.setDecimalSeparator('.');
                    DecimalFormat myFormatter = new DecimalFormat("#.###", formatSymbols);
                    text = "Rechteck ((" + myFormatter.format(env.getMinX()) + "," + myFormatter.format(env.getMinY()) + ")(" + myFormatter.format(env.getMaxX()) + "," + myFormatter.format(env.getMaxY()) + "))";
                } else {
                    text = value.toString();
                }
            } else {
                text = "keine Auswahl";
            }
            this.setText(text);
            return this;
        }
    }

    public static enum GEOM_FILTER_TYPE {
        POINT,
        RECTANGLE,
        BOTH;

    }
}

