/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.clientutils.SecresDownload;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSecresDownload
extends AbstractCancellableDownload
implements SecresDownload,
ConnectionContextProvider {
    private static final Logger LOG = log;
    private static final String SECRES_FORMAT = "%s/secres/%s/%s/%s";
    private final ConnectionContext connectionContext;

    public AbstractSecresDownload(String title, String directory, String targetFileBasename, String targetFileExtension, ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.title = title;
        this.setDirectory(directory);
        this.determineDestinationFile(targetFileBasename, targetFileExtension);
        this.status = Download.State.WAITING;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    protected final void setDirectory(String directory) {
        this.directory = directory;
    }

    protected final void setStatus(Download.State status) {
        this.status = status;
        this.stateChanged();
    }

    public void run() {
        if (!Download.State.WAITING.equals((Object)this.getStatus())) {
            return;
        }
        this.setStatus(Download.State.RUNNING);
        try (FileOutputStream outputStream = new FileOutputStream(this.fileToSaveTo);){
            URL secresUrl = this.getSecresURL();
            IOUtils.copyLarge((InputStream)WebAccessManager.getInstance().doRequest(secresUrl), (OutputStream)outputStream);
        }
        catch (Exception ex) {
            LOG.warn((Object)String.format("Couldn't write downloaded content to file '%s'.", this.getFileToSaveTo()), (Throwable)ex);
            super.error(ex);
            return;
        }
        if (Download.State.RUNNING.equals((Object)this.getStatus())) {
            this.setStatus(Download.State.COMPLETED);
            this.stateChanged();
        }
    }

    @Override
    public URL getSecresURL() throws Exception {
        String jwt = SessionManager.getSession().getUser().getJwsToken();
        String secresKey = this.getSecresKey();
        String secresApiBasePath = this.getSecresApiBasePath();
        String secresPath = this.getSecresPath();
        return new URL(String.format(SECRES_FORMAT, secresApiBasePath, jwt, secresKey, secresPath));
    }

    protected abstract String getSecresPath() throws Exception;

    protected abstract String getSecresApiBasePath() throws Exception;

    protected abstract String getSecresKey() throws Exception;
}

