/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungBaulastInfo;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CachedInfoBaulastRetriever {
    private static final Logger LOG = Logger.getLogger(CachedInfoBaulastRetriever.class);
    private final Map<BerechtigungspruefungBescheinigungBaulastInfo, CidsBean> cache = new HashMap<BerechtigungspruefungBescheinigungBaulastInfo, CidsBean>();

    private CachedInfoBaulastRetriever() {
    }

    public CidsBean loadBaulast(BerechtigungspruefungBescheinigungBaulastInfo info, ConnectionContext connectionContext) {
        if (this.cache.containsKey(info)) {
            return this.cache.get(info);
        }
        MetaClass mcBaulast = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"alb_baulast", (ConnectionContext)connectionContext);
        String query = "SELECT %d, id FROM alb_baulast WHERE blattnummer ILIKE '%s' AND laufende_nummer ILIKE '%s'";
        try {
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(String.format("SELECT %d, id FROM alb_baulast WHERE blattnummer ILIKE '%s' AND laufende_nummer ILIKE '%s'", mcBaulast.getID(), info.getBlattnummer(), info.getLaufende_nummer()), 0, connectionContext);
            this.cache.put(info, mos[0].getBean());
            return mos[0].getBean();
        }
        catch (ConnectionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public Map<BerechtigungspruefungBescheinigungBaulastInfo, CidsBean> getCache() {
        return this.cache;
    }

    public static CachedInfoBaulastRetriever getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final CachedInfoBaulastRetriever INSTANCE = new CachedInfoBaulastRetriever();

        private LazyInitialiser() {
        }
    }
}

