/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableComboboxCellEditor;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.sql.Date;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DatePickerCellEditor;

public class CidsBeansTable
extends JXTable
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(CidsBeansTable.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsBeansTable() {
        this(true);
    }

    public CidsBeansTable(boolean editable) {
        this.setEditable(editable);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setModel(CidsBeansTableModel model) {
        super.setModel((TableModel)model);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableModel model = this.getModel();
        if (model == null) {
            return null;
        }
        if (row < 0 || column < 0 || row >= model.getRowCount() || column >= model.getColumnCount()) {
            return null;
        }
        if (!this.getModel().isCellEditable(row, column)) {
            return null;
        }
        Class<?> columnClass = model.getColumnClass(column);
        if (columnClass != null) {
            if (CidsBean.class.equals(columnClass)) {
                CidsBeansTableModel cidsBeanModel;
                CidsBean cidsBean;
                if (model instanceof CidsBeansTableModel && (cidsBean = (cidsBeanModel = (CidsBeansTableModel)model).getCidsBean(row)) != null) {
                    String domain = cidsBean.getMetaObject().getDomain();
                    String columnProperty = cidsBeanModel.getColumnProperty(column);
                    int classId = cidsBean.getMetaObject().getAttributeByFieldName(columnProperty).getMai().getForeignKeyClassId();
                    try {
                        MetaClass metaClass = SessionManager.getProxy().getMetaClass(classId, domain, this.getConnectionContext());
                        return new DefaultBindableComboboxCellEditor(metaClass);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        return null;
                    }
                }
            } else if (Date.class.equals(columnClass)) {
                return new DatePickerCellEditor();
            }
        }
        return super.getCellEditor(row, column);
    }
}

