/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.aedsicad.aaaweb.rest.model.Buchungsblatt;
import de.cismet.cids.custom.clientutils.AlkisClientUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisRestUtils;
import de.cismet.cids.custom.utils.alkis.BaulastBescheinigungHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClientBaulastBescheinigungHelper
extends BaulastBescheinigungHelper {
    private static final Map<CidsBean, Buchungsblatt> BUCHUNGSBLATT_CACHE = new HashMap<CidsBean, Buchungsblatt>();

    public ClientBaulastBescheinigungHelper(ConnectionContext connectionContext) {
        super(SessionManager.getSession().getUser(), null, connectionContext);
    }

    protected Collection executeSearch(CidsServerSearch serverSearch) throws Exception {
        return SessionManager.getProxy().customServerSearch(serverSearch, this.getConnectionContext());
    }

    protected MetaObject getMetaObject(int oid, int cid) throws Exception {
        return SessionManager.getProxy().getMetaObject(oid, cid, "WUNDA_BLAU", this.getConnectionContext());
    }

    protected MetaObject[] getMetaObjects(String query) throws Exception {
        return SessionManager.getProxy().getMetaObjectByQuery(query, 0, this.getConnectionContext());
    }

    protected MetaClass getMetaClass(String name) {
        return ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)name, (ConnectionContext)this.getConnectionContext());
    }

    protected Buchungsblatt getBuchungsblatt(CidsBean buchungsblattBean) throws Exception {
        String buchungsblattcode;
        Buchungsblatt buchungsblatt = null;
        if (buchungsblattBean != null && (buchungsblatt = BUCHUNGSBLATT_CACHE.get(buchungsblattBean)) == null && (buchungsblattcode = String.valueOf(buchungsblattBean.getProperty("buchungsblattcode"))) != null && buchungsblattcode.length() > 5) {
            buchungsblatt = ClientAlkisRestUtils.getBuchungsblatt(AlkisClientUtils.fixBuchungslattCode(buchungsblattcode), this.getConnectionContext());
            BUCHUNGSBLATT_CACHE.put(buchungsblattBean, buchungsblatt);
        }
        return buchungsblatt;
    }
}

