/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import de.cismet.cids.custom.clientutils.DmsUrlPanel;
import de.cismet.cids.custom.clientutils.DmsUrlPathMapper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.URLSplitter;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.FlowLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DmsUrlsPanel
extends JPanel
implements DropTargetListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(DmsUrlsPanel.class);
    private Collection<CidsBean> dmsUrls;
    private ConnectionContext connectionContext;
    private final String domain;

    @Deprecated
    public DmsUrlsPanel() {
        this((String)null);
    }

    public DmsUrlsPanel(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    private CidsBean createNewDmsUrl(String url, String description, int typ) throws Exception {
        URLSplitter splitter = new URLSplitter(url);
        CidsBean dmsUrlBean = CidsBean.createNewCidsBeanFromTableName((String)this.getDomain(), (String)"dms_url", (ConnectionContext)this.getConnectionContext());
        CidsBean urlBaseBean = CidsBean.createNewCidsBeanFromTableName((String)this.getDomain(), (String)"url_base", (ConnectionContext)this.getConnectionContext());
        CidsBean urlBean = CidsBean.createNewCidsBeanFromTableName((String)this.getDomain(), (String)"url", (ConnectionContext)this.getConnectionContext());
        dmsUrlBean.setProperty("name", (Object)description);
        dmsUrlBean.setProperty("typ", (Object)typ);
        urlBaseBean.setProperty("path", (Object)splitter.getPath());
        urlBaseBean.setProperty("prot_prefix", (Object)splitter.getProt_prefix());
        urlBaseBean.setProperty("server", (Object)splitter.getServer());
        urlBean.setProperty("object_name", (Object)splitter.getObject_name());
        urlBean.setProperty("url_base_id", (Object)urlBaseBean);
        dmsUrlBean.setProperty("url", (Object)urlBean);
        return dmsUrlBean;
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0));
    }

    public void addDmsUrl(CidsBean dmsUrl) {
        this.dmsUrls.add(dmsUrl);
        this.refresh();
    }

    public void setDmsUrls(Collection<CidsBean> dmsUrls) {
        this.dmsUrls = dmsUrls;
        this.refresh();
    }

    public Collection<CidsBean> getDmsUrls() {
        return this.dmsUrls;
    }

    private DmsUrlPanel createDmsUrlPanel(CidsBean dmsUrlBean) {
        DmsUrlPanel dp = new DmsUrlPanel(dmsUrlBean);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Typ des neuen DocPanels: " + dp.getTyp()));
        }
        dp.setDeletable(true);
        dp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof DmsUrlPanel) {
                    DmsUrlPanel docPanel = (DmsUrlPanel)e.getSource();
                    if (e.getActionCommand().equals("DELETE_ACTION")) {
                        DmsUrlsPanel.this.remove(docPanel);
                        DmsUrlsPanel.this.revalidate();
                        DmsUrlsPanel.this.dmsUrls.remove(docPanel.getDMSUrlBean());
                        DmsUrlsPanel.this.repaint();
                    }
                }
            }
        });
        return dp;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        String description;
        dtde.acceptDrop(1);
        String url = StaticSwingTools.getLinkFromDropEvent((DropTargetDropEvent)dtde);
        if (url != null && (description = JOptionPane.showInputDialog(this, "Welche Beschriftung soll der Link haben?", url)) != null) {
            try {
                CidsBean dmsUrlBean = this.createNewDmsUrl(DmsUrlPathMapper.getInstance().replaceLocalPath(url), description, 1);
                this.dmsUrls.add(dmsUrlBean);
                this.add(this.createDmsUrlPanel(dmsUrlBean));
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isEnabled()) {
            dtde.rejectDrag();
        }
    }

    public void refresh() {
        this.removeAll();
        if (this.dmsUrls != null) {
            for (CidsBean dmsUrlBean : this.dmsUrls) {
                try {
                    this.add(this.createDmsUrlPanel(dmsUrlBean));
                }
                catch (Exception e) {
                    LOG.error((Object)"Fehler beim laden eines Dokumentes", (Throwable)e);
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        DropTarget dt = new DropTarget(this, 3, this);
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

