/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.clientutils.AbstractSecresDownload;
import de.cismet.cids.custom.clientutils.ServerResourcesLoaderClient;
import de.cismet.cids.custom.utils.PotenzialflaechenProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.actions.PotenzialflaecheReportServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.PropertiesServerResource;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.util.ArrayList;
import java.util.Collection;

public class PotenzialflaecheReportDownload
extends AbstractSecresDownload {
    private final Type type;
    private final boolean zip;
    private final Collection<CidsBean> beans;
    private final CidsBean templateBean;
    private final PotenzialflaechenProperties potenzialflaecheProperties = new PotenzialflaechenProperties();

    public PotenzialflaecheReportDownload(Type type, boolean zip, CidsBean templateBean, Collection<CidsBean> beans, ConnectionContext connectionContext) throws Exception {
        super(PotenzialflaecheReportDownload.getTitle(type, beans, templateBean), DownloadManagerDialog.getInstance().getJobName(), PotenzialflaecheReportDownload.getTargetFileBasename(type, beans, templateBean), zip ? ".zip" : ".pdf", connectionContext);
        this.getPotenzialflaecheProperties().setProperties(ServerResourcesLoaderClient.getInstance().loadProperties((PropertiesServerResource)WundaBlauServerResources.POTENZIALFLAECHEN_PROPERTIES.getValue()));
        this.type = type;
        this.zip = zip;
        this.beans = beans;
        this.templateBean = templateBean;
        if (this.templateBean == null) {
            throw new Exception("templateBean has to be given");
        }
        if (this.beans == null || this.beans.isEmpty()) {
            throw new Exception("flaecheBeans xor kategorieBeans has to be given");
        }
    }

    public static String getTargetFileBasename(Type type, Collection<CidsBean> beans, CidsBean templateBean) {
        CidsBean singleFlaecheBean = PotenzialflaecheReportDownload.getSingleFlaeche(type, beans);
        CidsBean singleKategorieBean = PotenzialflaecheReportDownload.getSingleKategorie(type, beans);
        String baseName = String.format("%s_%s", (String)templateBean.getProperty("bezeichnung"), singleFlaecheBean != null ? (String)singleFlaecheBean.getProperty("nummer") : (singleKategorieBean != null ? (String)singleKategorieBean.getProperty("bezeichnung") : "diverse_flaechen"));
        return baseName;
    }

    private static CidsBean getSingleFlaeche(Type type, Collection<CidsBean> beans) {
        return Type.FLAECHE.equals((Object)type) ? PotenzialflaecheReportDownload.getSingleBean(beans) : null;
    }

    private static CidsBean getSingleKategorie(Type type, Collection<CidsBean> beans) {
        return Type.KATEGORIE.equals((Object)type) ? PotenzialflaecheReportDownload.getSingleBean(beans) : null;
    }

    private static CidsBean getSingleBean(Collection<CidsBean> beans) {
        return beans != null && beans.size() == 1 ? beans.iterator().next() : null;
    }

    public static String getTitle(Type type, Collection<CidsBean> beans, CidsBean templateBean) {
        CidsBean singleFlaecheBean = PotenzialflaecheReportDownload.getSingleFlaeche(type, beans);
        CidsBean singleKategorieBean = PotenzialflaecheReportDownload.getSingleKategorie(type, beans);
        return String.format("%s - %s", (String)templateBean.getProperty("bezeichnung"), singleFlaecheBean != null ? (String)singleFlaecheBean.getProperty("bezeichnung") : (singleKategorieBean != null ? (String)singleKategorieBean.getProperty("bezeichnung") : "Potenzialfl\u00e4chen"));
    }

    @Override
    public String getSecresPath() throws Exception {
        ArrayList<ServerActionParameter> params = new ArrayList<ServerActionParameter>();
        Collection<CidsBean> beans = this.getBeans();
        Type type = this.getType();
        if (beans != null && type != null) {
            for (CidsBean flaecheBean : beans) {
                params.add(new ServerActionParameter((Type.FLAECHE.equals((Object)type) ? PotenzialflaecheReportServerAction.Parameter.POTENZIALFLAECHE : PotenzialflaecheReportServerAction.Parameter.KATEGORIE).toString(), (Object)new MetaObjectNode(flaecheBean)));
            }
        }
        params.add(new ServerActionParameter(PotenzialflaecheReportServerAction.Parameter.TEMPLATE.toString(), (Object)new MetaObjectNode(this.templateBean)));
        params.add(new ServerActionParameter(PotenzialflaecheReportServerAction.Parameter.RESULT_TYPE.toString(), (Object)(this.isZip() ? PotenzialflaecheReportServerAction.ResultType.ZIP : PotenzialflaecheReportServerAction.ResultType.PDF)));
        Object ret = SessionManager.getProxy().executeTask("potenzialflaecheReport", "WUNDA_BLAU", null, this.getConnectionContext(), params.toArray(new ServerActionParameter[0]));
        if (ret instanceof Exception) {
            Exception ex = (Exception)ret;
            throw ex;
        }
        return (String)ret;
    }

    @Override
    public String getSecresApiBasePath() throws Exception {
        return this.getPotenzialflaecheProperties().getSecresApi();
    }

    @Override
    public String getSecresKey() throws Exception {
        return this.getPotenzialflaecheProperties().getSecresKey();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isZip() {
        return this.zip;
    }

    public Collection<CidsBean> getBeans() {
        return this.beans;
    }

    public CidsBean getTemplateBean() {
        return this.templateBean;
    }

    public PotenzialflaechenProperties getPotenzialflaecheProperties() {
        return this.potenzialflaecheProperties;
    }

    public static enum Type {
        FLAECHE,
        KATEGORIE;

    }
}

