/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.clientutils.ClientStadtbilderConf;
import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.FastBindableReferenceCombo;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class StadtbilderUtils {
    private static final Logger LOG = Logger.getLogger(StadtbilderUtils.class);
    public static BufferedImage ERROR_IMAGE;
    public static BufferedImage PLACEHOLDER_IMAGE;
    private static CidsBean WUPPERTAL;
    private static CidsBean R102;
    private static final ConcurrentLRUCache<StadtbildInfo, SoftReference<BufferedImage>> IMAGE_CACHE;
    private static final ConcurrentHashMap<StadtbildInfo, String> FAILED_IMAGES;
    private static final PriorityExecutor unboundUEHThreadPoolExecutor;
    public static final int HIGH_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 0;
    public static final int LOW_PRIORITY = -1;

    public static CidsBean getWuppertal(ConnectionContext connectionContext) {
        if (WUPPERTAL == null) {
            WUPPERTAL = StadtbilderUtils.getOrtWuppertal(connectionContext);
        }
        return WUPPERTAL;
    }

    public static void simulateGC() {
        Set keys = ((ConcurrentLRUCache)IMAGE_CACHE).map.keySet();
        for (StadtbildInfo key : keys) {
            IMAGE_CACHE.get(key).clear();
        }
    }

    public static String getArcUrlPath(String bildnummer) {
        return ClientStadtbilderConf.getInstance().getPreviewUrlBase() + ClientStadtbilderConf.getInstance().getArcLocationTemplate().replace("{imageNumber}", bildnummer);
    }

    public static CidsBean getR102(ConnectionContext connectionContext) {
        if (R102 == null) {
            R102 = StadtbilderUtils.getLagerR102(connectionContext);
        }
        return R102;
    }

    private static CidsBean getOrtWuppertal(ConnectionContext connectionContext) {
        block6: {
            try {
                MetaClass ortClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"sb_ort", (ConnectionContext)connectionContext);
                if (ortClass == null) break block6;
                StringBuffer wuppertalQuery = new StringBuffer("select ").append(ortClass.getId()).append(", ").append(ortClass.getPrimaryKey()).append(" from ").append(ortClass.getTableName()).append(" where name ilike 'Wuppertal'");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: wuppertalQuery:" + wuppertalQuery.toString()));
                }
                try {
                    MetaObject[] wuppertal = SessionManager.getProxy().getMetaObjectByQuery(wuppertalQuery.toString(), 0, connectionContext);
                    if (wuppertal.length > 0) {
                        return wuppertal[0].getBean();
                    }
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"The Location Wuppertal could not be loaded.", (Throwable)ex);
            }
        }
        return null;
    }

    private static CidsBean getLagerR102(ConnectionContext connectionContext) {
        block6: {
            try {
                MetaClass lagerClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"sb_lager", (ConnectionContext)connectionContext);
                if (lagerClass == null) break block6;
                StringBuffer r102Query = new StringBuffer("select ").append(lagerClass.getId()).append(", ").append(lagerClass.getPrimaryKey()).append(" from ").append(lagerClass.getTableName()).append(" where name = 'R102'");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: r102Query:" + r102Query.toString()));
                }
                try {
                    MetaObject[] r102 = SessionManager.getProxy().getMetaObjectByQuery(r102Query.toString(), 0, connectionContext);
                    if (r102.length > 0) {
                        return r102[0].getBean();
                    }
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"The storage location R102 could not be loaded.", (Throwable)ex);
            }
        }
        return null;
    }

    public static void setModelForComboBoxesAndDecorateIt(JComboBox combobox, String className, ConnectionContext connectionContext) {
        MetaClass metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)className, (ConnectionContext)connectionContext);
        if (metaClass != null) {
            try {
                FastBindableReferenceCombo tempFastBindableCombo = new FastBindableReferenceCombo();
                new DummyContextPanel(connectionContext).add((Component)tempFastBindableCombo);
                tempFastBindableCombo.setSorted(true);
                tempFastBindableCombo.setNullable(true);
                tempFastBindableCombo.setMetaClass(metaClass);
                DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)tempFastBindableCombo.getModel();
                combobox.setModel(comboBoxModel);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)combobox);
        } else {
            LOG.warn((Object)("MetaClass is null. Probably the permissions for the class " + className + " are missing."));
        }
    }

    public static URL getURLOfLowResPicture(StadtbildInfo stadtbildInfo) {
        for (URL url : ClientStadtbilderConf.getInstance().getPreviewPictureUrls(stadtbildInfo.getBildnummer(), stadtbildInfo.getBildtypId(), stadtbildInfo.getJahr(), stadtbildInfo.getBlickrichtung())) {
            if (!WebAccessManager.getInstance().checkIfURLaccessible(url)) continue;
            return url;
        }
        return null;
    }

    public static String getFormatOfHighResPicture(StadtbildInfo stadtbildInfo) {
        for (URL url : ClientStadtbilderConf.getInstance().getHighresPictureUrls(stadtbildInfo.getBildnummer(), stadtbildInfo.getBildtypId(), stadtbildInfo.getJahr(), stadtbildInfo.getBlickrichtung())) {
            if (!WebAccessManager.getInstance().checkIfURLaccessible(url)) continue;
            return url.toString().substring(url.toString().lastIndexOf(".") + 1);
        }
        return null;
    }

    public static BufferedImage downloadImageForBildnummer(StadtbildInfo stadtbildInfo) throws Exception {
        if (StadtbilderUtils.isBildnummerInCacheOrFailed(stadtbildInfo)) {
            SoftReference<BufferedImage> cachedImageRef = IMAGE_CACHE.get(stadtbildInfo);
            if (cachedImageRef != null) {
                return cachedImageRef.get();
            }
            return null;
        }
        URL urlLowResImage = StadtbilderUtils.getURLOfLowResPicture(stadtbildInfo);
        if (urlLowResImage != null) {
            InputStream is = null;
            try {
                is = WebAccessManager.getInstance().doRequest(urlLowResImage);
                BufferedImage img = ImageIO.read(is);
                if (img != null) {
                    IMAGE_CACHE.put(stadtbildInfo, new SoftReference<BufferedImage>(img));
                } else {
                    FAILED_IMAGES.put(stadtbildInfo, "The image for " + stadtbildInfo.bildnummer + " returned from the server was apparently null.");
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            catch (Exception ex) {
                FAILED_IMAGES.put(stadtbildInfo, ex.getMessage());
                throw ex;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        LOG.warn((Object)"Error during closing InputStream.", (Throwable)ex);
                    }
                }
            }
        }
        return null;
    }

    public static Object fetchImageForBildnummer(CidsBean statdbildserie, StadtbildInfo stadtbildInfo, int priority, ConnectionContext connectionContext) {
        BufferedImage ret;
        SoftReference<BufferedImage> cachedImageRef;
        if (StadtbilderUtils.isBildnummerInCacheOrFailed(stadtbildInfo) && (cachedImageRef = IMAGE_CACHE.get(stadtbildInfo)) != null && (ret = cachedImageRef.get()) != null) {
            return ret;
        }
        Future<Image> futureImage = unboundUEHThreadPoolExecutor.submit(new FetchImagePriorityCallable(statdbildserie, stadtbildInfo, connectionContext), priority);
        return futureImage;
    }

    public static boolean isBildnummerInCacheOrFailed(StadtbildInfo stadtbildInfo) {
        return stadtbildInfo != null && (((ConcurrentLRUCache)StadtbilderUtils.IMAGE_CACHE).containsKey(stadtbildInfo) && IMAGE_CACHE.get(stadtbildInfo).get() != null || FAILED_IMAGES.containsKey(stadtbildInfo));
    }

    public static boolean isBildnummerInFailedSet(StadtbildInfo stadtbildInfo) {
        return FAILED_IMAGES.containsKey(stadtbildInfo);
    }

    public static String getErrorMessageForFailedImage(StadtbildInfo stadtbildInfo) {
        String message = FAILED_IMAGES.get(stadtbildInfo);
        if (StringUtils.isBlank((String)message)) {
            message = "No message for image " + stadtbildInfo.bildnummer;
        }
        return message;
    }

    public static void cacheImagesForStadtbilder(CidsBean stadtbildserie, List<CidsBean> stadtbilder, ConnectionContext connectionContext) {
        for (int i = 0; i < ClientStadtbilderConf.getInstance().getCacheSize() && i < stadtbilder.size(); ++i) {
            CidsBean stadtbild = stadtbilder.get(i);
            try {
                StadtbildInfo stadtbildInfo = new StadtbildInfo(stadtbildserie, stadtbild);
                StadtbilderUtils.fetchImageForBildnummer(stadtbildserie, stadtbildInfo, 0, connectionContext);
                continue;
            }
            catch (Exception ex) {
                LOG.error((Object)("Problem while loading image " + (String)stadtbild.getProperty("bildnummer")));
            }
        }
    }

    public static void removeBildnummerFromImageCacheAndFailedSet(StadtbildInfo stadtbildInfo) {
        ((ConcurrentLRUCache)StadtbilderUtils.IMAGE_CACHE).remove(stadtbildInfo);
        FAILED_IMAGES.remove(stadtbildInfo);
    }

    public static void removeBildnummerFromFailedSet(StadtbildInfo stadtbildInfo) {
        FAILED_IMAGES.remove(stadtbildInfo);
    }

    public static Image scaleImage(Image toScale, int dimension, boolean showWholePicture) {
        if (toScale instanceof BufferedImage) {
            if (toScale.getWidth(null) > dimension && toScale.getHeight(null) > dimension) {
                if (showWholePicture) {
                    return GraphicsUtilities.createThumbnail((BufferedImage)((BufferedImage)toScale), (int)dimension);
                }
                double reduce = (double)Math.min(toScale.getWidth(null), toScale.getHeight(null)) * 1.0 / (double)dimension;
                int newWidth = (int)Math.round((double)toScale.getWidth(null) / reduce);
                int newHeight = (int)Math.round((double)toScale.getHeight(null) / reduce);
                BufferedImage thumbnail = GraphicsUtilities.createThumbnail((BufferedImage)((BufferedImage)toScale), (int)newWidth, (int)newHeight);
                try {
                    return thumbnail.getSubimage((thumbnail.getWidth() - dimension) / 2, (thumbnail.getHeight() - dimension) / 2, dimension, dimension);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Something went wrong while cropping the image.", (Throwable)ex);
                    return GraphicsUtilities.createThumbnail((BufferedImage)((BufferedImage)toScale), (int)dimension, (int)dimension);
                }
            }
            if (toScale.getWidth(null) < dimension || toScale.getHeight(null) < dimension) {
                return StadtbilderUtils.oldScaleImage(toScale, dimension, showWholePicture);
            }
            return toScale;
        }
        return toScale;
    }

    private static Image oldScaleImage(Image toScale, int dimension, boolean showWholePicture) {
        Image toReturn = toScale;
        if (toReturn instanceof BufferedImage) {
            toReturn = toScale.getHeight(null) > toScale.getWidth(null) ^ showWholePicture ? ((BufferedImage)toReturn).getScaledInstance(dimension, -1, 4) : ((BufferedImage)toReturn).getScaledInstance(-1, dimension, 4);
        }
        return GraphicsUtilities.convertToBufferedImage((Image)toReturn);
    }

    static {
        IMAGE_CACHE = new ConcurrentLRUCache(ClientStadtbilderConf.getInstance().getCacheSize());
        FAILED_IMAGES = new ConcurrentHashMap();
        try {
            ERROR_IMAGE = ImageIO.read(StadtbilderUtils.class.getResourceAsStream("/de/cismet/cids/custom/objecteditors/wunda_blau/no_image.png"));
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not fetch ERROR_IMAGE", (Throwable)ex);
        }
        try {
            PLACEHOLDER_IMAGE = ImageIO.read(StadtbilderUtils.class.getResourceAsStream("/de/cismet/cids/custom/objecteditors/wunda_blau/wait_image.png"));
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not fetch ERROR_IMAGE", (Throwable)ex);
        }
        SecurityManager s = System.getSecurityManager();
        ThreadGroup parent = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup = new ThreadGroup(parent, "stadtbilderAggregationRendererDownload");
        CismetConcurrency.CismetThreadFactory factory = new CismetConcurrency.CismetThreadFactory(threadGroup, "stadtbilderAggregationRendererDownload", null);
        PriorityBlockingQueue<Runnable> queue = new PriorityBlockingQueue<Runnable>();
        unboundUEHThreadPoolExecutor = new PriorityExecutor(10, 10, 180L, TimeUnit.SECONDS, queue, (ThreadFactory)factory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static class StadtbildInfo {
        private String bildnummer;
        private Integer bildtypId;
        private Integer jahr;
        private String blickrichtung;

        public StadtbildInfo(CidsBean stadtbildserie, CidsBean stadtbild) {
            Integer jahr;
            String bildnummer = (String)stadtbild.getProperty("bildnummer");
            Integer bildtypId = (Integer)stadtbildserie.getProperty("bildtyp.id");
            Date aufnahmedatum = (Date)stadtbildserie.getProperty("aufnahmedatum");
            if (aufnahmedatum != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(aufnahmedatum);
                jahr = calendar.get(1);
            } else {
                jahr = null;
            }
            this.jahr = jahr;
            this.bildnummer = bildnummer;
            this.bildtypId = bildtypId;
            this.blickrichtung = (String)stadtbildserie.getProperty("blickrichtung.schluessel");
        }

        public String getBildnummer() {
            return this.bildnummer;
        }

        public Integer getBildtypId() {
            return this.bildtypId;
        }

        public Integer getJahr() {
            return this.jahr;
        }

        public String getBlickrichtung() {
            return this.blickrichtung;
        }

        public int hashCode() {
            int hash = 7;
            return 7;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StadtbildInfo other = (StadtbildInfo)obj;
            if (!Objects.equals(this.bildnummer, other.bildnummer)) {
                return false;
            }
            if (!Objects.equals(this.bildtypId, other.bildtypId)) {
                return false;
            }
            return Objects.equals(this.jahr, other.jahr);
        }
    }

    private static class DummyContextPanel
    extends JPanel
    implements ConnectionContextProvider {
        private final ConnectionContext connectionContext;

        DummyContextPanel(ConnectionContext connectionContext) {
            this.connectionContext = connectionContext;
        }

        public ConnectionContext getConnectionContext() {
            return this.connectionContext;
        }
    }

    public static class ConcurrentLRUCache<Key, Value> {
        private final int maxSize;
        private ConcurrentHashMap<Key, Value> map;
        private ConcurrentLinkedQueue<Key> queue;

        public ConcurrentLRUCache(int maxSize) {
            this.maxSize = maxSize;
            this.map = new ConcurrentHashMap(maxSize);
            this.queue = new ConcurrentLinkedQueue();
        }

        public void put(Key key, Value value) {
            this.queue.remove(key);
            while (this.queue.size() >= this.maxSize) {
                Key oldestKey = this.queue.poll();
                if (null == oldestKey) continue;
                this.map.remove(oldestKey);
            }
            this.queue.add(key);
            this.map.put(key, value);
        }

        public Value get(Key key) {
            if (this.queue.remove(key)) {
                this.queue.add(key);
            }
            return this.map.get(key);
        }

        private boolean containsKey(Key bildnummer) {
            return this.map.containsKey(bildnummer);
        }

        private void remove(Key key) {
            this.queue.remove(key);
            this.map.get(key);
        }
    }

    private static class PriorityExecutor
    extends ThreadPoolExecutor {
        public PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
        }

        public PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectHandler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, rejectHandler);
        }

        public Future<?> submit(Runnable task, int priority) {
            return super.submit(new ComparableFutureTask<Object>(task, null, priority));
        }

        public <T> Future<T> submit(Callable<T> task, int priority) {
            if (task == null) {
                throw new NullPointerException();
            }
            ComparableFutureTask<T> ftask = new ComparableFutureTask<T>(task, priority);
            this.execute(ftask);
            return ftask;
        }

        public void execute(Runnable command, int priority) {
            super.execute(new ComparableFutureTask<Object>(command, null, priority));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return (RunnableFuture)((Object)callable);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return (RunnableFuture)runnable;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t == null && r instanceof Future) {
                Throwable thrown = null;
                try {
                    if (!((Future)((Object)r)).isCancelled()) {
                        ((Future)((Object)r)).get();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    thrown = ex.getCause();
                }
                catch (Throwable tw) {
                    thrown = tw;
                }
                if (thrown != null) {
                    Thread thread = Thread.currentThread();
                    Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
                    if (handler == null) {
                        ThreadGroup groupHandler = thread.getThreadGroup();
                        if (groupHandler == null) {
                            Thread.UncaughtExceptionHandler defHandler = Thread.getDefaultUncaughtExceptionHandler();
                            if (defHandler != null) {
                                defHandler.uncaughtException(thread, thrown);
                            }
                        } else {
                            groupHandler.uncaughtException(thread, thrown);
                        }
                    } else {
                        handler.uncaughtException(thread, thrown);
                    }
                }
            }
        }
    }

    private static class FetchImagePriorityCallable
    implements Callable<Image> {
        final CidsBean stadtbildserie;
        final StadtbildInfo stadtbildInfo;
        final ConnectionContext connectionContext;

        public FetchImagePriorityCallable(CidsBean stadtbildserie, StadtbildInfo stadtbildInfo, ConnectionContext connectionContext) {
            this.stadtbildserie = stadtbildserie;
            this.stadtbildInfo = stadtbildInfo;
            this.connectionContext = connectionContext;
        }

        @Override
        public Image call() throws Exception {
            if (!Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(this.stadtbildserie, this.connectionContext).isPreviewAllowed()) {
                FAILED_IMAGES.put(this.stadtbildInfo, "The user is not allowed to see the image " + this.stadtbildInfo.bildnummer);
                return null;
            }
            if (StadtbilderUtils.isBildnummerInCacheOrFailed(this.stadtbildInfo)) {
                SoftReference cachedImageRef = (SoftReference)IMAGE_CACHE.get(this.stadtbildInfo);
                if (cachedImageRef != null) {
                    return (Image)cachedImageRef.get();
                }
                return null;
            }
            URL urlLowResImage = StadtbilderUtils.getURLOfLowResPicture(this.stadtbildInfo);
            if (urlLowResImage != null) {
                InputStream is = null;
                try {
                    is = WebAccessManager.getInstance().doRequest(urlLowResImage);
                    BufferedImage img = ImageIO.read(is);
                    if (img != null) {
                        IMAGE_CACHE.put(this.stadtbildInfo, new SoftReference<BufferedImage>(img));
                    } else {
                        FAILED_IMAGES.put(this.stadtbildInfo, "The image " + this.stadtbildInfo.bildnummer + " returned from the server was apparently null.");
                    }
                    BufferedImage bufferedImage = img;
                    return bufferedImage;
                }
                catch (Exception ex) {
                    FAILED_IMAGES.put(this.stadtbildInfo, ex.getMessage());
                    throw ex;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            LOG.warn((Object)"Error during closing InputStream.", (Throwable)ex);
                        }
                    }
                }
            }
            FAILED_IMAGES.put(this.stadtbildInfo, "No url exists to retrieve the image " + this.stadtbildInfo.bildnummer + ".");
            return null;
        }
    }

    static class ComparableFutureTask<T>
    extends FutureTask<T>
    implements Comparable<ComparableFutureTask<T>> {
        volatile int priority = 0;

        public ComparableFutureTask(Callable<T> callable, int priority) {
            super(callable);
            this.priority = priority;
        }

        public ComparableFutureTask(Runnable runnable, T result, int priority) {
            super(runnable, result);
            this.priority = priority;
        }

        @Override
        public int compareTo(ComparableFutureTask<T> o) {
            return Integer.valueOf(this.priority).compareTo(o.priority);
        }
    }
}

