/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.commons.searchgeometrylistener;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.Node;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AbstractCreateSearchGeometryListener;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public abstract class NodesSearchCreateSearchGeometryListener
extends AbstractCreateSearchGeometryListener
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(NodesSearchCreateSearchGeometryListener.class);
    public static final String INPUT_LISTENER_NAME = "CREATE_CUSTOMSEARCH_GEOMETRY";
    public static final String ACTION_SEARCH_STARTED = "ACTION_SEARCH_STARTED";
    public static final String ACTION_SEARCH_DONE = "ACTION_SEARCH_DONE";
    public static final String ACTION_SEARCH_FAILED = "ACTION_SEARCH_FAILED";
    private final ConnectionContext connectionContext;

    public NodesSearchCreateSearchGeometryListener(MappingComponent mc, PropertyChangeListener propChangeListener, ConnectionContext connectionContext) {
        super(mc, INPUT_LISTENER_NAME);
        this.connectionContext = connectionContext;
        this.setMode("POLYGON");
        this.addPropertyChangeListener(propChangeListener);
    }

    public abstract CidsServerSearch getCidsServerSearch(Geometry var1);

    public abstract String getCrs();

    protected boolean performSearch(SearchFeature searchFeature) {
        Geometry geometry;
        String crs = this.getCrs();
        if (crs != null) {
            int srid = CrsTransformer.extractSridFromCrs((String)crs);
            geometry = CrsTransformer.transformToGivenCrs((Geometry)searchFeature.getGeometry(), (String)crs);
            geometry.setSRID(srid);
        } else {
            geometry = searchFeature.getGeometry();
        }
        final CidsServerSearch search = this.getCidsServerSearch(geometry);
        final PropertyChangeSupport propChangeSupport = this.getPropertyChangeSupport();
        propChangeSupport.firePropertyChange(ACTION_SEARCH_STARTED, null, geometry);
        new SwingWorker<Node[], Void>(){

            @Override
            protected Node[] doInBackground() throws Exception {
                Node[] result = null;
                Collection searchResult = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), search, NodesSearchCreateSearchGeometryListener.this.getConnectionContext());
                if (this.isCancelled()) {
                    return result;
                }
                ArrayList<Node> nodes = new ArrayList<Node>(searchResult.size());
                for (Object singleSearchResult : searchResult) {
                    nodes.add((Node)singleSearchResult);
                    if (!this.isCancelled()) continue;
                    return result;
                }
                result = nodes.toArray(new Node[0]);
                return result;
            }

            @Override
            protected void done() {
                try {
                    Node[] nodes = (Node[])this.get();
                    if (nodes == null) {
                        propChangeSupport.firePropertyChange(NodesSearchCreateSearchGeometryListener.ACTION_SEARCH_FAILED, null, new Exception("Fehler w\u00e4hrend der Suche."));
                    } else {
                        propChangeSupport.firePropertyChange(NodesSearchCreateSearchGeometryListener.ACTION_SEARCH_DONE, null, nodes);
                    }
                }
                catch (Exception ex) {
                    propChangeSupport.firePropertyChange(NodesSearchCreateSearchGeometryListener.ACTION_SEARCH_FAILED, null, ex);
                }
            }
        }.execute();
        return true;
    }

    protected PNode getPointerAnnotation() {
        return null;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

