/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class AlkisPointFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final Logger LOG = Logger.getLogger(AlkisPointFeatureRenderer.class);
    private static final String PATH2ICONS = "/de/cismet/cids/custom/featurerenderer/wunda_blau/";
    private static final HashMap<String, String> pointtypeIcons = new HashMap(6);
    private static final HashMap<String, Color> pointtypeColors = new HashMap(6);
    private Color alkisPointColor = new Color(0, 0, 255);
    private ImageIcon alkisPointIcon;

    public void setMetaObject(MetaObject metaObject) throws ConnectionException {
        super.setMetaObject(metaObject);
        if (this.cidsBean != null) {
            String bezeichnung = null;
            try {
                bezeichnung = ((CidsBean)this.cidsBean.getProperty("pointtype")).getProperty("bezeichnung").toString();
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not determine cidsBeans pointtype. Is it an alkis point?", (Throwable)e);
            }
            if (bezeichnung == null || !pointtypeColors.containsKey(bezeichnung)) {
                LOG.warn((Object)("There is no icon or color defined for pointtype '" + bezeichnung + "'. Using default."));
                return;
            }
            URL urlToIcon = ((Object)((Object)this)).getClass().getResource(pointtypeIcons.get(bezeichnung));
            if (urlToIcon != null) {
                this.alkisPointIcon = new ImageIcon(urlToIcon);
            }
            if (pointtypeColors.containsKey(bezeichnung)) {
                this.alkisPointColor = pointtypeColors.get(bezeichnung);
            }
        }
    }

    public Paint getLinePaint(CidsFeature subFeature) {
        return this.getFillingStyle();
    }

    public Paint getFillingStyle(CidsFeature subFeature) {
        return this.alkisPointColor;
    }

    public FeatureAnnotationSymbol getPointSymbol() {
        FeatureAnnotationSymbol result;
        if (this.alkisPointIcon != null && this.alkisPointIcon != null) {
            result = new FeatureAnnotationSymbol(this.alkisPointIcon.getImage());
            result.setSweetSpotX(0.49);
            result.setSweetSpotY(0.93);
        } else {
            int fallbackSymbolSize = 8;
            BufferedImage bufferedImage = new BufferedImage(8, 8, 2);
            Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
            graphics.setColor(this.alkisPointColor);
            graphics.fillOval(0, 0, 8, 8);
            result = new FeatureAnnotationSymbol((Image)bufferedImage);
            result.setSweetSpotX(0.5);
            result.setSweetSpotY(0.5);
        }
        return result;
    }

    public void assign() {
    }

    public float getTransparency() {
        return 0.9f;
    }

    static {
        pointtypeIcons.put("Aufnahmepunkt", "/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_red.png");
        pointtypeIcons.put("Sonstiger Vermessungspunkt", "/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_orange.png");
        pointtypeIcons.put("Grenzpunkt", "/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_green.png");
        pointtypeIcons.put("Besonderer Gebaeudepunkt", "/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_yellow.png");
        pointtypeIcons.put("Besonderer Bauwerkspunkt", "/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_gray.png");
        pointtypeIcons.put("Besonderer Topographischer Punkt", "/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_sienna.png");
        pointtypeColors.put("Aufnahmepunkt", new Color(255, 0, 0));
        pointtypeColors.put("Sonstiger Vermessungspunkt", new Color(255, 69, 0));
        pointtypeColors.put("Grenzpunkt", new Color(0, 128, 0));
        pointtypeColors.put("Besonderer Gebaeudepunkt", new Color(255, 255, 0));
        pointtypeColors.put("Besonderer Bauwerkspunkt", new Color(128, 128, 128));
        pointtypeColors.put("Besonderer Topographischer Punkt", new Color(160, 82, 45));
    }
}

