/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.gui.piccolo.SelectionAwareTexturePaint;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class KkKompensationFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final Logger LOG = Logger.getLogger(KkKompensationFeatureRenderer.class);
    private static final Map<String, BufferedImage> IMAGE_MAP = new HashMap<String, BufferedImage>();

    private static BufferedImage readImage(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException ex) {
            LOG.error((Object)("Cannot load image: " + url), (Throwable)ex);
            return null;
        }
    }

    private static String generateMapKey(KatType kat, SelectionType selection) {
        return kat.toString() + "-" + selection.toString();
    }

    private Paint createTexturePaint(KatType type) {
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.07, 0.07);
        BufferedImage selected = IMAGE_MAP.get(KkKompensationFeatureRenderer.generateMapKey(type, SelectionType.SELECTED));
        BufferedImage highlighted = IMAGE_MAP.get(KkKompensationFeatureRenderer.generateMapKey(type, SelectionType.HIGHLIGHTED));
        BufferedImage unselected = IMAGE_MAP.get(KkKompensationFeatureRenderer.generateMapKey(type, SelectionType.UNSELECTED));
        if (selected != null && highlighted != null && unselected != null) {
            return new SelectionAwareTexturePaint(unselected, highlighted, selected, (Rectangle2D)r);
        }
        return null;
    }

    public float getTransparency() {
        return 0.7f;
    }

    public synchronized Paint getFillingStyle(CidsFeature subFeature) {
        String katKlasse = this.getKatKlasse();
        if (katKlasse != null) {
            if (katKlasse.startsWith("1")) {
                return Color.decode("#FB858B");
            }
            if (katKlasse.equals("11")) {
                return Color.decode("#F90921");
            }
            if (katKlasse.startsWith("2")) {
                return Color.decode("#84BA84");
            }
            if (katKlasse.equals("22")) {
                return Color.decode("#167500");
            }
            if (katKlasse.startsWith("3")) {
                return Color.decode("#FCFF96");
            }
            if (katKlasse.equals("33")) {
                return Color.decode("#FBFF22");
            }
            if (katKlasse.startsWith("4")) {
                return Color.decode("#F9D990");
            }
            if (katKlasse.equals("44")) {
                return Color.decode("#F5B121");
            }
            if (katKlasse.startsWith("5")) {
                return Color.decode("#DC79DD");
            }
            if (katKlasse.equals("55")) {
                return Color.decode("#BE00C1");
            }
        }
        return Color.decode("#80C0FF");
    }

    private String getKatKlasse() {
        String katKlasse = null;
        try {
            katKlasse = (String)this.metaObject.getBean().getProperty("kategorie.klasse");
        }
        catch (NullPointerException e) {
            LOG.error((Object)"Cannot retrieve field kategorie.klasse from kompensation object.", (Throwable)e);
        }
        return katKlasse;
    }

    public Paint getLinePaint(CidsFeature subFeature) {
        String katKlasse = this.getKatKlasse();
        if (katKlasse != null) {
            if (katKlasse.equals("1")) {
                return Color.decode("#FB858B");
            }
            if (katKlasse.equals("11")) {
                return Color.BLACK;
            }
            if (katKlasse.equals("2")) {
                return Color.decode("#84BA84");
            }
            if (katKlasse.equals("22")) {
                return Color.BLACK;
            }
            if (katKlasse.equals("3")) {
                return Color.decode("#FCFF96");
            }
            if (katKlasse.equals("33")) {
                return Color.BLACK;
            }
            if (katKlasse.equals("4")) {
                return Color.decode("#F9D990");
            }
            if (katKlasse.equals("44")) {
                return Color.BLACK;
            }
            if (katKlasse.equals("5")) {
                return Color.decode("#DC79DD");
            }
            if (katKlasse.equals("55")) {
                return Color.BLACK;
            }
        }
        return Color.BLACK;
    }

    public Stroke getLineStyle() {
        String katKlasse = this.getKatKlasse();
        if (katKlasse != null && katKlasse.length() == 2) {
            return new BasicStroke(2.0f);
        }
        return null;
    }

    public Paint getFillingStyle() {
        return this.getFillingStyle(null);
    }

    public Paint getLinePaint() {
        return this.getLinePaint(null);
    }

    public void assign() {
    }

    public JComponent getInfoComponent(Refreshable refresh) {
        return null;
    }

    static {
        URL urlArt = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffArtenschutz.png");
        URL urlArtSelected = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffArtenschutzSelected.png");
        URL urlArtHighlighted = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffArtenschutzHighlighted.png");
        URL urlDach = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffDachbegruenung.png");
        URL urlDachSelected = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffDachbegruenungSelected.png");
        URL urlDachHighlighted = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffDachbegruenungHighlighted.png");
        URL urlForst = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffForst.png");
        URL urlForstSelected = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffForstSelected.png");
        URL urlForstHighlighted = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffForstHighlighted.png");
        URL urlKomp = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffKompensation.png");
        URL urlKompSelected = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffKompensationSelected.png");
        URL urlKompHighlighted = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffKompensationHighlighted.png");
        URL urlPlanung = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffPlanung.png");
        URL urlPlanungSelected = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffPlanungSelected.png");
        URL urlPlanungHighlighted = KkKompensationFeatureRenderer.class.getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/SchraffPlanungHighlighted.png");
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.ART, SelectionType.UNSELECTED), KkKompensationFeatureRenderer.readImage(urlArt));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.ART, SelectionType.SELECTED), KkKompensationFeatureRenderer.readImage(urlArtSelected));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.ART, SelectionType.HIGHLIGHTED), KkKompensationFeatureRenderer.readImage(urlArtHighlighted));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.DACH, SelectionType.UNSELECTED), KkKompensationFeatureRenderer.readImage(urlDach));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.DACH, SelectionType.SELECTED), KkKompensationFeatureRenderer.readImage(urlDachSelected));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.DACH, SelectionType.HIGHLIGHTED), KkKompensationFeatureRenderer.readImage(urlDachHighlighted));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.FORST, SelectionType.UNSELECTED), KkKompensationFeatureRenderer.readImage(urlForst));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.FORST, SelectionType.SELECTED), KkKompensationFeatureRenderer.readImage(urlForstSelected));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.FORST, SelectionType.HIGHLIGHTED), KkKompensationFeatureRenderer.readImage(urlForstHighlighted));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.KOMP, SelectionType.UNSELECTED), KkKompensationFeatureRenderer.readImage(urlKomp));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.KOMP, SelectionType.SELECTED), KkKompensationFeatureRenderer.readImage(urlKompSelected));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.KOMP, SelectionType.HIGHLIGHTED), KkKompensationFeatureRenderer.readImage(urlKompHighlighted));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.PLANUNG, SelectionType.UNSELECTED), KkKompensationFeatureRenderer.readImage(urlPlanung));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.PLANUNG, SelectionType.SELECTED), KkKompensationFeatureRenderer.readImage(urlPlanungSelected));
        IMAGE_MAP.put(KkKompensationFeatureRenderer.generateMapKey(KatType.PLANUNG, SelectionType.HIGHLIGHTED), KkKompensationFeatureRenderer.readImage(urlPlanungHighlighted));
    }

    private static enum SelectionType {
        SELECTED,
        UNSELECTED,
        HIGHLIGHTED;

    }

    private static enum KatType {
        ART,
        DACH,
        FORST,
        KOMP,
        PLANUNG;

    }
}

