/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class NivellementPunktFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final Logger LOG = Logger.getLogger(NivellementPunktFeatureRenderer.class);
    private static final String PATH2ICONS = "/de/cismet/cids/custom/featurerenderer/wunda_blau/";
    private Color pointColor = new Color(185, 144, 83);
    private ImageIcon pointIcon;

    public void setMetaObject(MetaObject metaObject) throws ConnectionException {
        super.setMetaObject(metaObject);
        if (this.cidsBean != null) {
            boolean historisch = false;
            try {
                historisch = (Boolean)this.cidsBean.getProperty("historisch");
            }
            catch (ClassCastException ex) {
                LOG.warn((Object)"Could not cast attribute 'historisch' to boolean. Assuming false as value.", (Throwable)ex);
            }
            URL urlToIcon = null;
            if (!historisch) {
                urlToIcon = ((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_brass.png");
                this.pointColor = new Color(185, 144, 83);
            } else {
                urlToIcon = ((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/featurerenderer/wunda_blau/pointicon_silver.png");
                this.pointColor = new Color(192, 192, 192);
            }
            if (urlToIcon != null) {
                this.pointIcon = new ImageIcon(urlToIcon);
            }
        }
    }

    public Paint getLinePaint(CidsFeature subFeature) {
        return this.getFillingStyle();
    }

    public Paint getFillingStyle(CidsFeature subFeature) {
        return this.pointColor;
    }

    public FeatureAnnotationSymbol getPointSymbol() {
        FeatureAnnotationSymbol result;
        if (this.pointIcon != null) {
            result = new FeatureAnnotationSymbol(this.pointIcon.getImage());
            result.setSweetSpotX(0.49);
            result.setSweetSpotY(0.93);
        } else {
            int fallbackSymbolSize = 8;
            BufferedImage bufferedImage = new BufferedImage(8, 8, 2);
            Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
            graphics.setColor(this.pointColor);
            graphics.fillOval(0, 0, 8, 8);
            result = new FeatureAnnotationSymbol((Image)bufferedImage);
            result.setSweetSpotX(0.5);
            result.setSweetSpotY(0.5);
        }
        return result;
    }

    public void assign() {
    }

    public float getTransparency() {
        return 0.9f;
    }
}

