/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class TimLiegFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static Logger LOG = Logger.getLogger(TimLiegFeatureRenderer.class);
    private static final Color TIMLIEG_COLOR = new Color(0, 0, 255);
    private JPanel pnlMore;
    private JLabel lblEinBeabAndEinDat;
    private JTextArea txtAHinweis;

    public TimLiegFeatureRenderer() {
        this.initComponents();
    }

    private void initComponents() {
        this.pnlMore = new JPanel();
        this.lblEinBeabAndEinDat = new JLabel();
        this.txtAHinweis = new JTextArea();
        this.txtAHinweis.setLineWrap(true);
        this.txtAHinweis.setWrapStyleWord(true);
        this.txtAHinweis.setEditable(false);
        this.txtAHinweis.setBorder(null);
        this.pnlMore.setLayout(new BorderLayout());
        this.pnlMore.add((Component)this.lblEinBeabAndEinDat, "First");
        this.pnlMore.add((Component)this.txtAHinweis, "Center");
        this.add(this.pnlMore);
    }

    public void setMetaObject(MetaObject metaObject) throws ConnectionException {
        super.setMetaObject(metaObject);
        if (this.cidsBean != null) {
            String ein_beab = (String)this.cidsBean.getProperty("ein_beab");
            String hinweis = (String)this.cidsBean.getProperty("hinweis");
            Timestamp ein_dat = (Timestamp)this.cidsBean.getProperty("ein_dat");
            String date = DateFormat.getDateInstance().format(ein_dat);
            String time = DateFormat.getTimeInstance().format(ein_dat);
            this.lblEinBeabAndEinDat.setText(NbBundle.getMessage(TimLiegFeatureRenderer.class, (String)"TimLiegFeatureRenderer.lblUsrAndTimestamp.text", (Object)ein_beab, (Object)date, (Object)time));
            this.txtAHinweis.setText(hinweis);
        }
    }

    public Paint getLinePaint(CidsFeature subFeature) {
        return this.getFillingStyle();
    }

    public Paint getFillingStyle() {
        return TIMLIEG_COLOR;
    }

    public void assign() {
    }
}

