/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import de.cismet.cids.annotations.CidsAttribute;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Properties;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Layer;

public class UmweltstationFeatureRenderer
extends CustomCidsFeatureRenderer {
    @CidsAttribute(value="Typ")
    public String typ;
    Random random = new Random();
    @CidsAttribute(value="noise")
    Float noise = Float.valueOf(0.5f);
    @CidsAttribute(value="ozon")
    Float oz = Float.valueOf(0.65f);
    @CidsAttribute(value="sox")
    Float sox = Float.valueOf(0.1f);
    @CidsAttribute(value="pm10")
    Float pm = Float.valueOf(0.5f);
    @CidsAttribute(value="nox")
    Float nox = Float.valueOf(0.3f);
    @CidsAttribute(value="noiseVar")
    Float noiseVar = Float.valueOf(0.5f);
    @CidsAttribute(value="ozonVar")
    Float ozVar = Float.valueOf(0.65f);
    @CidsAttribute(value="soxVar")
    Float soxVar = Float.valueOf(0.1f);
    @CidsAttribute(value="pm10Var")
    Float pmVar = Float.valueOf(0.5f);
    @CidsAttribute(value="noxVar")
    Float noxVar = Float.valueOf(0.3f);
    ImageIcon errorimage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/error.png"));
    Properties properties = new Properties();
    private JLabel jLabel1;
    private JProgressBar jProgressBar1;
    private JLabel lblChart;
    private JLabel lblImagePreview;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public UmweltstationFeatureRenderer() {
        this.initComponents();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(350, 150));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    UmweltstationFeatureRenderer.this.refreshDiagram();
                    if (UmweltstationFeatureRenderer.this.refreshable instanceof PNode) {
                        ((PNode)UmweltstationFeatureRenderer.this.refreshable).repaint();
                    }
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        UmweltstationFeatureRenderer.this.log.error((Object)"Fehler beim Darstellen des Diagrams", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        });
        t.start();
    }

    private void refreshDiagram() {
        JFreeChart chart = UmweltstationFeatureRenderer.createChart(this.createDataset(this.noiseVar.floatValue(), this.soxVar.floatValue(), this.ozVar.floatValue(), this.pmVar.floatValue(), this.noxVar.floatValue()));
        chart.setBackgroundPaint((Paint)new Color(210, 210, 210));
        BufferedImage image = chart.createBufferedImage(250, 150);
        this.lblChart.setIcon(new ImageIcon(image));
    }

    public void assign() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final ImageIcon icon = new ImageIcon(new URL("http://s10221/cismet/res/luftmessung/" + UmweltstationFeatureRenderer.this.typ + ".jpg"));
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UmweltstationFeatureRenderer.this.lblImagePreview.setIcon(icon);
                        }
                    });
                }
                catch (Throwable ex) {
                    UmweltstationFeatureRenderer.this.log.warn((Object)"Fehler beim suchen des Bildes auf s10221. Versuche es auf kif.", ex);
                    try {
                        final ImageIcon icon = new ImageIcon(new URL("http://kif/web/luftmessung/" + UmweltstationFeatureRenderer.this.typ + ".jpg"));
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UmweltstationFeatureRenderer.this.lblImagePreview.setIcon(icon);
                            }
                        });
                    }
                    catch (Throwable ex2) {
                        UmweltstationFeatureRenderer.this.log.error((Object)"Auch auf kif nix gefunden", ex);
                    }
                }
            }
        });
        t.start();
    }

    public float getTransparency() {
        return 0.9f;
    }

    public Paint getFillingStyle() {
        return new Color(100, 100, 100, 50);
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.lblImagePreview = new JLabel();
        this.lblChart = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setPreferredSize(new Dimension(100, 100));
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/load.png")));
        this.lblImagePreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UmweltstationFeatureRenderer.this.lblImagePreviewMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                UmweltstationFeatureRenderer.this.lblImagePreviewMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                UmweltstationFeatureRenderer.this.lblImagePreviewMouseExited(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 11, 3, 3);
        this.add(this.lblImagePreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.lblChart, gridBagConstraints);
    }

    private void lblImagePreviewMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void lblImagePreviewMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void lblImagePreviewMouseClicked(MouseEvent evt) {
    }

    CategoryDataset createDataset(float noiseVar, float soxVar, float ozVar, float pmVar, float noxVar) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.oz = Float.valueOf(this.oz.floatValue() + ozVar * (this.random.nextFloat() - 0.5f));
        this.noise = Float.valueOf(this.noise.floatValue() + noiseVar * (this.random.nextFloat() - 0.5f));
        this.sox = Float.valueOf(this.sox.floatValue() + soxVar * (this.random.nextFloat() - 0.5f));
        this.pm = Float.valueOf(this.pm.floatValue() + pmVar * (this.random.nextFloat() - 0.5f));
        this.nox = Float.valueOf(this.nox.floatValue() + noxVar * (this.random.nextFloat() - 0.5f));
        if (this.oz.floatValue() < 0.0f) {
            this.oz = Float.valueOf(0.0f);
        }
        if (this.noise.floatValue() < 0.0f) {
            this.noise = Float.valueOf(0.0f);
        }
        if (this.sox.floatValue() < 0.0f) {
            this.sox = Float.valueOf(0.0f);
        }
        if (this.pm.floatValue() < 0.0f) {
            this.pm = Float.valueOf(0.0f);
        }
        if (this.nox.floatValue() < 0.0f) {
            this.nox = Float.valueOf(0.0f);
        }
        if ((double)this.noise.floatValue() > 1.2) {
            this.noise = Float.valueOf(1.2f);
        }
        if ((double)this.oz.floatValue() > 1.2) {
            this.oz = Float.valueOf(1.2f);
        }
        if ((double)this.sox.floatValue() > 1.2) {
            this.sox = Float.valueOf(1.2f);
        }
        if ((double)this.pm.floatValue() > 1.2) {
            this.pm = Float.valueOf(1.2f);
        }
        if ((double)this.nox.floatValue() > 1.2) {
            this.nox = Float.valueOf(1.2f);
        }
        dataset.addValue((Number)this.noise, (Comparable)((Object)"Series 1"), (Comparable)((Object)"L\u00e4rm"));
        dataset.addValue((Number)this.sox, (Comparable)((Object)"Series 1"), (Comparable)((Object)"SOx"));
        dataset.addValue((Number)this.oz, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Ozon"));
        dataset.addValue((Number)this.pm, (Comparable)((Object)"Series 1"), (Comparable)((Object)"PM10"));
        dataset.addValue((Number)this.nox, (Comparable)((Object)"Series 1"), (Comparable)((Object)"NOx"));
        return dataset;
    }

    static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)"", (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        CustomBarRenderer3D renderer = new CustomBarRenderer3D();
        plot.setRenderer((CategoryItemRenderer)renderer);
        ValueMarker marker = new ValueMarker(0.7, (Paint)new Color(255, 0, 0, 100), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker2 = new ValueMarker(0.3, (Paint)new Color(255, 255, 0, 100), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        plot.addRangeMarker((Marker)marker, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker2, Layer.BACKGROUND);
        renderer.setItemLabelsVisible(true);
        renderer.setMaximumBarWidth(0.05);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setVisible(false);
        rangeAxis.setAutoRange(false);
        rangeAxis.setRange(0.0, 1.2);
        return chart;
    }

    static class CustomBarRenderer3D
    extends BarRenderer3D {
        public Paint getItemPaint(int row, int column) {
            CategoryDataset dataset = this.getPlot().getDataset();
            double value = dataset.getValue(row, column).doubleValue();
            if (value <= 0.3) {
                return Color.green;
            }
            if (value <= 0.7) {
                return Color.yellow;
            }
            return Color.red;
        }
    }
}

