/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.image.ColorTintFilter;

public class Wbf_gebaeudeFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static Color BCKGRND = new Color(128, 128, 128, 128);
    ColorTintFilter tinter = new ColorTintFilter(Color.BLUE, 0.5f);
    private CidsBean cidsBean;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private JScrollPane jScrollPane1;
    private JTextPane txtDescription;

    public Wbf_gebaeudeFeatureRenderer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtDescription = new JTextPane();
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jScrollPane1.setOpaque(false);
        this.txtDescription.setContentType("text/html");
        this.txtDescription.setEditable(false);
        this.txtDescription.setOpaque(false);
        this.jScrollPane1.setViewportView(this.txtDescription);
        this.add(this.jScrollPane1, "Center");
    }

    public void assign() {
        this.cidsBean = this.metaObject.getBean();
        this.txtDescription.setText(this.getHtmlString());
    }

    public float getTransparency() {
        return 1.0f;
    }

    public Paint getFillingStyle() {
        return BCKGRND;
    }

    public FeatureAnnotationSymbol getPointSymbol() {
        Color color = Color.GRAY;
        int size = 16;
        BufferedImage bi = new BufferedImage(16, 16, 2);
        try {
            CidsBean cb = this.metaObject.getBean();
            CidsBean nutzungsart = (CidsBean)cb.getProperty("art");
            String typ = (String)nutzungsart.getProperty("typ");
            String beschreibung = (String)nutzungsart.getProperty("beschreibung");
            if (typ.equalsIgnoreCase("eigenheim") && beschreibung.equalsIgnoreCase("eigentumswohnung")) {
                color = Color.GREEN;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"gr\u00fcn");
                }
            } else if (typ.equalsIgnoreCase("eigenheim")) {
                color = Color.YELLOW;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"gelb");
                }
            } else if (typ.equalsIgnoreCase("mietwohngeb\u00e4ude")) {
                color = Color.RED;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"rot");
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"grau");
            }
            Graphics2D graphics = (Graphics2D)bi.getGraphics();
            graphics.setColor(color);
            if (typ.equalsIgnoreCase("mietwohngeb\u00e4ude") && beschreibung.equalsIgnoreCase("familiengerechtes Wohnen")) {
                graphics.fillPolygon(new int[]{0, 16, 8, 0}, new int[]{0, 0, 16, 0}, 4);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Dreieck");
                }
            } else if (typ.equalsIgnoreCase("mietwohngeb\u00e4ude") && beschreibung.equalsIgnoreCase("altengerechtes Wohnen")) {
                graphics.setStroke(new BasicStroke(2.0f));
                graphics.drawRect(0, 0, 16, 16);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"ungef\u00fclltes Quadrat");
                }
            } else if (typ.equalsIgnoreCase("mietwohngeb\u00e4ude") && beschreibung.equalsIgnoreCase("behindertengerechtes Wohnen")) {
                graphics.fillOval(0, 0, 16, 16);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Kreis");
                }
            } else {
                graphics.fillRect(0, 0, 16, 16);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Quadrat");
                }
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Fehler in getPointSymbol()", t);
            color = Color.GRAY;
            Graphics2D graphics = (Graphics2D)bi.getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, 16, 16);
        }
        BufferedImage tint = new BufferedImage(16, 16, 1);
        ((Graphics2D)tint.getGraphics()).drawImage((Image)bi, 0, 0, null);
        this.tinter.filter(tint, tint);
        FeatureAnnotationSymbol symb = FeatureAnnotationSymbol.newCustomSweetSpotFeatureAnnotationSymbol((Image)bi, null, (double)0.5, (double)0.5);
        return symb;
    }

    public String getAlternativeName() {
        Object o = this.cidsBean.getProperty("vorgaenge");
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return c.toArray()[0].toString() + " (Anzahl Vorg\u00e4nge: " + c.size() + ")";
        }
        String ret = (String)this.cidsBean.getProperty("gebaeude_anschrift");
        if (ret != null) {
            return ret;
        }
        return "Wohnungsbauf\u00f6rderung";
    }

    private String getHtmlString() {
        try {
            String header = "<html><body style=\"font-family: Arial,Helvetica,sans-serif; font-size:11pt\"><b>Eigent\u00fcmer: %s</b><br>%s<hr>";
            String eigentuemer = (String)this.cidsBean.getProperty("eigentuemer_name");
            String art = null;
            Object artO = this.cidsBean.getProperty("art");
            if (artO instanceof CidsBean && artO != null) {
                CidsBean artCidsBean = (CidsBean)artO;
                art = (String)artCidsBean.getProperty("beschreibung");
            }
            if (art == null) {
                art = "keine Nutzungsart";
            }
            header = String.format(header, eigentuemer, art);
            Object o = this.cidsBean.getProperty("vorgaenge");
            StringBuilder vorgaenge = new StringBuilder();
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                for (Object ob : c) {
                    String v = "Vorgang: %s (%s)<br>";
                    if (!(ob instanceof CidsBean)) continue;
                    CidsBean cb = (CidsBean)ob;
                    String nr = (String)cb.getProperty("vergabenummer");
                    String fnr = (String)cb.getProperty("folgenummer");
                    if (fnr != null && !fnr.trim().equals("0")) {
                        nr = nr + "/" + fnr;
                    }
                    String massnahmenkategorisierung = null;
                    Object massKatOb = cb.getProperty("massnahmenkategorisierung");
                    if (massKatOb instanceof CidsBean) {
                        CidsBean mkCidsBean = (CidsBean)massKatOb;
                        massnahmenkategorisierung = (String)mkCidsBean.getProperty("beschreibung");
                    }
                    if (nr == null) {
                        nr = "-";
                    }
                    if (massnahmenkategorisierung == null) {
                        massnahmenkategorisierung = "keine Kategorie";
                    }
                    v = String.format(v, nr, massnahmenkategorisierung);
                    vorgaenge.append(v);
                }
            }
            String footer = "</body></html>";
            return header + vorgaenge + "</body></html>";
        }
        catch (Exception e) {
            this.log.error((Object)"Error in getHtmlString", (Throwable)e);
            return "";
        }
    }
}

