/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.tools.BrowserLauncher;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WerbetraegerFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final Logger LOG = Logger.getLogger(WerbetraegerFeatureRenderer.class);
    String fullUrlA = null;
    String fullUrlB = null;
    ImageIcon errorimage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/error.png"));
    Properties properties = new Properties();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JProgressBar jProgressBar1;
    private JLabel lblImagePreviewA;
    private JLabel lblImagePreviewB;
    private JProgressBar prbLoad;

    public WerbetraegerFeatureRenderer() {
        this.initComponents();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(410, 150));
    }

    public void assign() {
        this.prbLoad.setVisible(true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String bezeichnung = (String)WerbetraegerFeatureRenderer.this.cidsBean.getProperty("bezeichnung");
                    if (StringUtils.isBlank((String)bezeichnung)) {
                        WerbetraegerFeatureRenderer.this.lblImagePreviewA.setIcon(WerbetraegerFeatureRenderer.this.errorimage);
                        WerbetraegerFeatureRenderer.this.prbLoad.setVisible(false);
                        WerbetraegerFeatureRenderer.this.lblImagePreviewB.setVisible(false);
                        LOG.error((Object)"The Werbetraeger does not have a name. The images can therefore not be loaded.");
                        return;
                    }
                    String urlA = "http://s10221/cismet/res/werbetafeln/200/t_" + bezeichnung + "a.JPG";
                    String urlB = "http://s10221/cismet/res/werbetafeln/200/t_" + bezeichnung + "b.JPG";
                    WerbetraegerFeatureRenderer.this.fullUrlA = "http://s10221/cismet/res/werbetafeln/" + bezeichnung + "a.JPG";
                    WerbetraegerFeatureRenderer.this.fullUrlB = "http://s10221/cismet/res/werbetafeln/" + bezeichnung + "b.JPG";
                    final ImageIcon a = new ImageIcon(new URL(urlA));
                    final ImageIcon b = new ImageIcon(new URL(urlB));
                    JPanel p = new JPanel();
                    p.setOpaque(false);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WerbetraegerFeatureRenderer.this.lblImagePreviewA.setIcon(a);
                            WerbetraegerFeatureRenderer.this.lblImagePreviewB.setIcon(b);
                            WerbetraegerFeatureRenderer.this.setPreferredSize(new Dimension(a.getIconWidth() + b.getIconWidth() + 6, Math.max(a.getIconHeight(), b.getIconHeight()) + 12));
                            WerbetraegerFeatureRenderer.this.prbLoad.setVisible(false);
                        }
                    });
                }
                catch (Exception e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WerbetraegerFeatureRenderer.this.lblImagePreviewA.setIcon(WerbetraegerFeatureRenderer.this.errorimage);
                            WerbetraegerFeatureRenderer.this.prbLoad.setVisible(false);
                        }
                    });
                }
            }
        });
        t.start();
    }

    public float getTransparency() {
        return 0.9f;
    }

    public Paint getFillingStyle() {
        return new Color(100, 100, 100, 50);
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.prbLoad = new JProgressBar();
        this.lblImagePreviewA = new JLabel();
        this.lblImagePreviewB = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setText("jLabel2");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setPreferredSize(new Dimension(100, 100));
        this.setLayout(new GridBagLayout());
        this.prbLoad.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.prbLoad.setBorderPainted(false);
        this.prbLoad.setIndeterminate(true);
        this.prbLoad.setPreferredSize(new Dimension(100, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add(this.prbLoad, gridBagConstraints);
        this.lblImagePreviewA.setHorizontalAlignment(0);
        this.lblImagePreviewA.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/load.png")));
        this.lblImagePreviewA.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WerbetraegerFeatureRenderer.this.lblImagePreviewAMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WerbetraegerFeatureRenderer.this.lblImagePreviewAMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WerbetraegerFeatureRenderer.this.lblImagePreviewAMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add(this.lblImagePreviewA, gridBagConstraints);
        this.lblImagePreviewB.setHorizontalAlignment(0);
        this.lblImagePreviewB.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/load.png")));
        this.lblImagePreviewB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WerbetraegerFeatureRenderer.this.lblImagePreviewBMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WerbetraegerFeatureRenderer.this.lblImagePreviewBMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WerbetraegerFeatureRenderer.this.lblImagePreviewBMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add(this.lblImagePreviewB, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("H\u00f6here Aufl\u00f6sung durch Mausklick.");
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add(this.jLabel3, gridBagConstraints);
    }

    private void lblImagePreviewAMouseExited(MouseEvent evt) {
    }

    private void lblImagePreviewAMouseEntered(MouseEvent evt) {
    }

    private void lblImagePreviewAMouseClicked(MouseEvent evt) {
        try {
            BrowserLauncher.openURL((String)this.fullUrlA);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void lblImagePreviewBMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void lblImagePreviewBMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void lblImagePreviewBMouseClicked(MouseEvent evt) {
        try {
            BrowserLauncher.openURL((String)this.fullUrlB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

