/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.nas.NasFeeCalculator;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NasFeePreviewPanel
extends JPanel
implements ConnectionContextProvider {
    private static final Logger log = Logger.getLogger(NasFeePreviewPanel.class);
    private static final String PK_NASOEIG = "nasoeig";
    private NasProduct nasProduct;
    private Geometry geom;
    private int pointAmount = 0;
    private int gebaeudeAmount = 0;
    private int flurstueckAmount = 0;
    private final DecimalFormat formatter = new DecimalFormat("#,###,##0.00 \u00a4\u00a4");
    private double discount;
    private final ConnectionContext connectionContext;
    private JPanel jPanel1;
    private JLabel lblAnzahlTitle;
    private JXBusyLabel lblBusy;
    private JLabel lblDatensaetze;
    private JLabel lblEigentuemer;
    private JLabel lblEigentuemerAnzahl;
    private JLabel lblEigentuemerGesamt;
    private JLabel lblError;
    private JLabel lblFiller;
    private JLabel lblFlurstuecke;
    private JLabel lblFlurstueckeAnzahl;
    private JLabel lblFlurstueckeGesamt;
    private JLabel lblGebaeude;
    private JLabel lblGebaeudeAnzahl;
    private JLabel lblGebeaudeGesamt;
    private JLabel lblGesamt;
    private JLabel lblGesamtTitle;
    private JLabel lblGesamtValue;
    private JLabel lblPunkte;
    private JLabel lblPunkteAnzahl;
    private JLabel lblPunkteGesamt;
    private JLabel lblTitle;
    private JPanel pnlFee;

    public NasFeePreviewPanel(ConnectionContext connectionContext) {
        this(new NasProduct("ohne_eigentuemer"), connectionContext);
        this.nasProduct.setBillingKey(PK_NASOEIG);
    }

    public NasFeePreviewPanel(NasProduct nasProduct, ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.nasProduct = nasProduct;
        this.discount = 1.0;
        this.initComponents();
    }

    public void setFlurstueckLabels(String amount, String value) {
        this.lblFlurstueckeAnzahl.setText(amount);
        this.lblFlurstueckeGesamt.setText(value);
    }

    public void setPointLabels(String amount, String value) {
        this.lblPunkteAnzahl.setText(amount);
        this.lblPunkteGesamt.setText(value);
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public void setGebaeudeLabels(String amount, String value) {
        this.lblGebaeudeAnzahl.setText(amount);
        this.lblGebeaudeGesamt.setText(value);
    }

    public void setEigentuemerLabels(String amount, String value) {
        this.lblEigentuemerAnzahl.setText(amount);
        this.lblEigentuemerGesamt.setText(value);
    }

    public void setTotalLabel(String value) {
        this.lblGesamtValue.setText(value);
    }

    private void showWait(boolean wait) {
        if (wait) {
            if (!this.lblBusy.isBusy()) {
                this.removeAll();
                this.add((Component)this.lblBusy);
                this.lblBusy.setBusy(true);
                this.lblBusy.setVisible(true);
            }
        } else {
            this.lblBusy.setBusy(false);
            this.lblBusy.setVisible(wait);
            this.removeAll();
            this.add(this.pnlFee);
        }
    }

    private void showError() {
        this.remove((Component)this.lblBusy);
        this.removeAll();
        this.add((Component)this.lblError, "Center");
        this.lblError.setVisible(true);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void calculateFee() {
        SwingWorker<HashMap<String, ArrayList<String>>, Void> feeCalculator = new SwingWorker<HashMap<String, ArrayList<String>>, Void>(){

            @Override
            protected HashMap<String, ArrayList<String>> doInBackground() throws Exception {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NasFeePreviewPanel.this.showWait(true);
                    }
                });
                NasFeePreviewPanel.this.pointAmount = 0;
                NasFeePreviewPanel.this.flurstueckAmount = 0;
                NasFeePreviewPanel.this.gebaeudeAmount = 0;
                HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
                if (NasFeePreviewPanel.this.geom == null) {
                    NasFeePreviewPanel.this.revalidate();
                    NasFeePreviewPanel.this.repaint();
                    return null;
                }
                double totalFee = 0.0;
                String nasBillingKey = NasFeePreviewPanel.this.nasProduct.getBillingKey();
                if (NasFeePreviewPanel.this.nasProduct != null && NasFeePreviewPanel.this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
                    ArrayList<String> values = new ArrayList<String>();
                    NasFeePreviewPanel.this.pointAmount = NasFeeCalculator.getPointAmount(NasFeePreviewPanel.this.geom, NasFeePreviewPanel.this.getConnectionContext());
                    values.add("" + NasFeePreviewPanel.this.pointAmount);
                    double pointFee = NasFeeCalculator.getFeeForPoints(NasFeePreviewPanel.this.pointAmount, nasBillingKey) * NasFeePreviewPanel.this.discount;
                    totalFee += pointFee;
                    values.add(NasFeePreviewPanel.this.formatter.format(pointFee));
                    result.put("punkte", values);
                } else {
                    ArrayList<String> flurstueckValues = new ArrayList<String>();
                    ArrayList<String> gebaeudeValues = new ArrayList<String>();
                    NasFeePreviewPanel.this.flurstueckAmount = NasFeeCalculator.getFlurstueckAmount(NasFeePreviewPanel.this.geom, NasFeePreviewPanel.this.getConnectionContext());
                    flurstueckValues.add("" + NasFeePreviewPanel.this.flurstueckAmount);
                    double flurstueckFee = NasFeeCalculator.getFeeForFlurstuecke(NasFeePreviewPanel.this.flurstueckAmount, nasBillingKey) * NasFeePreviewPanel.this.discount;
                    totalFee += flurstueckFee;
                    if (NasFeePreviewPanel.this.nasProduct != null && NasFeePreviewPanel.this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
                        double eigentuemerFee = NasFeeCalculator.getFeeForEigentuemer(NasFeePreviewPanel.this.flurstueckAmount, nasBillingKey) * NasFeePreviewPanel.this.discount;
                        totalFee += eigentuemerFee;
                        ArrayList<String> eigentuemerValues = new ArrayList<String>();
                        eigentuemerValues.add("" + NasFeePreviewPanel.this.flurstueckAmount);
                        eigentuemerValues.add(NasFeePreviewPanel.this.formatter.format(eigentuemerFee));
                        result.put("eigentuemer", eigentuemerValues);
                    }
                    flurstueckValues.add(NasFeePreviewPanel.this.formatter.format(flurstueckFee));
                    result.put("flurstuecke", flurstueckValues);
                    NasFeePreviewPanel.this.gebaeudeAmount = NasFeeCalculator.getGebaeudeAmount(NasFeePreviewPanel.this.geom, NasFeePreviewPanel.this.getConnectionContext());
                    gebaeudeValues.add("" + NasFeePreviewPanel.this.gebaeudeAmount);
                    double gebaeudeFee = NasFeeCalculator.getFeeForGebaeude(NasFeePreviewPanel.this.gebaeudeAmount, nasBillingKey) * NasFeePreviewPanel.this.discount;
                    totalFee += gebaeudeFee;
                    gebaeudeValues.add(NasFeePreviewPanel.this.formatter.format(gebaeudeFee));
                    result.put("gebaeude", gebaeudeValues);
                }
                ArrayList<String> totalList = new ArrayList<String>();
                totalList.add(NasFeePreviewPanel.this.formatter.format(totalFee));
                result.put("total", totalList);
                return result;
            }

            @Override
            protected void done() {
                try {
                    ArrayList values;
                    HashMap result = (HashMap)this.get();
                    if (result == null) {
                        NasFeePreviewPanel.this.showError();
                        NasFeePreviewPanel.this.revalidate();
                        NasFeePreviewPanel.this.repaint();
                        return;
                    }
                    for (String key : result.keySet()) {
                        values = (ArrayList)result.get(key);
                        if (NasFeePreviewPanel.this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
                            if (!key.equals("punkte")) continue;
                            NasFeePreviewPanel.this.setPointLabels((String)values.get(0), (String)values.get(1));
                            break;
                        }
                        if (NasFeePreviewPanel.this.nasProduct.getKey().equalsIgnoreCase("komplett") && key.equals("eigentuemer")) {
                            NasFeePreviewPanel.this.setEigentuemerLabels((String)values.get(0), (String)values.get(1));
                        }
                        if (key.equals("gebaeude")) {
                            NasFeePreviewPanel.this.setGebaeudeLabels((String)values.get(0), (String)values.get(1));
                            continue;
                        }
                        if (!key.equals("flurstuecke")) continue;
                        NasFeePreviewPanel.this.setFlurstueckLabels((String)values.get(0), (String)values.get(1));
                    }
                    for (String key : result.keySet()) {
                        values = (ArrayList)result.get(key);
                        if (!key.equals("total")) continue;
                        NasFeePreviewPanel.this.setTotalLabel((String)values.get(0));
                        break;
                    }
                    NasFeePreviewPanel.this.repaint();
                }
                catch (InterruptedException ex) {
                    NasFeePreviewPanel.this.showError();
                    log.error((Object)"nas fee calculation was interrupted. showing error state", (Throwable)ex);
                    return;
                }
                catch (ExecutionException ex) {
                    NasFeePreviewPanel.this.showError();
                    log.error((Object)"an error occured during nas fee calculation. showing error state", (Throwable)ex);
                    return;
                }
                NasFeePreviewPanel.this.showWait(false);
                NasFeePreviewPanel.this.revalidate();
                NasFeePreviewPanel.this.repaint();
            }
        };
        feeCalculator.execute();
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
        this.calculateFee();
    }

    public NasProduct getNasProduct() {
        return this.nasProduct;
    }

    public ArrayList<BillingProductGroupAmount> getProductGroupAmounts() {
        ArrayList<BillingProductGroupAmount> result = new ArrayList<BillingProductGroupAmount>();
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            result.addAll(this.getProductGroupAmountForObject("eapkt", this.pointAmount));
        } else if (this.nasProduct.getKey().equalsIgnoreCase("ohne_eigentuemer") || this.nasProduct.getKey().equalsIgnoreCase("dxf")) {
            result.addAll(this.getProductGroupAmountForObject("eageb", this.gebaeudeAmount));
            result.addAll(this.getProductGroupAmountForObject("eaflst", this.flurstueckAmount));
        } else if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            result.addAll(this.getProductGroupAmountForObject("eageb", this.gebaeudeAmount));
            result.addAll(this.getProductGroupAmountForObject("eaflst", this.flurstueckAmount));
            result.addAll(this.getProductGroupAmountForObject("eaeig", this.flurstueckAmount));
        }
        return result;
    }

    public void refresh() {
        this.calculateFee();
    }

    private ArrayList<BillingProductGroupAmount> getProductGroupAmountForObject(String objectBaseKey, int amount) {
        int tmpPoints;
        ArrayList<BillingProductGroupAmount> result = new ArrayList<BillingProductGroupAmount>();
        if (amount > 1000000) {
            tmpPoints = amount - 1000000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_1000001", tmpPoints));
            amount = 1000000;
        }
        if (amount > 100000) {
            tmpPoints = amount - 100000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_100001-1000000", tmpPoints));
            amount = 100000;
        }
        if (amount > 10000) {
            tmpPoints = amount - 10000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_10001-100000", tmpPoints));
            amount = 10000;
        }
        if (amount > 1000) {
            tmpPoints = amount - 1000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_1001-10000", tmpPoints));
            amount = 1000;
        }
        result.add(new BillingProductGroupAmount(objectBaseKey + "_1000", amount));
        return result;
    }

    private void initComponents() {
        this.pnlFee = new JPanel();
        this.lblTitle = new JLabel();
        this.lblAnzahlTitle = new JLabel();
        this.lblGesamtTitle = new JLabel();
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblFlurstuecke = new JLabel();
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblGebaeude = new JLabel();
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblPunkte = new JLabel();
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblFlurstueckeAnzahl = new JLabel();
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblFlurstueckeGesamt = new JLabel();
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblGebaeudeAnzahl = new JLabel();
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblGebeaudeGesamt = new JLabel();
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblPunkteAnzahl = new JLabel();
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            this.lblPunkteGesamt = new JLabel();
        }
        this.jPanel1 = new JPanel();
        this.lblGesamtValue = new JLabel();
        this.lblGesamt = new JLabel();
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            this.lblEigentuemer = new JLabel();
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            this.lblEigentuemerAnzahl = new JLabel();
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            this.lblEigentuemerGesamt = new JLabel();
        }
        this.lblFiller = new JLabel();
        this.lblDatensaetze = new JLabel();
        this.lblError = new JLabel();
        this.lblBusy = new JXBusyLabel(new Dimension(75, 75));
        this.pnlFee.setOpaque(false);
        this.pnlFee.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("DejaVu Sans", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        this.pnlFee.add((Component)this.lblTitle, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblAnzahlTitle, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblAnzahlTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.pnlFee.add((Component)this.lblAnzahlTitle, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblGesamtTitle, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblGesamtTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.pnlFee.add((Component)this.lblGesamtTitle, gridBagConstraints);
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblFlurstuecke, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblFlurstuecke.text"));
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            this.pnlFee.add((Component)this.lblFlurstuecke, gridBagConstraints);
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblGebaeude, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblGebaeude.text"));
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            this.pnlFee.add((Component)this.lblGebaeude, gridBagConstraints);
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblPunkte, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblPunkte.text"));
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            this.pnlFee.add((Component)this.lblPunkte, gridBagConstraints);
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblFlurstueckeAnzahl, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblFlurstueckeAnzahl.text"));
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.pnlFee.add((Component)this.lblFlurstueckeAnzahl, gridBagConstraints);
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblFlurstueckeGesamt, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblFlurstueckeGesamt.text"));
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.pnlFee.add((Component)this.lblFlurstueckeGesamt, gridBagConstraints);
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblGebaeudeAnzahl, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblGebaeudeAnzahl.text"));
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.pnlFee.add((Component)this.lblGebaeudeAnzahl, gridBagConstraints);
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblGebeaudeGesamt, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblGebeaudeGesamt.text"));
        }
        if (!this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.pnlFee.add((Component)this.lblGebeaudeGesamt, gridBagConstraints);
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblPunkteAnzahl, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblPunkteAnzahl.text"));
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.pnlFee.add((Component)this.lblPunkteAnzahl, gridBagConstraints);
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            Mnemonics.setLocalizedText((JLabel)this.lblPunkteGesamt, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblPunkteGesamt.text"));
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("punkte")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.pnlFee.add((Component)this.lblPunkteGesamt, gridBagConstraints);
        }
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblGesamtValue.setFont(new Font("DejaVu Sans", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.lblGesamtValue, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblGesamtValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 10, 10, 0);
        this.jPanel1.add((Component)this.lblGesamtValue, gridBagConstraints);
        this.lblGesamt.setFont(new Font("DejaVu Sans", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.lblGesamt, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblGesamt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        this.jPanel1.add((Component)this.lblGesamt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlFee.add((Component)this.jPanel1, gridBagConstraints);
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            Mnemonics.setLocalizedText((JLabel)this.lblEigentuemer, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblEigentuemer.text"));
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 10, 0);
            this.pnlFee.add((Component)this.lblEigentuemer, gridBagConstraints);
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            Mnemonics.setLocalizedText((JLabel)this.lblEigentuemerAnzahl, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblEigentuemerAnzahl.text"));
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.pnlFee.add((Component)this.lblEigentuemerAnzahl, gridBagConstraints);
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            Mnemonics.setLocalizedText((JLabel)this.lblEigentuemerGesamt, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblEigentuemerGesamt.text"));
        }
        if (this.nasProduct.getKey().equalsIgnoreCase("komplett")) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.pnlFee.add((Component)this.lblEigentuemerGesamt, gridBagConstraints);
        }
        Mnemonics.setLocalizedText((JLabel)this.lblFiller, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblFiller.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlFee.add((Component)this.lblFiller, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblDatensaetze, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblDatensaetze.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.pnlFee.add((Component)this.lblDatensaetze, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblError, (String)NbBundle.getMessage(NasFeePreviewPanel.class, (String)"NasFeePreviewPanel.lblError.text"));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.lblBusy.setHorizontalAlignment(0);
        this.lblBusy.setMaximumSize(new Dimension(140, 40));
        this.lblBusy.setMinimumSize(new Dimension(140, 60));
        this.lblBusy.setPreferredSize(new Dimension(140, 60));
        this.add((Component)this.lblBusy, "Center");
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

