/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.nas.PointNumberDialog;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import de.cismet.cids.custom.wunda_blau.search.actions.PointNumberReservationServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.commons.gui.progress.BusyLoggingTextPane;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PointNumberReservationPanel
extends JPanel
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(PointNumberReservationPanel.class);
    private static final String SEVER_ACTION = "pointNumberReservation";
    private static final String WUPP_ZONEN_KENNZIFFER = "32";
    private static final DateFormat DATE_PARSER = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("dd-MM-yyyy");
    private static final ArrayList<String> NBZ_WHITELISTE = new ArrayList();
    boolean showErrorLbl = false;
    private final PointNumberDialog pnrDialog;
    private BusyLoggingTextPane protokollPane;
    private ArrayList<String> nbz = new ArrayList();
    private int maxNbz = 4;
    private boolean anzahlWarnVisible = false;
    private final ConnectionContext connectionContext;
    private JButton btnErstellen;
    private JButton btnRefreshNbz;
    private JComboBox cbNbz;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JPanel jPanel1;
    private JSpinner jspAnzahl;
    private JLabel lblAnzWarn1;
    private JLabel lblAnzWarn2;
    private JLabel lblAnzWarnAnzahl;
    private JLabel lblAnzahl;
    private JLabel lblNbz;
    private JLabel lblNbzAnzahl;
    private JLabel lblNbzError;
    private JLabel lblNbzINfo;
    private JLabel lblStartwert;
    private JPanel pnlNbz;
    private JPanel pnlNbzInfo;
    private JTextField tfStartWert;

    public PointNumberReservationPanel() {
        this(null, ConnectionContext.createDeprecated());
    }

    public PointNumberReservationPanel(PointNumberDialog pnrDialog, ConnectionContext connectionContext) {
        this.pnrDialog = pnrDialog;
        this.connectionContext = connectionContext;
        Properties props = new Properties();
        try {
            String nbzWhitelistEntry;
            props.load(PointNumberReservationPanel.class.getResourceAsStream("pointNumberSettings.properties"));
            this.maxNbz = Integer.parseInt(props.getProperty("maxNbz"));
            BufferedReader whitelistReader = new BufferedReader(new InputStreamReader(PointNumberReservationPanel.class.getResourceAsStream("pnr_nbz_whitelist.properties")));
            while ((nbzWhitelistEntry = whitelistReader.readLine()) != null) {
                NBZ_WHITELISTE.add(nbzWhitelistEntry);
            }
            Collections.sort(NBZ_WHITELISTE);
            if (!this.loadNummerierungsbezirke()) {
                this.showErrorLbl = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error reading pointNUmberSetting.properties", (Throwable)e);
            this.showErrorLbl = true;
        }
        this.initComponents();
        if (!this.showErrorLbl) {
            this.cbNbz.setModel(new DefaultComboBoxModel<String>(this.nbz.toArray(new String[this.nbz.size()])));
            this.lblNbzAnzahl.setText("" + this.nbz.size());
        }
        CismapBroker.getInstance().addStatusListener(new StatusListener(){

            public void statusValueChanged(final StatusEvent e) {
                Runnable modifyControls = new Runnable(){

                    @Override
                    public void run() {
                        if (e.getName().equals("retrieval.started")) {
                            PointNumberReservationPanel.this.btnRefreshNbz.setVisible(true);
                        }
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    modifyControls.run();
                } else {
                    EventQueue.invokeLater(modifyControls);
                }
            }
        });
        this.cbNbz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointNumberReservationPanel.this.checkButtonState();
            }
        });
        this.btnRefreshNbz.setVisible(false);
        this.lblAnzWarn1.setVisible(false);
        this.lblAnzWarn2.setVisible(false);
        this.lblAnzWarnAnzahl.setVisible(false);
        JSpinner.NumberEditor ne = (JSpinner.NumberEditor)this.jspAnzahl.getEditor();
        ne.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PointNumberReservationPanel.this.handleAnzahlSpinnderChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PointNumberReservationPanel.this.handleAnzahlSpinnderChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PointNumberReservationPanel.this.handleAnzahlSpinnderChanged();
            }
        });
    }

    private void showError() {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (PointNumberReservationPanel.this.protokollPane != null) {
                    PointNumberReservationPanel.this.protokollPane.addMessage("W\u00e4hrend der Bearbeitung des Auftrags trat ein Fehler auf!", BusyLoggingTextPane.Styles.ERROR);
                    PointNumberReservationPanel.this.pnrDialog.enableDoneButton(true);
                    PointNumberReservationPanel.this.btnErstellen.setEnabled(true);
                    PointNumberReservationPanel.this.protokollPane.setBusy(false);
                }
            }
        }, 50L);
    }

    private boolean loadNummerierungsbezirke() {
        this.nbz = new ArrayList();
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        Geometry g = ((XBoundingBox)mapC.getCurrentBoundingBoxFromCamera()).getGeometry();
        if (!CrsTransformer.createCrsFromSrid((int)g.getSRID()).equals(ClientAlkisConf.getInstance().getSrsService())) {
            g = CrsTransformer.transformToGivenCrs((Geometry)g, (String)ClientAlkisConf.getInstance().getSrsService());
        }
        XBoundingBox bb = new XBoundingBox(g);
        int lowerX = Double.valueOf(Math.floor(bb.getX1())).intValue() / 1000;
        int upperX = Double.valueOf(Math.floor(bb.getX2())).intValue() / 1000;
        int lowerY = Double.valueOf(Math.floor(bb.getY1())).intValue() / 1000;
        int upperY = Double.valueOf(Math.floor(bb.getY2())).intValue() / 1000;
        int diffX = upperX - lowerX + 1 == 0 ? 1 : upperX - lowerX + 1;
        int diffY = upperY - lowerY + 1 == 0 ? 1 : upperY - lowerY + 1;
        ArrayList<String> mapNbz = new ArrayList<String>();
        for (int i = 0; i < diffX; ++i) {
            int x = lowerX + i;
            for (int j = 0; j < diffY; ++j) {
                int y = lowerY + j;
                String currNbz = WUPP_ZONEN_KENNZIFFER + x + y;
                if (Collections.binarySearch(NBZ_WHITELISTE, currNbz) <= 0) continue;
                mapNbz.add(currNbz);
            }
        }
        if (mapNbz.size() > this.maxNbz) {
            return false;
        }
        this.nbz.addAll(mapNbz);
        return true;
    }

    private void initComponents() {
        this.lblNbz = new JLabel();
        this.lblAnzahl = new JLabel();
        this.lblStartwert = new JLabel();
        this.tfStartWert = new JTextField();
        this.btnErstellen = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        if (this.showErrorLbl) {
            this.lblNbzError = new JLabel();
        }
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 48), new Dimension(0, Short.MAX_VALUE));
        this.pnlNbz = new JPanel();
        this.cbNbz = new JComboBox();
        this.btnRefreshNbz = new JButton();
        this.pnlNbzInfo = new JPanel();
        this.lblNbzAnzahl = new JLabel();
        this.lblNbzINfo = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(40, 0), new Dimension(40, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblAnzWarn2 = new JLabel();
        this.jspAnzahl = new JSpinner();
        this.jPanel1 = new JPanel();
        this.lblAnzWarn1 = new JLabel();
        this.lblAnzWarnAnzahl = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblNbz, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblNbz.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.lblNbz, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblAnzahl, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblAnzahl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.lblAnzahl, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblStartwert, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblStartwert.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.lblStartwert, gridBagConstraints);
        this.tfStartWert.setText(NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.tfStartWert.text"));
        this.tfStartWert.setMinimumSize(new Dimension(100, 27));
        this.tfStartWert.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.tfStartWert, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnErstellen, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.btnErstellen.text"));
        this.btnErstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberReservationPanel.this.btnErstellenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.btnErstellen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler2, gridBagConstraints);
        if (this.showErrorLbl) {
            this.lblNbzError.setForeground(new Color(255, 0, 0));
            Mnemonics.setLocalizedText((JLabel)this.lblNbzError, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblNbzError.text"));
        }
        if (this.showErrorLbl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)this.lblNbzError, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.filler3, gridBagConstraints);
        this.pnlNbz.setLayout(new GridBagLayout());
        this.cbNbz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberReservationPanel.this.cbNbzActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.pnlNbz.add((Component)this.cbNbz, gridBagConstraints);
        this.btnRefreshNbz.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-refresh.png")));
        this.btnRefreshNbz.setToolTipText(NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.btnRefreshNbz.toolTipText"));
        this.btnRefreshNbz.setLabel(NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.btnRefreshNbz.label"));
        this.btnRefreshNbz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointNumberReservationPanel.this.btnRefreshNbzActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 5, 10);
        this.pnlNbz.add((Component)this.btnRefreshNbz, gridBagConstraints);
        this.pnlNbzInfo.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblNbzAnzahl, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblNbzAnzahl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlNbzInfo.add((Component)this.lblNbzAnzahl, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblNbzINfo, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblNbzINfo.text"));
        this.pnlNbzInfo.add((Component)this.lblNbzINfo, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlNbz.add((Component)this.pnlNbzInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.pnlNbz.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlNbz, gridBagConstraints);
        this.lblAnzWarn2.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.lblAnzWarn2, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblAnzWarn2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lblAnzWarn2, gridBagConstraints);
        this.jspAnzahl.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.jspAnzahl.setMinimumSize(new Dimension(100, 28));
        this.jspAnzahl.setPreferredSize(new Dimension(100, 28));
        this.jspAnzahl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PointNumberReservationPanel.this.jspAnzahlStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jspAnzahl, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblAnzWarn1.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.lblAnzWarn1, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblAnzWarn1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.lblAnzWarn1, gridBagConstraints);
        this.lblAnzWarnAnzahl.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.lblAnzWarnAnzahl, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblAnzWarnAnzahl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.lblAnzWarnAnzahl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnErstellenActionPerformed(ActionEvent evt) {
        this.pnrDialog.warnIfNeeded();
        final String anr = this.pnrDialog.getAnr();
        if (anr == null || anr.isEmpty()) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.AnrExistsJOptionPane.message"), NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.AnrExistsJOptionPane.title"), 0);
            return;
        }
        this.protokollPane = this.pnrDialog.getProtokollPane();
        try {
            this.protokollPane.getDocument().remove(0, this.protokollPane.getDocument().getLength());
        }
        catch (BadLocationException ex) {
            LOG.error((Object)"Could not clear Protokoll Pane", (Throwable)ex);
        }
        final String nummerierungsbezirk = (String)this.cbNbz.getSelectedItem();
        if (!anr.matches("[a-zA-Z0-9_-]*") || !nummerierungsbezirk.matches("[0-9]*")) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.ValueCheckJOptionPane.message"), NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.ValueCheckJOptionPane.title"), 0);
            return;
        }
        this.pnrDialog.enableDoneButton(false);
        this.pnrDialog.memorizeAnrPrefix();
        this.btnErstellen.setEnabled(false);
        this.protokollPane.setBusy(true);
        final String anrPrefix = this.pnrDialog.getAnrPrefix();
        this.protokollPane.addMessage("Pr\u00fcfe ob Antragsnummer " + anrPrefix + "_" + anr + " schon existiert.", BusyLoggingTextPane.Styles.INFO);
        final SwingWorker<PointNumberReservationRequest, Void> reservationWorker = new SwingWorker<PointNumberReservationRequest, Void>(){

            @Override
            protected PointNumberReservationRequest doInBackground() throws Exception {
                Integer anzahl = (Integer)PointNumberReservationPanel.this.jspAnzahl.getValue();
                String swText = PointNumberReservationPanel.this.tfStartWert.getText();
                Integer startwert = swText != null && !swText.equals("") && swText.matches("[0-9]*") ? Integer.valueOf(Integer.parseInt(swText)) : Integer.valueOf(0);
                ServerActionParameter action = PointNumberReservationPanel.this.pnrDialog.isErgaenzenMode() ? new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.DO_ADDITION) : new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.DO_RESERVATION);
                ServerActionParameter prefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)anrPrefix);
                ServerActionParameter aNummer = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)anr);
                ServerActionParameter nbz = new ServerActionParameter(PointNumberReservationServerAction.Parameter.NBZ.toString(), (Object)nummerierungsbezirk);
                ServerActionParameter amount = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ANZAHL.toString(), (Object)anzahl);
                ServerActionParameter startVal = new ServerActionParameter(PointNumberReservationServerAction.Parameter.STARTWERT.toString(), (Object)startwert);
                PointNumberReservationRequest result = (PointNumberReservationRequest)SessionManager.getProxy().executeTask(PointNumberReservationPanel.SEVER_ACTION, "WUNDA_BLAU", null, PointNumberReservationPanel.this.getConnectionContext(), new ServerActionParameter[]{action, prefix, aNummer, nbz, amount, startVal});
                return result;
            }

            @Override
            protected void done() {
                Timer t = new Timer();
                t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            PointNumberReservationRequest result = (PointNumberReservationRequest)this.get();
                            PointNumberReservationPanel.this.pnrDialog.setResult(result);
                            if (result == null || !result.isSuccessfull()) {
                                PointNumberReservationPanel.this.protokollPane.addMessage("Fehler beim Senden des Auftrags.", BusyLoggingTextPane.Styles.ERROR);
                                PointNumberReservationPanel.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                                if (result != null && result.getErrorMessages() != null) {
                                    for (String s : result.getErrorMessages()) {
                                        PointNumberReservationPanel.this.protokollPane.addMessage(s, BusyLoggingTextPane.Styles.ERROR);
                                        PointNumberReservationPanel.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                                    }
                                    PointNumberReservationPanel.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                                    PointNumberReservationPanel.this.protokollPane.addMessage("Die Protokolldatei mit Fehlerinformationen steht zum Download bereit.", BusyLoggingTextPane.Styles.ERROR);
                                }
                                PointNumberReservationPanel.this.pnrDialog.enableDoneButton(true);
                                PointNumberReservationPanel.this.btnErstellen.setEnabled(true);
                                PointNumberReservationPanel.this.protokollPane.setBusy(false);
                                return;
                            }
                            PointNumberReservationPanel.this.protokollPane.addMessage("Ok.", BusyLoggingTextPane.Styles.SUCCESS);
                            PointNumberReservationPanel.this.pnrDialog.setSuccess();
                            PointNumberReservationPanel.this.protokollPane.setBusy(false);
                            PointNumberReservationPanel.this.protokollPane.addMessage("Reservierung f\u00fcr Antragsnummer: " + result.getAntragsnummer() + ". Folgende Punktnummern wurden reserviert: (g\u00fcltig bis)", BusyLoggingTextPane.Styles.SUCCESS);
                            PointNumberReservationPanel.this.protokollPane.addMessage("", BusyLoggingTextPane.Styles.INFO);
                            for (PointNumberReservation pnr : result.getPointNumbers()) {
                                PointNumberReservationPanel.this.protokollPane.addMessage(pnr.getPunktnummer() + " (" + DATE_FORMATTER.format(DATE_PARSER.parse(pnr.getAblaufDatum())) + ")", BusyLoggingTextPane.Styles.INFO);
                            }
                            if (!PointNumberReservationPanel.this.pnrDialog.isErgaenzenMode()) {
                                String anr = result.getAntragsnummer();
                                int underscorePos = anr.indexOf("_");
                                PointNumberReservationPanel.this.pnrDialog.addAnr(anr.substring(underscorePos + 1));
                            }
                            PointNumberReservationPanel.this.pnrDialog.enableDoneButton(true);
                            PointNumberReservationPanel.this.btnErstellen.setEnabled(true);
                        }
                        catch (InterruptedException ex) {
                            LOG.error((Object)"Swing worker that executes the reservation was interrupted", (Throwable)ex);
                            PointNumberReservationPanel.this.showError();
                        }
                        catch (ExecutionException ex) {
                            LOG.error((Object)"Error in execution of Swing Worker that executes the reservation", (Throwable)ex);
                            PointNumberReservationPanel.this.showError();
                        }
                        catch (ParseException ex) {
                            LOG.error((Object)"Error parsing the ablauf date of a reservation", (Throwable)ex);
                            PointNumberReservationPanel.this.showError();
                        }
                    }
                }, 50L);
            }
        };
        SwingWorker<Boolean, Void> isAntragExistingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                ServerActionParameter action = new ServerActionParameter(PointNumberReservationServerAction.Parameter.ACTION.toString(), (Object)PointNumberReservationServerAction.Action.IS_ANTRAG_EXISTING);
                ServerActionParameter prefix = new ServerActionParameter(PointNumberReservationServerAction.Parameter.PREFIX.toString(), (Object)anrPrefix);
                ServerActionParameter aNummer = new ServerActionParameter(PointNumberReservationServerAction.Parameter.AUFTRAG_NUMMER.toString(), (Object)anr);
                boolean isAntragExisting = (Boolean)SessionManager.getProxy().executeTask(PointNumberReservationPanel.SEVER_ACTION, "WUNDA_BLAU", null, PointNumberReservationPanel.this.getConnectionContext(), new ServerActionParameter[]{action, prefix, aNummer});
                return isAntragExisting;
            }

            @Override
            protected void done() {
                Timer t = new Timer();
                t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        boolean startReservationWorker = false;
                        try {
                            Boolean anrExists = (Boolean)this.get();
                            if (anrExists.booleanValue() && PointNumberReservationPanel.this.pnrDialog.isErgaenzenMode() || !anrExists.booleanValue() && !PointNumberReservationPanel.this.pnrDialog.isErgaenzenMode()) {
                                PointNumberReservationPanel.this.protokollPane.addMessage("Ok.", BusyLoggingTextPane.Styles.SUCCESS);
                                PointNumberReservationPanel.this.pnrDialog.setSuccess();
                                PointNumberReservationPanel.this.protokollPane.addMessage("Sende Reservierungsauftrag.", BusyLoggingTextPane.Styles.INFO);
                                reservationWorker.run();
                            } else {
                                if (PointNumberReservationPanel.this.pnrDialog.isErgaenzenMode()) {
                                    PointNumberReservationPanel.this.protokollPane.addMessage("Auftragsnummer existiert noch nicht!", BusyLoggingTextPane.Styles.ERROR);
                                } else {
                                    PointNumberReservationPanel.this.protokollPane.addMessage("Auftragsnummer existiert bereits", BusyLoggingTextPane.Styles.ERROR);
                                }
                                PointNumberReservationPanel.this.pnrDialog.enableDoneButton(true);
                                PointNumberReservationPanel.this.btnErstellen.setEnabled(true);
                                PointNumberReservationPanel.this.protokollPane.setBusy(false);
                            }
                        }
                        catch (InterruptedException ex) {
                            LOG.error((Object)"Swing worker that checks if antragsnummer is existing was interrupted", (Throwable)ex);
                            PointNumberReservationPanel.this.showError();
                        }
                        catch (ExecutionException ex) {
                            LOG.error((Object)"Error in execution of Swing Worker that checks if antragsnummer is existing", (Throwable)ex);
                            PointNumberReservationPanel.this.showError();
                        }
                    }
                }, 50L);
            }
        };
        isAntragExistingWorker.execute();
    }

    public void checkButtonState() {
        if (this.cbNbz.getSelectedItem() == null || ((String)this.cbNbz.getSelectedItem()).isEmpty()) {
            this.btnErstellen.setEnabled(false);
            return;
        }
        this.btnErstellen.setEnabled(true);
    }

    public void checkNummerierungsbezirke() {
        if (this.loadNummerierungsbezirke()) {
            if (this.showErrorLbl) {
                this.remove(this.lblNbzError);
                this.lblNbzError = null;
                this.showErrorLbl = false;
            }
        } else {
            this.showErrorLbl = true;
            if (this.lblNbzError == null) {
                this.lblNbzError = new JLabel();
                this.lblNbzError.setForeground(new Color(255, 0, 0));
                Mnemonics.setLocalizedText((JLabel)this.lblNbzError, (String)NbBundle.getMessage(PointNumberReservationPanel.class, (String)"PointNumberReservationPanel.lblNbzError.text"));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(10, 10, 0, 10);
                this.add((Component)this.lblNbzError, gridBagConstraints);
            }
        }
        this.cbNbz.setModel(new DefaultComboBoxModel<String>(this.nbz.toArray(new String[this.nbz.size()])));
        this.lblNbzAnzahl.setText("" + this.nbz.size());
    }

    private void btnRefreshNbzActionPerformed(ActionEvent evt) {
        this.checkNummerierungsbezirke();
        this.btnRefreshNbz.setVisible(false);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void jspAnzahlStateChanged(ChangeEvent evt) {
    }

    private void cbNbzActionPerformed(ActionEvent evt) {
    }

    private void handleAnzahlSpinnderChanged() {
        Number anzahl;
        JSpinner.NumberEditor ne = (JSpinner.NumberEditor)this.jspAnzahl.getEditor();
        try {
            anzahl = ne.getFormat().parse(ne.getTextField().getText());
        }
        catch (ParseException ex) {
            anzahl = (Number)this.jspAnzahl.getValue();
        }
        if (anzahl.intValue() > 100) {
            this.lblAnzWarnAnzahl.setText("" + anzahl.intValue());
            if (!this.anzahlWarnVisible) {
                this.anzahlWarnVisible = true;
                this.lblAnzWarn1.setVisible(true);
                this.lblAnzWarn2.setVisible(true);
                this.lblAnzWarnAnzahl.setVisible(true);
            }
        } else if (this.anzahlWarnVisible) {
            this.anzahlWarnVisible = false;
            this.lblAnzWarn1.setVisible(false);
            this.lblAnzWarn2.setVisible(false);
            this.lblAnzWarnAnzahl.setVisible(false);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

