/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import de.cismet.cids.custom.nas.CheckListItem;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PointNumberTableModel
extends AbstractTableModel {
    private static final int COLUMNS = 2;
    private final List<CheckListItem> punktnummern;
    private int selectedCidsBeans = 0;
    private final boolean showDatum;

    public PointNumberTableModel(List<CheckListItem> punktnummern, boolean showDatum) {
        this.punktnummern = punktnummern;
        this.showDatum = showDatum;
    }

    @Override
    public int getRowCount() {
        if (this.punktnummern == null) {
            return 0;
        }
        return this.punktnummern.size();
    }

    @Override
    public int getColumnCount() {
        if (this.punktnummern == null) {
            return 0;
        }
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.punktnummern == null) {
            return null;
        }
        CheckListItem bean = this.punktnummern.get(rowIndex);
        if (columnIndex == 0) {
            return bean.isSelected();
        }
        return "<html>" + bean.getPnr() + (this.showDatum ? " [<i>" + bean.getAblaufdatum() + "</i>] " : "");
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        CheckListItem item;
        if (column != 0) {
            return;
        }
        item.setSelected(!(item = this.punktnummern.get(row)).isSelected());
        this.selectedCidsBeans = item.isSelected() ? ++this.selectedCidsBeans : --this.selectedCidsBeans;
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public int getSelectedValues() {
        return this.selectedCidsBeans;
    }
}

