/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class PointNumberXmlDownload
extends AbstractDownload {
    boolean downloadProtokoll = false;
    private final PointNumberReservationRequest content;

    public PointNumberXmlDownload(PointNumberReservationRequest content, String title, String directory, String filename) {
        this.content = content;
        this.title = title;
        this.directory = directory;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".xml");
    }

    public void run() {
        String protokoll;
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        if (this.downloadProtokoll) {
            protokoll = this.content.getProtokoll();
        } else {
            if (!this.isPointNumberBeanValid()) {
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                return;
            }
            protokoll = this.content.getRawResult();
        }
        if (protokoll == null || protokoll.isEmpty()) {
            log.info((Object)"Downloaded content seems to be empty..");
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
            return;
        }
        try (FileOutputStream out = new FileOutputStream(this.fileToSaveTo);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");){
            w.write(protokoll);
            ((Writer)w).flush();
        }
        catch (IOException ex) {
            log.warn((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
            this.error(ex);
            return;
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    private boolean isPointNumberBeanValid() {
        if (this.content == null) {
            return false;
        }
        if (this.content.getAntragsnummer() == null || this.content.getAntragsnummer().isEmpty()) {
            return false;
        }
        return this.content.getPointNumbers() != null && !this.content.getPointNumbers().isEmpty();
    }
}

