/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.navigatorstartuphooks;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungMessageNotifier;
import de.cismet.cids.custom.berechtigungspruefung.BerechtigungspruefungProperties;
import de.cismet.cids.custom.clientutils.BerechtigungspruefungFreigabeDialog;
import de.cismet.cids.custom.clientutils.BerechtigungspruefungStornoDialog;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.wunda_blau.search.actions.BerechtigungspruefungAnfrageServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.servermessage.CidsServerMessageNotifier;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListener;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListenerEvent;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.configuration.StartupHook;
import org.apache.log4j.Logger;

public class BerechtigungspruefungMessageStartUpHook
implements StartupHook,
CidsServerMessageNotifierListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BerechtigungspruefungMessageStartUpHook.class);
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public void applicationStarted() {
        if ("WUNDA_BLAU".equals(SessionManager.getSession().getConnectionInfo().getUserDomain())) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csm://" + BerechtigungspruefungProperties.getInstance().getCsmAnfrage(), BerechtigungspruefungMessageStartUpHook.this.getConnectionContext())) {
                            CidsServerMessageNotifier.getInstance().subscribe((CidsServerMessageNotifierListener)BerechtigungspruefungMessageNotifier.getInstance(), BerechtigungspruefungProperties.getInstance().getCsmAnfrage());
                        }
                    }
                    catch (ConnectionException ex) {
                        LOG.warn((Object)("Konnte Rechte an csm://" + BerechtigungspruefungProperties.getInstance().getCsmAnfrage() + " nicht abfragen. Keine Benachrichtung bei neuen Pr\u00fcfungsanfragen!"), (Throwable)ex);
                    }
                    try {
                        if (SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csm://" + BerechtigungspruefungProperties.getInstance().getCsmBearbeitung(), BerechtigungspruefungMessageStartUpHook.this.getConnectionContext())) {
                            CidsServerMessageNotifier.getInstance().subscribe((CidsServerMessageNotifierListener)BerechtigungspruefungMessageNotifier.getInstance(), BerechtigungspruefungProperties.getInstance().getCsmBearbeitung());
                        }
                    }
                    catch (ConnectionException ex) {
                        LOG.warn((Object)("Konnte Rechte an csm://" + BerechtigungspruefungProperties.getInstance().getCsmBearbeitung() + " nicht abfragen. Keine Benachrichtung bei neuen Pr\u00fcfungsanfragen!"), (Throwable)ex);
                    }
                    CidsServerMessageNotifier.getInstance().subscribe((CidsServerMessageNotifierListener)BerechtigungspruefungMessageStartUpHook.this, BerechtigungspruefungProperties.getInstance().getCsmFreigabe());
                }
            }).start();
        }
    }

    public void messageRetrieved(CidsServerMessageNotifierListenerEvent event) {
        try {
            String benutzer = SessionManager.getSession().getUser().getName();
            MetaClass mcBerechtigungspruefung = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"BERECHTIGUNGSPRUEFUNG", (ConnectionContext)this.getConnectionContext());
            String query = "SELECT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE benutzer LIKE '" + benutzer + "' AND pruefstatus IS NOT NULL AND abgeholt IS NOT TRUE";
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(query, 0, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                for (MetaObject mo : mos) {
                    CidsBean berechtigungspruefungBean = mo.getBean();
                    String schluessel = (String)berechtigungspruefungBean.getProperty("schluessel");
                    if (Boolean.TRUE.equals(berechtigungspruefungBean.getProperty("pruefstatus"))) {
                        BerechtigungspruefungFreigabeDialog.getInstance().showFreigabe(berechtigungspruefungBean);
                        String produkttyp = (String)berechtigungspruefungBean.getProperty("produkttyp");
                        String downloadInfo = (String)berechtigungspruefungBean.getProperty("downloadinfo_json");
                        AlkisProductDownloadHelper.download(schluessel, produkttyp, downloadInfo, this.getConnectionContext());
                    } else {
                        BerechtigungspruefungStornoDialog.getInstance().showStorno(berechtigungspruefungBean);
                    }
                    try {
                        SessionManager.getProxy().executeTask("berechtigungspruefungAnfrage", "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{new ServerActionParameter(BerechtigungspruefungAnfrageServerAction.ParameterType.ABGEHOLT.toString(), (Object)schluessel)});
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

