/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BparkConfProperties {
    private static final transient Logger LOG = Logger.getLogger(BparkConfProperties.class);
    private final Double bufferMeter;
    private final String zonePattern;
    private final String nummerPattern;
    private final String urlMap;
    private final String urlRasterfari;
    private final String ordnerFotos;
    private final String ordnerThema;

    private BparkConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.zonePattern = String.valueOf(this.readProperty(properties, "ZONE_PATTERN", null));
        this.nummerPattern = String.valueOf(this.readProperty(properties, "NUMMER_PATTERN", null));
        this.urlMap = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING", null));
        this.urlRasterfari = String.valueOf(this.readProperty(properties, "RASTERFARI_URL", null));
        this.ordnerFotos = String.valueOf(this.readProperty(properties, "ORDNER_FOTOS", null));
        this.ordnerThema = String.valueOf(this.readProperty(properties, "ORDNER_THEMA", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.BPARK_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static BparkConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getZonePattern() {
        return this.zonePattern;
    }

    public String getNummerPattern() {
        return this.nummerPattern;
    }

    public String getUrlMap() {
        return this.urlMap;
    }

    public String getUrlRasterfari() {
        return this.urlRasterfari;
    }

    public String getOrdnerFotos() {
        return this.ordnerFotos;
    }

    public String getOrdnerThema() {
        return this.ordnerThema;
    }

    private static final class LazyInitialiser {
        private static final BparkConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            BparkConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.BPARK_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)BparkConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new BparkConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Laden der Properties f\u00fcr Bpark-Client", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

