/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class CidsSearchResultsList<O>
extends JList<O>
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(CidsSearchResultsList.class);
    private static final ListModel MODEL_LOAD = new DefaultListModel(){
        {
            this.add(0, "Ergebnisse werden geladen...");
        }
    };
    private static final ListModel MODEL_ERROR = new DefaultListModel(){
        {
            this.add(0, "[Fehler]");
        }
    };
    private static final ListModel MODEL_EMPTY = new DefaultListModel(){
        {
            this.add(0, "keine");
        }
    };
    ConnectionContext connectionContext = ConnectionContext.createDummy();
    private CidsServerSearch search;

    public CidsSearchResultsList() {
        this((CidsServerSearch)null);
    }

    public CidsSearchResultsList(CidsServerSearch search) {
        this.search = search;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public void refresh() {
        if (this.search != null) {
            this.setModel(MODEL_LOAD);
            new SwingWorker<Collection<O>, Void>(){

                @Override
                protected Collection<O> doInBackground() throws Exception {
                    return SessionManager.getProxy().customServerSearch(CidsSearchResultsList.this.search, CidsSearchResultsList.this.getConnectionContext());
                }

                @Override
                protected void done() {
                    try {
                        Collection results = (Collection)this.get();
                        if (results != null) {
                            if (results.isEmpty()) {
                                CidsSearchResultsList.this.setModel(MODEL_EMPTY);
                            } else {
                                DefaultListModel model = new DefaultListModel();
                                for (Object result : results) {
                                    model.addElement(result);
                                }
                                CidsSearchResultsList.this.setModel(model);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        CidsSearchResultsList.this.setModel(MODEL_ERROR);
                    }
                }
            }.execute();
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public CidsServerSearch getSearch() {
        return this.search;
    }

    public void setSearch(CidsServerSearch search) {
        this.search = search;
    }
}

