/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class DoubleNumberConverter
extends Converter<Double, String> {
    private static final transient Logger LOG = Logger.getLogger(DoubleNumberConverter.class);
    private static final DoubleNumberConverter INSTANCE = new DoubleNumberConverter();

    public static DoubleNumberConverter getInstance() {
        return INSTANCE;
    }

    public String convertForward(Double value) {
        return value.toString();
    }

    public Double convertReverse(String value) {
        try {
            if (value == null) {
                return null;
            }
            return new Double(value.replace(',', '.'));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("No valid number: " + value), (Throwable)e);
            return null;
        }
    }
}

