/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EmobConfProperties {
    private static final transient Logger LOG = Logger.getLogger(EmobConfProperties.class);
    private final String fotoUrlAutos;
    private final Double bufferMeter;
    private final String fotoUrlRaeder;
    private final String fotoUrlVerleih;

    private EmobConfProperties(Properties properties) {
        this.fotoUrlAutos = this.readProperty(properties, "PICTURE_PATH_CARS", null);
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.fotoUrlRaeder = this.readProperty(properties, "PICTURE_PATH_BIKES", null);
        this.fotoUrlVerleih = this.readProperty(properties, "PICTURE_PATH_RENT", null);
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.EMOB_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static EmobConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String getFotoUrlAutos() {
        return this.fotoUrlAutos;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getFotoUrlRaeder() {
        return this.fotoUrlRaeder;
    }

    public String getFotoUrlVerleih() {
        return this.fotoUrlVerleih;
    }

    private static final class LazyInitialiser {
        private static final EmobConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            EmobConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.EMOB_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)EmobConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new EmobConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

