/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import org.apache.log4j.Logger;

public class InspireUtils {
    private static final Logger LOG = Logger.getLogger(InspireUtils.class);
    public static final String FIELD__INSPIRE_EIND_ID = "inspire_eindeutige_id";
    public static final String FIELD__UUID = "uuid";
    public static final String FIELD__HERKUNFT = "herkunft";

    public static String generateUuid(ConnectionContext connectionContext) {
        String uuid = InspireUtils.getRandomHex() + InspireUtils.getRandomHex() + "-" + InspireUtils.getRandomHex() + "-" + InspireUtils.getRandomHex() + "-" + InspireUtils.getRandomHex() + "-" + InspireUtils.getRandomHex() + InspireUtils.getRandomHex() + InspireUtils.getRandomHex();
        String myWhere = " where uuid ilike '" + uuid + "'";
        CidsBean uuidBean = TableUtils.getOtherTableValue(FIELD__INSPIRE_EIND_ID, myWhere, connectionContext);
        if (uuidBean == null) {
            return uuid;
        }
        String neueUuid = InspireUtils.generateUuid(connectionContext);
        return neueUuid;
    }

    public static String getRandomHex() {
        int zahl = (int)Math.floor(Math.random() * Math.floor(65536.0));
        String uuid = Integer.toHexString(zahl);
        while (uuid.length() < 4) {
            uuid = "0" + uuid;
        }
        return uuid;
    }

    public static CidsBean writeUuid(String uuid, CidsBean classBean, String propertyValue, String herkunft, ConnectionContext connectionContext) {
        try {
            MetaClass metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)FIELD__INSPIRE_EIND_ID, (ConnectionContext)connectionContext);
            if (metaClass != null) {
                CidsBean newInspireBean = metaClass.getEmptyInstance(connectionContext).getBean();
                newInspireBean.setProperty(FIELD__UUID, (Object)uuid);
                newInspireBean.setProperty(FIELD__HERKUNFT, (Object)herkunft);
                classBean.setProperty(propertyValue, (Object)newInspireBean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"writeUuid failed", (Throwable)ex);
        }
        return classBean;
    }
}

