/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class NumberConverter
extends Converter<Float, String> {
    private static final transient Logger LOG = Logger.getLogger(NumberConverter.class);
    private static final NumberConverter INSTANCE = new NumberConverter();

    public static NumberConverter getInstance() {
        return INSTANCE;
    }

    public String convertForward(Float value) {
        return value.toString();
    }

    public Float convertReverse(String value) {
        try {
            if (value == null) {
                return null;
            }
            return new Float(value.replace(',', '.'));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("No valid number: " + value), (Throwable)e);
            return null;
        }
    }
}

