/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PoiConfProperties {
    private static final transient Logger LOG = Logger.getLogger(PoiConfProperties.class);
    private final Integer keyUrlLength;
    private final String keyUrlPattern;

    private PoiConfProperties(Properties properties) {
        this.keyUrlLength = Integer.valueOf(this.readProperty(properties, "MAX_KEYURL_LENGTH", null));
        this.keyUrlPattern = String.valueOf(this.readProperty(properties, "KEYURL_PATTERN", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.POI_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static PoiConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Integer getKeyUrlLength() {
        return this.keyUrlLength;
    }

    public String getKeyUrlPattern() {
        return this.keyUrlPattern;
    }

    private static final class LazyInitialiser {
        private static final PoiConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            PoiConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.POI_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)PoiConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new PoiConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

