/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import de.cismet.cids.custom.objecteditors.utils.CustomListCellRenderer;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.editors.EditorAndRendererComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.el.impl.ValueExpressionImpl;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;

public class RendererTools {
    private static final Logger LOG = Logger.getLogger(RendererTools.class);
    public static final Color ERROR_BACKGROUND = new Color(250, 215, 216);
    public static final Color ERROR_FORGROUND = new Color(145, 32, 32);

    private static Collection<JComponent> getAllBindedComponents(BindingGroup bindingGroup, String baseProp) {
        ArrayList<JComponent> allBindedComponents = new ArrayList<JComponent>();
        if (bindingGroup != null) {
            List bindings = bindingGroup.getBindings();
            for (Binding binding : bindings) {
                if (binding == null || !(binding.getTargetObject() instanceof JComponent)) continue;
                JComponent bindedComponent = (JComponent)binding.getTargetObject();
                ELProperty p = (ELProperty)binding.getSourceProperty();
                try {
                    Field expressionField = p.getClass().getDeclaredField("expression");
                    expressionField.setAccessible(true);
                    ValueExpressionImpl valueExpression = (ValueExpressionImpl)expressionField.get(p);
                    String expr = valueExpression.getExpressionString();
                    if (!expr.substring(2, expr.length() - 1).startsWith(baseProp + ".")) continue;
                    allBindedComponents.add(bindedComponent);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    LOG.warn((Object)"", (Throwable)ex);
                }
            }
        }
        return allBindedComponents;
    }

    public static void makeReadOnly(BindingGroup bindingGroup, String baseProp) {
        RendererTools.makeReadOnly(bindingGroup, baseProp, true);
    }

    public static void makeReadOnly(BindingGroup bindingGroup, String baseProp, boolean asRenderer) {
        for (JComponent component : RendererTools.getAllBindedComponents(bindingGroup, baseProp)) {
            RendererTools.makeReadOnly(component, asRenderer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void makeUneditable(BindingGroup bindingGroup, String baseProp, boolean readOnly) {
        for (JComponent component : RendererTools.getAllBindedComponents(bindingGroup, baseProp)) {
            RendererTools.makeUneditable(component, readOnly);
        }
        if (bindingGroup == null) return;
        List bindings = bindingGroup.getBindings();
        for (Binding binding : bindings) {
            if (binding == null || !(binding.getTargetObject() instanceof JComponent)) continue;
            JComponent target = (JComponent)binding.getTargetObject();
            ELProperty p = (ELProperty)binding.getSourceProperty();
            try {
                Field expressionField = p.getClass().getDeclaredField("expression");
                expressionField.setAccessible(true);
                ValueExpressionImpl valueExpression = (ValueExpressionImpl)expressionField.get(p);
                String expr = valueExpression.getExpressionString();
                if (!expr.substring(2, expr.length() - 1).startsWith(baseProp + ".")) continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                LOG.warn((Object)"", (Throwable)ex);
            }
        }
    }

    public static void makeReadOnly(JComponent comp) {
        RendererTools.makeReadOnly(comp, true);
    }

    public static void makeReadOnly(JComponent comp, boolean asRenderer) {
        if (comp instanceof EditorAndRendererComponent) {
            EditorAndRendererComponent er = (EditorAndRendererComponent)comp;
            er.setActingAsRenderer(asRenderer);
        } else {
            RendererTools.makeUneditable(comp, asRenderer);
        }
    }

    public static void makeUneditable(JComponent comp, boolean readOnly) {
        if (comp != null) {
            JComponent cb;
            JTextComponent tComp;
            UneditableMarkerComp newUneditableMarker;
            UneditableMarkerComp oldUneditableMarker = null;
            if (readOnly) {
                newUneditableMarker = new UneditableMarkerComp();
                comp.addComponentListener(newUneditableMarker);
            } else {
                for (ComponentListener subComp : comp.getComponentListeners()) {
                    if (!(subComp instanceof UneditableMarkerComp)) continue;
                    oldUneditableMarker = (UneditableMarkerComp)subComp;
                    break;
                }
                if (oldUneditableMarker != null) {
                    comp.removeComponentListener(oldUneditableMarker);
                }
                newUneditableMarker = null;
            }
            if (comp instanceof JTextArea) {
                tComp = (JTextArea)comp;
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        JTextArea dummy = new JTextArea();
                        newUneditableMarker.setDummy(dummy);
                        dummy.setBorder(tComp.getBorder());
                    }
                    tComp.setBorder(new EmptyBorder(0, 0, 0, 0));
                } else if (oldUneditableMarker != null) {
                    JTextArea dummy = (JTextArea)oldUneditableMarker.getDummy();
                    tComp.setBorder(dummy.getBorder());
                }
                tComp.setEditable(!readOnly);
                tComp.setOpaque(!readOnly);
            } else if (comp instanceof JTextField) {
                tComp = (JTextField)comp;
                tComp.setEditable(!readOnly);
                tComp.setOpaque(!readOnly);
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        JTextField dummy = new JTextField();
                        dummy.setBorder(tComp.getBorder());
                        newUneditableMarker.setDummy(dummy);
                    }
                    tComp.setBorder(new EmptyBorder(0, 0, 0, 0));
                } else if (oldUneditableMarker != null) {
                    JTextField dummy = (JTextField)oldUneditableMarker.getDummy();
                    tComp.setBorder(dummy.getBorder());
                }
            } else if (comp instanceof JScrollPane) {
                JScrollPane jsp = (JScrollPane)comp;
                jsp.setOpaque(!readOnly);
                jsp.getViewport().setOpaque(true);
            } else if (comp instanceof JComboBox) {
                cb = (JComboBox)comp;
                ((JComboBox)cb).setEnabled(!readOnly);
                if (readOnly) {
                    ((JComboBox)cb).setRenderer(new CustomListCellRenderer(((JComboBox)cb).getRenderer()));
                } else if (((JComboBox)cb).getRenderer() instanceof CustomListCellRenderer) {
                    ((JComboBox)cb).setRenderer(((CustomListCellRenderer)((JComboBox)cb).getRenderer()).getOrigRenderer());
                }
            } else if (comp instanceof JSpinner) {
                JSpinner sp = (JSpinner)comp;
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        JSpinner dummy = new JSpinner();
                        newUneditableMarker.setDummy(dummy);
                        dummy.setOpaque(sp.isOpaque());
                        dummy.setBorder(sp.getBorder());
                        dummy.getEditor().setOpaque(sp.getEditor().isOpaque());
                        ((JSpinner.DefaultEditor)dummy.getEditor()).getTextField().setOpaque(((JSpinner.DefaultEditor)sp.getEditor()).getTextField().isOpaque());
                    }
                    sp.setOpaque(false);
                    sp.setBorder(null);
                    sp.getEditor().setOpaque(false);
                    ((JSpinner.DefaultEditor)sp.getEditor()).getTextField().setOpaque(false);
                } else if (oldUneditableMarker != null) {
                    JSpinner dummy = (JSpinner)oldUneditableMarker.getDummy();
                    sp.setOpaque(dummy.isOpaque());
                    sp.setBorder(dummy.getBorder());
                    sp.getEditor().setOpaque(dummy.getEditor().isOpaque());
                    ((JSpinner.DefaultEditor)sp.getEditor()).getTextField().setOpaque(((JSpinner.DefaultEditor)dummy.getEditor()).getTextField().isOpaque());
                }
            } else if (comp instanceof DefaultBindableDateChooser) {
                DefaultBindableDateChooser dummy;
                DefaultBindableDateChooser dc = (DefaultBindableDateChooser)comp;
                Component arrow = dc.getComponents()[1];
                JFormattedTextField textField = (JFormattedTextField)dc.getComponents()[0];
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        dummy = new DefaultBindableDateChooser();
                        newUneditableMarker.setDummy((Component)dummy);
                        dummy.setOpaque(textField.isOpaque());
                        dummy.setBorder(textField.getBorder());
                    }
                    textField.setOpaque(false);
                    textField.setBorder(null);
                } else if (oldUneditableMarker != null) {
                    dummy = (DefaultBindableDateChooser)oldUneditableMarker.getDummy();
                    textField.setOpaque(dummy.isOpaque());
                    textField.setBorder(dummy.getBorder());
                }
                dc.setEditable(!readOnly);
                arrow.setVisible(!readOnly);
            } else if (comp instanceof JCheckBox) {
                cb = (JCheckBox)comp;
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        JCheckBox dummy = new JCheckBox();
                        newUneditableMarker.setDummy(dummy);
                        dummy.setUI(((AbstractButton)cb).getUI());
                    }
                    ((AbstractButton)cb).setUI(new BasicCheckBoxUI(){

                        @Override
                        protected BasicButtonListener createButtonListener(AbstractButton b) {
                            return null;
                        }
                    });
                } else if (oldUneditableMarker != null) {
                    JCheckBox dummy = (JCheckBox)oldUneditableMarker.getDummy();
                    ((AbstractButton)cb).setUI(dummy.getUI());
                }
            } else if (comp instanceof JXTable) {
                JXTable jxt = (JXTable)comp;
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        JXTable dummy = new JXTable();
                        newUneditableMarker.setDummy((Component)dummy);
                        dummy.setGridColor(jxt.getGridColor());
                        dummy.setBackground(jxt.getBackground());
                    }
                    ((DefaultTableRenderer)jxt.getDefaultRenderer(Object.class)).setBackground(new Color(0, 0, 0, 0));
                    jxt.setGridColor(Color.GRAY);
                    jxt.setBackground(new Color(0, 0, 0, 0));
                } else if (oldUneditableMarker != null) {
                    JXTable dummy = (JXTable)oldUneditableMarker.getDummy();
                    jxt.setGridColor(dummy.getGridColor());
                    jxt.setBackground(dummy.getBackground());
                }
                jxt.setEditable(!readOnly);
                jxt.setOpaque(!readOnly);
            } else if (comp instanceof JList) {
                JList jl = (JList)comp;
                if (readOnly) {
                    if (newUneditableMarker != null) {
                        JList dummy = new JList();
                        newUneditableMarker.setDummy(dummy);
                        dummy.setOpaque(jl.isOpaque());
                        dummy.setCellRenderer(jl.getCellRenderer());
                    }
                    jl.setOpaque(false);
                    jl.setCellRenderer(new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                            this.setOpaque(isSelected);
                            return this;
                        }
                    });
                } else if (oldUneditableMarker != null) {
                    JList dummy = (JList)oldUneditableMarker.getDummy();
                    jl.setOpaque(dummy.isOpaque());
                    jl.setCellRenderer(dummy.getCellRenderer());
                }
            } else {
                comp.setEnabled(!readOnly);
            }
        }
    }

    public static void makeDoubleSpinnerWithoutButtons(JSpinner spinner, int digits) {
        spinner.setUI(new BasicSpinnerUI(){

            @Override
            protected Component createNextButton() {
                return null;
            }

            @Override
            protected Component createPreviousButton() {
                return null;
            }
        });
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(digits);
        format.setMaximumFractionDigits(digits);
    }

    public static void makeTextBlackOfDisabledComboBox(JComboBox comboBox) {
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).setDisabledTextColor(Color.black);
        }
    }

    public static void jSpinnerShouldLookLikeLabel(JSpinner spinner) {
        spinner.setEnabled(false);
        spinner.setUI(new EmtpySpinnerUI());
        JComponent editorComponent = spinner.getEditor();
        if (editorComponent instanceof JSpinner.NumberEditor) {
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)editorComponent;
            editor.getTextField().setDisabledTextColor(Color.BLACK);
            editor.getTextField().setOpaque(false);
            editor.getTextField().setBorder(null);
        }
        spinner.getEditor().setOpaque(false);
        spinner.getEditor().setBorder(null);
        spinner.setBorder(null);
        spinner.setOpaque(false);
    }

    public static void jComboboxShouldLookLikeLabel(JComboBox combobox) {
        combobox.setEnabled(false);
        combobox.setUI(new EmptyComboBoxUI());
        Component editorComponent = combobox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            JTextComponent editor = (JTextComponent)editorComponent;
            editor.setDisabledTextColor(Color.BLACK);
            editor.setOpaque(false);
            editor.setBorder(null);
        }
        combobox.setBorder(null);
        combobox.setOpaque(false);
    }

    public static void jxDatePickerShouldLookLikeLabel(JXDatePicker datePicker) {
        datePicker.setEnabled(false);
        datePicker.getEditor().setDisabledTextColor(Color.BLACK);
        datePicker.getEditor().setOpaque(false);
        datePicker.getEditor().setBorder(null);
        datePicker.getComponent(1).setVisible(false);
    }

    public static void showErrorState(JComponent comp) {
        if (comp instanceof JComboBox) {
            RendererTools.changeOnlyEditorBackgroundAndForegroundColorOfEditableJComboBox((JComboBox)comp, ERROR_BACKGROUND, ERROR_FORGROUND);
        } else {
            comp.setForeground(ERROR_FORGROUND);
            comp.setBackground(ERROR_BACKGROUND);
        }
    }

    public static void showNormalState(JComponent comp) {
        if (comp instanceof JComboBox) {
            RendererTools.changeOnlyEditorBackgroundAndForegroundColorOfEditableJComboBox((JComboBox)comp, Color.white, Color.black);
        } else {
            comp.setForeground(Color.black);
            comp.setBackground(Color.white);
        }
    }

    public static void changeOnlyEditorBackgroundAndForegroundColorOfEditableJComboBox(JComboBox cb, Color backgroundColor, Color foregroundColor) {
        cb.getEditor().getEditorComponent().setBackground(backgroundColor);
        cb.getEditor().getEditorComponent().setForeground(foregroundColor);
        Component[] comps = cb.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JButton)) continue;
            JButton coloredArrowsButton = (JButton)comps[i];
            coloredArrowsButton.setBackground(null);
            coloredArrowsButton.setForeground(null);
            break;
        }
        cb.setRenderer(new RemoveColorFromComboBoxListRenderer());
    }

    public static class NoTabTextAreaKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent evt) {
            JTextArea textArea = (JTextArea)evt.getComponent();
            if (evt.getKeyCode() == 9) {
                if (evt.getModifiers() > 0) {
                    textArea.transferFocusBackward();
                } else {
                    textArea.transferFocus();
                }
                evt.consume();
            }
        }
    }

    static class EmptyComboBoxUI
    extends BasicComboBoxUI {
        EmptyComboBoxUI() {
        }

        @Override
        protected JButton createArrowButton() {
            return null;
        }
    }

    static class EmtpySpinnerUI
    extends BasicSpinnerUI {
        EmtpySpinnerUI() {
        }

        @Override
        protected Component createNextButton() {
            return null;
        }

        @Override
        protected Component createPreviousButton() {
            return null;
        }
    }

    private static class RemoveColorFromComboBoxListRenderer
    extends BasicComboBoxRenderer {
        private RemoveColorFromComboBoxListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            this.setFont(list.getFont());
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else {
                this.setText(value == null ? "" : value.toString());
            }
            return this;
        }
    }

    private static class UneditableMarkerComp
    extends ComponentAdapter {
        private Component dummy;

        private UneditableMarkerComp() {
        }

        public void setDummy(Component compDummy) {
            this.dummy = compDummy;
        }

        public Component getDummy() {
            return this.dummy;
        }
    }
}

