/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.DivBeanTable;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class TableUtils {
    private static final Logger LOG = Logger.getLogger(TableUtils.class);

    public static CidsBean getOtherTableValue(String myTable, String myWhere, ConnectionContext connectionContext) {
        MetaObject[] myMetaObject = TableUtils.getOtherTableValues(myTable, myWhere, connectionContext);
        if (myMetaObject != null && myMetaObject.length > 0) {
            return myMetaObject[0].getBean();
        }
        return null;
    }

    public static MetaObject[] getOtherTableValues(String myTable, String myWhere, ConnectionContext connectionContext) {
        block6: {
            try {
                MetaClass myClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)myTable, (ConnectionContext)connectionContext);
                if (myClass == null) break block6;
                StringBuffer myQuery = new StringBuffer("select ").append(myClass.getId()).append(", ").append(myClass.getName()).append(".").append(myClass.getPrimaryKey()).append(" from ").append(myClass.getTableName()).append(myWhere);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: myQuery:" + myQuery.toString()));
                }
                try {
                    MetaObject[] myMetaObject = SessionManager.getProxy().getMetaObjectByQuery(myQuery.toString(), 0, connectionContext);
                    if (myMetaObject.length > 0) {
                        return myMetaObject;
                    }
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)(myWhere + " kann nicht geladen werden in getOtherTableValue."), (Throwable)ex);
            }
        }
        return null;
    }

    public static String getMyWhere(String myWhere) {
        return " where name ilike '" + myWhere + "'";
    }

    public static CidsBean deleteItemFromList(CidsBean deleteBean, String propertyName, Object value, boolean andDeleteObjectFromDB) {
        if (value instanceof CidsBean && propertyName != null) {
            CidsBean bean = (CidsBean)value;
            if (andDeleteObjectFromDB) {
                try {
                    bean.delete();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            } else {
                Object coll = deleteBean.getProperty(propertyName);
                if (coll instanceof Collection) {
                    ((Collection)coll).remove(bean);
                }
            }
        }
        return deleteBean;
    }

    public static CidsBean addBeanToCollection(CidsBean addBean, String propName, CidsBean newTypeBean) {
        return TableUtils.addBeanToCollectionWithMessage(null, addBean, propName, newTypeBean);
    }

    public static CidsBean addBeanToCollectionWithMessage(Component parentComponent, CidsBean addBean, String propName, CidsBean newTypeBean) {
        Object o;
        if (newTypeBean != null && propName != null && (o = addBean.getProperty(propName)) instanceof Collection) {
            try {
                Collection col = (Collection)o;
                for (CidsBean bean : col) {
                    if (!newTypeBean.equals((Object)bean)) continue;
                    LOG.info((Object)("Bean " + newTypeBean + " already present in " + propName + "!"));
                    if (parentComponent != null) {
                        JOptionPane.showMessageDialog(parentComponent, "Das Objekt " + newTypeBean + " kann nicht noch einmal hinzugef\u00fcgt werden.", "Objekt hinzuf\u00fcgen", 0);
                    }
                    return addBean;
                }
                col.add(newTypeBean);
            }
            catch (HeadlessException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return addBean;
    }

    public static void addObjectToTable(JXTable table, String tableClass, ConnectionContext connectionContext) {
        try {
            CidsBean bean = CidsBeanSupport.createNewCidsBeanFromTableName(tableClass, connectionContext);
            ((DivBeanTable)table.getModel()).addBean(bean);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot add new " + tableClass + " object"), (Throwable)e);
        }
    }

    public static void removeObjectsFromTable(JXTable table) {
        int[] selectedRows = table.getSelectedRows();
        ArrayList<Integer> modelRows = new ArrayList<Integer>();
        for (int row : selectedRows) {
            modelRows.add(table.convertRowIndexToModel(row));
        }
        Collections.sort(modelRows, Collections.reverseOrder());
        Object object = modelRows.iterator();
        while (object.hasNext()) {
            Integer row = (Integer)object.next();
            ((DivBeanTable)table.getModel()).removeRow(row);
        }
    }
}

