/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objecteditors.wunda_blau.VermessungRissEditor;
import de.cismet.cids.custom.objectrenderer.utils.VermessungPictureFinderClientUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class VermessungUmleitungPanel
extends JPanel
implements DocumentListener,
CidsBeanDropListener,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VermessungUmleitungPanel.class);
    public static final String PLATZHALTER_PREFIX = "platzhalter";
    private static final String SEP = "/";
    private static String VERMESSUNG_DIRECTORY;
    private static String GRENZNIEDERSCHRIFT_DIRECTORY;
    private static String WEB_DAV_USER;
    private static String WEB_DAV_PASSWORD;
    private static boolean initError;
    private static String GRENZNIEDERSCHRIFT_PREFIX;
    private MODE mode;
    private VermessungRissEditor editor;
    private final Timer t = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            VermessungUmleitungPanel.this.t.stop();
            CardLayout cl = (CardLayout)VermessungUmleitungPanel.this.pnlControls.getLayout();
            cl.show(VermessungUmleitungPanel.this.pnlControls, "card2");
            VermessungUmleitungPanel.this.jXBusyLabel1.setBusy(true);
            String input = VermessungUmleitungPanel.this.getLinkDocument();
            if (input != null && !input.isEmpty()) {
                if (VermessungUmleitungPanel.this.isNummerConsistent(input)) {
                    if (!input.contains(VermessungUmleitungPanel.PLATZHALTER_PREFIX)) {
                        VermessungUmleitungPanel.this.tfName.getDocument().removeDocumentListener(VermessungUmleitungPanel.this);
                        String[] props = VermessungUmleitungPanel.this.parsePropertiesFromLink(input);
                        String correctFormattedNumber = props[0] + "-" + props[1] + "-" + props[2] + "-" + props[3];
                        VermessungUmleitungPanel.this.tfName.setText(correctFormattedNumber);
                        VermessungUmleitungPanel.this.tfName.getDocument().addDocumentListener(VermessungUmleitungPanel.this);
                    }
                    if (!VermessungUmleitungPanel.this.checkIfRissExists(input)) {
                        cl.show(VermessungUmleitungPanel.this.pnlControls, "card4");
                        VermessungUmleitungPanel.this.editor.handleRissDoesNotExists();
                    } else {
                        VermessungUmleitungPanel.this.checkIfLinkDocumentExists();
                    }
                } else {
                    VermessungUmleitungPanel.this.showError();
                }
            } else {
                cl.show(VermessungUmleitungPanel.this.pnlControls, "card3");
            }
        }
    });
    private long lastChange = 0L;
    private WebDavTunnelHelper webDavHelper;
    private boolean firstDocumentChange = true;
    private String lastCheckedDocument;
    private String escapeText;
    private final ConnectionContext connectionContext;
    private JButton btnCreateDocument;
    private JButton btnPlatzhalter;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JXBusyLabel jXBusyLabel1;
    private JLabel lblMessage;
    private JLabel lblMode;
    private JPanel pnlBusyLabel;
    private JPanel pnlControls;
    private JPanel pnlEmpty;
    private JPanel pnlError;
    private JPanel pnlOkButton;
    private JTextField tfName;

    public VermessungUmleitungPanel() {
        this(MODE.VERMESSUNGSRISS, null, null);
    }

    public VermessungUmleitungPanel(MODE m, VermessungRissEditor editor, ConnectionContext connectionContext) {
        this.mode = m;
        this.editor = editor;
        this.connectionContext = connectionContext;
        this.initComponents();
        this.jXBusyLabel1.setSize(16, 16);
        this.tfName.getDocument().addDocumentListener(this);
        if (!initError) {
            this.webDavHelper = new WebDavTunnelHelper("WUNDA_BLAU", ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, Boolean.valueOf(false));
        }
        new CidsBeanDropTarget((Component)this);
        new CidsBeanDropTarget((Component)this.tfName);
    }

    public void setLinkDocumentText(String text) {
        this.setLinkDocumentText(text, false);
    }

    public void setLinkDocumentText(String text, boolean fireEvent) {
        if (!fireEvent) {
            this.tfName.getDocument().removeDocumentListener(this);
        }
        this.escapeText = text;
        this.tfName.setText(text);
        CardLayout cl = (CardLayout)this.pnlControls.getLayout();
        cl.show(this.pnlControls, "card1");
        if (!fireEvent) {
            this.tfName.getDocument().addDocumentListener(this);
        }
    }

    public void setMode(MODE m) {
        this.mode = m;
        if (this.mode == MODE.VERMESSUNGSRISS) {
            this.lblMode.setVisible(false);
            this.btnPlatzhalter.setVisible(false);
        } else {
            this.lblMode.setVisible(true);
            this.btnPlatzhalter.setVisible(true);
        }
    }

    private void showError() {
        this.editor.handleNoDocumentFound();
        CardLayout cl = (CardLayout)this.pnlControls.getLayout();
        cl.show(this.pnlControls, "card4");
    }

    private boolean checkIfRissExists(String rissNummer) {
        try {
            if (rissNummer.startsWith(PLATZHALTER_PREFIX)) {
                return true;
            }
            String[] props = this.parsePropertiesFromLink(rissNummer);
            MetaClass MB_MC = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"vermessung_riss", (ConnectionContext)this.getConnectionContext());
            String query = "SELECT " + MB_MC.getID() + ", " + MB_MC.getPrimaryKey() + " ";
            query = query + "FROM " + MB_MC.getTableName();
            query = query + " WHERE schluessel ilike '" + props[0] + "' and gemarkung=" + props[1] + " and flur ilike '" + props[2] + "' and blatt ilike '" + StringUtils.stripStart((String)props[3], (String)"0") + "'";
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0, this.getConnectionContext());
            return metaObjects != null && metaObjects.length == 1 && metaObjects[0] != null;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error while checkig if riss exists", (Throwable)ex);
            return false;
        }
    }

    public void checkState() {
        this.checkIfLinkDocumentExists();
    }

    private void checkIfLinkDocumentExists() {
        final String linkDokument = this.getLinkDocument();
        final boolean isGrenzniederschrift = MODE.GRENZNIEDERSCHRIFT.equals((Object)this.mode);
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected void done() {
                try {
                    String document = (String)this.get();
                    VermessungUmleitungPanel.this.jXBusyLabel1.setBusy(false);
                    CardLayout cl = (CardLayout)VermessungUmleitungPanel.this.pnlControls.getLayout();
                    cl.show(VermessungUmleitungPanel.this.pnlControls, "card3");
                    if (document != null) {
                        VermessungUmleitungPanel.this.lastCheckedDocument = document;
                        VermessungUmleitungPanel.this.editor.successAlert();
                        VermessungUmleitungPanel.this.editor.reloadDocument(VermessungUmleitungPanel.this.lastCheckedDocument);
                    } else {
                        VermessungUmleitungPanel.this.lastCheckedDocument = VermessungPictureFinderClientUtils.getGrenzniederschriftLinkFilename(VermessungUmleitungPanel.this.getLinkDocument());
                        VermessungUmleitungPanel.this.editor.warnAlert();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Worker Thread interrupter", (Throwable)ex);
                    VermessungUmleitungPanel.this.showError();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Execution error", (Throwable)ex);
                    VermessungUmleitungPanel.this.showError();
                }
            }

            @Override
            protected String doInBackground() throws Exception {
                boolean isPlatzhalter = linkDokument.toLowerCase().startsWith(VermessungUmleitungPanel.PLATZHALTER_PREFIX);
                if (!isGrenzniederschrift && !isPlatzhalter) {
                    return null;
                }
                if (isPlatzhalter) {
                    return (isGrenzniederschrift ? VermessungPictureFinderClientUtils.getGrenzniederschriftLinkFilename(linkDokument) : VermessungPictureFinderClientUtils.getVermessungsrissLinkFilename(linkDokument)) + ".jpg";
                }
                String[] props = VermessungUmleitungPanel.this.parsePropertiesFromLink(linkDokument);
                if (isGrenzniederschrift) {
                    return VermessungPictureFinderClientUtils.findVermessungsrissPicture(props[0], Integer.parseInt(props[1]), props[2], props[3]);
                }
                return VermessungPictureFinderClientUtils.findGrenzniederschriftPicture(props[0], Integer.parseInt(props[1]), props[2], props[3]);
            }
        };
        worker.execute();
    }

    private String[] parsePropertiesFromLink(String link) {
        String[] splittedInput = link.split("-");
        if (splittedInput.length != 4) {
            return null;
        }
        String[] res = new String[]{splittedInput[0], splittedInput[1], StringUtils.leftPad((String)splittedInput[2], (int)3, (char)'0'), StringUtils.leftPad((String)splittedInput[3], (int)8, (char)'0')};
        return res;
    }

    private boolean isNummerConsistent(String vermessungrissNummer) {
        return vermessungrissNummer.matches("platzhalter.(\\d{3})") || vermessungrissNummer.matches("(\\d{3})-(\\d{4})-(\\d{1,3})-(\\d{1,8})");
    }

    private void deleteFile() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                if (initError) {
                    return false;
                }
                String filename = VermessungUmleitungPanel.this.createFilename();
                return VermessungUmleitungPanel.this.webDavHelper.deleteFileFromWebDAV(filename + ".txt", VermessungUmleitungPanel.this.createDirName(), VermessungUmleitungPanel.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.title"), NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.delete.message"), null, null, null, Level.ALL, null);
                        JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)VermessungUmleitungPanel.this), (ErrorInfo)ei);
                        VermessungUmleitungPanel.this.editor.handleEscapePressed();
                        if (VermessungUmleitungPanel.this.escapeText != null) {
                            VermessungUmleitungPanel.this.tfName.setText(VermessungUmleitungPanel.this.escapeText);
                        } else {
                            VermessungUmleitungPanel.this.tfName.setText("");
                        }
                    } else {
                        VermessungUmleitungPanel.this.editor.handleUmleitungDeleted();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Deleting link file worker was interrupted", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)"Error in deleting link file worker", (Throwable)ex);
                    ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanell.errorDialog.title"), NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.delete.message"), ex.getMessage(), null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)VermessungUmleitungPanel.this), (ErrorInfo)ei);
                }
            }
        };
        worker.execute();
    }

    private void createLinkFile() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                if (initError) {
                    return false;
                }
                String filename = VermessungUmleitungPanel.this.createFilename();
                File f = File.createTempFile(filename, ".txt");
                FileWriter fw = new FileWriter(f);
                BufferedWriter bfw = new BufferedWriter(fw);
                bfw.write(VermessungUmleitungPanel.this.getLinkDocument(), 0, VermessungUmleitungPanel.this.getLinkDocument().length());
                bfw.flush();
                bfw.close();
                VermessungUmleitungPanel.this.webDavHelper.uploadFileToWebDAV(filename + ".txt", f, VermessungUmleitungPanel.this.createDirName(), (Component)VermessungUmleitungPanel.this.editor, VermessungUmleitungPanel.this.getConnectionContext());
                return true;
            }

            @Override
            protected void done() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.title"), NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.create.message"), null, null, null, Level.ALL, null);
                        JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)VermessungUmleitungPanel.this), (ErrorInfo)ei);
                        VermessungUmleitungPanel.this.showError();
                        return;
                    }
                    VermessungUmleitungPanel.this.editor.handleUmleitungCreated(VermessungUmleitungPanel.this.lastCheckedDocument);
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Create Link File Worker was interrupted.", (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error in Create Link File worker", (Throwable)ex);
                    ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.title"), NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.errorDialog.create.message"), ex.getMessage(), null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)VermessungUmleitungPanel.this), (ErrorInfo)ei);
                }
            }
        };
        worker.execute();
    }

    private String createDirName() {
        CidsBean vermessungBean = this.editor.getCidsBean();
        CidsBean gemarkungBean = (CidsBean)vermessungBean.getProperty("gemarkung");
        Integer gemarkung = 0;
        if (gemarkungBean != null) {
            gemarkung = (Integer)gemarkungBean.getProperty("id");
        }
        StringBuffer buf = new StringBuffer();
        if (this.mode == MODE.VERMESSUNGSRISS) {
            buf.append(VERMESSUNG_DIRECTORY);
        } else {
            buf.append(GRENZNIEDERSCHRIFT_DIRECTORY);
        }
        buf.append(SEP);
        buf.append(String.format("%04d", gemarkung));
        buf.append(SEP);
        return buf.toString();
    }

    private String createFilename() {
        CidsBean vermessungBean = this.editor.getCidsBean();
        String schluessel = vermessungBean.getProperty("schluessel").toString();
        CidsBean gemarkungBean = (CidsBean)vermessungBean.getProperty("gemarkung");
        Integer gemarkung = 0;
        if (gemarkungBean != null) {
            gemarkung = (Integer)gemarkungBean.getProperty("id");
        }
        String flur = vermessungBean.getProperty("flur").toString();
        String blatt = vermessungBean.getProperty("blatt").toString();
        String fullPath = MODE.GRENZNIEDERSCHRIFT.equals((Object)this.mode) ? VermessungPictureFinderClientUtils.getGrenzniederschriftPictureFilename(schluessel, gemarkung, flur, blatt) : VermessungPictureFinderClientUtils.getVermessungsrissPictureFilename(schluessel, gemarkung, flur, blatt);
        return Paths.get(fullPath, new String[0]).getFileName().toString();
    }

    public String getLinkDocument() {
        return this.tfName.getText().trim();
    }

    public void reset() {
        this.firstDocumentChange = true;
        this.escapeText = null;
        this.tfName.getDocument().removeDocumentListener(this);
        this.tfName.setText("");
        this.tfName.getDocument().addDocumentListener(this);
    }

    private void handleDocumentChangedEvent() {
        long curr = System.currentTimeMillis();
        long diff = curr - this.lastChange;
        this.lastChange = curr;
        if (this.firstDocumentChange) {
            this.firstDocumentChange = false;
            this.t.start();
        }
        if (diff < 800L) {
            this.t.restart();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChangedEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChangedEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChangedEvent();
    }

    public void setTextColor(Color c) {
        this.lblMessage.setForeground(c);
        this.lblMode.setForeground(c);
    }

    public void beansDropped(ArrayList<CidsBean> droppedBeans) {
        try {
            CidsBean bean;
            if (droppedBeans.size() > 1) {
                LOG.info((Object)"There were more than one bean dropped on the vermessungs riss umleitungs text field. Just regarding the first one");
            }
            if ((bean = droppedBeans.get(0)) != null && bean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("vermessung_riss")) {
                String schluessel = bean.getProperty("schluessel").toString();
                CidsBean gemarkungBean = (CidsBean)bean.getProperty("gemarkung");
                Integer gemarkung = 0;
                if (gemarkungBean != null) {
                    gemarkung = (Integer)gemarkungBean.getProperty("id");
                }
                String flur = bean.getProperty("flur").toString();
                String blatt = bean.getProperty("blatt").toString();
                StringBuffer buf = new StringBuffer();
                buf.append(StringUtils.leftPad((String)schluessel, (int)3, (char)'0'));
                buf.append("-");
                buf.append(String.format("%04d", gemarkung));
                buf.append("-");
                buf.append(StringUtils.leftPad((String)flur, (int)3, (char)'0'));
                buf.append("-");
                buf.append(StringUtils.leftPad((String)blatt, (int)8, (char)'0'));
                this.tfName.setText(buf.toString());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Problem when adding the DroppedBeans", (Throwable)ex);
        }
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.jPanel1 = new JPanel();
        this.tfName = new DropAwareTextField();
        this.lblMode = new JLabel();
        this.pnlControls = new JPanel();
        this.pnlEmpty = new JPanel();
        this.pnlOkButton = new JPanel();
        this.btnCreateDocument = new JButton();
        this.pnlBusyLabel = new JPanel();
        this.jXBusyLabel1 = new JXBusyLabel(new Dimension(16, 16));
        this.pnlError = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnPlatzhalter = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.setMinimumSize(new Dimension(860, 32));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(860, 32));
        this.setLayout(new GridBagLayout());
        this.lblMessage.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.lblMessage, (String)NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.lblMessage.text"));
        this.lblMessage.setMaximumSize(new Dimension(1000, 18));
        this.lblMessage.setMinimumSize(new Dimension(330, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.lblMessage, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.tfName.setText(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.tfName.text"));
        this.tfName.setMinimumSize(new Dimension(180, 27));
        this.tfName.setPreferredSize(new Dimension(180, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.tfName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblMode, (String)NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.lblMode.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.lblMode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.pnlControls.setMinimumSize(new Dimension(32, 32));
        this.pnlControls.setOpaque(false);
        this.pnlControls.setLayout(new CardLayout());
        this.pnlEmpty.setOpaque(false);
        this.pnlControls.add((Component)this.pnlEmpty, "card1");
        this.pnlOkButton.setOpaque(false);
        this.pnlOkButton.setPreferredSize(new Dimension(32, 32));
        this.pnlOkButton.setLayout(new GridBagLayout());
        this.btnCreateDocument.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/glyphicons_206_ok_2.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateDocument, (String)NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.btnCreateDocument.text"));
        this.btnCreateDocument.setToolTipText(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.btnCreateDocument.toolTipText"));
        this.btnCreateDocument.setBorderPainted(false);
        this.btnCreateDocument.setContentAreaFilled(false);
        this.btnCreateDocument.setFocusPainted(false);
        this.btnCreateDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungUmleitungPanel.this.btnCreateDocumentActionPerformed(evt);
            }
        });
        this.pnlOkButton.add((Component)this.btnCreateDocument, new GridBagConstraints());
        this.pnlControls.add((Component)this.pnlOkButton, "card3");
        this.pnlBusyLabel.setOpaque(false);
        this.pnlBusyLabel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jXBusyLabel1, (String)NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.jXBusyLabel1.text"));
        this.jXBusyLabel1.setFocusable(false);
        this.jXBusyLabel1.setMaximumSize(new Dimension(16, 16));
        this.jXBusyLabel1.setMinimumSize(new Dimension(16, 16));
        this.pnlBusyLabel.add((Component)this.jXBusyLabel1, new GridBagConstraints());
        this.pnlControls.add((Component)this.pnlBusyLabel, "card2");
        this.pnlError.setFocusable(false);
        this.pnlError.setOpaque(false);
        this.pnlError.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/icon-warning-sign.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.jLabel1.text"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.jLabel1.toolTipText"));
        this.jLabel1.setFocusable(false);
        this.pnlError.add((Component)this.jLabel1, new GridBagConstraints());
        this.pnlControls.add((Component)this.pnlError, "card4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.pnlControls, gridBagConstraints);
        this.btnPlatzhalter.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/icon-file.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPlatzhalter, (String)NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.btnPlatzhalter.text"));
        this.btnPlatzhalter.setToolTipText(NbBundle.getMessage(VermessungUmleitungPanel.class, (String)"VermessungUmleitungPanel.btnPlatzhalter.toolTipText"));
        this.btnPlatzhalter.setBorderPainted(false);
        this.btnPlatzhalter.setContentAreaFilled(false);
        this.btnPlatzhalter.setFocusPainted(false);
        this.btnPlatzhalter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungUmleitungPanel.this.btnPlatzhalterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.btnPlatzhalter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void btnCreateDocumentActionPerformed(ActionEvent evt) {
        if (this.getLinkDocument() == null || this.getLinkDocument().isEmpty()) {
            this.deleteFile();
        } else {
            this.createLinkFile();
        }
    }

    private void btnPlatzhalterActionPerformed(ActionEvent evt) {
        this.tfName.getDocument().removeDocumentListener(this);
        String schluessel = (String)this.editor.getCidsBean().getProperty("schluessel");
        if (schluessel == null) {
            LOG.error((Object)"can not read schluessel from vermessungsriss cidsbean");
            return;
        }
        String url = "platzhalter/" + StringUtils.leftPad((String)schluessel, (int)3, (char)'0');
        this.tfName.setText(url);
        this.tfName.getDocument().addDocumentListener(this);
        this.checkIfLinkDocumentExists();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        initError = false;
        GRENZNIEDERSCHRIFT_PREFIX = "GN_";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
            String pass = bundle.getString("password");
            if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                pass = PasswordEncrypter.decryptString((String)pass);
            }
            WEB_DAV_PASSWORD = pass;
            WEB_DAV_USER = bundle.getString("user");
            VERMESSUNG_DIRECTORY = bundle.getString("url_vermessungsrisse");
            GRENZNIEDERSCHRIFT_DIRECTORY = bundle.getString("url_grenzniederschriften");
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not read WebDav properties from property file. The umleitungsmechanism for Vermessungrisse will not work", (Throwable)ex);
            WEB_DAV_PASSWORD = "";
            WEB_DAV_USER = "";
            VERMESSUNG_DIRECTORY = "";
            GRENZNIEDERSCHRIFT_DIRECTORY = "";
            initError = true;
        }
    }

    private final class DropAwareTextField
    extends JTextField
    implements CidsBeanDropListener {
        private DropAwareTextField() {
        }

        public void beansDropped(ArrayList<CidsBean> beans) {
            VermessungUmleitungPanel.this.beansDropped(beans);
        }
    }

    public static enum MODE {
        VERMESSUNGSRISS,
        GRENZNIEDERSCHRIFT;

    }
}

