/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VkConfProperties {
    private static final transient Logger LOG = Logger.getLogger(VkConfProperties.class);
    private final Double bufferMeter;
    private final String url;
    private final String pathDokumente;
    private final String pathFotos;
    private final String neuVorhaben;
    private final String mailBB;
    private final String mailNeu;
    private final String hilfeDokumente;
    private final String hilfeDokumenteUrl;
    private final String hilfeDokumenteEndung;
    private final String hilfeFotos;
    private final String hilfeFotosUrl;
    private final String hilfeFotosEndung;
    private final String hilfeStek;
    private final String hilfeLink;
    private final String hilfeBeschluss;
    private final String hilfeAnhang;
    private final String hilfeOrt;
    private final String hilfeKontakt;
    private final String hinweisMailversand;
    private final String textAbgeschlossenJa;
    private final String textAbgeschlossenNein;
    private final String textAbgeschlossenNicht;
    private final String textLage;
    private final String textMailHinweis;
    private final String textMailProtokoll;

    private VkConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.url = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING", null));
        this.pathDokumente = String.valueOf(this.readProperty(properties, "DOK_PATH", null));
        this.pathFotos = String.valueOf(this.readProperty(properties, "FOTOS_PATH", null));
        this.neuVorhaben = String.valueOf(this.readProperty(properties, "NEU_VORHABEN", null));
        this.mailBB = String.valueOf(this.readProperty(properties, "MAIL_BB", null));
        this.mailNeu = String.valueOf(this.readProperty(properties, "MAIL_NEU", null));
        this.hilfeDokumente = String.valueOf(this.readProperty(properties, "HILFE_DOKUMENTE", null));
        this.hilfeDokumenteUrl = String.valueOf(this.readProperty(properties, "HILFE_DOKUMENTE_URL", null));
        this.hilfeDokumenteEndung = String.valueOf(this.readProperty(properties, "HILFE_DOKUMENTE_ENDUNG", null));
        this.hilfeFotos = String.valueOf(this.readProperty(properties, "HILFE_FOTOS", null));
        this.hilfeFotosUrl = String.valueOf(this.readProperty(properties, "HILFE_FOTOS_URL", null));
        this.hilfeFotosEndung = String.valueOf(this.readProperty(properties, "HILFE_FOTOS_ENDUNG", null));
        this.hilfeStek = String.valueOf(this.readProperty(properties, "HILFE_STEK", null));
        this.hilfeLink = String.valueOf(this.readProperty(properties, "HILFE_LINK", null));
        this.hilfeBeschluss = String.valueOf(this.readProperty(properties, "HILFE_BESCHLUSS", null));
        this.hilfeAnhang = String.valueOf(this.readProperty(properties, "HILFE_ANHANG", null));
        this.hilfeOrt = String.valueOf(this.readProperty(properties, "HILFE_ORT", null));
        this.hilfeKontakt = String.valueOf(this.readProperty(properties, "HILFE_KONTAKT", null));
        this.hinweisMailversand = String.valueOf(this.readProperty(properties, "HINWEIS_MAILVERSAND", null));
        this.textAbgeschlossenJa = String.valueOf(this.readProperty(properties, "TEXT_ABGESCHLOSSEN_JA", null));
        this.textAbgeschlossenNein = String.valueOf(this.readProperty(properties, "TEXT_ABGESCHLOSSEN_NEIN", null));
        this.textAbgeschlossenNicht = String.valueOf(this.readProperty(properties, "TEXT_ABGESCHLOSSEN_NICHT", null));
        this.textLage = String.valueOf(this.readProperty(properties, "TEXT_LAGE", null));
        this.textMailHinweis = String.valueOf(this.readProperty(properties, "TEXT_MAIL", null));
        this.textMailProtokoll = String.valueOf(this.readProperty(properties, "TEXT_PROTOKOLL", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.VK_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static VkConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPathDokumente() {
        return this.pathDokumente;
    }

    public String getPathFotos() {
        return this.pathFotos;
    }

    public String getNeuVorhaben() {
        return this.neuVorhaben;
    }

    public String getMailBB() {
        return this.mailBB;
    }

    public String getMailNeu() {
        return this.mailNeu;
    }

    public String getHilfeDokumente() {
        return this.hilfeDokumente;
    }

    public String getHilfeDokumenteUrl() {
        return this.hilfeDokumenteUrl;
    }

    public String getHilfeDokumenteEndung() {
        return this.hilfeDokumenteEndung;
    }

    public String getHilfeFotos() {
        return this.hilfeFotos;
    }

    public String getHilfeFotosUrl() {
        return this.hilfeFotosUrl;
    }

    public String getHilfeFotosEndung() {
        return this.hilfeFotosEndung;
    }

    public String getHilfeStek() {
        return this.hilfeStek;
    }

    public String getHilfeLink() {
        return this.hilfeLink;
    }

    public String getHilfeBeschluss() {
        return this.hilfeBeschluss;
    }

    public String getHilfeAnhang() {
        return this.hilfeAnhang;
    }

    public String getHilfeOrt() {
        return this.hilfeOrt;
    }

    public String getHilfeKontakt() {
        return this.hilfeKontakt;
    }

    public String getHinweisMailversand() {
        return this.hinweisMailversand;
    }

    public String getTextAbgeschlossenJa() {
        return this.textAbgeschlossenJa;
    }

    public String getTextAbgeschlossenNein() {
        return this.textAbgeschlossenNein;
    }

    public String getTextAbgeschlossenNicht() {
        return this.textAbgeschlossenNicht;
    }

    public String getTextLage() {
        return this.textLage;
    }

    public String getTextMailHinweis() {
        return this.textMailHinweis;
    }

    public String getTextMailProtokoll() {
        return this.textMailProtokoll;
    }

    private static final class LazyInitialiser {
        private static final VkConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            VkConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.VK_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)VkConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new VkConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Laden der Properties f\u00fcr Vk-Client", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

