/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.wunda_blau.search.server.Alb_BaulastChecker;
import de.cismet.cids.custom.wunda_blau.search.server.Alb_BaulastblattChecker;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Alb_Constraints {
    public static List<String> getIncorrectBaulastDates(CidsBean blattBean) {
        ArrayList<String> result = new ArrayList<String>();
        List<CidsBean> baulastBeans = CidsBeanSupport.getBeanCollectionFromProperty(blattBean, "baulasten");
        if (baulastBeans != null) {
            for (CidsBean baulast : baulastBeans) {
                if (Alb_Constraints.checkBaulastDates(baulast)) continue;
                result.add(baulast.toString());
            }
        }
        return result;
    }

    public static boolean checkBaulastDates(CidsBean baulastBean) {
        Object eintragungsDatumObj = baulastBean.getProperty("eintragungsdatum");
        Object loeschungsDatumObj = baulastBean.getProperty("loeschungsdatum");
        Object befristungsDatumObj = baulastBean.getProperty("befristungsdatum");
        Object geschlossenAmDatumObj = baulastBean.getProperty("geschlossen_am");
        ArrayList<Date> testDates = new ArrayList<Date>();
        if (befristungsDatumObj instanceof Date) {
            testDates.add((Date)befristungsDatumObj);
        }
        if (geschlossenAmDatumObj instanceof Date) {
            testDates.add((Date)geschlossenAmDatumObj);
        }
        if (loeschungsDatumObj instanceof Date) {
            testDates.add((Date)loeschungsDatumObj);
        }
        if (testDates.size() > 0) {
            if (eintragungsDatumObj instanceof Date) {
                Date eintragungsDatum = (Date)eintragungsDatumObj;
                for (Date toTest : testDates) {
                    if (toTest.compareTo(eintragungsDatum) >= 0) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean checkUniqueBlattNummer(String blattnummer, int id, ConnectionContext connectionContext) throws ConnectionException {
        Object countObj;
        List innerList;
        Object o;
        Alb_BaulastblattChecker search = new Alb_BaulastblattChecker(blattnummer, id);
        Collection result = SessionManager.getConnection().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, connectionContext);
        if (result != null && result.size() > 0 && (o = result.iterator().next()) instanceof List && (innerList = (List)o).size() > 0 && (countObj = innerList.get(0)) instanceof Long) {
            long count = (Long)countObj;
            return count < 1L;
        }
        throw new RuntimeException("Unbekannter Fehler beim Speichern!");
    }

    public static boolean checkUniqueBaulastNummer(String blattnummer, String laufendeNr, int id, ConnectionContext connectionContext) throws ConnectionException {
        Object countObj;
        List innerList;
        Object o;
        Alb_BaulastChecker search = new Alb_BaulastChecker(blattnummer, laufendeNr, id);
        Collection result = SessionManager.getConnection().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, connectionContext);
        if (result != null && result.size() > 0 && (o = result.iterator().next()) instanceof List && (innerList = (List)o).size() > 0 && (countObj = innerList.get(0)) instanceof Long) {
            long count = (Long)countObj;
            return count < 1L;
        }
        throw new RuntimeException("Unbekannter Fehler beim Speichern!");
    }

    public static List<String> getBaulastenOhneBelastestesFlurstueckFromBlatt(CidsBean baulastBlattBean) {
        ArrayList<String> result = new ArrayList<String>();
        List<CidsBean> baulastenList = CidsBeanSupport.getBeanCollectionFromProperty(baulastBlattBean, "baulasten");
        if (baulastenList != null) {
            for (CidsBean baulast : baulastenList) {
                if (Alb_Constraints.checkBaulastHasBelastetesFlurstueck(baulast)) continue;
                result.add(baulast.toString());
            }
        } else {
            throw new RuntimeException("Could not get Property 'baulasten' from Blatt Bean!");
        }
        return result;
    }

    public static boolean checkBaulastHasBelastetesFlurstueck(CidsBean baulastBean) {
        if (baulastBean != null) {
            List<CidsBean> fsList = CidsBeanSupport.getBeanCollectionFromProperty(baulastBean, "flurstuecke_belastet");
            return fsList != null && fsList.size() > 0;
        }
        return false;
    }

    public static boolean checkEintragungsdatum(CidsBean baulastBean) {
        Object eintragungsDatumObj = baulastBean.getProperty("eintragungsdatum");
        return eintragungsDatumObj != null && eintragungsDatumObj instanceof Date;
    }
}

