/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_picturePanel;
import de.cismet.cids.custom.objectrenderer.utils.WebAccessBaulastenPictureFinder;
import de.cismet.cids.custom.utils.alkis.BaulastenPictureFinder;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Alb_baulastUmleitungPanel
extends JPanel
implements DocumentListener,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(Alb_baulastUmleitungPanel.class);
    private static final String PLATZHALTER_DOC_NAME = "000000-00";
    private static final String LAGEPLAN_ENDUNG = "p";
    private static final String TEXTBLATT_ENDUNG = "b";
    private static final String BAULASTEN_DIRECTORY;
    private static final String WEB_DAV_USER;
    private static final String WEB_DAV_PASSWORD;
    private MODE mode;
    private Alb_picturePanel picturePan;
    private final Timer t = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Alb_baulastUmleitungPanel.this.t.stop();
            CardLayout cl = (CardLayout)Alb_baulastUmleitungPanel.this.pnlControls.getLayout();
            cl.show(Alb_baulastUmleitungPanel.this.pnlControls, "card2");
            Alb_baulastUmleitungPanel.this.jXBusyLabel1.setBusy(true);
            if (Alb_baulastUmleitungPanel.this.getLinkDocument() != null && !Alb_baulastUmleitungPanel.this.getLinkDocument().isEmpty()) {
                Alb_baulastUmleitungPanel.this.checkIfLinkDocumentExists();
            } else {
                cl.show(Alb_baulastUmleitungPanel.this.pnlControls, "card3");
            }
        }
    });
    private long lastChange = 0L;
    private final WebDavTunnelHelper webDavHelper = new WebDavTunnelHelper("WUNDA_BLAU", ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, Boolean.valueOf(false));
    private boolean firstDocumentChange = true;
    private String escapeText;
    private final ConnectionContext connectionContext;
    private JButton btnCreateDocument;
    private JButton btnPlatzhalter;
    private JLabel jLabel1;
    private JXBusyLabel jXBusyLabel1;
    private JLabel lblDateiname;
    private JLabel lblMode;
    private JPanel pnlBusyLabel;
    private JPanel pnlControls;
    private JPanel pnlEmpty;
    private JPanel pnlError;
    private JPanel pnlOkButton;
    private JTextField tfName;

    public Alb_baulastUmleitungPanel(ConnectionContext connectionContext) {
        this(MODE.TEXTBLATT, null, connectionContext);
    }

    public Alb_baulastUmleitungPanel(MODE m, Alb_picturePanel picturePanel, ConnectionContext connectionContext) {
        this.mode = m;
        this.picturePan = picturePanel;
        this.connectionContext = connectionContext;
        this.initComponents();
        this.jXBusyLabel1.setSize(16, 16);
        this.setModeLabeltext();
        this.tfName.getDocument().addDocumentListener(this);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setLinkDocumentText(String text) {
        this.tfName.getDocument().removeDocumentListener(this);
        this.escapeText = text;
        this.tfName.setText(text);
        CardLayout cl = (CardLayout)this.pnlControls.getLayout();
        cl.show(this.pnlControls, "card1");
        this.tfName.getDocument().addDocumentListener(this);
    }

    public void setMode(MODE m) {
        this.mode = m;
        this.setModeLabeltext();
    }

    private void setModeLabeltext() {
        String text = this.mode == MODE.LAGEPLAN ? LAGEPLAN_ENDUNG : TEXTBLATT_ENDUNG;
        this.lblMode.setText(text);
    }

    private void showError() {
        this.picturePan.handleNoDocumentFound();
        CardLayout cl = (CardLayout)this.pnlControls.getLayout();
        cl.show(this.pnlControls, "card4");
    }

    private void checkIfLinkDocumentExists() {
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected void done() {
                try {
                    String document = (String)this.get();
                    Alb_baulastUmleitungPanel.this.jXBusyLabel1.setBusy(false);
                    if (document != null) {
                        Alb_baulastUmleitungPanel.this.picturePan.successAlert();
                        CardLayout cl = (CardLayout)Alb_baulastUmleitungPanel.this.pnlControls.getLayout();
                        cl.show(Alb_baulastUmleitungPanel.this.pnlControls, "card3");
                    } else {
                        Alb_baulastUmleitungPanel.this.showError();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Worker Thread interrupter", (Throwable)ex);
                    Alb_baulastUmleitungPanel.this.showError();
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)"Execution error", (Throwable)ex);
                    Alb_baulastUmleitungPanel.this.showError();
                }
            }

            @Override
            protected String doInBackground() throws Exception {
                String input = Alb_baulastUmleitungPanel.this.getLinkDocument();
                if (!Alb_baulastUmleitungPanel.this.isNummerConsistent(input)) {
                    return null;
                }
                String blattnummer = input.contains("-") ? input.substring(0, input.indexOf("-")) : input.substring(0, 7);
                String lfdNummer = input.substring(input.length() - 2, input.length());
                List res = Alb_baulastUmleitungPanel.this.mode == MODE.LAGEPLAN ? WebAccessBaulastenPictureFinder.getInstance().findPlanPicture(blattnummer, lfdNummer) : WebAccessBaulastenPictureFinder.getInstance().findTextblattPicture(blattnummer, lfdNummer);
                if (res == null || res.isEmpty()) {
                    return null;
                }
                return (String)res.get(0);
            }
        };
        worker.execute();
    }

    private boolean isNummerConsistent(String baulastnr) {
        return baulastnr.matches("\\d{6}-\\d{2}") || baulastnr.matches("\\d{6}[a-zA-Z]\\d{2}");
    }

    private void deleteFile() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                String filename = Alb_baulastUmleitungPanel.this.createFilename();
                File f = File.createTempFile(filename, ".txt");
                return Alb_baulastUmleitungPanel.this.webDavHelper.deleteFileFromWebDAV(filename + ".txt", Alb_baulastUmleitungPanel.this.createDirName(), Alb_baulastUmleitungPanel.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.errorDialog.title"), NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.errorDialog.delete.message"), null, null, null, Level.ALL, null);
                        JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)Alb_baulastUmleitungPanel.this), (ErrorInfo)ei);
                        Alb_baulastUmleitungPanel.this.picturePan.handleEscapePressed();
                        if (Alb_baulastUmleitungPanel.this.escapeText != null) {
                            Alb_baulastUmleitungPanel.this.tfName.setText(Alb_baulastUmleitungPanel.this.escapeText);
                        } else {
                            Alb_baulastUmleitungPanel.this.tfName.setText("");
                        }
                    } else {
                        Alb_baulastUmleitungPanel.this.picturePan.handleUmleitungDeleted();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Deleting link file worker was interrupted", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)"Error in deleting link file worker", (Throwable)ex);
                    ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.errorDialog.title"), NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.errorDialog.delete.message"), ex.getMessage(), null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)Alb_baulastUmleitungPanel.this), (ErrorInfo)ei);
                }
            }
        };
        worker.execute();
    }

    private void createLinkFile() {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String filename = Alb_baulastUmleitungPanel.this.createFilename().toLowerCase();
                File f = File.createTempFile(filename, ".txt");
                FileWriter fw = new FileWriter(f);
                BufferedWriter bfw = new BufferedWriter(fw);
                String linkDocument = Alb_baulastUmleitungPanel.this.getLinkDocument() + (Alb_baulastUmleitungPanel.this.mode == MODE.LAGEPLAN ? Alb_baulastUmleitungPanel.LAGEPLAN_ENDUNG : Alb_baulastUmleitungPanel.TEXTBLATT_ENDUNG);
                bfw.write(linkDocument, 0, linkDocument.length());
                bfw.flush();
                bfw.close();
                Alb_baulastUmleitungPanel.this.webDavHelper.uploadFileToWebDAV(filename + ".txt", f, Alb_baulastUmleitungPanel.this.createDirName(), (Component)Alb_baulastUmleitungPanel.this.picturePan, Alb_baulastUmleitungPanel.this.getConnectionContext());
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Create Link File Worker was interrupted.", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)"Error in Create Link File worker", (Throwable)ex);
                    ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.errorDialog.title"), NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.errorDialog.create.message"), ex.getMessage(), null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull((Component)Alb_baulastUmleitungPanel.this), (ErrorInfo)ei);
                }
            }
        };
        worker.execute();
    }

    private String createDirName() {
        String blattnummer = (String)this.picturePan.getCidsBean().getProperty("blattnummer");
        return BAULASTEN_DIRECTORY + BaulastenPictureFinder.getFolderWihoutPath((int)BaulastenPictureFinder.getBlattnummer((String)blattnummer)) + "/";
    }

    private String createFilename() {
        String blattnummer = (String)this.picturePan.getCidsBean().getProperty("blattnummer");
        String lfdNummer = (String)this.picturePan.getCidsBean().getProperty("laufende_nummer");
        String filenameSuffix = this.mode == MODE.LAGEPLAN ? LAGEPLAN_ENDUNG : TEXTBLATT_ENDUNG;
        return BaulastenPictureFinder.getObjectFilenameWithoutFolder((String)blattnummer, (String)lfdNummer) + filenameSuffix;
    }

    public String getLinkDocument() {
        return this.tfName.getText().toLowerCase();
    }

    public void reset() {
        this.firstDocumentChange = true;
        this.escapeText = null;
        this.tfName.getDocument().removeDocumentListener(this);
        this.tfName.setText("");
        this.tfName.getDocument().addDocumentListener(this);
    }

    private void handleDocumentChangedEvent() {
        long curr = System.currentTimeMillis();
        long diff = curr - this.lastChange;
        this.lastChange = curr;
        if (this.firstDocumentChange) {
            this.firstDocumentChange = false;
            this.t.start();
        }
        if (diff < 800L) {
            this.t.restart();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChangedEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChangedEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChangedEvent();
    }

    public void setTextColor(Color c) {
        this.lblDateiname.setForeground(c);
        this.lblMode.setForeground(c);
    }

    private void initComponents() {
        this.lblDateiname = new JLabel();
        this.tfName = new JTextField();
        if (this.mode == MODE.LAGEPLAN) {
            this.btnPlatzhalter = new JButton();
        }
        this.lblMode = new JLabel();
        this.pnlControls = new JPanel();
        this.pnlEmpty = new JPanel();
        this.pnlOkButton = new JPanel();
        this.btnCreateDocument = new JButton();
        this.pnlBusyLabel = new JPanel();
        this.jXBusyLabel1 = new JXBusyLabel(new Dimension(16, 16));
        this.pnlError = new JPanel();
        this.jLabel1 = new JLabel();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        this.setMinimumSize(new Dimension(383, 50));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(802, 50));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblDateiname, (String)NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.lblDateiname.text"));
        this.lblDateiname.setAutoscrolls(true);
        this.lblDateiname.setPreferredSize(new Dimension(580, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.add((Component)this.lblDateiname, gridBagConstraints);
        this.lblDateiname.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.lblDateiname.AccessibleContext.accessibleName"));
        this.tfName.setBackground(new Color(255, 255, 255));
        this.tfName.setText(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.tfName.text"));
        this.tfName.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfName.setMinimumSize(new Dimension(82, 23));
        this.tfName.setPreferredSize(new Dimension(82, 23));
        this.tfName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Alb_baulastUmleitungPanel.this.tfNameKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                Alb_baulastUmleitungPanel.this.tfNameKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                Alb_baulastUmleitungPanel.this.tfNameKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.tfName, gridBagConstraints);
        if (this.mode == MODE.LAGEPLAN) {
            this.btnPlatzhalter.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/icon-file.png")));
            Mnemonics.setLocalizedText((AbstractButton)this.btnPlatzhalter, (String)NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.btnPlatzhalter.text"));
            this.btnPlatzhalter.setToolTipText(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.btnPlatzhalter.toolTipText"));
            this.btnPlatzhalter.setBorderPainted(false);
            this.btnPlatzhalter.setContentAreaFilled(false);
            this.btnPlatzhalter.setFocusPainted(false);
            this.btnPlatzhalter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Alb_baulastUmleitungPanel.this.btnPlatzhalterActionPerformed(evt);
                }
            });
        }
        if (this.mode == MODE.LAGEPLAN) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.btnPlatzhalter, gridBagConstraints);
        }
        Mnemonics.setLocalizedText((JLabel)this.lblMode, (String)NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.lblMode.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.lblMode, gridBagConstraints);
        this.pnlControls.setOpaque(false);
        this.pnlControls.setLayout(new CardLayout());
        this.pnlEmpty.setOpaque(false);
        this.pnlControls.add((Component)this.pnlEmpty, "card1");
        this.pnlOkButton.setOpaque(false);
        this.pnlOkButton.setPreferredSize(new Dimension(32, 32));
        this.pnlOkButton.setLayout(new GridBagLayout());
        this.btnCreateDocument.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/glyphicons_206_ok_2.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateDocument, (String)NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.btnCreateDocument.text"));
        this.btnCreateDocument.setToolTipText(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.btnCreateDocument.toolTipText"));
        this.btnCreateDocument.setBorderPainted(false);
        this.btnCreateDocument.setContentAreaFilled(false);
        this.btnCreateDocument.setFocusPainted(false);
        this.btnCreateDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastUmleitungPanel.this.btnCreateDocumentActionPerformed(evt);
            }
        });
        this.pnlOkButton.add((Component)this.btnCreateDocument, new GridBagConstraints());
        this.pnlControls.add((Component)this.pnlOkButton, "card3");
        this.pnlBusyLabel.setOpaque(false);
        this.pnlBusyLabel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jXBusyLabel1, (String)NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.jXBusyLabel1.text"));
        this.jXBusyLabel1.setFocusable(false);
        this.jXBusyLabel1.setMaximumSize(new Dimension(16, 16));
        this.jXBusyLabel1.setMinimumSize(new Dimension(16, 16));
        this.pnlBusyLabel.add((Component)this.jXBusyLabel1, new GridBagConstraints());
        this.pnlControls.add((Component)this.pnlBusyLabel, "card2");
        this.pnlError.setFocusable(false);
        this.pnlError.setOpaque(false);
        this.pnlError.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/icon-warning-sign.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.jLabel1.text"));
        this.jLabel1.setToolTipText(NbBundle.getMessage(Alb_baulastUmleitungPanel.class, (String)"Alb_baulastUmleitungPanel.jLabel1.toolTipText"));
        this.jLabel1.setFocusable(false);
        this.pnlError.add((Component)this.jLabel1, new GridBagConstraints());
        this.pnlControls.add((Component)this.pnlError, "card4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.pnlControls, gridBagConstraints);
    }

    private void btnPlatzhalterActionPerformed(ActionEvent evt) {
        this.tfName.setText(PLATZHALTER_DOC_NAME);
    }

    private void btnCreateDocumentActionPerformed(ActionEvent evt) {
        if (this.getLinkDocument() == null || this.getLinkDocument().isEmpty()) {
            this.deleteFile();
        } else {
            this.createLinkFile();
        }
    }

    private void tfNameKeyTyped(KeyEvent evt) {
    }

    private void tfNameKeyPressed(KeyEvent evt) {
    }

    private void tfNameKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.firstDocumentChange = true;
            this.picturePan.handleEscapePressed();
            if (this.escapeText != null) {
                this.tfName.setText(this.escapeText);
            } else {
                this.tfName.setText("");
            }
        }
    }

    static {
        String user = "";
        String pass = "";
        String dir = "";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
            pass = bundle.getString("password");
            if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                pass = PasswordEncrypter.decryptString((String)pass);
            }
            user = bundle.getString("user");
            dir = bundle.getString("url_baulasten");
        }
        catch (Exception ex) {
            LOG.warn((Object)"could not load props from bundle", (Throwable)ex);
        }
        WEB_DAV_PASSWORD = pass;
        WEB_DAV_USER = user;
        BAULASTEN_DIRECTORY = dir;
    }

    public static enum MODE {
        TEXTBLATT,
        LAGEPLAN;

    }
}

