/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.annotations.AggregationRenderer;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_Constraints;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_baulastEditor;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_baulastEditorPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_baulastReportDialog;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_picturePanel;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.BaulastenReportGenerator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.BeanInitializer;
import de.cismet.cids.editors.DefaultBeanInitializer;
import de.cismet.cids.editors.EditorBeanInitializerStore;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.editors.converters.SqlDateToUtilDateConverter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.WeakListeners;

@AggregationRenderer
public class Alb_baulastblattEditor
extends JPanel
implements DisposableCidsBeanStore,
TitleComponentProvider,
FooterComponentProvider,
BorderProvider,
RequestsFullSizeComponent,
EditorSaveListener,
ConnectionContextStore {
    private static final int BLATT_NUMMER_ANZAHL_ZIFFERN = 6;
    private static final Color WRONG_BLATTNUMMER_COLOR = new Color(242, 222, 222);
    static final Logger LOG = Logger.getLogger(Alb_baulastblattEditor.class);
    private static final Comparator<Object> OBJECT_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return AlphanumComparator.getInstance().compare(String.valueOf(o1), String.valueOf(o2));
        }
    };
    public static final String TITLE_PREFIX = "Baulastblatt";
    public static final String TITLE_AGR_PREFIX = "Baulastbl\u00e4tter";
    private static final String FLURSTUECKE_BELASTET = "flurstuecke_belastet";
    private static final String FLURSTUECKE_BEGUENSTIGT = "flurstuecke_beguenstigt";
    private static final String ACTION_TAG = "custom.baulast.document@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_BLATT = "baulast.report.blatt_disabled@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_PLAN = "baulast.report.plan_disabled@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_RASTER = "baulast.report.raster_disabled@WUNDA_BLAU";
    private static final Converter<Date, String> DATE_TO_STRING = new Converter<Date, String>(){

        public String convertForward(Date value) {
            if (value != null) {
                return DateFormat.getDateInstance().format(value);
            }
            return "";
        }

        public Date convertReverse(String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private final Validator<String> NUMBER_VALIDATOR = new Validator<String>(){

        public Validator.Result validate(String t) {
            String corBlattnummer;
            String regex6 = "\\d{6}";
            String regex7 = "\\d{6}[a-zA-Z]";
            if (!(t.matches("\\d{6}") || t.matches("\\d{6}[a-zA-Z]") || (corBlattnummer = Alb_baulastblattEditor.correctBlattnummer(t)).matches("\\d{6}") || corBlattnummer.matches("\\d{6}[a-zA-Z]"))) {
                Alb_baulastblattEditor.this.wrongBlattnummer = true;
                Alb_baulastblattEditor.this.txtBlattnummer.setBackground(WRONG_BLATTNUMMER_COLOR);
                return new Validator.Result((Validator)this, (Object)"ERROR", "Keine korrekte Blattnummer");
            }
            Alb_baulastblattEditor.this.wrongBlattnummer = false;
            Alb_baulastblattEditor.this.txtBlattnummer.setBackground(Color.white);
            return null;
        }
    };
    private final boolean editable;
    private CidsBean cidsBean;
    private CardLayout cardLayout;
    private Collection<CidsBean> baulastenBeans = null;
    private PropertyChangeListener strongReferenceToWeakListener = null;
    private boolean wrongBlattnummer = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Alb_picturePanel alb_picturePanel;
    private JButton btnAddLaufendeNummer;
    private JButton btnBack;
    private JButton btnCopyBaulast;
    private JButton btnForward;
    private JButton btnPasteBaulast;
    private JButton btnRemoveLaufendeNummer;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JXHyperlink jXHyperlink1;
    private JXHyperlink jXHyperlink2;
    private JXHyperlink jXHyperlink3;
    private JLabel lblBack;
    private JLabel lblBearbeiter;
    private JLabel lblBearbeitetAm;
    private JLabel lblBlattInMap;
    private JLabel lblBlattnummer;
    private JLabel lblDurch;
    private JLabel lblForw;
    private JLabel lblLetzteBearbeitung;
    private JLabel lblTitle;
    private JList lstLaufendeNummern;
    private Alb_baulastEditorPanel panBaulastEditor;
    private RoundedPanel panBlattNummer;
    private RoundedPanel panBlattberichte;
    private JPanel panButtons;
    private JPanel panControlsLaufendeNummern;
    private JPanel panFooter;
    private JPanel panFooterLeft;
    private JPanel panFooterRight;
    private JPanel panMain;
    private JPanel panTitle;
    private RoundedPanel rpLaufendeNummern;
    private JScrollPane scpLaufendeNummern;
    private SemiRoundedPanel semiRoundedPanel1;
    private SemiRoundedPanel semiRoundedPanel2;
    private SemiRoundedPanel semiRoundedPanel3;
    private SqlDateToUtilDateConverter sqlDateToUtilDateConverter;
    private JTextField txtBlattnummer;
    private BindingGroup bindingGroup;

    public Alb_baulastblattEditor() {
        this(true);
    }

    public Alb_baulastblattEditor(boolean editable) {
        this.editable = editable;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.alb_picturePanel = new Alb_picturePanel(!this.editable, false, this.getConnectionContext());
        this.alb_picturePanel.getDocTypePanel().setVisible(false);
        this.initComponents();
        this.initFooterElements();
        this.cardLayout = (CardLayout)this.getLayout();
        if (!this.editable) {
            this.panControlsLaufendeNummern.setVisible(false);
            this.txtBlattnummer.setEditable(false);
            this.txtBlattnummer.setOpaque(false);
            this.txtBlattnummer.setBorder(null);
            this.lblLetzteBearbeitung.setVisible(false);
            this.lblBearbeiter.setVisible(false);
            this.lblDurch.setVisible(false);
            this.lblBearbeitetAm.setVisible(false);
        }
        try {
            boolean billingAllowed = BillingPopup.isBillingAllowed("nivppdf", this.getConnectionContext());
            this.jXHyperlink1.setEnabled(!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_BLATT, this.getConnectionContext()) && billingAllowed);
            this.jXHyperlink2.setEnabled(!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_PLAN, this.getConnectionContext()) && billingAllowed);
            this.jXHyperlink3.setEnabled(!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_RASTER, this.getConnectionContext()) && billingAllowed);
        }
        catch (Exception ex) {
            LOG.info((Object)"exception while checking action tags", (Throwable)ex);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static String correctBlattnummer(String blattnummer) {
        int size = blattnummer.matches("^\\d*[a-zA-Z]$") ? 7 : 6;
        while (blattnummer.length() < size) {
            blattnummer = "0" + blattnummer;
        }
        return blattnummer;
    }

    private void fillBaulastQualityAttributes() {
        for (CidsBean baulastBean : this.baulastenBeans) {
            Alb_baulastEditor.addPruefungsInfoToBean(baulastBean);
        }
    }

    private void initFooterElements() {
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblForw, this.btnForward, ObjectRendererUtils.FORWARD_SELECTED, ObjectRendererUtils.FORWARD_PRESSED);
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblBack, this.btnBack, ObjectRendererUtils.BACKWARD_SELECTED, ObjectRendererUtils.BACKWARD_PRESSED);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void disableSecondPageIfNoPermission() {
        if (!ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext())) {
            for (MouseListener l : this.lblForw.getMouseListeners()) {
                this.lblForw.removeMouseListener(l);
            }
            this.lblForw.setEnabled(false);
            this.btnForward.setEnabled(false);
            for (MouseListener l : this.lblBack.getMouseListeners()) {
                this.lblBack.removeMouseListener(l);
            }
            this.lblBack.setEnabled(false);
            this.btnBack.setEnabled(false);
        }
    }

    public void setCidsBean(CidsBean cidsBean) {
        try {
            if (cidsBean != null) {
                int nrIdx = this.lstLaufendeNummern.getSelectedIndex();
                this.bindingGroup.unbind();
                this.cidsBean = cidsBean;
                this.baulastenBeans = CidsBeanSupport.getBeanCollectionFromProperty(cidsBean, "baulasten");
                if (this.baulastenBeans != null) {
                    Collections.sort((List)this.baulastenBeans, OBJECT_COMPARATOR);
                }
                this.bindingGroup.bind();
                if (nrIdx <= 0) {
                    this.lstLaufendeNummern.setSelectedIndex(0);
                } else {
                    try {
                        this.lstLaufendeNummern.setSelectedIndex(nrIdx);
                    }
                    catch (Exception x) {
                        this.lstLaufendeNummern.setSelectedIndex(0);
                        LOG.error((Object)x, (Throwable)x);
                    }
                }
                Object laufendeNr = ((CidsBean)this.lstLaufendeNummern.getSelectedValue()).getProperty("laufende_nummer");
                Object blattnummer = cidsBean.getProperty("blattnummer");
                this.lblTitle.setText("Baulastblatt " + blattnummer + ": lfd. Nummer " + laufendeNr);
                this.checkLaufendeNummern();
                this.strongReferenceToWeakListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("blattnummer".equals(evt.getPropertyName())) {
                            for (CidsBean bean : Alb_baulastblattEditor.this.baulastenBeans) {
                                try {
                                    bean.setProperty("blattnummer", evt.getNewValue());
                                }
                                catch (Exception ex) {
                                    LOG.warn((Object)ex, (Throwable)ex);
                                }
                            }
                        }
                    }
                };
                cidsBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.strongReferenceToWeakListener, (Object)cidsBean));
            }
            this.disableSecondPageIfNoPermission();
        }
        catch (Exception x) {
            LOG.error((Object)x, (Throwable)x);
        }
    }

    private void checkLaufendeNummern() {
        if (this.lstLaufendeNummern.getModel().getSize() > 0) {
            if (!this.panBaulastEditor.isEnabled()) {
                this.setAllSubComponentsEnabled(this.panBaulastEditor, true);
            }
        } else if (this.panBaulastEditor.isEnabled()) {
            this.setAllSubComponentsEnabled(this.panBaulastEditor, false);
        }
    }

    private void setAllSubComponentsEnabled(JComponent component, boolean enabled) {
        component.setEnabled(enabled);
        for (Component subComponent : component.getComponents()) {
            if (subComponent == null || !(subComponent instanceof JComponent)) continue;
            this.setAllSubComponentsEnabled((JComponent)subComponent, enabled);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.sqlDateToUtilDateConverter = new SqlDateToUtilDateConverter();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.panFooter = new JPanel();
        this.panButtons = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.lblLetzteBearbeitung = new JLabel();
        this.lblBearbeiter = new JLabel();
        this.lblDurch = new JLabel();
        this.lblBearbeitetAm = new JLabel();
        this.panFooterLeft = new JPanel();
        this.lblBack = new JLabel();
        this.btnBack = new JButton();
        this.jPanel3 = new JPanel();
        this.panFooterRight = new JPanel();
        this.btnForward = new JButton();
        this.lblForw = new JLabel();
        this.jPanel4 = this.alb_picturePanel.getDocTypePanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.panMain = new JPanel();
        this.panBaulastEditor = new Alb_baulastEditorPanel(this.editable, this.getConnectionContext());
        this.rpLaufendeNummern = new RoundedPanel();
        this.scpLaufendeNummern = new JScrollPane();
        this.lstLaufendeNummern = new JList();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.panControlsLaufendeNummern = new JPanel();
        this.btnAddLaufendeNummer = new JButton();
        this.btnRemoveLaufendeNummer = new JButton();
        this.btnCopyBaulast = new JButton();
        this.btnPasteBaulast = new JButton();
        this.panBlattberichte = new RoundedPanel();
        this.semiRoundedPanel3 = new SemiRoundedPanel();
        this.jLabel4 = new JLabel();
        this.jXHyperlink1 = new JXHyperlink();
        this.jXHyperlink2 = new JXHyperlink();
        this.jXHyperlink3 = new JXHyperlink();
        this.panBlattNummer = new RoundedPanel();
        this.lblBlattnummer = new JLabel();
        this.txtBlattnummer = new JTextField();
        this.semiRoundedPanel2 = new SemiRoundedPanel();
        this.jLabel3 = new JLabel();
        this.lblBlattInMap = new JLabel();
        this.alb_picturePanel = this.alb_picturePanel;
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 14));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText(TITLE_PREFIX);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new BorderLayout());
        this.panButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridLayout(1, 0));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.add(this.filler1);
        this.lblLetzteBearbeitung.setForeground(new Color(204, 204, 204));
        this.lblLetzteBearbeitung.setText("Letzte Bearbeitung am");
        this.jPanel1.add(this.lblLetzteBearbeitung);
        this.lblBearbeiter.setForeground(new Color(204, 204, 204));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.panBaulastEditor, (Property)ELProperty.create((String)"${cidsBean.bearbeitungsdatum}"), (Object)this.lblBearbeiter, (Property)BeanProperty.create((String)"text"), (String)"bearbeitungsdatum");
        binding.setSourceNullValue((Object)"(unbekannt)");
        binding.setSourceUnreadableValue((Object)"(unbekannt)");
        binding.setConverter(DATE_TO_STRING);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel1.add(this.lblBearbeiter);
        this.lblDurch.setForeground(new Color(204, 204, 204));
        this.lblDurch.setText("durch");
        this.jPanel1.add(this.lblDurch);
        this.lblBearbeitetAm.setForeground(new Color(204, 204, 204));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.panBaulastEditor, (Property)ELProperty.create((String)"${cidsBean.bearbeitet_von}"), (Object)this.lblBearbeitetAm, (Property)BeanProperty.create((String)"text"), (String)"bearbeitet_von");
        binding.setSourceNullValue((Object)"(unbekannt)");
        binding.setSourceUnreadableValue((Object)"(unbekannt)");
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel1.add(this.lblBearbeitetAm);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.01;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.panFooterLeft.setMaximumSize(new Dimension(124, 40));
        this.panFooterLeft.setMinimumSize(new Dimension(124, 40));
        this.panFooterLeft.setOpaque(false);
        this.panFooterLeft.setPreferredSize(new Dimension(124, 40));
        this.panFooterLeft.setLayout(new FlowLayout(2, 10, 5));
        this.lblBack.setFont(new Font("Tahoma", 1, 14));
        this.lblBack.setForeground(new Color(255, 255, 255));
        this.lblBack.setText("Info");
        this.lblBack.setEnabled(false);
        this.lblBack.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Alb_baulastblattEditor.this.lblBackMouseClicked(evt);
            }
        });
        this.panFooterLeft.add(this.lblBack);
        this.btnBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left.png")));
        this.btnBack.setBorder(null);
        this.btnBack.setBorderPainted(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setEnabled(false);
        this.btnBack.setFocusPainted(false);
        this.btnBack.setMaximumSize(new Dimension(30, 30));
        this.btnBack.setMinimumSize(new Dimension(30, 30));
        this.btnBack.setPreferredSize(new Dimension(30, 30));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.btnBackActionPerformed(evt);
            }
        });
        this.panFooterLeft.add(this.btnBack);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.panFooterLeft, gridBagConstraints);
        this.panButtons.add(this.jPanel2);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.panFooterRight.setMaximumSize(new Dimension(124, 40));
        this.panFooterRight.setOpaque(false);
        this.panFooterRight.setLayout(new FlowLayout(0, 10, 5));
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.btnForwardActionPerformed(evt);
            }
        });
        this.panFooterRight.add(this.btnForward);
        this.lblForw.setFont(new Font("Tahoma", 1, 14));
        this.lblForw.setForeground(new Color(255, 255, 255));
        this.lblForw.setText("Dokumente");
        this.lblForw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Alb_baulastblattEditor.this.lblForwMouseClicked(evt);
            }
        });
        this.panFooterRight.add(this.lblForw);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.panFooterRight, gridBagConstraints);
        this.jPanel4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel6.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        this.panButtons.add(this.jPanel3);
        this.panFooter.add((Component)this.panButtons, "Center");
        this.setLayout(new CardLayout());
        this.panMain.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panMain.setOpaque(false);
        this.panMain.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMain.add((Component)this.panBaulastEditor, gridBagConstraints);
        this.rpLaufendeNummern.setLayout((LayoutManager)new GridBagLayout());
        this.lstLaufendeNummern.setFixedCellWidth(75);
        ELProperty eLProperty = ELProperty.create((String)"${cidsBean.baulasten}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstLaufendeNummern);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstLaufendeNummern.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Alb_baulastblattEditor.this.lstLaufendeNummernValueChanged(evt);
            }
        });
        this.scpLaufendeNummern.setViewportView(this.lstLaufendeNummern);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.rpLaufendeNummern.add((Component)this.scpLaufendeNummern, (Object)gridBagConstraints);
        this.semiRoundedPanel1.setBackground(Color.darkGray);
        this.semiRoundedPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Laufende Nummern");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel1.add((Component)this.jLabel1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpLaufendeNummern.add((Component)this.semiRoundedPanel1, (Object)gridBagConstraints);
        this.panControlsLaufendeNummern.setOpaque(false);
        this.panControlsLaufendeNummern.setLayout(new GridBagLayout());
        this.btnAddLaufendeNummer.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        this.btnAddLaufendeNummer.setMaximumSize(new Dimension(43, 25));
        this.btnAddLaufendeNummer.setMinimumSize(new Dimension(43, 25));
        this.btnAddLaufendeNummer.setPreferredSize(new Dimension(43, 25));
        this.btnAddLaufendeNummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.btnAddLaufendeNummerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panControlsLaufendeNummern.add((Component)this.btnAddLaufendeNummer, gridBagConstraints);
        this.btnRemoveLaufendeNummer.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        this.btnRemoveLaufendeNummer.setMaximumSize(new Dimension(43, 25));
        this.btnRemoveLaufendeNummer.setMinimumSize(new Dimension(43, 25));
        this.btnRemoveLaufendeNummer.setPreferredSize(new Dimension(43, 25));
        this.btnRemoveLaufendeNummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.btnRemoveLaufendeNummerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panControlsLaufendeNummern.add((Component)this.btnRemoveLaufendeNummer, gridBagConstraints);
        this.btnCopyBaulast.setIcon(new ImageIcon(this.getClass().getResource("/res/16/document-copy.png")));
        this.btnCopyBaulast.setMaximumSize(new Dimension(43, 25));
        this.btnCopyBaulast.setMinimumSize(new Dimension(43, 25));
        this.btnCopyBaulast.setPreferredSize(new Dimension(43, 25));
        this.btnCopyBaulast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.btnCopyBaulastActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panControlsLaufendeNummern.add((Component)this.btnCopyBaulast, gridBagConstraints);
        this.btnPasteBaulast.setIcon(new ImageIcon(this.getClass().getResource("/res/16/clipboard-paste.png")));
        this.btnPasteBaulast.setMaximumSize(new Dimension(43, 25));
        this.btnPasteBaulast.setMinimumSize(new Dimension(43, 25));
        this.btnPasteBaulast.setPreferredSize(new Dimension(43, 25));
        this.btnPasteBaulast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.btnPasteBaulastActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panControlsLaufendeNummern.add((Component)this.btnPasteBaulast, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.rpLaufendeNummern.add((Component)this.panControlsLaufendeNummern, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMain.add((Component)this.rpLaufendeNummern, gridBagConstraints);
        this.panBlattberichte.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel3.setBackground(Color.darkGray);
        this.semiRoundedPanel3.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel4.setForeground(new Color(255, 255, 255));
        this.jLabel4.setText("Baulastblattberichte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.semiRoundedPanel3.add((Component)this.jLabel4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panBlattberichte.add((Component)this.semiRoundedPanel3, (Object)gridBagConstraints);
        this.jXHyperlink1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jXHyperlink1.setText("mit Textbl\u00e4ttern");
        this.jXHyperlink1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.jXHyperlink1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.panBlattberichte.add((Component)this.jXHyperlink1, (Object)gridBagConstraints);
        this.jXHyperlink2.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jXHyperlink2.setText("mit Textbl\u00e4ttern und Pl\u00e4nen");
        this.jXHyperlink2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.jXHyperlink2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.panBlattberichte.add((Component)this.jXHyperlink2, (Object)gridBagConstraints);
        this.jXHyperlink3.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf_blr.png")));
        this.jXHyperlink3.setText("<html>mit Textbl\u00e4ttern, Pl\u00e4nen<br/>und Rasterdateien");
        this.jXHyperlink3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastblattEditor.this.jXHyperlink3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.panBlattberichte.add((Component)this.jXHyperlink3, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMain.add((Component)this.panBlattberichte, gridBagConstraints);
        this.panBlattNummer.setLayout((LayoutManager)new GridBagLayout());
        this.lblBlattnummer.setText("Blattnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panBlattNummer.add((Component)this.lblBlattnummer, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.blattnummer}"), (Object)this.txtBlattnummer, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"");
        binding.setValidator(this.NUMBER_VALIDATOR);
        this.bindingGroup.addBinding((Binding)binding);
        this.txtBlattnummer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Alb_baulastblattEditor.this.txtBlattnummerFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panBlattNummer.add((Component)this.txtBlattnummer, (Object)gridBagConstraints);
        this.semiRoundedPanel2.setBackground(Color.darkGray);
        this.semiRoundedPanel2.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText(TITLE_PREFIX);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 26, 5, 0);
        this.semiRoundedPanel2.add((Component)this.jLabel3, (Object)gridBagConstraints);
        this.lblBlattInMap.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom-best-fit.png")));
        this.lblBlattInMap.setToolTipText("Flurst\u00fccke des Baulastblattes in Karte anzeigen");
        this.lblBlattInMap.setCursor(new Cursor(12));
        this.lblBlattInMap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Alb_baulastblattEditor.this.lblBlattInMapMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.semiRoundedPanel2.add((Component)this.lblBlattInMap, (Object)gridBagConstraints);
        this.lblBlattInMap.getAccessibleContext().setAccessibleDescription("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panBlattNummer.add((Component)this.semiRoundedPanel2, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panMain.add((Component)this.panBlattNummer, gridBagConstraints);
        this.add((Component)this.panMain, "card1");
        this.add((Component)this.alb_picturePanel, "card2");
        this.bindingGroup.bind();
    }

    private void lstLaufendeNummernValueChanged(ListSelectionEvent evt) {
        Object selectionObj = this.lstLaufendeNummern.getSelectedValue();
        if (selectionObj instanceof CidsBean) {
            this.bindingGroup.getBinding("bearbeitet_von").unbind();
            this.bindingGroup.getBinding("bearbeitungsdatum").unbind();
            CidsBean selectedBean = (CidsBean)selectionObj;
            this.panBaulastEditor.setCidsBean(selectedBean);
            this.alb_picturePanel.setCidsBean(selectedBean);
            this.btnPasteBaulast.setEnabled(this.isPastePossible());
            this.bindingGroup.getBinding("bearbeitet_von").bind();
            this.bindingGroup.getBinding("bearbeitungsdatum").bind();
            Object laufendeNr = selectedBean.getProperty("laufende_nummer");
            Object blattNummer = selectedBean.getProperty("blattnummer");
            this.lblTitle.setText("Baulastblatt " + blattNummer + ": lfd. Nummer " + laufendeNr);
        }
        Object[] selectedValues = this.lstLaufendeNummern.getSelectedValues();
        ArrayList selectedObjects = TypeSafeCollections.newArrayList();
        for (Object obj : selectedValues) {
            if (!(obj instanceof CidsBean)) continue;
            selectedObjects.add(((CidsBean)obj).getMetaObject());
        }
        this.panBaulastEditor.setAllSelectedMetaObjects(selectedObjects);
    }

    private void btnAddLaufendeNummerActionPerformed(ActionEvent evt) {
        try {
            String userInput;
            List<CidsBean> baulasten = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "baulasten");
            if (baulasten != null && (userInput = (String)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this), "Bitte die neue Laufende Nummer eingeben:", "Neue Laufende Nummer anlegen", -1, null, null, this.getHighestCurrentLaufendeNummer(baulasten) + 1)) != null) {
                if (this.isNewLaufendeNummer(userInput)) {
                    int laufendeNr = Integer.parseInt(userInput);
                    CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("alb_baulast", this.getConnectionContext());
                    newBean.setProperty("geprueft", (Object)false);
                    newBean.setProperty("laufende_nummer", (Object)String.valueOf(laufendeNr));
                    newBean.setProperty("blattnummer", (Object)this.txtBlattnummer.getText());
                    newBean.setProperty("bearbeitet_von", (Object)SessionManager.getSession().getUser().getName());
                    newBean.setProperty("bearbeitungsdatum", (Object)new Date(System.currentTimeMillis()));
                    baulasten.add(newBean);
                    int newIndex = this.lstLaufendeNummern.getModel().getSize();
                    this.lstLaufendeNummern.setSelectedIndex(newIndex - 1);
                } else {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die Nummer " + userInput + " kann nicht angelegt werden, weil diese Nummer bereits existiert!");
                }
            }
            this.checkLaufendeNummern();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Hinzuf\u00fcgen einer neuen Laufenden Nummer", ex, this);
        }
    }

    private boolean isNewLaufendeNummer(String input) {
        List<CidsBean> lasten = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "baulasten");
        for (CidsBean baulast : lasten) {
            Object laufendeNr = baulast.getProperty("laufende_nummer");
            if (!input.equals(laufendeNr)) continue;
            return false;
        }
        return true;
    }

    private int getHighestCurrentLaufendeNummer(Collection<CidsBean> baulasten) {
        int max = 0;
        if (baulasten != null) {
            for (CidsBean baulastBean : baulasten) {
                Object laufendeNummerObj = baulastBean.getProperty("laufende_nummer");
                if (laufendeNummerObj == null) continue;
                try {
                    int currentLN = Integer.valueOf(laufendeNummerObj.toString());
                    if (currentLN <= max) continue;
                    max = currentLN;
                }
                catch (Exception exception) {}
            }
        }
        return max;
    }

    private void btnRemoveLaufendeNummerActionPerformed(ActionEvent evt) {
        Object selection = this.lstLaufendeNummern.getSelectedValue();
        if (selection instanceof CidsBean) {
            try {
                CidsBean selectionBean = (CidsBean)selection;
                Object laufendeNummer = selectionBean.getProperty("laufende_nummer");
                List<CidsBean> baulastenCol = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "baulasten");
                if (baulastenCol != null) {
                    int answer;
                    boolean checkOK = true;
                    if (laufendeNummer == null || String.valueOf(laufendeNummer).length() < 1) {
                        HashSet checkBelastet = TypeSafeCollections.newHashSet();
                        HashSet checkBeguenstigt = TypeSafeCollections.newHashSet();
                        for (CidsBean otherBaulastenBean : baulastenCol) {
                            if (otherBaulastenBean == selectionBean) continue;
                            checkBelastet.addAll(CidsBeanSupport.getBeanCollectionFromProperty(otherBaulastenBean, FLURSTUECKE_BELASTET));
                            checkBeguenstigt.addAll(CidsBeanSupport.getBeanCollectionFromProperty(otherBaulastenBean, FLURSTUECKE_BEGUENSTIGT));
                        }
                        checkOK = checkBelastet.containsAll(CidsBeanSupport.getBeanCollectionFromProperty(selectionBean, FLURSTUECKE_BELASTET)) && checkBeguenstigt.containsAll(CidsBeanSupport.getBeanCollectionFromProperty(selectionBean, FLURSTUECKE_BEGUENSTIGT));
                    }
                    if ((answer = checkOK ? JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Soll die Nummer wirklich gel\u00f6scht werden?", "Nummer entfernen", 0) : JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Plausibilit\u00e4tspr\u00fcfung fehlgeschlagen. Nicht alle Flurst\u00fccke des Platzhalters wurden realen Baulasten zugeordnet. Soll dennoch gel\u00f6scht werden?", "Platzhalter entfernen", 0, 2)) == 0) {
                        selectionBean.delete();
                        this.lstLaufendeNummern.setSelectedIndex(this.lstLaufendeNummern.getMinSelectionIndex());
                    }
                }
                this.checkLaufendeNummern();
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                ObjectRendererUtils.showExceptionWindowToUser("Fehler beim L\u00f6schen", e, this);
            }
        }
    }

    private void lblBackMouseClicked(MouseEvent evt) {
        this.btnBackActionPerformed(null);
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, "card1");
        this.alb_picturePanel.getDocTypePanel().setVisible(false);
        this.btnBack.setEnabled(false);
        this.btnForward.setEnabled(true);
        this.lblBack.setEnabled(false);
        this.lblForw.setEnabled(true);
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, "card2");
        this.alb_picturePanel.getDocTypePanel().setVisible(true);
        this.btnBack.setEnabled(true);
        this.btnForward.setEnabled(false);
        this.lblBack.setEnabled(true);
        this.lblForw.setEnabled(false);
        this.alb_picturePanel.updateIfPicturePathsChanged();
        String fileCollisionWarning = this.alb_picturePanel.getCollisionWarning();
        if (fileCollisionWarning.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), fileCollisionWarning, "Unterschiedliche Dateiformate", 2);
        }
        this.alb_picturePanel.clearCollisionWarning();
    }

    private void lblForwMouseClicked(MouseEvent evt) {
        this.btnForwardActionPerformed(null);
    }

    private void btnPasteBaulastActionPerformed(ActionEvent evt) {
        CidsBean currentBaulastBean = this.panBaulastEditor.getCidsBean();
        try {
            EditorBeanInitializerStore.getInstance().initialize(currentBaulastBean);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private void btnCopyBaulastActionPerformed(ActionEvent evt) {
        CidsBean currentBaulastBean = this.panBaulastEditor.getCidsBean();
        EditorBeanInitializerStore.getInstance().registerInitializer(currentBaulastBean.getMetaObject().getMetaClass(), (BeanInitializer)new DefaultBeanInitializer(currentBaulastBean, this.getConnectionContext()){

            protected void processSimpleProperty(CidsBean beanToInit, String propertyName, Object simpleValueToProcess) throws Exception {
                if ("geprueft".equalsIgnoreCase(propertyName) || "pruefdatum".equalsIgnoreCase(propertyName) || "geprueft_von".equalsIgnoreCase(propertyName) || "pruefkommentar".equalsIgnoreCase(propertyName)) {
                    return;
                }
                Object curVal = beanToInit.getProperty(propertyName);
                if (curVal == null || "".equals(curVal.toString())) {
                    super.processSimpleProperty(beanToInit, propertyName, simpleValueToProcess);
                }
            }

            protected void processArrayProperty(CidsBean beanToInit, String propertyName, Collection<CidsBean> arrayValueToProcess) throws Exception {
                if (!propertyName.endsWith("pages")) {
                    List<CidsBean> collectionToFill = CidsBeanSupport.getBeanCollectionFromProperty(beanToInit, propertyName);
                    collectionToFill.clear();
                    collectionToFill.addAll(arrayValueToProcess);
                }
            }
        });
        this.btnPasteBaulast.setEnabled(this.isPastePossible());
    }

    private void lblBlattInMapMouseClicked(MouseEvent evt) {
        ObjectRendererUtils.switchToCismapMap();
        ObjectRendererUtils.addBeanGeomAsFeatureToCismapMap(this.cidsBean, true);
    }

    private void correctBlattnummer() {
        String bnn = Alb_baulastblattEditor.correctBlattnummer(this.txtBlattnummer.getText());
        if (bnn != null && !bnn.equals(this.txtBlattnummer.getText())) {
            this.txtBlattnummer.setText(bnn);
        }
    }

    private void txtBlattnummerFocusLost(FocusEvent evt) {
        this.correctBlattnummer();
    }

    private void jXHyperlink1ActionPerformed(ActionEvent evt) {
        Alb_baulastReportDialog.getInstance().showAndDoDownload(BaulastenReportGenerator.Type.TEXTBLATT, this.baulastenBeans, this);
    }

    private void jXHyperlink2ActionPerformed(ActionEvent evt) {
        Alb_baulastReportDialog.getInstance().showAndDoDownload(BaulastenReportGenerator.Type.TEXTBLATT_PLAN, this.baulastenBeans, this);
    }

    private void jXHyperlink3ActionPerformed(ActionEvent evt) {
        Alb_baulastReportDialog.getInstance().showAndDoDownload(BaulastenReportGenerator.Type.TEXTBLATT_PLAN_RASTER, this.baulastenBeans, this);
    }

    private boolean isPastePossible() {
        CidsBean blBean = this.panBaulastEditor.getCidsBean();
        boolean isNewBean = blBean != null && blBean.getMetaObject().getStatus() == 1;
        return isNewBean && EditorBeanInitializerStore.getInstance().getInitializer(blBean.getMetaObject().getMetaClass()) != null;
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(0, 5, 0, 5);
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.alb_picturePanel.dispose();
        this.panBaulastEditor.dispose();
        this.strongReferenceToWeakListener = null;
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        this.correctBlattnummer();
        try {
            List<String> alleLastenOhneBelastetesFS;
            boolean unique;
            ArrayList<String> errors = new ArrayList<String>();
            String blattnummer = this.txtBlattnummer.getText();
            if (this.wrongBlattnummer) {
                errors.add("Die Blattnummer " + blattnummer + " ist nicht korrekt! Bitte geben Sie eine g\u00fcltige Blattnummer ein.");
            }
            if (!(unique = Alb_Constraints.checkUniqueBlattNummer(blattnummer, this.getCidsBean().getMetaObject().getID(), this.getConnectionContext()))) {
                errors.add("Die Blattnummer " + blattnummer + " existiert bereits! Bitte geben Sie eine andere Blattnummer ein.");
            }
            if ((alleLastenOhneBelastetesFS = Alb_Constraints.getBaulastenOhneBelastestesFlurstueckFromBlatt(this.cidsBean)).size() > 0) {
                errors.add("Folgende Baulasten haben kein belastetes Flurst\u00fcck:\n" + alleLastenOhneBelastetesFS + "\nBitte ordnen Sie diesen laufenden Nummern belastete Flurst\u00fccke zu, erst dann kann der Datensatz gespeichert werden.");
            }
            for (CidsBean last : this.baulastenBeans) {
                if (Alb_Constraints.checkEintragungsdatum(last)) continue;
                errors.add("Die Baulast" + last.toString() + " muss ein Eintragungsdatum haben.");
            }
            List<String> incorrectBaulasteDates = Alb_Constraints.getIncorrectBaulastDates(this.cidsBean);
            if (incorrectBaulasteDates.size() > 0) {
                errors.add("Sie haben bei den folgenden laufenden Nummern des aktuell bearbeiteten Baulastblattes unplausible Datumsangaben vorgenommen (Eingabedatum fehlt oder liegt nach dem L\u00f6sch- Schlie\u00df oder Befristungsdatum):\n" + incorrectBaulasteDates + "\nBitte korrigieren Sie die fehlerhaften Datumsangaben, erst dann kann der Datensatz gespeichert werden.");
            }
            HashSet<String> laufendeNummerCheck = new HashSet<String>();
            for (CidsBean last : this.baulastenBeans) {
                String lastString = String.valueOf(last);
                if (laufendeNummerCheck.add(lastString)) continue;
                errors.add("Die laufende Nummer " + lastString + " ist mehrfach vergeben. Bitte ordnen Sie jeder Baulaste eine eindeutige laufende Nummer zu.");
            }
            for (CidsBean last : this.baulastenBeans) {
                List baulastArt = (List)last.getProperty("art");
                if (baulastArt != null && !baulastArt.isEmpty()) continue;
                errors.add("Die Baulast" + last.toString() + " muss mindestens eine Baulastart haben.");
            }
            if (errors.size() > 0) {
                String errorOutput = "";
                for (String s : errors) {
                    errorOutput = errorOutput + s + "\n";
                }
                errorOutput = errorOutput.substring(0, errorOutput.length() - 1);
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), errorOutput, "Fehler aufgetreten", 2);
                return false;
            }
            this.fillBaulastQualityAttributes();
            return true;
        }
        catch (Exception ex) {
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Speichern", ex, this);
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"kif", (String)"alb_baulastblatt", (int)15626, (int)1024, (int)800);
    }
}

