/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_baulastReportDialog;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_baulastUmleitungPanel;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.ClientStaticProperties;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.WebAccessBaulastenPictureFinder;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.BaulastenReportGenerator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionAdapter;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import de.cismet.tools.gui.panels.AlertPanel;
import de.cismet.tools.gui.panels.LayeredAlertPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class Alb_picturePanel
extends JPanel
implements ConnectionContextProvider,
RasterfariDocumentLoaderPanel.Listener {
    private static final Logger LOG = Logger.getLogger(Alb_picturePanel.class);
    private static final String REPORT_ACTION_TAG_BLATT = "baulast.report.blatt_disabled@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_PLAN = "baulast.report.plan_disabled@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_RASTER = "baulast.report.raster_disabled@WUNDA_BLAU";
    private static final String OPEN_ACTION_TAG = "baulast.renderer.openbutton_disabled@WUNDA_BLAU";
    private static final String TEXTBLATT_PROPERTY = "textblatt";
    private static final String LAGEPLAN_PROPERTY = "lageplan";
    public static final String BLATTNUMMER_PROPERTY = "blattnummer";
    public static final String LFDNUMMER_PROPERTY = "laufende_nummer";
    private static final int LAGEPLAN_DOCUMENT = 0;
    private static final int TEXTBLATT_DOCUMENT = 1;
    private static final int NO_SELECTION = -1;
    private static final Color KALIBRIERUNG_VORHANDEN = new Color(120, 255, 190);
    private static boolean alreadyWarnedAboutPermissionProblem = false;
    private static final String SRS = "EPSG:25832";
    private static final Crs CRS = new Crs("EPSG:25832", "EPSG:25832", "EPSG:25832", true, true);
    private static final XBoundingBox HOMEBB = new XBoundingBox(2583621.251964098, 5682507.032498134, 2584022.9413952776, 5682742.852810634, "EPSG:25832", true);
    private final JLabel alertWarnMessage = new JLabel("<html> <b>Warnung! </b> Es wurde kein Dokument gefunden. Klicken Sie auf diese Meldung um eine Weiterleitung einzurichten.</html>");
    final AlertPanel alert = new AlertPanel(AlertPanel.TYPE.DANGER, (Component)this.alertWarnMessage, true);
    private CidsBean cidsBean;
    private String[] documentDocuments;
    private JToggleButton[] documentButtons;
    private transient PropertyChangeListener updatePicturePathListener = null;
    private final MessenFeatureCollectionListener messenListener = new MessenFeatureCollectionListener();
    private int currentDocument = -1;
    private boolean pathsChanged = false;
    private final Map<Integer, Geometry> pageGeometries = new HashMap<Integer, Geometry>();
    private String collisionWarning = "";
    private final boolean selfPersisting;
    private boolean isErrorMessageVisible = true;
    private Alb_baulastUmleitungPanel umleitungsPanel;
    private boolean umleitungChangedFlag = false;
    private boolean showUmleitung = true;
    private boolean showDocTypePanelEnabled = true;
    private final ConnectionContext connectionContext;
    private ButtonGroup btnGrpDocs;
    private JButton btnHome;
    private JButton btnOpen;
    private JToggleButton btnPlan;
    private JToggleButton btnTextblatt;
    private ButtonGroup buttonGrpMode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JXHyperlink jXHyperlink1;
    private JXHyperlink jXHyperlink2;
    private JXHyperlink jXHyperlink3;
    private JXBusyLabel jxLBusyMeasure;
    private JXHyperlink jxlUmleitung;
    private JLabel lblArea;
    private JLabel lblCurrentViewTitle;
    private JLabel lblDistance;
    private JLabel lblReducedSize;
    private JLabel lblTxtArea;
    private JLabel lblTxtDistance;
    private JLabel lblUmleitung;
    private JLabel lblUmleitung2;
    private JList lstPictures;
    private LayeredAlertPanel measureComponentPanel;
    private RoundedPanel panBlattberichte;
    private JPanel panCenter;
    private JPanel panPicNavigation;
    private JPanel pnlAlert;
    private JPanel pnlBusy;
    private JPanel pnlLink;
    private JPanel pnlMeasureComp;
    private JPanel pnlMeasureComponentWrapper;
    private JPanel pnlUmleitungLink;
    private RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private RoundedPanel rpControls;
    private RoundedPanel rpMessdaten;
    private RoundedPanel rpSeiten;
    private JScrollPane scpPictureList;
    private SemiRoundedPanel semiRoundedPanel1;
    private SemiRoundedPanel semiRoundedPanel2;
    private SemiRoundedPanel semiRoundedPanel3;
    private SemiRoundedPanel semiRoundedPanel4;
    private SemiRoundedPanel semiRoundedPanel5;
    private SemiRoundedPanel semiRoundedPanel6;
    private RoundedPanel spDocuments;
    private JToggleButton togCalibrate;
    private JToggleButton togMessenLine;
    private JToggleButton togMessenPoly;
    private JToggleButton togPan;
    private JToggleButton togZoom;

    public Alb_picturePanel(ConnectionContext connectionContext) {
        this(false, true, connectionContext);
    }

    public Alb_picturePanel(boolean selfPersisting, boolean showDocTypePanelEnabled, ConnectionContext connectionContext) {
        this.selfPersisting = selfPersisting;
        this.showDocTypePanelEnabled = showDocTypePanelEnabled;
        this.connectionContext = connectionContext;
        this.umleitungsPanel = new Alb_baulastUmleitungPanel(Alb_baulastUmleitungPanel.MODE.TEXTBLATT, this, this.getConnectionContext());
        this.documentDocuments = new String[2];
        this.documentButtons = new JToggleButton[2];
        this.initComponents();
        this.lblReducedSize.setVisible(false);
        this.alert.setPreferredSize(new Dimension(500, 50));
        this.alert.setCursor(Cursor.getPredefinedCursor(12));
        this.pnlAlert.add((Component)this.alert, "Center");
        this.pnlAlert.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        this.jxlUmleitung.setClickedColor(new Color(204, 204, 204));
        this.documentButtons[0] = this.btnPlan;
        this.documentButtons[1] = this.btnTextblatt;
        this.rasterfariDocumentLoaderPanel1.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.messenListener);
        this.rasterfariDocumentLoaderPanel1.setScaleAndOffsets(Math.min(HOMEBB.getWidth(), HOMEBB.getHeight()), HOMEBB.getX1() + HOMEBB.getWidth() / 2.0, -HOMEBB.getY1() - HOMEBB.getHeight() / 2.0);
        this.alert.setVisible(false);
        this.alert.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Alb_picturePanel.this.handleAlertClick();
            }
        });
        this.alert.addCloseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Alb_picturePanel.this.showUmleitung = true;
                String editedLink = Alb_picturePanel.this.umleitungsPanel.getLinkDocument();
                if (Alb_picturePanel.this.jxlUmleitung.getText() == null || Alb_picturePanel.this.jxlUmleitung.getText().isEmpty()) {
                    Alb_picturePanel.this.lstPictures.setModel(new DefaultListModel());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Alb_picturePanel.this.showAlert(true);
                            Alb_picturePanel.this.invalidate();
                            Alb_picturePanel.this.revalidate();
                            Alb_picturePanel.this.repaint();
                        }
                    });
                } else if (!Alb_picturePanel.this.jxlUmleitung.getText().isEmpty() && !Alb_picturePanel.this.jxlUmleitung.getText().contains(editedLink)) {
                    Alb_picturePanel.this.showMeasureIsLoading();
                    Alb_picturePanel.this.lstPictures.setModel(new DefaultListModel());
                    FileSearchWorker worker = new FileSearchWorker();
                    worker.execute();
                }
            }
        });
        try {
            boolean billingAllowed = BillingPopup.isBillingAllowed("bla", this.getConnectionContext());
            this.jXHyperlink1.setEnabled(!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_BLATT, this.getConnectionContext()) && billingAllowed);
            this.jXHyperlink2.setEnabled(!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_PLAN, this.getConnectionContext()) && billingAllowed);
            this.jXHyperlink3.setEnabled(!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_RASTER, this.getConnectionContext()) && billingAllowed);
            this.btnOpen.setEnabled(!ObjectRendererUtils.checkActionTag(OPEN_ACTION_TAG, this.getConnectionContext()));
        }
        catch (Exception ex) {
            LOG.info((Object)"exception while checking action tags", (Throwable)ex);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void dispose() {
        this.rasterfariDocumentLoaderPanel1.getFeatureCollection().removeFeatureCollectionListener((FeatureCollectionListener)this.messenListener);
        this.rasterfariDocumentLoaderPanel1.dispose();
        this.updatePicturePathListener = null;
    }

    public void updateIfPicturePathsChanged() {
        if (this.pathsChanged) {
            this.setCurrentDocumentNull();
            CismetThreadPool.execute((Runnable)new FileSearchWorker());
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.documentDocuments = new String[2];
        this.umleitungChangedFlag = false;
        this.lstPictures.setModel(new DefaultListModel());
        this.rasterfariDocumentLoaderPanel1.removeAllFeatures();
        this.setEnabled(false);
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            this.updatePicturePathListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String evtProp = evt.getPropertyName();
                    if (Alb_picturePanel.TEXTBLATT_PROPERTY.equals(evtProp) || Alb_picturePanel.LAGEPLAN_PROPERTY.equals(evtProp)) {
                        Alb_picturePanel.this.pathsChanged = true;
                    }
                }
            };
            cidsBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.updatePicturePathListener, (Object)cidsBean));
        }
        this.setCurrentDocumentNull();
        this.jxLBusyMeasure.setBusy(true);
        CismetThreadPool.execute((Runnable)new FileSearchWorker());
    }

    private void initComponents() {
        this.btnGrpDocs = new ButtonGroup();
        this.buttonGrpMode = new ButtonGroup();
        this.pnlLink = new JPanel();
        this.lblUmleitung = new JLabel();
        this.jxlUmleitung = new JXHyperlink();
        this.lblUmleitung2 = new JLabel();
        this.pnlAlert = new JPanel();
        this.pnlMeasureComponentWrapper = new JPanel();
        this.pnlBusy = new JPanel();
        this.jxLBusyMeasure = new JXBusyLabel(new Dimension(64, 64));
        this.pnlMeasureComp = new JPanel();
        this.rasterfariDocumentLoaderPanel1 = new RasterfariDocumentLoaderPanel(ClientStaticProperties.getInstance().getAlbBaulastUrlPrefix(), (RasterfariDocumentLoaderPanel.Listener)this, HOMEBB, CRS, this.getConnectionContext());
        this.panPicNavigation = new JPanel();
        this.panBlattberichte = new RoundedPanel();
        this.semiRoundedPanel6 = new SemiRoundedPanel();
        this.jLabel4 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jXHyperlink1 = new JXHyperlink();
        this.jXHyperlink2 = new JXHyperlink();
        this.jXHyperlink3 = new JXHyperlink();
        this.spDocuments = new RoundedPanel();
        this.semiRoundedPanel2 = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnPlan = new JToggleButton();
        this.btnTextblatt = new JToggleButton();
        this.rpSeiten = new RoundedPanel();
        this.scpPictureList = new JScrollPane();
        this.lstPictures = this.rasterfariDocumentLoaderPanel1.getLstPages();
        this.semiRoundedPanel3 = new SemiRoundedPanel();
        this.jLabel2 = new JLabel();
        this.rpControls = new RoundedPanel();
        this.semiRoundedPanel4 = new SemiRoundedPanel();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.btnHome = this.rasterfariDocumentLoaderPanel1.getBtnHome();
        this.togPan = this.rasterfariDocumentLoaderPanel1.getTogPan();
        this.togZoom = this.rasterfariDocumentLoaderPanel1.getTogZoom();
        this.togMessenLine = new JToggleButton();
        this.togMessenPoly = new JToggleButton();
        this.togCalibrate = new JToggleButton();
        this.btnOpen = new JButton();
        this.rpMessdaten = new RoundedPanel();
        this.lblArea = new JLabel();
        this.lblDistance = new JLabel();
        this.lblTxtDistance = new JLabel();
        this.lblTxtArea = new JLabel();
        this.semiRoundedPanel5 = new SemiRoundedPanel();
        this.jLabel6 = new JLabel();
        this.panCenter = new JPanel();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.lblCurrentViewTitle = new JLabel();
        this.pnlUmleitungLink = new JPanel();
        this.lblReducedSize = new JLabel();
        this.measureComponentPanel = new LayeredAlertPanel(this.pnlMeasureComponentWrapper, this.pnlAlert);
        this.pnlLink.setOpaque(false);
        this.pnlLink.setLayout(new GridBagLayout());
        this.lblUmleitung.setForeground(new Color(254, 254, 254));
        this.lblUmleitung.setText("( Umleitung auf: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.pnlLink.add((Component)this.lblUmleitung, gridBagConstraints);
        this.jxlUmleitung.setForeground(new Color(204, 204, 204));
        this.jxlUmleitung.setText("");
        this.jxlUmleitung.setToolTipText("");
        this.jxlUmleitung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.jxlUmleitungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.pnlLink.add((Component)this.jxlUmleitung, gridBagConstraints);
        this.lblUmleitung2.setForeground(new Color(254, 254, 254));
        this.lblUmleitung2.setText(" )");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.pnlLink.add((Component)this.lblUmleitung2, gridBagConstraints);
        this.pnlAlert.setBackground(new Color(254, 254, 254));
        this.pnlAlert.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlAlert.setLayout(new BorderLayout());
        this.pnlMeasureComponentWrapper.setLayout(new CardLayout());
        this.pnlBusy.setBackground(new Color(254, 254, 254));
        this.pnlBusy.setBorder(BorderFactory.createEtchedBorder());
        this.pnlBusy.setLayout(new GridBagLayout());
        this.jxLBusyMeasure.setPreferredSize(new Dimension(64, 64));
        this.pnlBusy.add((Component)this.jxLBusyMeasure, new GridBagConstraints());
        this.pnlMeasureComponentWrapper.add((Component)this.pnlBusy, "busyCard");
        this.pnlMeasureComp.setLayout(new BorderLayout());
        this.pnlMeasureComp.add((Component)this.rasterfariDocumentLoaderPanel1, "Center");
        this.pnlMeasureComponentWrapper.add((Component)this.pnlMeasureComp, "measureCard");
        this.setMinimumSize(new Dimension(800, 700));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(800, 700));
        this.setLayout(new BorderLayout());
        this.panPicNavigation.setMinimumSize(new Dimension(180, 1000));
        this.panPicNavigation.setName("");
        this.panPicNavigation.setOpaque(false);
        this.panPicNavigation.setPreferredSize(new Dimension(180, 1000));
        this.panPicNavigation.setLayout(new GridBagLayout());
        this.panBlattberichte.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel6.setBackground(Color.darkGray);
        this.semiRoundedPanel6.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel4.setForeground(new Color(255, 255, 255));
        this.jLabel4.setText("Baulastbericht");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.semiRoundedPanel6.add((Component)this.jLabel4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panBlattberichte.add((Component)this.semiRoundedPanel6, (Object)gridBagConstraints);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jXHyperlink1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jXHyperlink1.setText("mit Textbl\u00e4ttern");
        this.jXHyperlink1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.jXHyperlink1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.jPanel4.add((Component)this.jXHyperlink1, gridBagConstraints);
        this.jXHyperlink2.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jXHyperlink2.setText("<html>mit Textbl\u00e4ttern<br/> und Pl\u00e4nen");
        this.jXHyperlink2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.jXHyperlink2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.jPanel4.add((Component)this.jXHyperlink2, gridBagConstraints);
        this.jXHyperlink3.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf_blr.png")));
        this.jXHyperlink3.setText("<html>mit Textblatt, Plan und<br/>Rasterdokumenten");
        this.jXHyperlink3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.jXHyperlink3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.jPanel4.add((Component)this.jXHyperlink3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        this.panBlattberichte.add((Component)this.jPanel4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 7);
        this.panPicNavigation.add((Component)this.panBlattberichte, gridBagConstraints);
        this.spDocuments.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel2.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel2.setLayout((LayoutManager)new FlowLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Dokumentauswahl");
        this.semiRoundedPanel2.add((Component)this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.spDocuments.add((Component)this.semiRoundedPanel2, (Object)gridBagConstraints);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        this.btnGrpDocs.add(this.btnPlan);
        this.btnPlan.setText("Plan");
        this.btnPlan.setPreferredSize(new Dimension(53, 33));
        this.btnPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.btnPlanActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnPlan);
        this.btnGrpDocs.add(this.btnTextblatt);
        this.btnTextblatt.setSelected(true);
        this.btnTextblatt.setText("Textblatt");
        this.btnTextblatt.setPreferredSize(new Dimension(53, 33));
        this.btnTextblatt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.btnTextblattActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnTextblatt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.spDocuments.add((Component)this.jPanel2, (Object)gridBagConstraints);
        if (this.showDocTypePanelEnabled) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 7);
            this.panPicNavigation.add((Component)this.spDocuments, gridBagConstraints);
        }
        this.rpSeiten.setLayout((LayoutManager)new GridBagLayout());
        this.scpPictureList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.scpPictureList.setMinimumSize(new Dimension(87, 140));
        this.scpPictureList.setOpaque(false);
        this.lstPictures.setSelectionMode(0);
        this.lstPictures.setEnabled(false);
        this.lstPictures.setFixedCellWidth(75);
        this.lstPictures.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Alb_picturePanel.this.lstPicturesValueChanged(evt);
            }
        });
        this.scpPictureList.setViewportView(this.lstPictures);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpSeiten.add((Component)this.scpPictureList, (Object)gridBagConstraints);
        this.semiRoundedPanel3.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel3.setLayout((LayoutManager)new FlowLayout());
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("Seitenauswahl");
        this.semiRoundedPanel3.add((Component)this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpSeiten.add((Component)this.semiRoundedPanel3, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 7);
        this.panPicNavigation.add((Component)this.rpSeiten, gridBagConstraints);
        this.rpControls.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel4.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel4.setLayout((LayoutManager)new FlowLayout());
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("Steuerung");
        this.semiRoundedPanel4.add((Component)this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpControls.add((Component)this.semiRoundedPanel4, (Object)gridBagConstraints);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
        this.btnHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));
        this.btnHome.setText("\u00dcbersicht");
        this.btnHome.setToolTipText("\u00dcbersicht");
        this.btnHome.setFocusPainted(false);
        this.btnHome.setHorizontalAlignment(2);
        this.btnHome.setMinimumSize(new Dimension(89, 29));
        this.jPanel3.add(this.btnHome);
        this.buttonGrpMode.add(this.togPan);
        this.togPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));
        this.togPan.setSelected(true);
        this.togPan.setText("Verschieben");
        this.togPan.setToolTipText("Verschieben");
        this.togPan.setFocusPainted(false);
        this.togPan.setHorizontalAlignment(2);
        this.togPan.setMinimumSize(new Dimension(89, 29));
        this.jPanel3.add(this.togPan);
        this.buttonGrpMode.add(this.togZoom);
        this.togZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));
        this.togZoom.setText("Zoomen");
        this.togZoom.setToolTipText("Zoomen");
        this.togZoom.setFocusPainted(false);
        this.togZoom.setHorizontalAlignment(2);
        this.togZoom.setMinimumSize(new Dimension(89, 29));
        this.jPanel3.add(this.togZoom);
        this.buttonGrpMode.add(this.togMessenLine);
        this.togMessenLine.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/newLinestring.png")));
        this.togMessenLine.setText("Messlinie");
        this.togMessenLine.setToolTipText("Messen (Linie)");
        this.togMessenLine.setFocusPainted(false);
        this.togMessenLine.setHorizontalAlignment(2);
        this.togMessenLine.setMinimumSize(new Dimension(89, 29));
        this.togMessenLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.togMessenLineActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.togMessenLine);
        this.buttonGrpMode.add(this.togMessenPoly);
        this.togMessenPoly.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/newPolygon.png")));
        this.togMessenPoly.setText("Messfl\u00e4che");
        this.togMessenPoly.setToolTipText("Messen (Polygon)");
        this.togMessenPoly.setFocusPainted(false);
        this.togMessenPoly.setHorizontalAlignment(2);
        this.togMessenPoly.setMinimumSize(new Dimension(89, 29));
        this.togMessenPoly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.togMessenPolyActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.togMessenPoly);
        this.buttonGrpMode.add(this.togCalibrate);
        this.togCalibrate.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/screen.gif")));
        this.togCalibrate.setText("Kalibrieren");
        this.togCalibrate.setToolTipText("Kalibrieren");
        this.togCalibrate.setEnabled(false);
        this.togCalibrate.setFocusPainted(false);
        this.togCalibrate.setHorizontalAlignment(2);
        this.togCalibrate.setMinimumSize(new Dimension(89, 29));
        this.togCalibrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.togCalibrateActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.togCalibrate);
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/folder-image.png")));
        this.btnOpen.setText("\u00d6ffnen");
        this.btnOpen.setToolTipText("Download zum \u00d6ffnen in externer Anwendung");
        this.btnOpen.setFocusPainted(false);
        this.btnOpen.setHorizontalAlignment(2);
        this.btnOpen.setMinimumSize(new Dimension(89, 29));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_picturePanel.this.btnOpenActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnOpen);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.rpControls.add((Component)this.jPanel3, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 7);
        this.panPicNavigation.add((Component)this.rpControls, gridBagConstraints);
        this.rpMessdaten.setLayout((LayoutManager)new GridBagLayout());
        this.lblArea.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.rpMessdaten.add((Component)this.lblArea, (Object)gridBagConstraints);
        this.lblDistance.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.rpMessdaten.add((Component)this.lblDistance, (Object)gridBagConstraints);
        this.lblTxtDistance.setFont(new Font("Tahoma", 1, 11));
        this.lblTxtDistance.setText("L\u00e4nge/Umfang:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.rpMessdaten.add((Component)this.lblTxtDistance, (Object)gridBagConstraints);
        this.lblTxtArea.setFont(new Font("Tahoma", 1, 11));
        this.lblTxtArea.setText("Fl\u00e4che:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.rpMessdaten.add((Component)this.lblTxtArea, (Object)gridBagConstraints);
        this.semiRoundedPanel5.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel5.setLayout((LayoutManager)new FlowLayout());
        this.jLabel6.setForeground(new Color(255, 255, 255));
        this.jLabel6.setText("Messdaten");
        this.semiRoundedPanel5.add((Component)this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpMessdaten.add((Component)this.semiRoundedPanel5, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 7);
        this.panPicNavigation.add((Component)this.rpMessdaten, gridBagConstraints);
        this.add((Component)this.panPicNavigation, "West");
        this.panCenter.setOpaque(false);
        this.panCenter.setLayout(new GridBagLayout());
        this.semiRoundedPanel1.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.lblCurrentViewTitle.setForeground(new Color(255, 255, 255));
        this.lblCurrentViewTitle.setText("Keine Auswahl");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.semiRoundedPanel1.add((Component)this.lblCurrentViewTitle, (Object)gridBagConstraints);
        this.pnlUmleitungLink.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.semiRoundedPanel1.add((Component)this.pnlUmleitungLink, (Object)gridBagConstraints);
        this.lblReducedSize.setForeground(new Color(254, 254, 254));
        this.lblReducedSize.setText(NbBundle.getMessage(Alb_picturePanel.class, (String)"VermessungBuchwerkEditor.lblReducedSize.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.semiRoundedPanel1.add((Component)this.lblReducedSize, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panCenter.add((Component)this.semiRoundedPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panCenter.add((Component)this.measureComponentPanel, gridBagConstraints);
        this.add((Component)this.panCenter, "Center");
    }

    private void togMessenPolyActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionMeasurePolygon();
    }

    private void togMessenLineActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionMeasureLine();
    }

    private void togCalibrateActionPerformed(ActionEvent evt) {
        if (this.rasterfariDocumentLoaderPanel1.getCurrentPage() != -1) {
            Double distance = this.askForDistanceValue();
            if (distance != null) {
                if (distance > 0.0) {
                    this.rasterfariDocumentLoaderPanel1.calibrate(distance.doubleValue());
                    try {
                        this.registerGeometryForPage(this.rasterfariDocumentLoaderPanel1.getMainDocumentGeometry(), this.currentDocument, this.rasterfariDocumentLoaderPanel1.getCurrentPage());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        ErrorInfo ei = new ErrorInfo("Fehler beim Speichern der Kalibrierung", "Beim Speichern der Kalibrierung ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
                        JXErrorPane.showDialog((Component)this, (ErrorInfo)ei);
                    }
                } else {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Eingegebene(r) Distanz bzw. Umfang ist kein g\u00fcltiger Wert oder gleich 0.", "Ung\u00fcltige Eingabe", 2);
                }
            }
            this.togPan.setSelected(true);
        }
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        final String document = this.rasterfariDocumentLoaderPanel1.getCurrentDocument();
        if (document == null) {
            return;
        }
        final URL documentUrl = document.contains("_rs.") ? this.rasterfariDocumentLoaderPanel1.getDocumentUrl(document.replaceAll("_rs", "")) : this.rasterfariDocumentLoaderPanel1.getDocumentUrl();
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String filename = document.substring(document.lastIndexOf("/") + 1);
                if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)Alb_picturePanel.this)) {
                    DownloadManager.instance().add((Download)new HttpDownload(documentUrl, "", DownloadManagerDialog.getInstance().getJobName(), "Baulast", filename.substring(0, filename.lastIndexOf(".")), filename.substring(filename.lastIndexOf("."))));
                }
            }
        });
    }

    private void btnPlanActionPerformed(ActionEvent evt) {
        this.umleitungsPanel = new Alb_baulastUmleitungPanel(Alb_baulastUmleitungPanel.MODE.LAGEPLAN, this, this.getConnectionContext());
        this.showUmleitung = true;
        this.showPlan();
        this.checkLinkInTitle();
    }

    private void btnTextblattActionPerformed(ActionEvent evt) {
        this.umleitungsPanel = new Alb_baulastUmleitungPanel(Alb_baulastUmleitungPanel.MODE.TEXTBLATT, this, this.getConnectionContext());
        this.showUmleitung = true;
        this.showTextBlatt();
        this.checkLinkInTitle();
    }

    private void jxlUmleitungActionPerformed(ActionEvent evt) {
        this.umleitungsPanel.reset();
        this.alert.setType(AlertPanel.TYPE.SUCCESS);
        this.umleitungsPanel.setTextColor(AlertPanel.successMessageColor);
        String s = this.jxlUmleitung.getText();
        this.umleitungsPanel.setLinkDocumentText(s.substring(0, s.length() - 1));
        Alb_baulastUmleitungPanel.MODE mode = this.currentDocument == 0 ? Alb_baulastUmleitungPanel.MODE.LAGEPLAN : Alb_baulastUmleitungPanel.MODE.TEXTBLATT;
        this.umleitungsPanel.setMode(mode);
        this.alert.setContent((Component)this.umleitungsPanel);
        this.alert.setVisible(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void jXHyperlink3ActionPerformed(ActionEvent evt) {
        Alb_baulastReportDialog.getInstance().showAndDoDownload(BaulastenReportGenerator.Type.TEXTBLATT_PLAN_RASTER, Arrays.asList(this.cidsBean), this);
    }

    private void jXHyperlink1ActionPerformed(ActionEvent evt) {
        Alb_baulastReportDialog.getInstance().showAndDoDownload(BaulastenReportGenerator.Type.TEXTBLATT, Arrays.asList(this.cidsBean), this);
    }

    private void jXHyperlink2ActionPerformed(ActionEvent evt) {
        Alb_baulastReportDialog.getInstance().showAndDoDownload(BaulastenReportGenerator.Type.TEXTBLATT_PLAN, Arrays.asList(this.cidsBean), this);
    }

    private void lstPicturesValueChanged(ListSelectionEvent evt) {
        int page = this.lstPictures.getSelectedIndex();
        this.refreshMessenForPage(page);
    }

    private Collection<CidsBean> getPages() {
        if (this.cidsBean != null) {
            Object o = null;
            if (this.currentDocument == 1) {
                o = this.cidsBean.getProperty("textblatt_pages");
            } else if (this.currentDocument == 0) {
                o = this.cidsBean.getProperty("lageplan_pages");
            }
            if (o instanceof Collection) {
                return (Collection)o;
            }
        }
        return null;
    }

    private void registerGeometryForPage(Geometry geometry, int documentNo, int pageNo) throws Exception {
        Geometry oldVal;
        if (!(geometry == null || documentNo <= -1 || pageNo <= -1 || (oldVal = this.pageGeometries.get(pageNo)) != null && oldVal.equals(geometry))) {
            this.pageGeometries.put(pageNo, geometry);
            Collection<CidsBean> pageGeoCollection = this.getPages();
            if (pageGeoCollection != null) {
                boolean pageFound = false;
                for (CidsBean pageGeom : pageGeoCollection) {
                    Object pageNumberObj = pageGeom.getProperty("page_number");
                    if (!(pageNumberObj instanceof Integer) || pageNo != (Integer)pageNumberObj) continue;
                    pageGeom.setProperty("geometry", (Object)geometry);
                    pageFound = true;
                    break;
                }
                if (!pageFound) {
                    CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName("ALB_GEO_DOCUMENT_PAGE", this.getConnectionContext());
                    newBean.setProperty("page_number", (Object)pageNo);
                    newBean.setProperty("geometry", (Object)geometry);
                    pageGeoCollection.add(newBean);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)newBean.getMetaObject().getDebugString());
                    }
                }
                if (this.selfPersisting) {
                    this.persistBean();
                }
                this.rpMessdaten.setBackground(KALIBRIERUNG_VORHANDEN);
                this.rpMessdaten.setAlpha(120);
            } else {
                LOG.error((Object)"Empty Page Collection!");
            }
        }
    }

    public void showMeasureIsLoading() {
        this.jxLBusyMeasure.setBusy(true);
        CardLayout cl = (CardLayout)this.pnlMeasureComponentWrapper.getLayout();
        cl.show(this.pnlMeasureComponentWrapper, "busyCard");
    }

    public void showMeasurePanel() {
        this.jxLBusyMeasure.setBusy(false);
        CardLayout cl = (CardLayout)this.pnlMeasureComponentWrapper.getLayout();
        cl.show(this.pnlMeasureComponentWrapper, "measureCard");
    }

    private void showPlan() {
        this.lblCurrentViewTitle.setText("Lageplan");
        this.currentDocument = 0;
        this.showDocument(this.currentDocument);
    }

    private void showTextBlatt() {
        this.lblCurrentViewTitle.setText("Textblatt");
        this.currentDocument = 1;
        this.showDocument(this.currentDocument);
    }

    private void showDocument(int currentDocument) {
        this.showMeasureIsLoading();
        this.checkLinkInTitle();
        this.showAlert(false);
        if (this.documentDocuments[currentDocument] == null) {
            this.showAlert(true);
        } else {
            this.rasterfariDocumentLoaderPanel1.setDocument(this.documentDocuments[currentDocument]);
            this.readPageGeometriesIntoMap(this.getPages());
        }
        this.showMeasurePanel();
    }

    private void readPageGeometriesIntoMap(Collection<CidsBean> pageGeoms) {
        this.pageGeometries.clear();
        if (pageGeoms != null) {
            for (CidsBean bean : pageGeoms) {
                Object pageNumberObj = bean.getProperty("page_number");
                Object geometryObj = bean.getProperty("geometry");
                if (!(pageNumberObj instanceof Integer) || !(geometryObj instanceof Geometry)) continue;
                this.pageGeometries.put((Integer)pageNumberObj, (Geometry)geometryObj);
            }
        }
    }

    private void checkLinkInTitle() {
        String document = this.documentDocuments[this.currentDocument];
        this.checkLinkInTitle(document);
    }

    private void checkLinkInTitle(String document) {
        this.showLinkInTitle(false);
        this.lblReducedSize.setVisible(false);
        if (document != null) {
            if (document.contains("_rs.")) {
                this.lblReducedSize.setVisible(true);
            }
            String filename = this.getDocumentFilename();
            this.jxlUmleitung.setText("");
            if (!document.contains(filename)) {
                this.jxlUmleitung.setText(this.extractFilenameofUrl(document));
                this.showLinkInTitle(true);
                this.repaint();
            }
        }
    }

    private String getDocumentFilename() {
        if (this.currentDocument == 0) {
            return WebAccessBaulastenPictureFinder.getInstance().getPlanPictureFilename(this.getCidsBean()).toString();
        }
        return WebAccessBaulastenPictureFinder.getInstance().getTextblattPictureFilename(this.getCidsBean()).toString();
    }

    private String extractFilenameofUrl(String document) {
        String[] splittedUrl = document.split("/");
        String s = splittedUrl[splittedUrl.length - 1];
        return s.substring(0, s.indexOf("."));
    }

    private void setCurrentDocumentNull() {
        this.pageGeometries.clear();
        this.setCurrentPageNull();
    }

    private void setCurrentPageNull() {
        this.rpMessdaten.setBackground(Color.WHITE);
    }

    private void showPermissionWarning() {
        if (!alreadyWarnedAboutPermissionProblem) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Kein Schreibrecht", "Kein Schreibrecht f\u00fcr die Klasse. \u00c4nderungen werden nicht gespeichert.", 2);
        }
        LOG.warn((Object)"User has no right to save Baulast bean!");
        alreadyWarnedAboutPermissionProblem = true;
    }

    private void persistBean() throws Exception {
        if (CidsBeanSupport.checkWritePermission(this.cidsBean)) {
            alreadyWarnedAboutPermissionProblem = false;
            SwingWorker<Void, Void> persistWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Alb_picturePanel.this.cidsBean.persist(Alb_picturePanel.this.getConnectionContext());
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        ErrorInfo ei = new ErrorInfo("Fehler beim Speichern der Kalibrierung", "Beim Speichern der Kalibrierung ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
                        JXErrorPane.showDialog((Component)Alb_picturePanel.this, (ErrorInfo)ei);
                    }
                }
            };
            CismetThreadPool.execute((Runnable)persistWorker);
        } else {
            this.showPermissionWarning();
        }
    }

    private Double askForDistanceValue() {
        try {
            String laenge = JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this), "Bitte L\u00e4nge bzw. Umfang in Metern eingeben:", "Kalibrierung", 3);
            if (laenge != null) {
                return Math.abs(Double.parseDouble(laenge.replace(',', '.')));
            }
            return null;
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
            return 0.0;
        }
    }

    public String getCollisionWarning() {
        return this.collisionWarning;
    }

    public void clearCollisionWarning() {
        this.collisionWarning = "";
    }

    private void resetMeasureDataLabels() {
        this.lblTxtDistance.setText("L\u00e4nge/Umfang:");
        this.lblDistance.setText("-");
        this.lblArea.setText("-");
    }

    private void refreshMeasurementsInStatus(Collection<Feature> cf) {
        double umfang = 0.0;
        double area = 0.0;
        for (Feature f : cf) {
            Geometry geom = f.getGeometry();
            if (!(f instanceof PureNewFeature) || geom == null) continue;
            area += geom.getArea();
            if ((umfang += geom.getLength()) != 0.0) {
                if (area != 0.0) {
                    this.lblTxtDistance.setText("Umfang:");
                    this.lblDistance.setText(StaticDecimalTools.round((double)umfang) + " m ");
                    this.lblArea.setText(StaticDecimalTools.round((double)area) + " m\u00b2");
                    continue;
                }
                if ("POLYGON".equals(this.rasterfariDocumentLoaderPanel1.getMessenInputListener().getMode())) {
                    umfang *= 0.5;
                }
                this.lblTxtDistance.setText("L\u00e4nge:");
                this.lblDistance.setText(StaticDecimalTools.round((double)umfang) + " m ");
                this.lblArea.setText("-");
                continue;
            }
            this.resetMeasureDataLabels();
        }
    }

    private void showAlert(boolean show) {
        if (!this.selfPersisting) {
            this.alert.setType(AlertPanel.TYPE.DANGER);
            this.alert.setContent((Component)this.alertWarnMessage);
            this.alert.setVisible(show);
        }
    }

    public JPanel getDocTypePanel() {
        return this.jPanel2;
    }

    private void showLinkInTitle(boolean flag) {
        this.pnlUmleitungLink.removeAll();
        if (flag && !this.selfPersisting) {
            this.pnlUmleitungLink.add(this.pnlLink);
        }
    }

    private void handleAlertClick() {
        if (this.isErrorMessageVisible) {
            if (this.showUmleitung) {
                this.showUmleitung = false;
                String document = this.documentDocuments[this.currentDocument];
                String filename = this.getDocumentFilename();
                if (document == null || document.contains(filename)) {
                    this.umleitungsPanel.reset();
                    Alb_baulastUmleitungPanel.MODE mode = this.currentDocument == 0 ? Alb_baulastUmleitungPanel.MODE.LAGEPLAN : Alb_baulastUmleitungPanel.MODE.TEXTBLATT;
                    this.umleitungsPanel.setMode(mode);
                    this.umleitungsPanel.setTextColor(AlertPanel.dangerMessageColor);
                    this.alert.setContent((Component)this.umleitungsPanel);
                }
            }
        } else {
            this.isErrorMessageVisible = true;
            this.showUmleitung = true;
            this.alert.setContent((Component)this.alertWarnMessage);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void successAlert() {
        this.setCurrentPageNull();
        this.alert.setType(AlertPanel.TYPE.SUCCESS);
        this.umleitungsPanel.setTextColor(AlertPanel.successMessageColor);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void handleNoDocumentFound() {
        this.alert.setType(AlertPanel.TYPE.DANGER);
        this.umleitungsPanel.setTextColor(AlertPanel.dangerMessageColor);
        this.rasterfariDocumentLoaderPanel1.removeAllFeatures();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void reloadPictureFromUrl(URL url) {
        this.showMeasureIsLoading();
    }

    public void reloadDocuments() {
        FileSearchWorker worker = new FileSearchWorker();
        worker.execute();
    }

    void setUmleitungChangedFlag(boolean aFlag) {
        this.umleitungChangedFlag = aFlag;
    }

    boolean isUmleitungChangedFlag() {
        return this.umleitungChangedFlag;
    }

    public void handleUmleitungCreated(String document) {
        this.showAlert(false);
        this.umleitungChangedFlag = true;
        this.checkLinkInTitle(document);
        FileSearchWorker worker = new FileSearchWorker(false);
        worker.execute();
    }

    public void handleUmleitungDeleted() {
        this.showAlert(true);
        this.rasterfariDocumentLoaderPanel1.removeAllFeatures();
        this.umleitungChangedFlag = true;
        this.jxlUmleitung.setText("");
        this.showLinkInTitle(false);
        this.repaint();
    }

    public void handleEscapePressed() {
        this.rasterfariDocumentLoaderPanel1.removeAllFeatures();
    }

    public void refreshMessenForPage(int pageNumber) {
        int defaultSrid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getName());
        Geometry pageGeom = this.pageGeometries.get(pageNumber);
        if (pageGeom != null) {
            int srid = pageGeom.getSRID();
            if (srid == CismapBroker.getInstance().getDefaultCrsAlias()) {
                srid = defaultSrid;
            }
            XBoundingBox bb = new XBoundingBox(srid != defaultSrid ? CrsTransformer.transformToDefaultCrs((Geometry)pageGeom) : pageGeom);
            this.rasterfariDocumentLoaderPanel1.setMainDocumentGeometry(pageGeom);
            this.rasterfariDocumentLoaderPanel1.setScaleAndOffsets(Math.max(bb.getWidth(), bb.getHeight()), bb.getX1() + bb.getWidth() / 2.0, -bb.getY1() - bb.getHeight() / 2.0);
        } else {
            Coordinate centroid = HOMEBB.getGeometry().getCentroid().getCoordinate();
            XBoundingBox bb = new XBoundingBox(centroid.x - 828.0, centroid.y - 1169.0, centroid.x + 828.0, centroid.y + 1169.0, SRS, true);
            this.rasterfariDocumentLoaderPanel1.setMainDocumentGeometry(bb.getGeometry(defaultSrid));
            this.rasterfariDocumentLoaderPanel1.setScaleAndOffsets(Math.max(bb.getWidth(), bb.getHeight()), bb.getX1() + bb.getWidth() / 2.0, -bb.getY1() - bb.getHeight() / 2.0);
        }
        this.togPan.setSelected(true);
        this.resetMeasureDataLabels();
        if (pageGeom != null) {
            this.rpMessdaten.setBackground(KALIBRIERUNG_VORHANDEN);
            this.rpMessdaten.setAlpha(120);
        } else {
            this.rpMessdaten.setBackground(Color.WHITE);
            this.rpMessdaten.setAlpha(60);
        }
    }

    final class MessenFeatureCollectionListener
    extends FeatureCollectionAdapter {
        MessenFeatureCollectionListener() {
        }

        public void featuresAdded(FeatureCollectionEvent fce) {
            if (!Alb_picturePanel.this.togCalibrate.isEnabled()) {
                for (Feature f : Alb_picturePanel.this.rasterfariDocumentLoaderPanel1.getFeatureCollection().getAllFeatures()) {
                    if (!(f instanceof PureNewFeature) || f.getGeometry() instanceof Point) continue;
                    Alb_picturePanel.this.togCalibrate.setEnabled(true);
                }
            }
            Alb_picturePanel.this.refreshMeasurementsInStatus(fce.getEventFeatures());
        }

        public void featuresRemoved(FeatureCollectionEvent fce) {
            if (Alb_picturePanel.this.togCalibrate.isEnabled()) {
                for (Feature f : Alb_picturePanel.this.rasterfariDocumentLoaderPanel1.getFeatureCollection().getAllFeatures()) {
                    if (!(f instanceof PureNewFeature) || f.getGeometry() instanceof Point) continue;
                    return;
                }
                Alb_picturePanel.this.togCalibrate.setEnabled(false);
            }
        }

        public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            this.featuresRemoved(fce);
        }

        public void featuresChanged(FeatureCollectionEvent fce) {
            Alb_picturePanel.this.refreshMeasurementsInStatus(fce.getEventFeatures());
        }

        public void featureSelectionChanged(FeatureCollectionEvent fce) {
            Alb_picturePanel.this.refreshMeasurementsInStatus(fce.getEventFeatures());
        }
    }

    final class FileSearchWorker
    extends SwingWorker<List<String>[], Void> {
        private boolean reloadMeasurementComp = true;

        public FileSearchWorker() {
            this(true);
        }

        public FileSearchWorker(boolean reloadMeasuringComponent) {
            this.reloadMeasurementComp = reloadMeasuringComponent;
            if (this.reloadMeasurementComp) {
                Alb_picturePanel.this.rasterfariDocumentLoaderPanel1.reset();
                Alb_picturePanel.this.togPan.setSelected(true);
                Alb_picturePanel.this.resetMeasureDataLabels();
            }
        }

        @Override
        protected List<String>[] doInBackground() throws Exception {
            List[] result = new List[2];
            result[1] = WebAccessBaulastenPictureFinder.getInstance().findTextblattPicture(Alb_picturePanel.this.getCidsBean());
            result[0] = WebAccessBaulastenPictureFinder.getInstance().findPlanPicture(Alb_picturePanel.this.getCidsBean());
            LOG.debug((Object)("Textbl\u00e4tter:" + result[1]));
            LOG.debug((Object)("Lagepl\u00e4ne:" + result[0]));
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                List[] result = (List[])this.get();
                StringBuffer collisionLists = new StringBuffer();
                for (int i = 0; i < result.length; ++i) {
                    List current = result[i];
                    if (current == null || current.size() <= 0) continue;
                    if (current.size() > 1) {
                        if (collisionLists.length() > 0) {
                            collisionLists.append(",\n");
                        }
                        collisionLists.append(current);
                    }
                    ((Alb_picturePanel)Alb_picturePanel.this).documentDocuments[i] = (String)current.get(0);
                }
                if (collisionLists.length() > 0) {
                    Alb_picturePanel.this.collisionWarning = "Achtung: im Zielverzeichnis sind mehrere Dateien mit demselben Namen in unterschiedlichen Dateiformaten vorhanden.\n\nBitte l\u00f6schen Sie die ung\u00fcltigen Formate und setzen Sie die Bearbeitung in WuNDa anschlie\u00dfend fort.\n\nDateien:\n" + collisionLists + "\n";
                    LOG.info((Object)Alb_picturePanel.this.collisionWarning);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            finally {
                if (this.reloadMeasurementComp) {
                    Alb_picturePanel.this.pathsChanged = false;
                    Alb_picturePanel.this.setEnabled(true);
                    if (Alb_picturePanel.this.btnTextblatt.isSelected()) {
                        Alb_picturePanel.this.showTextBlatt();
                    } else if (Alb_picturePanel.this.btnPlan.isSelected()) {
                        Alb_picturePanel.this.showPlan();
                    } else {
                        Alb_picturePanel.this.lstPictures.setModel(new DefaultListModel());
                        Alb_picturePanel.this.rasterfariDocumentLoaderPanel1.removeAllFeatures();
                        Alb_picturePanel.this.setEnabled(false);
                    }
                }
            }
        }
    }
}

