/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.objecteditors.utils.BaumChildrenLoader;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumErsatzPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumParentPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.ComboBoxFilterDialog;
import de.cismet.cids.custom.wunda_blau.search.server.AbstractMonToLwmoSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BaumSchadenLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class BaumErsatzEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
BaumParentPanel {
    private static final Logger LOG = Logger.getLogger(BaumErsatzEditor.class);
    private static final String[] SCHADEN_COL_NAMES = new String[]{"Gebiet-Aktenzeichen", "Meldungsdatum", "Id", "gef. Art"};
    private static final String[] SCHADEN_PROP_NAMES = new String[]{"fk_meldung.fk_gebiet.aktenzeichen", "fk_meldung.datum", "id", "fk_art"};
    private static final Class[] SCHADEN_PROP_TYPES = new Class[]{CidsBean.class, Date.class, Integer.class, CidsBean.class};
    private static final String[] LOADING_COL_NAMES = new String[]{"Die Daten werden geladen......"};
    private static final String[] MUSTSET_COL_NAMES = new String[]{"Die Daten bitte zuweisen......"};
    private static final String TITLE_NEW_ERSATZ = "eine neue Ersatzpflanzung anlegen ....";
    public static final String FIELD__ID = "id";
    public static final String FIELD__GEOREFERENZ = "fk_geom";
    public static final String FIELD__SELBST = "selbststaendig";
    public static final String FIELD__DISPENS = "dispensbau";
    public static final String FIELD__AB = "abarbeiten";
    public static final String FIELD__ART = "fk_art.name";
    public static final String FIELD__FK_SCHADEN = "fk_schaden";
    public static final String FIELD__SCHADEN_ID = "fk_schaden.id";
    public static final String FIELD__SCHADEN_ART = "fk_schaden.fk_art.name";
    public static final String FIELD__MELDUNG_DATUM = "fk_schaden.fk_meldung.datum";
    public static final String FIELD__GEBIET_AZ = "fk_schaden.fk_meldung.fk_gebiet.aktenzeichen";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_GEOM = "geom";
    public static final String TABLE__SCHADEN = "baum_schaden";
    public static final String TABLE__NAME = "baum_ersatz";
    public static final String BUNDLE_NOSCHADEN = "BaumErsatzEditor.isOkForSaving().noSchaden";
    public static final String BUNDLE_PANE_PREFIX = "BaumErsatzEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BaumErsatzEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BaumErsatzEditor.isOkForSaving().JOptionPane.title";
    public static final String BUNDLE_NOSAVE_MESSAGE = "BaumErsatzEditor.noSave().message";
    public static final String BUNDLE_NOSAVE_TITLE = "BaumErsatzEditor.noSave().title";
    private static Exception errorNoSave = null;
    private final boolean editor;
    private final BaumChildrenLoader baumChildrenLoader = new BaumChildrenLoader(this);
    private BaumErsatzPanel baumErsatzPanel;
    private JButton btnChangeSchaden;
    private ComboBoxFilterDialog comboBoxFilterDialogSchaden;
    private JScrollPane jScrollPaneMeldung;
    private JLabel lblGebiet_Meldung;
    private JPanel panContent;
    private JPanel panErsatz;
    JPanel panErsatzMain;
    private JPanel panFillerUnten;
    private JXTable xtSchaden;

    public BaumErsatzEditor() {
        this(true);
    }

    public BaumErsatzEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.xtSchaden.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.xtSchaden.getColumn(2).setMaxWidth(70);
        this.xtSchaden.getColumn(1).setMaxWidth(150);
        this.xtSchaden.setSortable(false);
        this.xtSchaden.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = BaumErsatzEditor.this.xtSchaden.rowAtPoint(e.getPoint());
                int col = BaumErsatzEditor.this.xtSchaden.columnAtPoint(e.getPoint());
                if (row > -1 && col > -1) {
                    Object value = BaumErsatzEditor.this.xtSchaden.getValueAt(row, col);
                    if (null != value && !"".equals(value)) {
                        BaumErsatzEditor.this.xtSchaden.setToolTipText(value.toString());
                    } else {
                        BaumErsatzEditor.this.xtSchaden.setToolTipText(null);
                    }
                }
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.comboBoxFilterDialogSchaden = new ComboBoxFilterDialog(null, (AbstractMonToLwmoSearch)new BaumSchadenLightweightSearch(), "Gebiet-Meldung-Schaden ausw\u00e4hlen", this.getConnectionContext());
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panErsatz = new JPanel();
        this.lblGebiet_Meldung = new JLabel();
        this.jScrollPaneMeldung = new JScrollPane();
        this.xtSchaden = new JXTable();
        this.btnChangeSchaden = new JButton();
        this.panErsatzMain = new JPanel();
        this.baumErsatzPanel = new BaumErsatzPanel(this.getBaumChildrenLoader());
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panErsatz.setOpaque(false);
        this.panErsatz.setLayout(new GridBagLayout());
        this.lblGebiet_Meldung.setFont(new Font("Tahoma", 1, 11));
        this.lblGebiet_Meldung.setText("Gebiet - Meldung - Schaden:");
        this.lblGebiet_Meldung.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panErsatz.add((Component)this.lblGebiet_Meldung, gridBagConstraints);
        this.xtSchaden.setModel((TableModel)new ErsatzSchadenTableModel());
        this.xtSchaden.setVisibleRowCount(1);
        this.jScrollPaneMeldung.setViewportView((Component)this.xtSchaden);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.panErsatz.add((Component)this.jScrollPaneMeldung, gridBagConstraints);
        this.btnChangeSchaden.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/tick_32.png")));
        this.btnChangeSchaden.setToolTipText("Gebiet - Meldung - Schaden zuweisen");
        this.btnChangeSchaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaumErsatzEditor.this.btnChangeSchadenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.panErsatz.add((Component)this.btnChangeSchaden, gridBagConstraints);
        this.btnChangeSchaden.setVisible(this.isEditor());
        this.panErsatzMain.setOpaque(false);
        this.panErsatzMain.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panErsatzMain.add((Component)this.baumErsatzPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panErsatz.add((Component)this.panErsatzMain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panContent.add((Component)this.panErsatz, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
    }

    private void btnChangeSchadenActionPerformed(ActionEvent evt) {
        Object selectedItem = this.comboBoxFilterDialogSchaden.showAndGetSelected();
        if (selectedItem instanceof CidsBean) {
            CidsBean schadenBean = (CidsBean)selectedItem;
            this.setSchadenTable(schadenBean);
            this.xtSchaden.getTableHeader().setForeground(Color.BLACK);
            try {
                this.getCidsBean().setProperty(FIELD__FK_SCHADEN, (Object)schadenBean);
            }
            catch (Exception ex) {
                LOG.warn((Object)"problem in setbeanproperty: fk_schaden.", (Throwable)ex);
            }
        }
    }

    public boolean isOkForSaving() {
        if (BaumErsatzEditor.getErrorNoSave() != null) {
            this.noSave();
            return false;
        }
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        boolean noErrorOccured = this.baumErsatzPanel.isOkForSaving(this.getCidsBean());
        try {
            if (this.getCidsBean().getProperty(FIELD__SCHADEN_ID) == null) {
                LOG.warn((Object)"No schaden specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumErsatzEditor.class, (String)BUNDLE_NOSCHADEN));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Schaden not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumErsatzEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BaumErsatzEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumErsatzEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save && noErrorOccured;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        block6: {
            try {
                this.cidsBean = cb;
                this.baumErsatzPanel.setCidsBean(this.getCidsBean());
                if (this.getCidsBean().getMetaObject().getStatus() == 1) {
                    this.getCidsBean().setProperty(FIELD__DISPENS, (Object)false);
                    this.getCidsBean().setProperty(FIELD__AB, (Object)false);
                    this.getCidsBean().setProperty(FIELD__SELBST, (Object)false);
                }
                if (this.getCidsBean() != null) {
                    if (this.getCidsBean().getProperty(FIELD__FK_SCHADEN) == null) {
                        this.xtSchaden.getTableHeader().setForeground(Color.red);
                    } else {
                        this.xtSchaden.getTableHeader().setForeground(Color.BLACK);
                        this.setSchadenTable((CidsBean)this.getCidsBean().getProperty(FIELD__FK_SCHADEN));
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Bean not set.", (Throwable)ex);
                if (!this.isEditor()) break block6;
                BaumErsatzEditor.setErrorNoSave(ex);
                this.noSave();
            }
        }
    }

    public void noSave() {
        ErrorInfo info = new ErrorInfo(NbBundle.getMessage(BaumErsatzEditor.class, (String)BUNDLE_NOSAVE_TITLE), NbBundle.getMessage(BaumErsatzEditor.class, (String)BUNDLE_NOSAVE_MESSAGE), null, null, (Throwable)BaumErsatzEditor.getErrorNoSave(), Level.SEVERE, null);
        JXErrorPane.showDialog((Component)((Object)this), (ErrorInfo)info);
    }

    private void setSchadenTable(CidsBean schadenBean) {
        ArrayList<CidsBean> schadenBeans = new ArrayList<CidsBean>();
        schadenBeans.add(schadenBean);
        ((ErsatzSchadenTableModel)this.xtSchaden.getModel()).setCidsBeans(schadenBeans);
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly((JComponent)this.xtSchaden);
            this.btnChangeSchaden.setVisible(this.editor);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE__NAME, (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_ERSATZ;
        }
        SimpleDateFormat formatTag = new SimpleDateFormat("dd.MM.yy");
        return String.format("G: %s - M: %s - S: %s, %s - E:%s", this.getCidsBean().getProperty(FIELD__GEBIET_AZ), formatTag.format(this.getCidsBean().getProperty(FIELD__MELDUNG_DATUM)), this.getCidsBean().getProperty(FIELD__SCHADEN_ID), this.getCidsBean().getProperty(FIELD__SCHADEN_ART), this.getCidsBean().getProperty(FIELD__ID));
    }

    private void clearBaumChildrenLoader() {
        this.getBaumChildrenLoader().clearAllMaps();
        this.getBaumChildrenLoader().setLoadingCompletedWithoutError(false);
    }

    public void dispose() {
        this.baumErsatzPanel.dispose();
        this.xtSchaden.removeAll();
        ((ErsatzSchadenTableModel)this.xtSchaden.getModel()).clear();
        this.clearBaumChildrenLoader();
        this.comboBoxFilterDialogSchaden.dispose();
    }

    public void setTitle(String string) {
    }

    @Override
    public boolean isEditor() {
        return this.editor;
    }

    public static Exception getErrorNoSave() {
        return errorNoSave;
    }

    public static void setErrorNoSave(Exception errorNoSave) {
        BaumErsatzEditor.errorNoSave = errorNoSave;
    }

    public BaumChildrenLoader getBaumChildrenLoader() {
        return this.baumChildrenLoader;
    }

    class RegexPatternFormatter
    extends DefaultFormatter {
        protected Matcher fillingMatcher;
        protected Matcher matchingMatcher;
        private Object lastValid = null;

        RegexPatternFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.lastValid = null;
                return null;
            }
            this.fillingMatcher.reset(string);
            if (!this.fillingMatcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String value = (String)super.stringToValue(string);
            this.matchingMatcher.reset(string);
            if (this.matchingMatcher.matches()) {
                this.lastValid = value;
            }
            return value;
        }

        public Object getLastValid() {
            return this.lastValid;
        }
    }

    class MustSetTableModel
    extends CidsBeansTableModel {
        public MustSetTableModel() {
            super(SCHADEN_PROP_NAMES, MUSTSET_COL_NAMES, SCHADEN_PROP_TYPES);
        }
    }

    class LoadingTableModel
    extends CidsBeansTableModel {
        public LoadingTableModel() {
            super(SCHADEN_PROP_NAMES, LOADING_COL_NAMES, SCHADEN_PROP_TYPES);
        }
    }

    class ErsatzSchadenTableModel
    extends CidsBeansTableModel {
        public ErsatzSchadenTableModel() {
            super(SCHADEN_PROP_NAMES, SCHADEN_COL_NAMES, SCHADEN_PROP_TYPES);
        }
    }
}

