/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.server.RedundantObjectSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.BeforeSavingHook;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class BaumHauptartEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
BeforeSavingHook,
SaveVetoable,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(BaumHauptartEditor.class);
    public static final String REDUNDANT_TOSTRING_TEMPLATE = "%s";
    public static final String[] REDUNDANT_TOSTRING_FIELDS = new String[]{"name", "id"};
    public static final String REDUNDANT_TABLE = "baum_hauptart";
    public static final String FIELD__SCHLUESSEL = "schluessel";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__NAME_BOTANISCH = "name_botanisch";
    public static final String FIELD__ID = "id";
    public static final String TABLE_NAME = "baum_hauptart";
    public static final String BUNDLE_NONAME = "BaumHauptartEditor.isOkForSaving().noName";
    public static final String BUNDLE_DUPLICATENAME = "BaumHauptartEditor.isOkForSaving().duplicateName";
    public static final String BUNDLE_DUPLICATEKEY = "BaumHauptartEditor.isOkForSaving().duplicateSchluessel";
    public static final String BUNDLE_PANE_PREFIX = "BaumHauptartEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BaumHauptartEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BaumHauptartEditor.isOkForSaving().JOptionPane.title";
    private static String TITLE_NEW_HAUPTART = "eine neue Hauptart anlegen...";
    private Boolean redundantName = false;
    private Boolean redundantKey = false;
    private final boolean editor;
    private JLabel lblName;
    private JLabel lblNameBotanisch;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panName;
    private JTextField txtName;
    private JTextField txtNameBotanisch;
    private BindingGroup bindingGroup;

    public BaumHauptartEditor() {
        this(true);
    }

    public BaumHauptartEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void beforeSaving() {
        ArrayList<String> conditions = new ArrayList<String>();
        RedundantObjectSearch hauptartSearch = new RedundantObjectSearch(REDUNDANT_TOSTRING_TEMPLATE, REDUNDANT_TOSTRING_FIELDS, null, "baum_hauptart");
        conditions.add("name ilike '" + this.txtName.getText().trim() + "'");
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        hauptartSearch.setWhere(conditions);
        try {
            this.redundantName = !SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)hauptartSearch, this.getConnectionContext()).isEmpty();
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"problem in check name: load values.", (Throwable)ex);
        }
        conditions.clear();
        conditions.add("schluessel ilike '" + this.txtName.getText().trim() + "'");
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        hauptartSearch.setWhere(conditions);
        try {
            this.redundantKey = !SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)hauptartSearch, this.getConnectionContext()).isEmpty();
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"problem in check key: load values.", (Throwable)ex);
        }
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            try {
                this.getCidsBean().setProperty(FIELD__SCHLUESSEL, (Object)this.txtName.getText().trim());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Key not set");
            }
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumHauptartEditor.class, (String)BUNDLE_NONAME));
                save = false;
            } else if (this.redundantName.booleanValue()) {
                LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumHauptartEditor.class, (String)BUNDLE_DUPLICATENAME));
                save = false;
            } else if (this.redundantKey.booleanValue()) {
                LOG.warn((Object)"Duplicate key specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumHauptartEditor.class, (String)BUNDLE_DUPLICATEKEY));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumHauptartEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BaumHauptartEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumHauptartEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panName = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblNameBotanisch = new JLabel();
        this.txtNameBotanisch = new JTextField();
        this.panFillerUnten1 = new JPanel();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtName, gridBagConstraints);
        this.lblNameBotanisch.setFont(new Font("Tahoma", 1, 11));
        this.lblNameBotanisch.setText("Name botanisch:");
        this.lblNameBotanisch.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblNameBotanisch, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.name_botanisch}"), (Object)this.txtNameBotanisch, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtNameBotanisch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            this.bindingGroup.bind();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error setCidsBean", (Throwable)ex);
        }
    }

    private boolean isEditor() {
        return this.editor;
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtNameBotanisch);
        }
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_HAUPTART;
        }
        return this.getCidsBean().toString();
    }

    public void setTitle(String string) {
    }
}

