/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.server.RedundantObjectSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.BeforeSavingHook;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class BaumMassnahmeEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
BeforeSavingHook,
SaveVetoable,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(BaumMassnahmeEditor.class);
    public static final String REDUNDANT_TOSTRING_TEMPLATE = "%s";
    public static final String[] REDUNDANT_TOSTRING_FIELDS = new String[]{"name", "id"};
    public static final String REDUNDANT_TABLE = "baum_massnahme";
    public static final String TABLE_NAME = "baum_massnahme";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__ID = "id";
    public static final String FIELD__KSCHNITT = "schnitt_krone";
    private static String TITLE_NEW_MASSNAHME = "eine neue Massnahme anlegen...";
    public static final String BUNDLE_NONAME = "BaumMassnahmeEditor.isOkForSaving().noName";
    public static final String BUNDLE_DUPLICATENAME = "BaumMassnahmeEditor.isOkForSaving().duplicateName";
    public static final String BUNDLE_NONUMBER = "BaumMassnahmeEditor.isOkForSaving().noNumber";
    public static final String BUNDLE_PANE_PREFIX = "BaumMassnahmeEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BaumMassnahmeEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BaumMassnahmeEditor.isOkForSaving().JOptionPane.title";
    private Boolean redundantName = false;
    private final boolean editor;
    JCheckBox chSchnittKrone;
    private Box.Filler filler3;
    private JLabel lblName;
    private JLabel lblNummer;
    private JLabel lblSchnittKrone;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panFillerUnten2;
    private JTextField txtName;
    private JTextField txtNummer;
    private BindingGroup bindingGroup;

    public BaumMassnahmeEditor() {
        this(true);
    }

    public BaumMassnahmeEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten1 = new JPanel();
        this.panContent = new RoundedPanel();
        this.panDaten = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblNummer = new JLabel();
        this.txtNummer = new JTextField();
        this.lblSchnittKrone = new JLabel();
        this.chSchnittKrone = new JCheckBox();
        this.panFillerUnten2 = new JPanel();
        this.panFillerUnten = new JPanel();
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler3, gridBagConstraints);
        this.lblNummer.setFont(new Font("Tahoma", 1, 11));
        this.lblNummer.setText("Nummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblNummer, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.nummer}"), (Object)this.txtNummer, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtNummer, gridBagConstraints);
        this.lblSchnittKrone.setFont(new Font("Tahoma", 1, 11));
        this.lblSchnittKrone.setText("Kronenschnitt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblSchnittKrone, gridBagConstraints);
        this.chSchnittKrone.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.schnitt_krone}"), (Object)this.chSchnittKrone, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.chSchnittKrone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panContent.add((Component)this.panDaten, gridBagConstraints);
        this.panFillerUnten2.setName("");
        this.panFillerUnten2.setOpaque(false);
        GroupLayout panFillerUnten2Layout = new GroupLayout(this.panFillerUnten2);
        this.panFillerUnten2.setLayout(panFillerUnten2Layout);
        panFillerUnten2Layout.setHorizontalGroup(panFillerUnten2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten2Layout.setVerticalGroup(panFillerUnten2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.panFillerUnten2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            this.bindingGroup.bind();
            if (this.getCidsBean() != null && this.getCidsBean().getPrimaryKeyValue() == -1) {
                this.getCidsBean().setProperty(FIELD__KSCHNITT, (Object)false);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Bean not set.", (Throwable)ex);
        }
    }

    private boolean isEditor() {
        return this.editor;
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtNummer);
            RendererTools.makeReadOnly(this.chSchnittKrone);
        }
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_MASSNAHME;
        }
        return this.getCidsBean().toString();
    }

    public void setTitle(String string) {
    }

    public void beforeSaving() {
        RedundantObjectSearch massSearch = new RedundantObjectSearch(REDUNDANT_TOSTRING_TEMPLATE, REDUNDANT_TOSTRING_FIELDS, null, "baum_massnahme");
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("name ilike '" + this.txtName.getText().trim() + "'");
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        massSearch.setWhere(conditions);
        try {
            this.redundantName = !SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)massSearch, this.getConnectionContext()).isEmpty();
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"problem in check name: load values.", (Throwable)ex);
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumMassnahmeEditor.class, (String)BUNDLE_NONAME));
                save = false;
            } else if (this.redundantName.booleanValue()) {
                LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumMassnahmeEditor.class, (String)BUNDLE_DUPLICATENAME));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.txtNummer.getText().trim().isEmpty()) {
                LOG.warn((Object)"No nummer specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BaumMassnahmeEditor.class, (String)BUNDLE_NONUMBER));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Number not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BaumMassnahmeEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BaumMassnahmeEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BaumMassnahmeEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }
}

