/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.BparkConfProperties;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.custom.wunda_blau.search.server.BparkFotosLightweightSearch;
import de.cismet.cids.custom.wunda_blau.search.server.RedundantObjectSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.BeforeSavingHook;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BparkZoneEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
RequestsFullSizeComponent,
BeforeSavingHook,
PropertyChangeListener,
RasterfariDocumentLoaderPanel.Listener {
    private static String FOTOS;
    private static String THEMA;
    private static String RASTERFARI;
    private static String MAPURL;
    private static Double BUFFER;
    public static final String GEOMTYPE = "Polygon";
    private static final String FOTOS_TOSTRING_TEMPLATE = "%s";
    private static final String[] FOTOS_TOSTRING_FIELDS;
    private static final Logger LOG;
    public static final String REDUNDANT_TOSTRING_TEMPLATE = "%s";
    public static final String[] REDUNDANT_TOSTRING_FIELDS;
    public static final String REDUNDANT_TABLE = "bpark_zone";
    public static final String FIELD__ID = "id";
    public static final String FIELD__ZONE = "zone";
    public static final String FIELD__NUMMER = "nummer";
    public static final String FIELD__FOTONAME = "name";
    public static final String FIELD__PUBLISH = "veroeffentlicht";
    public static final String FIELD__GEOM = "fk_geom";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_NAME = "bpark_zone";
    public static final String TABLE_GEOM = "geom";
    public static final String TABLE_FOTOS = "bpark_fotos";
    public static final String BUNDLE_NOZONE = "BparkZoneEditor.isOkForSaving().noZone";
    public static final String BUNDLE_ZONEFALSE = "BparkZoneEditor.isOkForSaving().ZoneFalse";
    public static final String BUNDLE_DUPLICATEZONE = "BparkZoneEditor.isOkForSaving().duplicateZone";
    public static final String BUNDLE_NUMMERFALSE = "BparkZoneEditor.isOkForSaving().NummerFalse";
    public static final String BUNDLE_NOGEOM = "BparkZoneEditor.isOkForSaving().noGeom";
    public static final String BUNDLE_PANE_PREFIX = "BparkZoneEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BparkZoneEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BparkZoneEditor.isOkForSaving().JOptionPane.title";
    private static final String TITLE_NEW_ZONE = "eine neue Bewohnerparkzone anlegen...";
    public static String nummerPattern;
    public static String zonePattern;
    private final BparkFotosLightweightSearch searchFotos;
    private Boolean redundantZoneNummer = false;
    private final boolean editor;
    private JComboBox cbGeom;
    private JCheckBox chkVeroeffentlicht;
    private Box.Filler filler3;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelAllgemein;
    private JPanel jPanelFotoAuswahl;
    private JPanel jPanelFotos;
    JTabbedPane jTabbedPane;
    private JXBusyLabel jxLBusy;
    private JLabel lblBemerkung;
    private JLabel lblGeom;
    private JLabel lblHeaderDocument;
    private JLabel lblHeaderListe;
    private JLabel lblHeaderPages;
    private JLabel lblHinweis;
    private JLabel lblKarte;
    private JLabel lblKeineFotos;
    private JLabel lblNummer;
    private JLabel lblVeroeffentlicht;
    private JLabel lblZone;
    private JList lstFotos;
    private JList lstPages;
    private JPanel panBemerkung;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFiller;
    private JPanel panGebiet;
    private JPanel panHinweis;
    private JPanel panLage;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel pnlBild;
    private JPanel pnlCard1;
    private RoundedPanel pnlDocument;
    private SemiRoundedPanel pnlHeaderDocument;
    private SemiRoundedPanel pnlHeaderListe;
    private SemiRoundedPanel pnlHeaderPages;
    private RoundedPanel pnlListe;
    private RoundedPanel pnlPages;
    private RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private RoundedPanel rpKarte;
    private JScrollPane scpBemerkung;
    private JScrollPane scpFotos;
    private JScrollPane scpHinweis;
    private JScrollPane scpPages;
    private SemiRoundedPanel semiRoundedPanel7;
    private JTextArea taBemerkung;
    private JTextArea taHinweis;
    private JTextField txtNummer;
    private JTextField txtZone;
    private BindingGroup bindingGroup;

    public BparkZoneEditor() {
        this(true);
    }

    public BparkZoneEditor(boolean boolEditor) {
        this.editor = boolEditor;
        this.searchFotos = new BparkFotosLightweightSearch("%s", FOTOS_TOSTRING_FIELDS);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initProperties();
        this.initComponents();
        zonePattern = BparkConfProperties.getInstance().getZonePattern();
        nummerPattern = BparkConfProperties.getInstance().getNummerPattern();
        this.lstFotos.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CidsBean bean;
                Object newValue = value;
                if (value instanceof CidsBean && (newValue = (bean = (CidsBean)value).getProperty(BparkZoneEditor.FIELD__FOTONAME)) == null) {
                    newValue = "unbenannt";
                }
                Component compoName = super.getListCellRendererComponent((JList<?>)list, newValue, index, isSelected, cellHasFocus);
                compoName.setForeground(Color.black);
                return compoName;
            }
        });
        if (this.lstFotos != null) {
            this.lstFotos.setSelectedIndex(0);
        }
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panContent = new RoundedPanel();
        this.panGebiet = new JPanel();
        this.pnlCard1 = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.jPanelAllgemein = new JPanel();
        this.panDaten = new JPanel();
        this.lblZone = new JLabel();
        this.txtZone = new JTextField();
        this.lblNummer = new JLabel();
        this.txtNummer = new JTextField();
        this.lblGeom = new JLabel();
        if (this.isEditor()) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setAllowedGeometryTypes(new Class[]{Polygon.class, MultiPolygon.class});
        }
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblHinweis = new JLabel();
        this.panHinweis = new JPanel();
        this.scpHinweis = new JScrollPane();
        this.taHinweis = new JTextArea();
        this.lblBemerkung = new JLabel();
        this.panBemerkung = new JPanel();
        this.scpBemerkung = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.panFiller = new JPanel();
        this.lblVeroeffentlicht = new JLabel();
        this.chkVeroeffentlicht = new JCheckBox();
        this.panLage = new JPanel();
        this.rpKarte = new RoundedPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.lblKarte = new JLabel();
        this.jPanelFotos = new JPanel();
        this.jPanelFotoAuswahl = new JPanel();
        this.pnlDocument = new RoundedPanel();
        this.pnlHeaderDocument = new SemiRoundedPanel();
        this.lblHeaderDocument = new JLabel();
        this.pnlBild = new JPanel();
        this.jPanel1 = new JPanel();
        this.rasterfariDocumentLoaderPanel1 = new RasterfariDocumentLoaderPanel(RASTERFARI, (RasterfariDocumentLoaderPanel.Listener)this, this.getConnectionContext());
        this.jPanel2 = new JPanel();
        this.jxLBusy = new JXBusyLabel(new Dimension(64, 64));
        this.jPanel3 = new JPanel();
        this.lblKeineFotos = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.pnlPages = new RoundedPanel();
        this.pnlHeaderPages = new SemiRoundedPanel();
        this.lblHeaderPages = new JLabel();
        this.scpPages = new JScrollPane();
        this.lstPages = this.rasterfariDocumentLoaderPanel1.getLstPages();
        this.pnlListe = new RoundedPanel();
        this.pnlHeaderListe = new SemiRoundedPanel();
        this.lblHeaderListe = new JLabel();
        this.scpFotos = new JScrollPane();
        this.lstFotos = new JList();
        this.setLayout(new GridBagLayout());
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panGebiet.setOpaque(false);
        this.panGebiet.setLayout(new GridBagLayout());
        this.pnlCard1.setOpaque(false);
        this.pnlCard1.setLayout(new GridBagLayout());
        this.jPanelAllgemein.setOpaque(false);
        this.jPanelAllgemein.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblZone.setFont(new Font("Tahoma", 1, 11));
        this.lblZone.setText("Zone:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblZone, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.zone}"), (Object)this.txtZone, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtZone, gridBagConstraints);
        this.lblNummer.setFont(new Font("Tahoma", 1, 11));
        this.lblNummer.setText("Nummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblNummer, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.nummer}"), (Object)this.txtNummer, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtNummer, gridBagConstraints);
        this.lblGeom.setFont(new Font("Tahoma", 1, 11));
        this.lblGeom.setText("Geometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblGeom, gridBagConstraints);
        if (this.isEditor()) {
            if (this.editor) {
                this.cbGeom.setFont(new Font("Dialog", 0, 12));
            }
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panDaten.add((Component)this.cbGeom, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler3, gridBagConstraints);
        this.lblHinweis.setFont(new Font("Tahoma", 1, 11));
        this.lblHinweis.setText("Hinweis:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHinweis, gridBagConstraints);
        this.panHinweis.setOpaque(false);
        this.panHinweis.setLayout(new GridBagLayout());
        this.taHinweis.setColumns(20);
        this.taHinweis.setLineWrap(true);
        this.taHinweis.setRows(2);
        this.taHinweis.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hinweis}"), (Object)this.taHinweis, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpHinweis.setViewportView(this.taHinweis);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHinweis.add((Component)this.scpHinweis, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panHinweis, gridBagConstraints);
        this.lblBemerkung.setFont(new Font("Tahoma", 1, 11));
        this.lblBemerkung.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblBemerkung, gridBagConstraints);
        this.panBemerkung.setOpaque(false);
        this.panBemerkung.setLayout(new GridBagLayout());
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setLineWrap(true);
        this.taBemerkung.setRows(2);
        this.taBemerkung.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBemerkung.setViewportView(this.taBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBemerkung.add((Component)this.scpBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panBemerkung, gridBagConstraints);
        this.panFiller.setMinimumSize(new Dimension(20, 0));
        this.panFiller.setOpaque(false);
        GroupLayout panFillerLayout = new GroupLayout(this.panFiller);
        this.panFiller.setLayout(panFillerLayout);
        panFillerLayout.setHorizontalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        panFillerLayout.setVerticalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panDaten.add((Component)this.panFiller, gridBagConstraints);
        this.lblVeroeffentlicht.setFont(new Font("Tahoma", 1, 11));
        this.lblVeroeffentlicht.setText("Ver\u00f6ffentlicht:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblVeroeffentlicht, gridBagConstraints);
        this.chkVeroeffentlicht.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.veroeffentlicht}"), (Object)this.chkVeroeffentlicht, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.panDaten.add((Component)this.chkVeroeffentlicht, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.jPanelAllgemein.add((Component)this.panDaten, gridBagConstraints);
        this.panLage.setMinimumSize(new Dimension(300, 142));
        this.panLage.setOpaque(false);
        this.panLage.setLayout(new GridBagLayout());
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.lblKarte.setForeground(new Color(255, 255, 255));
        this.lblKarte.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.lblKarte, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLage.add((Component)this.rpKarte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanelAllgemein.add((Component)this.panLage, gridBagConstraints);
        this.jTabbedPane.addTab("Allgemeine Informationen", this.jPanelAllgemein);
        this.jPanelFotos.setOpaque(false);
        this.jPanelFotos.setLayout(new GridBagLayout());
        this.jPanelFotoAuswahl.setOpaque(false);
        this.jPanelFotoAuswahl.setLayout(new GridBagLayout());
        this.pnlDocument.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderDocument.setBackground(Color.darkGray);
        this.pnlHeaderDocument.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderDocument.setForeground(Color.white);
        this.lblHeaderDocument.setText("Foto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlHeaderDocument.add((Component)this.lblHeaderDocument, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        this.pnlDocument.add((Component)this.pnlHeaderDocument, (Object)gridBagConstraints);
        this.pnlBild.setOpaque(false);
        this.pnlBild.setLayout(new CardLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.rasterfariDocumentLoaderPanel1, "Center");
        this.pnlBild.add((Component)this.jPanel1, "DOCUMENT");
        this.jPanel2.setLayout(new BorderLayout());
        this.jxLBusy.setHorizontalAlignment(0);
        this.jxLBusy.setPreferredSize(new Dimension(64, 64));
        this.jPanel2.add((Component)this.jxLBusy, "Center");
        this.pnlBild.add((Component)this.jPanel2, "BUSY");
        this.jPanel3.setLayout(new BorderLayout());
        this.lblKeineFotos.setHorizontalAlignment(0);
        this.lblKeineFotos.setText("F\u00fcr dieses Gebiet sind beim n\u00e4chtlichen Abgleich keine Fotos vorhanden gewesen.");
        this.jPanel3.add((Component)this.lblKeineFotos, "Center");
        this.pnlBild.add((Component)this.jPanel3, "NO_DOCUMENT");
        this.jPanel4.setLayout(new BorderLayout());
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Das Foto f\u00fcr dieses Gebiet kann nicht geladen werden.");
        this.jPanel4.add((Component)this.jLabel2, "Center");
        this.pnlBild.add((Component)this.jPanel4, "ERROR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.pnlDocument.add((Component)this.pnlBild, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        this.jPanelFotoAuswahl.add((Component)this.pnlDocument, gridBagConstraints);
        this.pnlHeaderPages.setBackground(new Color(51, 51, 51));
        this.pnlHeaderPages.setLayout((LayoutManager)new FlowLayout());
        this.lblHeaderPages.setForeground(new Color(255, 255, 255));
        this.lblHeaderPages.setText(NbBundle.getMessage(BparkZoneEditor.class, (String)"VermessungRissEditor.lblHeaderPages.text"));
        this.pnlHeaderPages.add((Component)this.lblHeaderPages);
        this.pnlPages.add((Component)this.pnlHeaderPages, (Object)"North");
        this.scpPages.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scpPages.setMinimumSize(new Dimension(31, 75));
        this.scpPages.setOpaque(false);
        this.scpPages.setPreferredSize(new Dimension(85, 75));
        this.lstPages.setSelectionMode(0);
        this.lstPages.setFixedCellWidth(75);
        this.scpPages.setViewportView(this.lstPages);
        this.pnlPages.add((Component)this.scpPages, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.jPanelFotoAuswahl.add((Component)this.pnlPages, gridBagConstraints);
        this.pnlListe.setMinimumSize(new Dimension(200, 49));
        this.pnlHeaderListe.setBackground(new Color(51, 51, 51));
        this.pnlHeaderListe.setLayout((LayoutManager)new FlowLayout());
        this.lblHeaderListe.setForeground(new Color(255, 255, 255));
        this.lblHeaderListe.setText("Fotoliste");
        this.pnlHeaderListe.add((Component)this.lblHeaderListe);
        this.pnlListe.add((Component)this.pnlHeaderListe, (Object)"North");
        this.scpFotos.setPreferredSize(new Dimension(80, 130));
        this.lstFotos.setModel(new DefaultListModel());
        this.lstFotos.setSelectionMode(0);
        this.lstFotos.setFixedCellWidth(75);
        this.lstFotos.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BparkZoneEditor.this.lstFotosValueChanged(evt);
            }
        });
        this.scpFotos.setViewportView(this.lstFotos);
        this.pnlListe.add((Component)this.scpFotos, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        this.jPanelFotoAuswahl.add((Component)this.pnlListe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanelFotos.add((Component)this.jPanelFotoAuswahl, gridBagConstraints);
        this.jTabbedPane.addTab("Fotos", this.jPanelFotos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlCard1.add((Component)this.jTabbedPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panGebiet.add((Component)this.pnlCard1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panContent.add((Component)this.panGebiet, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void lstFotosValueChanged(ListSelectionEvent evt) {
        this.showFoto();
    }

    public boolean isEditor() {
        return this.editor;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void showDocumentCard(DocumentCard card) {
        ((CardLayout)this.pnlBild.getLayout()).show(this.pnlBild, card.toString());
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("remove propchange bpark_zone: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("add propchange bpark_zone: " + this.getCidsBean()));
                this.getCidsBean().addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.setMapWindow();
            this.bindingGroup.bind();
            this.setTitle(this.getTitle());
        }
        catch (Exception ex) {
            LOG.error((Object)"Bean not set", (Throwable)ex);
        }
        this.loadFotoList();
        this.showFoto();
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            try {
                this.getCidsBean().setProperty(FIELD__PUBLISH, (Object)false);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot set default values", (Throwable)e);
            }
        }
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            this.lblGeom.setVisible(this.isEditor());
            RendererTools.makeReadOnly(this.txtNummer);
            RendererTools.makeReadOnly(this.txtZone);
            RendererTools.makeReadOnly(this.taHinweis);
            RendererTools.makeReadOnly(this.taBemerkung);
            RendererTools.makeReadOnly(this.chkVeroeffentlicht);
        }
    }

    private void loadFotoList() {
        try {
            this.searchFotos.setGebietId(this.getCidsBean().getPrimaryKeyValue());
            this.searchFotos.setTableName(TABLE_FOTOS);
            this.searchFotos.setRepresentationFields(FOTOS_TOSTRING_FIELDS);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)this.searchFotos, this.getConnectionContext());
            ArrayList<CidsBean> beansFotos = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansFotos.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", this.getConnectionContext()).getBean());
                }
                for (CidsBean fotoBean : beansFotos) {
                    ((DefaultListModel)this.lstFotos.getModel()).addElement(fotoBean);
                }
                this.lstFotos.setSelectedIndex(0);
                this.lstFotos.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        JList l = (JList)e.getSource();
                        ListModel m = l.getModel();
                        int index = l.locationToIndex(e.getPoint());
                        if (index > -1) {
                            l.setToolTipText(m.getElementAt(index).toString());
                        }
                    }
                });
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading fotos", (Throwable)ex);
        }
    }

    public void setMapWindow() {
        CidsBean cb = this.getCidsBean();
        try {
            if (cb.getProperty(FIELD__GEOM) != null) {
                this.panPreviewMap.initMap(cb, FIELD__GEOREFERENZ__GEO_FIELD, BUFFER, MAPURL);
            } else {
                int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
                BoundingBox initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
                Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();
                MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_GEOM, (ConnectionContext)this.getConnectionContext());
                CidsBean newGeom = geomMetaClass.getEmptyInstance(this.getConnectionContext()).getBean();
                newGeom.setProperty(FIELD__GEO_FIELD, (Object)centerPoint);
                this.panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, BUFFER);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"Map window not set.", (Throwable)ex);
        }
    }

    private void initProperties() {
        try {
            FOTOS = BparkConfProperties.getInstance().getOrdnerFotos();
            RASTERFARI = BparkConfProperties.getInstance().getUrlRasterfari();
            THEMA = BparkConfProperties.getInstance().getOrdnerThema();
            BUFFER = BparkConfProperties.getInstance().getBufferMeter();
            MAPURL = BparkConfProperties.getInstance().getUrlMap();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Get no conf properties.", (Throwable)ex);
        }
    }

    private void showFoto() {
        if (!this.lstFotos.isSelectionEmpty()) {
            try {
                String fotoName = this.lstFotos.getSelectedValue().toString();
                String id = this.cidsBean.getPrimaryKeyValue().toString();
                String fotoUrl = THEMA + "/" + FOTOS + "/" + id + "/" + fotoName;
                this.rasterfariDocumentLoaderPanel1.setDocument(fotoUrl);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Get no foto.", (Throwable)ex);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)"bpark_zone", (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_ZONE;
        }
        String id = this.getCidsBean().getPrimaryKeyValue().toString();
        String zone = this.getCidsBean().getProperty(FIELD__ZONE).toString();
        return this.getCidsBean().getProperty(FIELD__NUMMER) == null || this.getCidsBean().getProperty(FIELD__NUMMER).toString().trim().length() == 0 ? String.format("%s (%s)", zone, id) : String.format("%s - %s (%s)", zone, this.getCidsBean().getProperty(FIELD__NUMMER).toString(), id);
    }

    public void dispose() {
        this.panPreviewMap.dispose();
        if (this.isEditor()) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
            if (this.getCidsBean() != null) {
                LOG.info((Object)("remove propchange bpark_zone: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.lstFotos.removeAll();
        this.rasterfariDocumentLoaderPanel1.dispose();
        this.bindingGroup.unbind();
        super.dispose();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "<Error>";
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(FIELD__GEOM)) {
            this.setMapWindow();
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtZone.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_NOZONE));
                save = false;
            } else if (this.redundantZoneNummer.booleanValue()) {
                LOG.warn((Object)"False zone specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_DUPLICATEZONE));
                save = false;
            } else if (!this.txtZone.getText().matches(zonePattern)) {
                LOG.warn((Object)"False zone specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_ZONEFALSE));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Zone not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (!this.txtNummer.getText().trim().isEmpty() && !this.txtNummer.getText().matches(nummerPattern)) {
                LOG.warn((Object)"No aktenzeichen specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_NUMMERFALSE));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"nummmr wrong given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.getCidsBean().getProperty(FIELD__GEOM) == null) {
                LOG.warn((Object)"No geom specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_NOGEOM));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BparkZoneEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public void beforeSaving() {
        RedundantObjectSearch zoneSearch = new RedundantObjectSearch("%s", REDUNDANT_TOSTRING_FIELDS, null, "bpark_zone");
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("zone ilike '" + this.txtZone.getText().trim() + "'");
        if (this.txtNummer.getText().trim().isEmpty()) {
            conditions.add("((nummer ilike '" + this.txtNummer.getText().trim() + "') OR(" + FIELD__NUMMER + " is null))");
        } else {
            conditions.add("nummer ilike '" + this.txtNummer.getText().trim() + "'");
        }
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        zoneSearch.setWhere(conditions);
        try {
            this.redundantZoneNummer = !SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)zoneSearch, this.getConnectionContext()).isEmpty();
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"problem in beforeSaving.", (Throwable)ex);
        }
    }

    public void showMeasureIsLoading() {
        this.showDocumentCard(DocumentCard.BUSY);
    }

    public void showMeasurePanel() {
        this.showDocumentCard(DocumentCard.DOCUMENT);
    }

    static {
        FOTOS_TOSTRING_FIELDS = new String[]{FIELD__FOTONAME};
        LOG = Logger.getLogger(BparkZoneEditor.class);
        REDUNDANT_TOSTRING_FIELDS = new String[]{FIELD__ZONE, FIELD__NUMMER, FIELD__ID};
        nummerPattern = "";
        zonePattern = "";
    }

    class RegexPatternFormatter
    extends DefaultFormatter {
        protected Matcher fillingMatcher;
        protected Matcher matchingMatcher;
        private Object lastValid = null;

        RegexPatternFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.lastValid = null;
                return null;
            }
            this.fillingMatcher.reset(string);
            if (!this.fillingMatcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String value = (String)super.stringToValue(string);
            this.matchingMatcher.reset(string);
            if (this.matchingMatcher.matches()) {
                this.lastValid = value;
            }
            return value;
        }

        public Object getLastValid() {
            return this.lastValid;
        }
    }

    private static enum DocumentCard {
        BUSY,
        DOCUMENT,
        NO_DOCUMENT,
        ERROR;

    }
}

