/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.custom.objecteditors.wunda_blau.GrundwassermessstelleDiagrammAxisPanel;
import de.cismet.cids.custom.reports.wunda_blau.GrundwassermessstellenReportBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ShapeUtilities;

public class GrundwassermessstelleMesswerteDiagrammPanel
extends JPanel
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(GrundwassermessstelleMesswerteDiagrammPanel.class);
    public static final DataFlavor STOFF_BEAN_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "DiagrammStoffBean");
    private Collection<CidsBean> messungBeans;
    private final ConnectionContext connectionContext;
    private final Shape[] shapes = new Shape[]{ShapeUtilities.createDiagonalCross((float)3.0f, (float)1.0f), ShapeUtilities.createDiamond((float)5.0f), ShapeUtilities.createDownTriangle((float)5.0f), ShapeUtilities.createRegularCross((float)3.0f, (float)1.0f), ShapeUtilities.createUpTriangle((float)5.0f)};
    private final Paint[] colors = new Paint[]{new Color(247, 150, 70, 255), new Color(155, 187, 89, 255), new Color(128, 100, 162, 255), new Color(75, 172, 198, 255), new Color(192, 80, 77, 255), new Color(155, 100, 162, 255)};
    private List<CidsBean> stoffBeans;
    private GrundwassermessstelleDiagrammAxisPanel grundwassermessstelleDiagrammAxisPanel4;
    private GrundwassermessstelleDiagrammAxisPanel grundwassermessstelleDiagrammAxisPanel5;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public GrundwassermessstelleMesswerteDiagrammPanel() {
        this(ConnectionContext.createDummy());
    }

    public GrundwassermessstelleMesswerteDiagrammPanel(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
    }

    public List<GrundwassermessstellenReportBean.LegendeBean> getLegendBeans(GrundwassermessstelleDiagrammAxisPanel axisPanel) {
        ArrayList<GrundwassermessstellenReportBean.LegendeBean> legendBeans = new ArrayList<GrundwassermessstellenReportBean.LegendeBean>();
        for (CidsBean stoffBean : axisPanel.getEnabledStoffBeans()) {
            Icon icon = this.createIcon((String)stoffBean.getProperty("schluessel"));
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g2d = image.createGraphics();
            g2d.setColor(Color.WHITE);
            g2d.drawRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            icon.paintIcon(null, g2d, 0, 0);
            GrundwassermessstellenReportBean.LegendeBean legendBean = new GrundwassermessstellenReportBean.LegendeBean(stoffBean, image);
            legendBeans.add(legendBean);
        }
        return legendBeans;
    }

    public List<GrundwassermessstellenReportBean.LegendeBean> getLegendLeftBeans() {
        return this.getLegendBeans(this.grundwassermessstelleDiagrammAxisPanel4);
    }

    public List<GrundwassermessstellenReportBean.LegendeBean> getLegendRightBeans() {
        return this.getLegendBeans(this.grundwassermessstelleDiagrammAxisPanel5);
    }

    public void setMessungBeans(Collection<CidsBean> messungBeans) {
        this.messungBeans = messungBeans;
    }

    public Collection<CidsBean> getMessungBeans() {
        return this.messungBeans;
    }

    public void refreshChart() {
        this.getChartPanel().setChart(this.createChartPanel());
    }

    public void setStoffBeans(List<CidsBean> stoffBeans) {
        this.stoffBeans = stoffBeans;
        this.grundwassermessstelleDiagrammAxisPanel4.setStoffBeans(stoffBeans);
        this.grundwassermessstelleDiagrammAxisPanel5.setStoffBeans(null);
    }

    public ChartPanel getChartPanel() {
        return (ChartPanel)this.jPanel2;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jPanel2 = new ChartPanel(null);
        this.grundwassermessstelleDiagrammAxisPanel4 = new GrundwassermessstelleDiagrammAxisPanel(this);
        this.grundwassermessstelleDiagrammAxisPanel5 = new GrundwassermessstelleDiagrammAxisPanel(this);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(null);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.grundwassermessstelleDiagrammAxisPanel4.setAxisName(null);
        this.grundwassermessstelleDiagrammAxisPanel4.setMinimumSize(new Dimension(215, 43));
        this.grundwassermessstelleDiagrammAxisPanel4.setOpaque(false);
        this.grundwassermessstelleDiagrammAxisPanel4.setPreferredSize(new Dimension(215, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.grundwassermessstelleDiagrammAxisPanel4, gridBagConstraints);
        this.grundwassermessstelleDiagrammAxisPanel5.setAxisName(null);
        this.grundwassermessstelleDiagrammAxisPanel5.setMinimumSize(new Dimension(215, 43));
        this.grundwassermessstelleDiagrammAxisPanel5.setOpaque(false);
        this.grundwassermessstelleDiagrammAxisPanel5.setPreferredSize(new Dimension(215, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.grundwassermessstelleDiagrammAxisPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private TimeSeriesCollection createDataSet(GrundwassermessstelleDiagrammAxisPanel axisPanel) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (CidsBean stoffBean : axisPanel.getEnabledStoffBeans()) {
            String einheit = (String)stoffBean.getProperty("einheit");
            String name = (String)stoffBean.getProperty("name");
            TimeSeries series = new TimeSeries((Comparable)((Object)(name + (einheit != null ? " (" + einheit + ")" : ""))));
            String schluessel = (String)stoffBean.getProperty("schluessel");
            series.setKey((Comparable)((Object)schluessel));
            for (CidsBean messungBean : this.messungBeans) {
                Date datum = (Date)messungBean.getProperty("datum");
                for (CidsBean messwertBean : messungBean.getBeanCollectionProperty("messwerte")) {
                    if (schluessel == null || !schluessel.equals((String)messwertBean.getProperty("stoff_schluessel")) || series.getDataItem((RegularTimePeriod)new Day(datum)) != null) continue;
                    series.add((RegularTimePeriod)new Day(datum), messwertBean.getProperty("wert") != null ? Double.valueOf(Math.abs((Double)messwertBean.getProperty("wert"))) : null);
                }
            }
            dataset.addSeries(series);
        }
        return dataset;
    }

    public Icon createIcon(String schluessel) {
        Shape shape = this.getShape(schluessel);
        Paint color = this.getColor(schluessel);
        ShapeIcon icon = new ShapeIcon(shape, color, 18, 18);
        return icon;
    }

    public int getIndex(String schluessel, List<CidsBean> stoffBeans) {
        if (schluessel == null) {
            return -1;
        }
        if (stoffBeans != null) {
            for (CidsBean stoffBean : stoffBeans) {
                if (!schluessel.equals(stoffBean.getProperty("schluessel"))) continue;
                return stoffBeans.indexOf(stoffBean);
            }
        }
        return -1;
    }

    private Shape getShape(String schluessel) {
        int index = this.getIndex(schluessel, this.stoffBeans);
        if (index >= 0) {
            return this.shapes[index % this.shapes.length];
        }
        return null;
    }

    public Paint getColor(String schluessel) {
        int index = this.getIndex(schluessel, this.stoffBeans);
        if (index >= 0) {
            return this.colors[index % this.colors.length];
        }
        return null;
    }

    public JFreeChart createChartPanel() {
        TimeSeriesCollection dataSetLeft = this.createDataSet(this.grundwassermessstelleDiagrammAxisPanel4);
        TimeSeriesCollection dataSetRight = !this.grundwassermessstelleDiagrammAxisPanel5.getEnabledStoffBeans().isEmpty() ? this.createDataSet(this.grundwassermessstelleDiagrammAxisPanel5) : null;
        JFreeChart chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)dataSetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        DateAxis dateAxis = new DateAxis();
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd.MM.yyy"));
        dateAxis.setVerticalTickLabels(true);
        plot.setDomainAxis((ValueAxis)dateAxis);
        plot.setDataset(0, (XYDataset)dataSetLeft);
        plot.setRenderer(0, (XYItemRenderer)new StandardXYItemRenderer(1));
        plot.setRangeAxis(0, plot.getRangeAxis());
        plot.mapDatasetToRangeAxis(0, 0);
        XYItemRenderer leftRenderer = plot.getRenderer();
        for (int index = 0; index < dataSetLeft.getSeriesCount(); ++index) {
            String schluessel = (String)((Object)dataSetLeft.getSeries(index).getKey());
            leftRenderer.setSeriesShape(index, this.getShape(schluessel));
            leftRenderer.setSeriesPaint(index, this.getColor(schluessel));
        }
        if (dataSetRight != null) {
            plot.setDataset(1, (XYDataset)dataSetRight);
            StandardXYItemRenderer rightRenderer = new StandardXYItemRenderer(1);
            plot.setRenderer(1, (XYItemRenderer)rightRenderer);
            NumberAxis numberAxis = new NumberAxis();
            plot.setRangeAxis(1, (ValueAxis)numberAxis);
            plot.mapDatasetToRangeAxis(1, 1);
            for (int index = 0; index < dataSetRight.getSeriesCount(); ++index) {
                String schluessel = (String)((Object)dataSetRight.getSeries(index).getKey());
                rightRenderer.setSeriesShape(index, this.getShape(schluessel));
                rightRenderer.setSeriesPaint(index, this.getColor(schluessel));
            }
        }
        return chart;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static class ShapeIcon
    implements Icon {
        private final Shape shape;
        private final Paint paint;
        private final int width;
        private final int height;

        public ShapeIcon(Shape shape, Paint paint, int width, int height) {
            this.shape = shape;
            this.width = width;
            this.height = height;
            this.paint = paint;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.paint != null) {
                g2.setPaint(this.paint);
            }
            if (this.shape != null) {
                g2.translate(this.width / 2, this.height / 2);
                g2.draw(this.shape);
                g2.fill(this.shape);
                g2.translate(-this.width / 2, -this.height / 2);
            }
        }
    }
}

