/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wunda_blau.KkVerfahrenEditor;
import de.cismet.cids.custom.wunda_blau.search.server.KkVerfahrenSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.server.search.CidsServerSearch;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.apache.log4j.Logger;

public class KkKompensationEditor
extends KkVerfahrenEditor
implements EditorSaveListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(KkKompensationEditor.class);
    private CidsBean kompensationBean;

    public KkKompensationEditor() {
        this(true);
    }

    public KkKompensationEditor(boolean editable) {
        super(editable);
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        block6: {
            this.kompensationBean = cidsBean;
            if (cidsBean != null) {
                try {
                    KkVerfahrenSearch search = new KkVerfahrenSearch(cidsBean.getMetaObject().getId());
                    List res = (List)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, this.getConnectionContext());
                    if (res != null && res.size() == 1) {
                        CidsBean verfahren = ((MetaObject)res.get(0)).getBean();
                        List kompensationen = verfahren.getBeanCollectionProperty("kompensationen");
                        if (this.editable) {
                            kompensationen.remove(cidsBean);
                            kompensationen.add(cidsBean);
                        }
                        this.setVerfahrenBean(verfahren);
                        this.selectKompensation(cidsBean);
                        break block6;
                    }
                    this.setVerfahrenBean(null);
                    LOG.error((Object)"Cannot retrieve verfahren object");
                }
                catch (Exception e) {
                    this.setVerfahrenBean(null);
                    LOG.error((Object)"Error while retrieving verfahren object", (Throwable)e);
                }
            } else {
                this.setVerfahrenBean(null);
            }
        }
    }

    private void setVerfahrenBean(CidsBean verfahrenBean) {
        if (this.editable && super.getCidsBean() != null) {
            LOG.info((Object)("remove propchange verfahren: " + super.getCidsBean()));
            super.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.setCidsBean(verfahrenBean);
        if (this.editable && super.getCidsBean() != null) {
            LOG.info((Object)("add propchange verfahren: " + super.getCidsBean()));
            super.getCidsBean().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void editorClosed(EditorClosedEvent event) {
        this.setCidsBean(null);
        super.editorClosed(event);
    }

    @Override
    public boolean prepareForSave() {
        try {
            CidsBean verfahrenBean;
            if (super.prepareForSave() && (verfahrenBean = super.getCidsBean()) != null) {
                super.setCidsBean(verfahrenBean.persist(this.getConnectionContext()));
                return true;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Cannot persist object", (Throwable)ex);
        }
        return false;
    }

    @Override
    public void dispose() {
        this.setCidsBean(null);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.editable) {
            LOG.info((Object)("propchange " + evt.getPropertyName() + " " + evt.getNewValue()));
            this.kompensationBean.setArtificialChangeFlag(true);
        }
    }
}

