/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.KlimarouteConfProperties;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.custom.wunda_blau.search.server.RedundantObjectSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.BeforeSavingHook;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class KlimarouteEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
BeforeSavingHook,
PropertyChangeListener,
RequestsFullSizeComponent {
    public static final String GEOMTYPE = "LineString";
    private static final Logger LOG = Logger.getLogger(KlimarouteEditor.class);
    public static final String REDUNDANT_TOSTRING_TEMPLATE = "%s";
    public static final String[] REDUNDANT_TOSTRING_FIELDS = new String[]{"name", "id"};
    public static final String REDUNDANT_TABLE = "klimaroute";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__KEY = "key";
    public static final String FIELD__ID = "id";
    public static final String FIELD__DIFICULTY = "fk_schwierigkeitsgrad";
    public static final String FIELD__WAY = "fk_wegeart";
    public static final String FIELD__DISTANCE = "distanz";
    public static final String FIELD__GEOM = "geom";
    public static final String FIELD__DAUER = "dauer";
    public static final String FIELD__PUBLISH = "to_publish";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "geom.geo_field";
    public static final String TABLE_NAME = "klimaroute";
    public static final String TABLE_GEOM = "geom";
    public static final String BUNDLE_NONAME = "KlimarouteEditor.isOkForSaving().noName";
    public static final String BUNDLE_DUPLICATENAME = "KlimarouteEditor.isOkForSaving().duplicateName";
    public static final String BUNDLE_NOKEY = "KlimarouteEditor.isOkForSaving().noKey";
    public static final String BUNDLE_DUPLICATEKEY = "KlimarouteEditor.isOkForSaving().duplicateKey";
    public static final String BUNDLE_LENGTHKEY = "KlimarouteEditor.isOkForSaving().lengthKey";
    public static final String BUNDLE_WRONGKEY = "KlimarouteEditor.isOkForSaving().wrongKey";
    public static final String BUNDLE_NODIFICULTY = "KlimarouteEditor.isOkForSaving().noDificulty";
    public static final String BUNDLE_NOWAY = "KlimarouteEditor.isOkForSaving().noWay";
    public static final String BUNDLE_WRONGGEOM = "KlimarouteEditor.isOkForSaving().wrongGeom";
    public static final String BUNDLE_PANE_PREFIX = "KlimarouteEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "KlimarouteEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "KlimarouteEditor.isOkForSaving().JOptionPane.title";
    private static final String TITLE_NEW_KLIMAROUTE = "eine neue Klimaroute anlegen...";
    private static Color colorAlarm = new Color(255, 0, 0);
    private static String keyPattern = "";
    ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            KlimarouteEditor.this.writeDauer();
        }
    };
    private final boolean editor;
    private Integer keyLength = 0;
    private Boolean keyRedundant = false;
    private Boolean nameRedundant = false;
    private JComboBox cbGeom;
    private DefaultBindableReferenceCombo cbSchwierigkeit;
    private DefaultBindableReferenceCombo cbWegeart;
    private JCheckBox chkVeroeffentlicht;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JPanel jPanelAllgemein;
    private JLabel lblBeschreibung;
    private JLabel lblDauer;
    private JLabel lblDistanz;
    private JLabel lblDistanzRO;
    private JLabel lblGeom;
    private JLabel lblKarte;
    private JLabel lblKey;
    private JLabel lblMeter;
    private JLabel lblMinute;
    private JLabel lblName;
    private JLabel lblSchwierigkeit;
    private JLabel lblStunde;
    private JLabel lblUrl;
    private JLabel lblVeroeffentlicht;
    private JLabel lblWegeart;
    private JPanel panBeschreibung;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFillerUnten;
    private JPanel panLage;
    private JPanel panLinks;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel panRechts;
    private RoundedPanel rpKarte;
    private JScrollPane scpBeschreibung;
    private SemiRoundedPanel semiRoundedPanel7;
    JSpinner spMinute;
    JSpinner spStunde;
    private JTextArea taBeschreibung;
    private JTextField txtKey;
    private JTextField txtName;
    private JTextField txtUrl;
    private BindingGroup bindingGroup;

    public KlimarouteEditor() {
        this(true);
    }

    public KlimarouteEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        if (this.isEditor()) {
            this.spMinute.addChangeListener(this.listener);
            this.spStunde.addChangeListener(this.listener);
        }
        this.setReadOnly();
        KlimarouteEditor.setKeyPattern(KlimarouteConfProperties.getInstance().getKeyPattern());
        this.setKeyLength(KlimarouteConfProperties.getInstance().getKeyLength());
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.jPanelAllgemein = new JPanel();
        this.panDaten = new JPanel();
        this.panLinks = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblDauer = new JLabel();
        this.spStunde = new JSpinner();
        this.lblStunde = new JLabel();
        this.spMinute = new JSpinner();
        this.lblMinute = new JLabel();
        this.lblDistanz = new JLabel();
        this.lblDistanzRO = new JLabel();
        this.lblMeter = new JLabel();
        this.lblSchwierigkeit = new JLabel();
        this.cbSchwierigkeit = new DefaultBindableReferenceCombo(true);
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblWegeart = new JLabel();
        this.cbWegeart = new DefaultBindableReferenceCombo(true);
        this.lblVeroeffentlicht = new JLabel();
        this.chkVeroeffentlicht = new JCheckBox();
        this.lblGeom = new JLabel();
        if (this.isEditor()) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
        }
        this.lblUrl = new JLabel();
        this.txtUrl = new JTextField();
        this.lblKey = new JLabel();
        this.txtKey = new JTextField();
        this.panRechts = new JPanel();
        this.panBeschreibung = new JPanel();
        this.scpBeschreibung = new JScrollPane();
        this.taBeschreibung = new JTextArea();
        this.lblBeschreibung = new JLabel();
        this.panLage = new JPanel();
        this.rpKarte = new RoundedPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.lblKarte = new JLabel();
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(840, 298));
        this.panContent.setLayout(new GridBagLayout());
        this.jPanelAllgemein.setOpaque(false);
        this.jPanelAllgemein.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.panLinks.setOpaque(false);
        this.panLinks.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.txtName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panLinks.add((Component)this.filler3, gridBagConstraints);
        this.lblDauer.setFont(new Font("Tahoma", 1, 11));
        this.lblDauer.setText("Dauer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblDauer, gridBagConstraints);
        this.spStunde.setFont(new Font("Dialog", 0, 12));
        this.spStunde.setModel(new SpinnerNumberModel(0, 0, 20, 1));
        this.spStunde.setPreferredSize(new Dimension(48, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.spStunde, gridBagConstraints);
        this.lblStunde.setFont(new Font("Tahoma", 1, 11));
        this.lblStunde.setText("h");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.panLinks.add((Component)this.lblStunde, gridBagConstraints);
        this.spMinute.setFont(new Font("Dialog", 0, 12));
        this.spMinute.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.spMinute.setPreferredSize(new Dimension(48, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.spMinute, gridBagConstraints);
        this.lblMinute.setFont(new Font("Tahoma", 1, 11));
        this.lblMinute.setText("min");
        this.lblMinute.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.panLinks.add((Component)this.lblMinute, gridBagConstraints);
        this.lblDistanz.setFont(new Font("Tahoma", 1, 11));
        this.lblDistanz.setText("Distanz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblDistanz, gridBagConstraints);
        this.lblDistanzRO.setFont(new Font("Dialog", 0, 12));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.distanz}"), (Object)this.lblDistanzRO, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panLinks.add((Component)this.lblDistanzRO, gridBagConstraints);
        this.lblMeter.setFont(new Font("Tahoma", 1, 11));
        this.lblMeter.setText("km");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.panLinks.add((Component)this.lblMeter, gridBagConstraints);
        this.lblSchwierigkeit.setFont(new Font("Tahoma", 1, 11));
        this.lblSchwierigkeit.setText("Schwierigkeit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblSchwierigkeit, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_schwierigkeitsgrad}"), (Object)this.cbSchwierigkeit, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.cbSchwierigkeit, gridBagConstraints);
        this.cbSchwierigkeit.setNullable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panLinks.add((Component)this.filler4, gridBagConstraints);
        this.lblWegeart.setFont(new Font("Tahoma", 1, 11));
        this.lblWegeart.setText("Wegeart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblWegeart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_wegeart}"), (Object)this.cbWegeart, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.cbWegeart, gridBagConstraints);
        this.cbSchwierigkeit.setNullable(true);
        this.lblVeroeffentlicht.setFont(new Font("Tahoma", 1, 11));
        this.lblVeroeffentlicht.setText("Ver\u00f6ffentlicht:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblVeroeffentlicht, gridBagConstraints);
        this.chkVeroeffentlicht.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.to_publish}"), (Object)this.chkVeroeffentlicht, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panLinks.add((Component)this.chkVeroeffentlicht, gridBagConstraints);
        this.lblGeom.setFont(new Font("Tahoma", 1, 11));
        this.lblGeom.setText("Geometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblGeom, gridBagConstraints);
        if (this.isEditor()) {
            if (this.editor) {
                this.cbGeom.setFont(new Font("Dialog", 0, 12));
            }
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 8;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panLinks.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.lblUrl.setFont(new Font("Tahoma", 1, 11));
        this.lblUrl.setText("URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblUrl, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.url}"), (Object)this.txtUrl, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.txtUrl, gridBagConstraints);
        this.lblKey.setFont(new Font("Tahoma", 1, 11));
        this.lblKey.setText("Key:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panLinks.add((Component)this.lblKey, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.key}"), (Object)this.txtKey, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panLinks.add((Component)this.txtKey, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panDaten.add((Component)this.panLinks, gridBagConstraints);
        this.panRechts.setOpaque(false);
        this.panRechts.setLayout(new GridBagLayout());
        this.panBeschreibung.setOpaque(false);
        this.panBeschreibung.setLayout(new GridBagLayout());
        this.taBeschreibung.setColumns(20);
        this.taBeschreibung.setLineWrap(true);
        this.taBeschreibung.setRows(2);
        this.taBeschreibung.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.beschreibung}"), (Object)this.taBeschreibung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBeschreibung.setViewportView(this.taBeschreibung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBeschreibung.add((Component)this.scpBeschreibung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panRechts.add((Component)this.panBeschreibung, gridBagConstraints);
        this.lblBeschreibung.setFont(new Font("Tahoma", 1, 11));
        this.lblBeschreibung.setText("Beschreibung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panRechts.add((Component)this.lblBeschreibung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panDaten.add((Component)this.panRechts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 0, 10);
        this.jPanelAllgemein.add((Component)this.panDaten, gridBagConstraints);
        this.panLage.setMinimumSize(new Dimension(300, 142));
        this.panLage.setOpaque(false);
        this.panLage.setLayout(new GridBagLayout());
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.lblKarte.setForeground(new Color(255, 255, 255));
        this.lblKarte.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.lblKarte, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLage.add((Component)this.rpKarte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanelAllgemein.add((Component)this.panLage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.jPanelAllgemein, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public void writeDauer() {
        String minute = this.spMinute.getValue().toString();
        if (minute.length() == 1) {
            minute = "0" + minute;
        }
        String stunde = this.spStunde.getValue().toString();
        String dauer = stunde + ":" + minute;
        try {
            this.getCidsBean().setProperty(FIELD__DAUER, (Object)dauer);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"dauer not set.", (Throwable)ex);
        }
    }

    public void readDauer() {
        if (this.getCidsBean() != null && this.getCidsBean().getProperty(FIELD__DAUER) != null) {
            String dauer = this.getCidsBean().getProperty(FIELD__DAUER).toString();
            String[] values = dauer.split(":");
            this.spMinute.setValue(Integer.parseInt(values[1]));
            this.spStunde.setValue(Integer.parseInt(values[0]));
        }
    }

    public void beforeSaving() {
        RedundantObjectSearch krSearch = new RedundantObjectSearch(REDUNDANT_TOSTRING_TEMPLATE, REDUNDANT_TOSTRING_FIELDS, null, "klimaroute");
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("name ilike '" + this.txtName.getText().trim() + "'");
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        krSearch.setWhere(conditions);
        try {
            this.setNameRedundant(!SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)krSearch, this.getConnectionContext()).isEmpty());
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"problem in check name: load values.", (Throwable)ex);
        }
        conditions.clear();
        conditions.add("key ilike '" + this.txtKey.getText().trim() + "'");
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        krSearch.setWhere(conditions);
        try {
            this.setKeyRedundant(!SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)krSearch, this.getConnectionContext()).isEmpty());
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"problem in check key: load values.", (Throwable)ex);
        }
    }

    public boolean isEditor() {
        return this.editor;
    }

    public boolean isKeyRedundant() {
        return this.keyRedundant;
    }

    public void setKeyRedundant(boolean ok) {
        this.keyRedundant = ok;
    }

    public boolean isNameRedundant() {
        return this.nameRedundant;
    }

    public void setNameRedundant(boolean ok) {
        this.nameRedundant = ok;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("remove propchange klimaroute: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("add propchange klimaroute: " + this.getCidsBean()));
                this.getCidsBean().addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.setMapWindow();
            this.bindingGroup.bind();
            this.readDauer();
            this.setTitle(this.getTitle());
            if (this.getCidsBean().getMetaObject().getStatus() == 1) {
                try {
                    this.getCidsBean().setProperty(FIELD__PUBLISH, (Object)false);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot set default values", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Bean not set", (Throwable)ex);
        }
    }

    public void setMapWindow() {
        CidsBean cb = this.getCidsBean();
        try {
            Double bufferMeter = KlimarouteConfProperties.getInstance().getBufferMeter();
            String mapUrl = KlimarouteConfProperties.getInstance().getMapUrl();
            if (cb.getProperty("geom") != null) {
                this.panPreviewMap.initMap(cb, FIELD__GEOREFERENZ__GEO_FIELD, bufferMeter, mapUrl);
            } else {
                int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
                BoundingBox initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
                Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();
                MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"geom", (ConnectionContext)this.getConnectionContext());
                CidsBean newGeom = geomMetaClass.getEmptyInstance(this.getConnectionContext()).getBean();
                newGeom.setProperty(FIELD__GEO_FIELD, (Object)centerPoint);
                this.panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, bufferMeter);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"Map window not set.", (Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeDoubleSpinnerWithoutButtons(this.spStunde, 0);
            RendererTools.makeReadOnly(this.spStunde);
            RendererTools.makeDoubleSpinnerWithoutButtons(this.spMinute, 0);
            RendererTools.makeReadOnly(this.spMinute);
            RendererTools.makeReadOnly((JComponent)this.cbSchwierigkeit);
            RendererTools.makeReadOnly(this.txtUrl);
            RendererTools.makeReadOnly(this.taBeschreibung);
            RendererTools.makeReadOnly((JComponent)this.cbWegeart);
            RendererTools.makeReadOnly(this.chkVeroeffentlicht);
            RendererTools.makeReadOnly(this.txtKey);
            this.lblGeom.setVisible(this.isEditor());
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)"klimaroute", (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_KLIMAROUTE;
        }
        return this.getCidsBean().toString();
    }

    public void dispose() {
        this.panPreviewMap.dispose();
        if (this.isEditor()) {
            if (this.cbGeom != null) {
                ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
                ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setCidsMetaObject(null);
                this.cbGeom = null;
            }
            this.spMinute.removeChangeListener(this.listener);
            this.spStunde.removeChangeListener(this.listener);
            if (this.getCidsBean() != null) {
                LOG.info((Object)("remove propchangeklimaroute: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.bindingGroup.unbind();
        super.dispose();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "<Error>";
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("geom")) {
            this.setMapWindow();
            this.setDistance();
        }
        if (evt.getPropertyName().equals(FIELD__KEY) && this.getCidsBean().getMetaObject().getStatus() != 1) {
            this.lblKey.setForeground(colorAlarm);
        }
    }

    public void setDistance() {
        double length = 0.0;
        if (this.getCidsBean() != null && this.getCidsBean().getProperty("geom") != null) {
            CidsBean geom_pos = (CidsBean)this.getCidsBean().getProperty("geom");
            length = (double)Math.round(((Geometry)geom_pos.getProperty(FIELD__GEO_FIELD)).getLength()) / 1000.0;
        }
        try {
            this.getCidsBean().setProperty(FIELD__DISTANCE, (Object)length);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"distanz not set.", (Throwable)ex);
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_NONAME));
                save = false;
            } else if (this.isNameRedundant()) {
                LOG.warn((Object)"Duplicate Name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_DUPLICATENAME));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.getCidsBean().getProperty(FIELD__DIFICULTY) == null) {
                LOG.warn((Object)"No schwierigkeitsgrad specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_NODIFICULTY));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"schwierigkeitsgrad not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.getCidsBean().getProperty(FIELD__WAY) == null) {
                LOG.warn((Object)"No wegeart specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_NOWAY));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"wegeart not given.", (Throwable)ex);
            save = false;
        }
        try {
            CidsBean geom_pos;
            if (this.getCidsBean() != null && this.getCidsBean().getProperty("geom") != null && !((Geometry)(geom_pos = (CidsBean)this.getCidsBean().getProperty("geom")).getProperty(FIELD__GEO_FIELD)).getGeometryType().equals(GEOMTYPE)) {
                LOG.warn((Object)"Wrong geom specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_WRONGGEOM));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom wrong.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.txtKey.getText().trim().isEmpty()) {
                LOG.warn((Object)"No key specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_NOKEY));
                save = false;
            } else if (!this.txtKey.getText().matches(keyPattern)) {
                LOG.warn((Object)"Wrong key specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_WRONGKEY));
                save = false;
            } else if (this.isKeyRedundant()) {
                LOG.warn((Object)"Wrong key specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_DUPLICATEKEY));
                save = false;
            } else if (this.getCidsBean().getProperty(FIELD__KEY).toString().length() > this.keyLength) {
                LOG.warn((Object)"Wrong key length specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_LENGTHKEY));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Key not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(KlimarouteEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public static String getKeyPattern() {
        return keyPattern;
    }

    public static void setKeyPattern(String keyPattern) {
        KlimarouteEditor.keyPattern = keyPattern;
    }

    public Integer getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
    }

    class MustSetModelCb
    extends DefaultComboBoxModel {
        public MustSetModelCb() {
            super(new String[]{"Die Daten bitte zuweisen......"});
        }
    }

    class LoadModelCb
    extends DefaultComboBoxModel {
        public LoadModelCb() {
            super(new String[]{"Die Daten werden geladen......"});
        }
    }
}

