/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.NivellementPunktAggregationRenderer;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.editors.converters.DoubleToStringConverter;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.security.WebAccessManager;
import de.cismet.security.exceptions.AccessMethodIsNotSupportedException;
import de.cismet.security.exceptions.MissingArgumentException;
import de.cismet.security.exceptions.NoHandlerForURLException;
import de.cismet.security.exceptions.RequestFailedException;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class NivellementPunktEditor
extends JPanel
implements DisposableCidsBeanStore,
TitleComponentProvider,
FooterComponentProvider,
BorderProvider,
RequestsFullSizeComponent,
EditorSaveListener,
ConnectionContextStore,
RasterfariDocumentLoaderPanel.Listener {
    private static final Logger LOG = Logger.getLogger(NivellementPunktEditor.class);
    private static final String[] SUFFIXES = new String[]{"tif", "jpg", "tiff", "jpeg"};
    private static final Converter<Double, String> CONVERTER_HOEHE = new DoubleToStringConverter();
    private CidsBean cidsBean;
    private boolean readOnly;
    private String oldDgkBlattnummer;
    private String oldLaufendeNummer;
    private String urlOfDocument;
    private RefreshDocumentWorker currentRefreshDocumentWorker;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup bgrControls;
    private JButton btnHome;
    private JButton btnOpen;
    private JButton btnReport;
    private JCheckBox chkHistorisch;
    private JComboBox cmbFestlegungsart;
    private JComboBox cmbGeometrie;
    private JComboBox cmbLagegenauigkeit;
    private Box.Filler gluFillDescription;
    private Box.Filler gluFiller;
    private Box.Filler gluFillerControls;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel lblBemerkung;
    private JLabel lblFestlegungsart;
    private JLabel lblGeometrie;
    private JLabel lblHeaderDocument;
    private JLabel lblHistorisch;
    private JLabel lblHoeheUeberNHN;
    private JLabel lblHoeheUeberNHN2016;
    private JLabel lblHoeheUeberNN;
    private JLabel lblLagebezeichnung;
    private JLabel lblLagegenauigkeit;
    private JLabel lblMessungsjahr;
    private JLabel lblMissingRasterdocument;
    private JLabel lblPunktnummerNRW;
    private JLabel lblPunktnummerWUP;
    private JLabel lblPunktnummerWUPSeparator;
    private JLabel lblTitle;
    private RoundedPanel pnlControls;
    private RoundedPanel pnlDocument;
    private SemiRoundedPanel pnlHeaderDocument;
    private RoundedPanel pnlSimpleAttributes;
    private JPanel pnlTitle;
    private RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private JScrollPane scpBemerkung;
    private SemiRoundedPanel semiRoundedPanel4;
    private Box.Filler strFooter;
    private JToggleButton togPan;
    private JToggleButton togZoom;
    private JTextArea txaBemerkung;
    private JTextField txtDGKBlattnummer;
    private JTextField txtHoeheUeberNHN;
    private JTextField txtHoeheUeberNHN2016;
    private JTextField txtHoeheUeberNN;
    private JTextField txtLagebezeichnung;
    private JTextField txtLaufendeNummer;
    private JTextField txtMessungsjahr;
    private JTextField txtPunktnummerNRW;
    private BindingGroup bindingGroup;

    public NivellementPunktEditor() {
        this(false);
    }

    public NivellementPunktEditor(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.setOpaque(false);
        this.lblMissingRasterdocument.setVisible(false);
        if (this.readOnly) {
            this.txtDGKBlattnummer.setEditable(false);
            this.txtLaufendeNummer.setEditable(false);
            this.txtPunktnummerNRW.setEditable(false);
            this.txtLagebezeichnung.setEditable(false);
            this.cmbLagegenauigkeit.setEditable(false);
            this.cmbLagegenauigkeit.setEnabled(false);
            this.txtHoeheUeberNHN2016.setEditable(false);
            this.txtHoeheUeberNHN.setEditable(false);
            this.txtHoeheUeberNN.setEditable(false);
            this.txtMessungsjahr.setEditable(false);
            this.txaBemerkung.setEditable(false);
            this.cmbFestlegungsart.setEditable(false);
            this.cmbFestlegungsart.setEnabled(false);
            this.lblGeometrie.setVisible(false);
            this.chkHistorisch.setEnabled(false);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.pnlTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.bgrControls = new ButtonGroup();
        this.strFooter = new Box.Filler(new Dimension(0, 22), new Dimension(0, 22), new Dimension(Short.MAX_VALUE, 22));
        this.pnlSimpleAttributes = new RoundedPanel();
        this.txtDGKBlattnummer = new JTextField();
        this.lblHoeheUeberNHN2016 = new JLabel();
        this.txtHoeheUeberNHN2016 = new JTextField();
        this.lblFestlegungsart = new JLabel();
        this.cmbFestlegungsart = new DefaultBindableReferenceCombo();
        this.lblLagebezeichnung = new JLabel();
        this.txtLagebezeichnung = new JTextField();
        this.lblLagegenauigkeit = new JLabel();
        this.cmbLagegenauigkeit = new DefaultBindableReferenceCombo();
        this.lblMessungsjahr = new JLabel();
        this.txtMessungsjahr = new JTextField();
        this.lblPunktnummerNRW = new JLabel();
        this.txtPunktnummerNRW = new JTextField();
        this.lblBemerkung = new JLabel();
        this.scpBemerkung = new JScrollPane();
        this.txaBemerkung = new JTextArea();
        this.lblGeometrie = new JLabel();
        if (!this.readOnly) {
            this.cmbGeometrie = new DefaultCismapGeometryComboBoxEditor();
        }
        this.lblPunktnummerWUP = new JLabel();
        this.lblPunktnummerWUPSeparator = new JLabel();
        this.gluFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.txtLaufendeNummer = new JTextField();
        this.lblHistorisch = new JLabel();
        this.chkHistorisch = new JCheckBox();
        this.gluFillDescription = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.txtHoeheUeberNN = new JTextField();
        this.lblHoeheUeberNN = new JLabel();
        this.txtHoeheUeberNHN = new JTextField();
        this.lblHoeheUeberNHN = new JLabel();
        this.jPanel1 = new JPanel();
        this.pnlDocument = new RoundedPanel();
        this.pnlHeaderDocument = new SemiRoundedPanel();
        this.lblHeaderDocument = new JLabel();
        this.lblMissingRasterdocument = new JLabel();
        this.rasterfariDocumentLoaderPanel1 = new RasterfariDocumentLoaderPanel(ClientAlkisConf.getInstance().getRasterfariUrl(), (RasterfariDocumentLoaderPanel.Listener)this, this.getConnectionContext());
        this.pnlControls = new RoundedPanel();
        this.togPan = new JToggleButton();
        this.togZoom = new JToggleButton();
        this.btnHome = new JButton();
        this.semiRoundedPanel4 = new SemiRoundedPanel();
        this.jLabel3 = new JLabel();
        this.btnOpen = new JButton();
        this.btnReport = new JButton();
        this.gluFillerControls = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlTitle.setOpaque(false);
        this.pnlTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 14));
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.pnlSimpleAttributes.setAlpha(0);
        this.pnlSimpleAttributes.setLayout((LayoutManager)new GridBagLayout());
        this.txtDGKBlattnummer.setPreferredSize(new Dimension(145, 27));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.dgk_blattnummer}"), (Object)this.txtDGKBlattnummer, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtDGKBlattnummer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NivellementPunktEditor.this.txtDGKBlattnummerFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NivellementPunktEditor.this.txtDGKBlattnummerFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtDGKBlattnummer, (Object)gridBagConstraints);
        this.lblHoeheUeberNHN2016.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblHoeheUeberNHN2016.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblHoeheUeberNHN2016, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hoehe_ueber_nhn2016}"), (Object)this.txtHoeheUeberNHN2016, (Property)BeanProperty.create((String)"text"));
        binding.setConverter(CONVERTER_HOEHE);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtHoeheUeberNHN2016, (Object)gridBagConstraints);
        this.lblFestlegungsart.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblFestlegungsart.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblFestlegungsart, (Object)gridBagConstraints);
        this.cmbFestlegungsart.setPreferredSize(new Dimension(145, 27));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.festlegungsart}"), (Object)this.cmbFestlegungsart, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.cmbFestlegungsart, (Object)gridBagConstraints);
        this.lblLagebezeichnung.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblLagebezeichnung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblLagebezeichnung, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.lagebezeichnung}"), (Object)this.txtLagebezeichnung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtLagebezeichnung, (Object)gridBagConstraints);
        this.lblLagegenauigkeit.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblLagegenauigkeit.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblLagegenauigkeit, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.lagegenauigkeit}"), (Object)this.cmbLagegenauigkeit, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.cmbLagegenauigkeit, (Object)gridBagConstraints);
        this.lblMessungsjahr.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblMessungsjahr.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblMessungsjahr, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.messungsjahr}"), (Object)this.txtMessungsjahr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtMessungsjahr, (Object)gridBagConstraints);
        this.lblPunktnummerNRW.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblPunktnummerNRW.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblPunktnummerNRW, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.punktnummer_nrw}"), (Object)this.txtPunktnummerNRW, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtPunktnummerNRW, (Object)gridBagConstraints);
        this.lblBemerkung.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblBemerkung.text"));
        this.lblBemerkung.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblBemerkung, (Object)gridBagConstraints);
        this.txaBemerkung.setColumns(20);
        this.txaBemerkung.setRows(3);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.txaBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBemerkung.setViewportView(this.txaBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.scpBemerkung, (Object)gridBagConstraints);
        this.lblGeometrie.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblGeometrie.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblGeometrie, (Object)gridBagConstraints);
        if (!this.readOnly) {
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geometrie}"), (Object)this.cmbGeometrie, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cmbGeometrie).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (!this.readOnly) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.pnlSimpleAttributes.add((Component)this.cmbGeometrie, (Object)gridBagConstraints);
        }
        this.lblPunktnummerWUP.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblPunktnummerWUP.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblPunktnummerWUP, (Object)gridBagConstraints);
        this.lblPunktnummerWUPSeparator.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblPunktnummerWUPSeparator.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.pnlSimpleAttributes.add((Component)this.lblPunktnummerWUPSeparator, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        this.pnlSimpleAttributes.add((Component)this.gluFiller, (Object)gridBagConstraints);
        this.txtLaufendeNummer.setColumns(3);
        this.txtLaufendeNummer.setPreferredSize(new Dimension(145, 27));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.laufende_nummer}"), (Object)this.txtLaufendeNummer, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.txtLaufendeNummer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NivellementPunktEditor.this.txtLaufendeNummerFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NivellementPunktEditor.this.txtLaufendeNummerFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtLaufendeNummer, (Object)gridBagConstraints);
        this.lblHistorisch.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblHistorisch.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.lblHistorisch, (Object)gridBagConstraints);
        this.chkHistorisch.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.chkHistorisch.text"));
        this.chkHistorisch.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.historisch}"), (Object)this.chkHistorisch, (Property)BeanProperty.create((String)"selected"), (String)"");
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.chkHistorisch, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.pnlSimpleAttributes.add((Component)this.gluFillDescription, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hoehe_ueber_nn}"), (Object)this.txtHoeheUeberNN, (Property)BeanProperty.create((String)"text"));
        binding.setConverter(CONVERTER_HOEHE);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtHoeheUeberNN, (Object)gridBagConstraints);
        this.lblHoeheUeberNN.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblHoeheUeberNN.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pnlSimpleAttributes.add((Component)this.lblHoeheUeberNN, (Object)gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hoehe_ueber_nhn}"), (Object)this.txtHoeheUeberNHN, (Property)BeanProperty.create((String)"text"));
        binding.setConverter(CONVERTER_HOEHE);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSimpleAttributes.add((Component)this.txtHoeheUeberNHN, (Object)gridBagConstraints);
        this.lblHoeheUeberNHN.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblHoeheUeberNHN.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pnlSimpleAttributes.add((Component)this.lblHoeheUeberNHN, (Object)gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.pnlSimpleAttributes.add((Component)this.jPanel1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(8, 0, 10, 0);
        this.add((Component)this.pnlSimpleAttributes, gridBagConstraints);
        this.pnlDocument.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderDocument.setBackground(Color.darkGray);
        this.pnlHeaderDocument.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderDocument.setForeground(Color.white);
        this.lblHeaderDocument.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblHeaderDocument.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlHeaderDocument.add((Component)this.lblHeaderDocument, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        this.pnlDocument.add((Component)this.pnlHeaderDocument, (Object)gridBagConstraints);
        this.lblMissingRasterdocument.setBackground(Color.white);
        this.lblMissingRasterdocument.setHorizontalAlignment(0);
        this.lblMissingRasterdocument.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/missingRasterdocument.png")));
        this.lblMissingRasterdocument.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblMissingRasterdocument.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlDocument.add((Component)this.lblMissingRasterdocument, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlDocument.add((Component)this.rasterfariDocumentLoaderPanel1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        this.add((Component)this.pnlDocument, gridBagConstraints);
        this.pnlControls.setLayout((LayoutManager)new GridBagLayout());
        this.bgrControls.add(this.togPan);
        this.togPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));
        this.togPan.setSelected(true);
        this.togPan.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.togPan.text"));
        this.togPan.setToolTipText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.togPan.toolTipText"));
        this.togPan.setEnabled(false);
        this.togPan.setFocusPainted(false);
        this.togPan.setHorizontalAlignment(2);
        this.togPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NivellementPunktEditor.this.togPanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.pnlControls.add((Component)this.togPan, (Object)gridBagConstraints);
        this.bgrControls.add(this.togZoom);
        this.togZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));
        this.togZoom.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.togZoom.text"));
        this.togZoom.setToolTipText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.togZoom.toolTipText"));
        this.togZoom.setEnabled(false);
        this.togZoom.setFocusPainted(false);
        this.togZoom.setHorizontalAlignment(2);
        this.togZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NivellementPunktEditor.this.togZoomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.pnlControls.add((Component)this.togZoom, (Object)gridBagConstraints);
        this.btnHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));
        this.btnHome.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.btnHome.text"));
        this.btnHome.setToolTipText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.btnHome.toolTipText"));
        this.btnHome.setEnabled(false);
        this.btnHome.setFocusPainted(false);
        this.btnHome.setHorizontalAlignment(2);
        this.btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NivellementPunktEditor.this.btnHomeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlControls.add((Component)this.btnHome, (Object)gridBagConstraints);
        this.semiRoundedPanel4.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel4.setLayout((LayoutManager)new FlowLayout());
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.jLabel3.text"));
        this.semiRoundedPanel4.add((Component)this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlControls.add((Component)this.semiRoundedPanel4, (Object)gridBagConstraints);
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/folder-image.png")));
        this.btnOpen.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.btnOpen.text"));
        this.btnOpen.setToolTipText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.btnOpen.toolTipText"));
        this.btnOpen.setEnabled(false);
        this.btnOpen.setFocusPainted(false);
        this.btnOpen.setHorizontalAlignment(2);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NivellementPunktEditor.this.btnOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.pnlControls.add((Component)this.btnOpen, (Object)gridBagConstraints);
        this.btnReport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/printer.png")));
        this.btnReport.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.btnReport.text"));
        this.btnReport.setFocusPainted(false);
        this.btnReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NivellementPunktEditor.this.btnReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.pnlControls.add((Component)this.btnReport, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.add((Component)this.pnlControls, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.gluFillerControls, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void togPanActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionPan();
    }

    private void togZoomActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionZoom();
    }

    private void btnHomeActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionOverview();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        try {
            if (BillingPopup.doBilling("nivppdf", this.urlOfDocument, (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                this.openDoc(this.urlOfDocument);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void openDoc(final String urlOfDocument) {
        if (urlOfDocument != null) {
            URL url;
            try {
                url = new URL(urlOfDocument);
            }
            catch (MalformedURLException ex) {
                LOG.info((Object)("Couldn't download nivellement point from '" + urlOfDocument + "'."), (Throwable)ex);
                return;
            }
            CismetThreadPool.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)NivellementPunktEditor.this)) {
                        String filename = urlOfDocument.substring(urlOfDocument.lastIndexOf("/") + 1);
                        DownloadManager.instance().add((Download)new HttpDownload(url, "", DownloadManagerDialog.getInstance().getJobName(), "NivP-Beschreibung", filename.substring(0, filename.lastIndexOf(".")), filename.substring(filename.lastIndexOf("."))));
                    }
                }
            });
        }
    }

    private void txtDGKBlattnummerFocusLost(FocusEvent evt) {
        if (this.oldDgkBlattnummer != null && !this.oldDgkBlattnummer.equals(this.txtDGKBlattnummer.getText())) {
            this.refreshImage();
        }
    }

    private void txtLaufendeNummerFocusLost(FocusEvent evt) {
        if (this.oldLaufendeNummer != null && !this.oldLaufendeNummer.equals(this.txtLaufendeNummer.getText())) {
            this.refreshImage();
        }
    }

    private void txtDGKBlattnummerFocusGained(FocusEvent evt) {
        this.oldDgkBlattnummer = this.txtDGKBlattnummer.getText();
    }

    private void txtLaufendeNummerFocusGained(FocusEvent evt) {
        this.oldLaufendeNummer = this.txtLaufendeNummer.getText();
    }

    private void btnReportActionPerformed(ActionEvent evt) {
        try {
            if (BillingPopup.doBilling("nivppdf", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                NivellementPunktAggregationRenderer.downloadReport(Arrays.asList(this.cidsBean), "", "", this.getConnectionContext());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    protected void refreshImage() {
        if (this.currentRefreshDocumentWorker != null && !this.currentRefreshDocumentWorker.isDone()) {
            this.currentRefreshDocumentWorker.cancel(true);
        }
        this.currentRefreshDocumentWorker = new RefreshDocumentWorker();
        CismetThreadPool.execute((Runnable)this.currentRefreshDocumentWorker);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            if (1 == this.cidsBean.getMetaObject().getStatus()) {
                try {
                    this.cidsBean.setProperty("dgk_blattnummer", (Object)"0000");
                    this.cidsBean.setProperty("laufende_nummer", (Object)"000");
                    this.cidsBean.setProperty("historisch", (Object)"false");
                    this.cidsBean.setProperty("hoehe_ueber_nn", (Object)0.0);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Could not set initial properties to new NivellementPunkt", (Throwable)ex);
                }
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)this.cidsBean, (ConnectionContext)this.getConnectionContext());
            this.bindingGroup.bind();
            String dgkBlattnummer = (String)cidsBean.getProperty("dgk_blattnummer");
            String laufendeNummer = (String)cidsBean.getProperty("laufende_nummer");
            this.lblTitle.setText(NbBundle.getMessage(NivellementPunktEditor.class, (String)"NivellementPunktEditor.lblTitle.text") + " " + dgkBlattnummer + AlkisProducts.getFormattedLaufendeNummerNivP((String)laufendeNummer));
            this.refreshImage();
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.rasterfariDocumentLoaderPanel1.dispose();
        if (!this.readOnly) {
            ((DefaultCismapGeometryComboBoxEditor)this.cmbGeometrie).dispose();
        }
    }

    public JComponent getTitleComponent() {
        return this.pnlTitle;
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(0, 5, 0, 5);
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        boolean save = true;
        try {
            Float.valueOf(this.txtHoeheUeberNHN2016.getText().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            save = false;
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die angegebene H\u00f6he ist ung\u00fcltig.", "Fehler aufgetreten", 2);
        }
        try {
            Float.valueOf(this.txtHoeheUeberNN.getText().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            save = false;
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die angegebene historische NN H\u00f6he ist ung\u00fcltig.", "Fehler aufgetreten", 2);
        }
        try {
            Float.valueOf(this.txtHoeheUeberNHN.getText().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            save = false;
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die angegebene historische NHN H\u00f6he ist ung\u00fcltig.", "Fehler aufgetreten", 2);
        }
        if (this.txtDGKBlattnummer.getText() == null || this.txtDGKBlattnummer.getText().trim().length() <= 0) {
            save = false;
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die angegebene DGK-Blattnummer ist ung\u00fcltig.", "Fehler aufgetreten", 2);
        }
        if (this.txtLaufendeNummer.getText() == null || this.txtLaufendeNummer.getText().trim().length() <= 0) {
            save = false;
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die angegebene laufende Nummer ist ung\u00fcltig.", "Fehler aufgetreten", 2);
        }
        return save;
    }

    public JComponent getFooterComponent() {
        return this.strFooter;
    }

    public static void main(String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"sb", (String)"nivellement_punkt", (int)6818, (int)1024, (int)768);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void showMeasureIsLoading() {
    }

    public void showMeasurePanel() {
    }

    class RefreshDocumentWorker
    extends SwingWorker<String, Object> {
        RefreshDocumentWorker() {
        }

        @Override
        protected String doInBackground() throws Exception {
            Collection validDocuments = ClientAlkisProducts.getInstance().getCorrespondingNivPURLs(NivellementPunktEditor.this.txtDGKBlattnummer.getText(), NivellementPunktEditor.this.txtLaufendeNummer.getText());
            String document = null;
            for (String validDocument : validDocuments) {
                try {
                    URL url = ClientAlkisConf.getInstance().getDownloadUrlForDocument(validDocument);
                    if (!WebAccessManager.getInstance().checkIfURLaccessible(url)) continue;
                    document = validDocument;
                    NivellementPunktEditor.this.urlOfDocument = url.toExternalForm();
                    break;
                }
                catch (MissingArgumentException ex) {
                    LOG.warn((Object)("Could not read document from URL '" + validDocument + "'. Skipping this url."), (Throwable)ex);
                }
                catch (AccessMethodIsNotSupportedException ex) {
                    LOG.warn((Object)("Can't access document URL '" + validDocument + "' with default access method. Skipping this url."), (Throwable)ex);
                }
                catch (RequestFailedException ex) {
                    LOG.warn((Object)("Requesting document from URL '" + validDocument + "' failed. Skipping this url."), (Throwable)ex);
                }
                catch (NoHandlerForURLException ex) {
                    LOG.warn((Object)("Can't handle URL '" + validDocument + "'. Skipping this url."), (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("An exception occurred while opening URL '" + validDocument + "'. Skipping this url."), (Throwable)ex);
                }
            }
            if (document == null) {
                LOG.error((Object)"Couldn't get a connection to associated document.");
                NivellementPunktEditor.this.urlOfDocument = null;
            }
            return document;
        }

        @Override
        protected void done() {
            String document = null;
            try {
                if (!this.isCancelled()) {
                    document = (String)this.get();
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Was interrupted while refreshing document.", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.warn((Object)"There was an exception while refreshing document.", (Throwable)ex);
            }
            NivellementPunktEditor.this.rasterfariDocumentLoaderPanel1.reset();
            if (document != null && !this.isCancelled()) {
                boolean billingAllowed = BillingPopup.isBillingAllowed("nivppdf", NivellementPunktEditor.this.getConnectionContext());
                NivellementPunktEditor.this.rasterfariDocumentLoaderPanel1.setVisible(true);
                NivellementPunktEditor.this.lblMissingRasterdocument.setVisible(false);
                NivellementPunktEditor.this.rasterfariDocumentLoaderPanel1.setDocument(document);
                NivellementPunktEditor.this.btnHome.setEnabled(true);
                NivellementPunktEditor.this.btnOpen.setEnabled(billingAllowed);
                NivellementPunktEditor.this.btnReport.setEnabled(billingAllowed);
                NivellementPunktEditor.this.togPan.setEnabled(true);
                NivellementPunktEditor.this.togZoom.setEnabled(true);
            } else {
                NivellementPunktEditor.this.rasterfariDocumentLoaderPanel1.setVisible(false);
                NivellementPunktEditor.this.lblMissingRasterdocument.setVisible(true);
                NivellementPunktEditor.this.btnHome.setEnabled(false);
                NivellementPunktEditor.this.btnOpen.setEnabled(false);
                NivellementPunktEditor.this.btnReport.setEnabled(false);
                NivellementPunktEditor.this.togPan.setEnabled(false);
                NivellementPunktEditor.this.togZoom.setEnabled(false);
            }
        }
    }
}

