/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RasterfariControlPanel
extends JPanel
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(RasterfariControlPanel.class);
    private final RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private ConnectionContext connectionContext;
    private final String downloadName;
    private ButtonGroup bgrControls;
    private JButton btnHome;
    private JButton btnOpen;
    private JPanel jPanel1;
    private JToggleButton togPan;
    private JToggleButton togZoom;

    public RasterfariControlPanel() {
        this(null, null);
    }

    public RasterfariControlPanel(RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1, String downloadName) {
        this.rasterfariDocumentLoaderPanel1 = rasterfariDocumentLoaderPanel1;
        this.downloadName = downloadName;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.bgrControls = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.btnHome = this.rasterfariDocumentLoaderPanel1.getBtnHome();
        this.togPan = this.rasterfariDocumentLoaderPanel1.getTogPan();
        this.togZoom = this.rasterfariDocumentLoaderPanel1.getTogZoom();
        this.btnOpen = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridLayout(0, 1, 0, 5));
        this.btnHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnHome, (String)NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.btnHome.text"));
        this.btnHome.setToolTipText(NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.btnHome.toolTipText"));
        this.bgrControls.add(this.btnHome);
        this.btnHome.setFocusPainted(false);
        this.btnHome.setHorizontalAlignment(2);
        this.btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariControlPanel.this.btnHomeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnHome);
        this.bgrControls.add(this.togPan);
        this.togPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));
        this.togPan.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.togPan, (String)NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.togPan.text"));
        this.togPan.setToolTipText(NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.togPan.toolTipText"));
        this.togPan.setFocusPainted(false);
        this.togPan.setHorizontalAlignment(2);
        this.togPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariControlPanel.this.togPanActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.togPan);
        this.bgrControls.add(this.togZoom);
        this.togZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.togZoom, (String)NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.togZoom.text"));
        this.togZoom.setToolTipText(NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.togZoom.toolTipText"));
        this.togZoom.setFocusPainted(false);
        this.togZoom.setHorizontalAlignment(2);
        this.togZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariControlPanel.this.togZoomActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.togZoom);
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/folder-image.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpen, (String)NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.btnOpen.text"));
        this.btnOpen.setToolTipText(NbBundle.getMessage(RasterfariControlPanel.class, (String)"RasterfariControlPanel.btnOpen.toolTipText"));
        this.bgrControls.add(this.btnOpen);
        this.btnOpen.setFocusPainted(false);
        this.btnOpen.setHorizontalAlignment(2);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterfariControlPanel.this.btnOpenActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnOpen);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void togPanActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionPan();
    }

    private void togZoomActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionZoom();
    }

    private void btnHomeActionPerformed(ActionEvent evt) {
        this.rasterfariDocumentLoaderPanel1.actionOverview();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        try {
            String priceGroup = "ea";
            URL documentUrl = this.rasterfariDocumentLoaderPanel1.getDocumentUrl();
            if (BillingPopup.doBilling("fsuekom", documentUrl.toExternalForm(), (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                this.downloadProduct(documentUrl);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void downloadProduct(final URL url) {
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)RasterfariControlPanel.this)) {
                    String urlString = url.toExternalForm();
                    String filename = urlString.substring(urlString.lastIndexOf("/") + 1);
                    DownloadManager.instance().add((Download)new HttpDownload(url, "", DownloadManagerDialog.getInstance().getJobName(), RasterfariControlPanel.this.getDownloadName(), filename.substring(0, filename.lastIndexOf(".")), filename.substring(filename.lastIndexOf("."))));
                }
            }
        });
    }

    public String getDownloadName() {
        return this.downloadName;
    }
}

