/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.wunda_blau.search.server.Sb_maxBildnummerFetcherServerSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Sb_stadtbildserieEditorAddBildnummerDialog
extends JDialog
implements ConnectionContextProvider {
    private static final Pattern noAlphaSuffixPattern = Pattern.compile(".*[a-zA-Z]$");
    private static final Pattern sixNumbersPattern = Pattern.compile("\\d{6}$");
    public static final String DOMAIN = "WUNDA_BLAU";
    public static final String STADTBILDER_TABLE = "SB_STADTBILD";
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class);
    private final ArrayList<String> bildnummernToAdd = new ArrayList();
    private final HashMap<String, CidsBean> stadtBilderBeans = new HashMap();
    private final BildnummerEvaluationDocumentListener bildnummerEvaluationDocumentListener = new BildnummerEvaluationDocumentListener();
    private ShowWarning showWarning;
    private final ConnectionContext connectionContext;
    private JButton btnCancel;
    private JButton btnOk;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JXBusyLabel lblBusy;
    private JLabel lblWarning;
    private JTextField txtFromBildnummer;
    private JTextField txtTillBildnummer;

    public Sb_stadtbildserieEditorAddBildnummerDialog(Frame parent, boolean modal, ConnectionContext connectionContext) {
        super(parent, modal);
        this.connectionContext = connectionContext;
        this.initComponents();
        new NextBildNummerFetcherWorker().execute();
    }

    private void initComponents() {
        this.txtFromBildnummer = new JTextField();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtTillBildnummer = new JTextField();
        this.lblWarning = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.lblBusy = new JXBusyLabel(new Dimension(20, 20));
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.title"));
        this.setPreferredSize(new Dimension(500, 170));
        this.getContentPane().setLayout(new GridBagLayout());
        this.txtFromBildnummer.setText(NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.txtFromBildnummer.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtFromBildnummer, gridBagConstraints);
        this.txtFromBildnummer.getDocument().addDocumentListener(this.bildnummerEvaluationDocumentListener);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOk, (String)NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.btnOk.text"));
        this.btnOk.setEnabled(false);
        this.btnOk.setPreferredSize(new Dimension(75, 26));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.btnCancel.text"));
        this.btnCancel.setPreferredSize(new Dimension(110, 26));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnCancel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.txtTillBildnummer.setText(NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.txtTillBildnummer.text"));
        this.txtTillBildnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.txtTillBildnummerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtTillBildnummer, gridBagConstraints);
        this.txtTillBildnummer.getDocument().addDocumentListener(this.bildnummerEvaluationDocumentListener);
        Mnemonics.setLocalizedText((JLabel)this.lblWarning, (String)NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.text"));
        this.lblWarning.setPreferredSize(new Dimension(120, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.filler2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblBusy, (String)NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblBusy.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.lblBusy, gridBagConstraints);
        this.pack();
    }

    private void txtTillBildnummerActionPerformed(ActionEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnOkActionPerformed(ActionEvent evt) {
        this.stadtBilderBeans.clear();
        StringBuilder bildnummern = new StringBuilder("'" + this.bildnummernToAdd.get(0) + "'");
        for (int i = 1; i < this.bildnummernToAdd.size(); ++i) {
            bildnummern.append(",");
            bildnummern.append("'").append(this.bildnummernToAdd.get(i)).append("'");
        }
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)DOMAIN, (String)STADTBILDER_TABLE, (ConnectionContext)this.getConnectionContext());
        String query = "SELECT " + mc.getID() + ", " + mc.getPrimaryKey() + " FROM " + mc.getTableName() + " WHERE  bildnummer IN (" + bildnummern + ") order by bildnummer";
        try {
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, DOMAIN, this.getConnectionContext());
            for (MetaObject mo : metaObjects) {
                CidsBean cb = mo.getBean();
                this.stadtBilderBeans.put((String)cb.getProperty("bildnummer"), cb);
            }
            for (String bildnummer : this.bildnummernToAdd) {
                if (this.stadtBilderBeans.containsKey(bildnummer)) continue;
                MetaObject metaObject = mc.getEmptyInstance(this.getConnectionContext());
                metaObject.setStatus(1);
                CidsBean cidsBean = metaObject.getBean();
                try {
                    cidsBean.setProperty("bildnummer", (Object)bildnummer);
                    this.stadtBilderBeans.put(bildnummer, cidsBean);
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
            }
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)ex, (Throwable)ex);
            this.stadtBilderBeans.clear();
        }
        finally {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.stadtBilderBeans.clear();
        this.setVisible(false);
        this.dispose();
    }

    public Collection<CidsBean> showDialog() {
        StaticSwingTools.showDialog((JDialog)this);
        return this.stadtBilderBeans.values();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Sb_stadtbildserieEditorAddBildnummerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Sb_stadtbildserieEditorAddBildnummerDialog dialog = new Sb_stadtbildserieEditorAddBildnummerDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static String greatestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }

    private void showError(String error) {
        if (this.showWarning != null) {
            this.showWarning.stop();
        }
        this.lblWarning.setText(error);
        this.lblWarning.setForeground(Color.red);
        this.btnOk.setEnabled(false);
    }

    private void clearWarningOrError() {
        if (this.showWarning != null) {
            this.showWarning.stop();
        }
        this.lblWarning.setText("");
        this.btnOk.setEnabled(true);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    class NextBildNummerFetcherWorker
    extends SwingWorker<Integer, Void> {
        public NextBildNummerFetcherWorker() {
            Sb_stadtbildserieEditorAddBildnummerDialog.this.txtFromBildnummer.setEnabled(false);
            Sb_stadtbildserieEditorAddBildnummerDialog.this.lblBusy.setVisible(true);
            Sb_stadtbildserieEditorAddBildnummerDialog.this.lblBusy.setBusy(true);
        }

        @Override
        protected Integer doInBackground() throws Exception {
            Sb_maxBildnummerFetcherServerSearch maxBildnummerFetcher = new Sb_maxBildnummerFetcherServerSearch();
            Collection maxBildnummerCollection = SessionManager.getConnection().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)maxBildnummerFetcher, Sb_stadtbildserieEditorAddBildnummerDialog.this.getConnectionContext());
            if (maxBildnummerCollection != null && !maxBildnummerCollection.isEmpty()) {
                ArrayList firstColumnObject = (ArrayList)maxBildnummerCollection.toArray(new Object[1])[0];
                Object firstRowObject = firstColumnObject.get(0);
                return (Integer)firstRowObject;
            }
            return null;
        }

        @Override
        protected void done() {
            Integer maxBildnummer = null;
            try {
                maxBildnummer = (Integer)this.get();
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            if (maxBildnummer != null) {
                String nextBildnummer = Integer.toString(maxBildnummer + 1);
                Sb_stadtbildserieEditorAddBildnummerDialog.this.txtFromBildnummer.setText(nextBildnummer);
            } else {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.txtFromBildnummer.requestFocusInWindow();
            }
            Sb_stadtbildserieEditorAddBildnummerDialog.this.txtFromBildnummer.setEnabled(true);
            Sb_stadtbildserieEditorAddBildnummerDialog.this.lblBusy.setVisible(false);
            Sb_stadtbildserieEditorAddBildnummerDialog.this.lblBusy.setBusy(false);
        }
    }

    class ShowWarning {
        private static final int TIMER_PERIOD = 1000;
        protected static final int MAX_COUNT = 2;
        private int count;
        private Timer timer;

        public ShowWarning(String warning) {
            if (Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning != null) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning.stop();
            }
            Sb_stadtbildserieEditorAddBildnummerDialog.this.lblWarning.setText(warning);
            Sb_stadtbildserieEditorAddBildnummerDialog.this.lblWarning.setForeground(Color.black);
            Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setEnabled(false);
            String text = "Ok (" + (2 - this.count + 1) + ")";
            Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setText(text);
        }

        public void start() {
            this.timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ShowWarning.this.count < 2) {
                        ShowWarning.this.count++;
                        String text = "Ok (" + (2 - ShowWarning.this.count + 1) + ")";
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setText(text);
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setEnabled(false);
                    } else {
                        ((Timer)e.getSource()).stop();
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setEnabled(true);
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setText("Ok");
                    }
                }
            });
            this.timer.start();
        }

        public void stop() {
            Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setText("Ok");
            Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setEnabled(true);
            this.timer.stop();
        }
    }

    private class BildnummerEvaluationDocumentListener
    implements DocumentListener {
        private final Timer timer;

        public BildnummerEvaluationDocumentListener() {
            this.timer = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BildnummerEvaluationDocumentListener.this.evaluateBildnummern();
                }
            });
            this.timer.setRepeats(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.timer.restart();
        }

        private void evaluateBildnummern() {
            String fromBildnummer = Sb_stadtbildserieEditorAddBildnummerDialog.this.txtFromBildnummer.getText().trim();
            String tillBildnummer = Sb_stadtbildserieEditorAddBildnummerDialog.this.txtTillBildnummer.getText().trim();
            if (fromBildnummer.isEmpty()) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.clearWarningOrError();
                Sb_stadtbildserieEditorAddBildnummerDialog.this.btnOk.setEnabled(false);
                return;
            }
            if (tillBildnummer.isEmpty()) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.bildnummernToAdd.clear();
                Sb_stadtbildserieEditorAddBildnummerDialog.this.bildnummernToAdd.add(Sb_stadtbildserieEditorAddBildnummerDialog.this.txtFromBildnummer.getText());
                if (!sixNumbersPattern.matcher(fromBildnummer).matches()) {
                    Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning = new ShowWarning(NbBundle.getMessage(BildnummerEvaluationDocumentListener.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.sixNumbers"));
                    Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning.start();
                } else {
                    Sb_stadtbildserieEditorAddBildnummerDialog.this.clearWarningOrError();
                }
                return;
            }
            if (noAlphaSuffixPattern.matcher(fromBildnummer).matches() || noAlphaSuffixPattern.matcher(tillBildnummer).matches()) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.showError(NbBundle.getMessage(Sb_stadtbildserieEditorAddBildnummerDialog.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.suffixLetter"));
            } else if (fromBildnummer.equalsIgnoreCase(tillBildnummer)) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.showError(NbBundle.getMessage(BildnummerEvaluationDocumentListener.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.equals"));
            } else if (fromBildnummer.length() != tillBildnummer.length()) {
                Sb_stadtbildserieEditorAddBildnummerDialog.this.showError(NbBundle.getMessage(BildnummerEvaluationDocumentListener.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.length"));
            } else {
                int end;
                String prefix = Sb_stadtbildserieEditorAddBildnummerDialog.greatestCommonPrefix(fromBildnummer, tillBildnummer);
                int prefix_length = prefix.length();
                String begin_str = fromBildnummer.substring(prefix_length);
                String end_str = tillBildnummer.substring(prefix_length);
                int begin = Integer.parseInt(begin_str);
                if (begin >= (end = Integer.parseInt(end_str))) {
                    Sb_stadtbildserieEditorAddBildnummerDialog.this.showError(NbBundle.getMessage(BildnummerEvaluationDocumentListener.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.endBiggerThanBegining"));
                } else {
                    String intToStringFormat = "%0" + end_str.length() + "d";
                    Sb_stadtbildserieEditorAddBildnummerDialog.this.bildnummernToAdd.clear();
                    for (int i = begin; i <= end; ++i) {
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.bildnummernToAdd.add(prefix + String.format(intToStringFormat, i));
                    }
                    if (!sixNumbersPattern.matcher(fromBildnummer).matches() || !sixNumbersPattern.matcher(tillBildnummer).matches()) {
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning = new ShowWarning(NbBundle.getMessage(BildnummerEvaluationDocumentListener.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.sixNumbers"));
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning.start();
                    } else if (end - begin > 300) {
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning = new ShowWarning(NbBundle.getMessage(BildnummerEvaluationDocumentListener.class, (String)"Sb_stadtbildserieEditorAddBildnummerDialog.lblWarning.tooBig"));
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.showWarning.start();
                    } else {
                        Sb_stadtbildserieEditorAddBildnummerDialog.this.clearWarningOrError();
                    }
                }
            }
        }
    }
}

