/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.SpstConfProperties;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.custom.wunda_blau.search.server.AdresseLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.FastBindableReferenceCombo;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class SpstAnlageEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
RequestsFullSizeComponent,
PropertyChangeListener {
    private static final MetaClass MC__ART;
    public static final String GEOMTYPE = "Point";
    public static final double GEOM_CHECK_BUFFER_POINT = 500.0;
    public static final double GEOM_CHECK_BUFFER_AREA = 50.0;
    public static final String ADRESSE_TOSTRING_TEMPLATE = "%s";
    public static final String[] ADRESSE_TOSTRING_FIELDS;
    private static final Logger LOG;
    public static final String FIELD__NAME = "name";
    public static final String FIELD__STRASSE_SCHLUESSEL = "fk_strasse.strassenschluessel";
    public static final String FIELD__STRASSE = "fk_strasse";
    public static final String FIELD__STRASSE_GEOREFERENZ = "fk_strasse.bsa_bbox";
    public static final String FIELD__HNR = "fk_adresse";
    public static final String FIELD__HNR_GEOREFERENZ = "fk_adresse.umschreibendes_rechteck";
    public static final String FIELD__HAUSNUMMER = "hausnummer";
    public static final String FIELD__ID = "id";
    public static final String FIELD__VEROEFFENTLICHT = "to_publish";
    public static final String FIELD__UEBERPRUEFT = "ueberprueft";
    public static final String FIELD__ORT = "ort";
    public static final String FIELD__PLZ = "plz";
    public static final String FIELD__GEOREFERENZ = "fk_geom";
    public static final String FIELD__ART = "fk_art";
    public static final String FIELD__STRASSE_NAME = "name";
    public static final String FIELD__STRASSE_KEY = "strassenschluessel";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_NAME = "spst_anlage";
    public static final String TABLE_GEOM = "geom";
    public static final String BUNDLE_NONAME = "SpstAnlageEditor.isOkForSaving().noName";
    public static final String BUNDLE_NOORT = "SpstAnlageEditor.isOkForSaving().noOrt";
    public static final String BUNDLE_NOPLZ = "SpstAnlageEditor.isOkForSaving().noPlz";
    public static final String BUNDLE_WRONGPLZ = "SpstAnlageEditor.isOkForSaving().wrongPlz";
    public static final String BUNDLE_NOART = "SpstAnlageEditor.isOkForSaving().noArt";
    public static final String BUNDLE_NOSTREET = "SpstAnlageEditor.isOkForSaving().noStrasse";
    public static final String BUNDLE_NOGEOM = "SpstAnlageEditor.isOkForSaving().noGeom";
    public static final String BUNDLE_GEOMOKAY = "SpstAnlageEditor.isOkForSaving().GeomNotOkay";
    public static final String BUNDLE_WRONGGEOM = "SpstAnlageEditor.isOkForSaving().wrongGeom";
    public static final String BUNDLE_PANE_PREFIX = "SpstAnlageEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "SpstAnlageEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "SpstAnlageEditor.isOkForSaving().JOptionPane.title";
    private static final String TITLE_NEW_ANLAGE = "eine neue Sportanlage anlegen...";
    private final AdresseLightweightSearch hnrSearch = new AdresseLightweightSearch(AdresseLightweightSearch.Subject.HNR, "%s", ADRESSE_TOSTRING_FIELDS);
    private CidsBean beanHNr;
    private final ActionListener hnrActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JList<Object> pop = ((ComboPopup)((Object)SpstAnlageEditor.this.cbHNr.getUI().getAccessibleChild((JComponent)SpstAnlageEditor.this.cbHNr, 0))).getList();
            JTextField txt = (JTextField)SpstAnlageEditor.this.cbHNr.getEditor().getEditorComponent();
            Object selectedValue = pop.getSelectedValue();
            txt.setText(selectedValue != null ? String.valueOf(selectedValue) : "");
        }
    };
    private final boolean editor;
    private SwingWorker worker_geom;
    private Boolean geomOkay = false;
    JComboBox<String> cbArt;
    private JComboBox cbGeom;
    private FastBindableReferenceCombo cbHNr;
    FastBindableReferenceCombo cbStrasse;
    JCheckBox chUeberprueft;
    JCheckBox chVeroeffentlicht;
    private Box.Filler filler3;
    private JFormattedTextField ftxtPlz;
    private JLabel lblArt;
    private JLabel lblBemerkung;
    private JLabel lblGeom;
    private JLabel lblHNrRenderer;
    private JLabel lblHnr;
    private JLabel lblKarte;
    private JLabel lblName;
    private JLabel lblOrt;
    private JLabel lblPlz;
    private JLabel lblStrasse;
    private JLabel lblUeberprueft;
    private JLabel lblVeroeffentlich;
    private JPanel panBemerkung;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFiller;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel panZusatz;
    private RoundedPanel rpKarte;
    private JScrollPane scpBemerkung;
    private SemiRoundedPanel semiRoundedPanel7;
    private JTextArea taBemerkung;
    private JTextField txtName;
    private JTextField txtOrt;
    private BindingGroup bindingGroup;

    public SpstAnlageEditor() {
        this(true);
    }

    public SpstAnlageEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        if (this.isEditor()) {
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cbHNr);
        }
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panContent = new RoundedPanel();
        this.panDaten = new JPanel();
        this.lblPlz = new JLabel();
        this.ftxtPlz = new JFormattedTextField();
        this.lblGeom = new JLabel();
        if (this.isEditor()) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setAllowedGeometryTypes(new Class[]{Point.class});
        }
        this.lblStrasse = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblHnr = new JLabel();
        if (this.isEditor()) {
            this.cbHNr = new FastBindableReferenceCombo((LightweightMetaObjectsSearch)this.hnrSearch, this.hnrSearch.getRepresentationPattern(), this.hnrSearch.getRepresentationFields());
        }
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.panZusatz = new JPanel();
        this.lblBemerkung = new JLabel();
        this.panBemerkung = new JPanel();
        this.scpBemerkung = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.panFiller = new JPanel();
        this.cbStrasse = new FastBindableReferenceCombo();
        if (!this.isEditor()) {
            this.lblHNrRenderer = new JLabel();
        }
        this.lblArt = new JLabel();
        this.lblUeberprueft = new JLabel();
        this.chUeberprueft = new JCheckBox();
        this.lblVeroeffentlich = new JLabel();
        this.chVeroeffentlicht = new JCheckBox();
        this.cbArt = new DefaultBindableReferenceCombo(MC__ART);
        this.lblOrt = new JLabel();
        this.txtOrt = new JTextField();
        this.rpKarte = new RoundedPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.lblKarte = new JLabel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.setLayout(new GridBagLayout());
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblPlz.setFont(new Font("Tahoma", 1, 11));
        this.lblPlz.setText("Plz:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblPlz, gridBagConstraints);
        this.ftxtPlz.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#####"))));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.plz}"), (Object)this.ftxtPlz, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.ftxtPlz, gridBagConstraints);
        this.lblGeom.setFont(new Font("Tahoma", 1, 11));
        this.lblGeom.setText("Geometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblGeom, gridBagConstraints);
        if (this.isEditor()) {
            if (this.editor) {
                this.cbGeom.setFont(new Font("Dialog", 0, 12));
            }
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panDaten.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.lblStrasse.setFont(new Font("Tahoma", 1, 11));
        this.lblStrasse.setText("Stra\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblStrasse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler3, gridBagConstraints);
        this.lblHnr.setFont(new Font("Tahoma", 1, 11));
        this.lblHnr.setText("Hausnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHnr, gridBagConstraints);
        if (this.isEditor()) {
            this.cbHNr.setMaximumRowCount(20);
            this.cbHNr.setEnabled(false);
            this.cbHNr.setMinimumSize(new Dimension(100, 19));
            this.cbHNr.setPreferredSize(new Dimension(100, 19));
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_adresse}"), (Object)this.cbHNr, (Property)BeanProperty.create((String)"selectedItem"));
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panDaten.add((Component)this.cbHNr, gridBagConstraints);
        }
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblName, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtName, gridBagConstraints);
        this.panZusatz.setOpaque(false);
        this.panZusatz.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panZusatz, gridBagConstraints);
        this.lblBemerkung.setFont(new Font("Tahoma", 1, 11));
        this.lblBemerkung.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblBemerkung, gridBagConstraints);
        this.panBemerkung.setOpaque(false);
        this.panBemerkung.setLayout(new GridBagLayout());
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setLineWrap(true);
        this.taBemerkung.setRows(2);
        this.taBemerkung.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBemerkung.setViewportView(this.taBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBemerkung.add((Component)this.scpBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panBemerkung, gridBagConstraints);
        this.panFiller.setMinimumSize(new Dimension(20, 0));
        this.panFiller.setOpaque(false);
        GroupLayout panFillerLayout = new GroupLayout(this.panFiller);
        this.panFiller.setLayout(panFillerLayout);
        panFillerLayout.setHorizontalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        panFillerLayout.setVerticalGroup(panFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.panDaten.add((Component)this.panFiller, gridBagConstraints);
        this.cbStrasse.setMaximumRowCount(20);
        this.cbStrasse.setModel((ComboBoxModel)new LoadModelCb());
        this.cbStrasse.setNullable(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_strasse}"), (Object)this.cbStrasse, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbStrasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpstAnlageEditor.this.cbStrasseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.cbStrasse, gridBagConstraints);
        if (!this.isEditor()) {
            this.lblHNrRenderer.setFont(new Font("Dialog", 0, 12));
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_adresse.hausnummer}"), (Object)this.lblHNrRenderer, (Property)BeanProperty.create((String)"text"));
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (!this.isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipady = 10;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            this.panDaten.add((Component)this.lblHNrRenderer, gridBagConstraints);
        }
        this.lblArt.setFont(new Font("Tahoma", 1, 11));
        this.lblArt.setText("Art:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblArt, gridBagConstraints);
        this.lblUeberprueft.setFont(new Font("Tahoma", 1, 11));
        this.lblUeberprueft.setText("\u00dcberpr\u00fcft:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblUeberprueft, gridBagConstraints);
        this.chUeberprueft.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ueberprueft}"), (Object)this.chUeberprueft, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.chUeberprueft, gridBagConstraints);
        this.lblVeroeffentlich.setFont(new Font("Tahoma", 1, 11));
        this.lblVeroeffentlich.setText("Ver\u00f6ffentlicht:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.panDaten.add((Component)this.lblVeroeffentlich, gridBagConstraints);
        this.chVeroeffentlicht.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.to_publish}"), (Object)this.chVeroeffentlicht, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.chVeroeffentlicht, gridBagConstraints);
        this.cbArt.setFont(new Font("Dialog", 0, 12));
        this.cbArt.setMaximumRowCount(15);
        this.cbArt.setPreferredSize(new Dimension(100, 24));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_art}"), this.cbArt, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add(this.cbArt, gridBagConstraints);
        this.lblOrt.setFont(new Font("Tahoma", 1, 11));
        this.lblOrt.setText("Ort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblOrt, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ort}"), (Object)this.txtOrt, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtOrt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panContent.add((Component)this.panDaten, gridBagConstraints);
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.lblKarte.setForeground(new Color(255, 255, 255));
        this.lblKarte.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.lblKarte, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        this.panPreviewMap.setPreferredSize(new Dimension(500, 250));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panContent.add((Component)this.rpKarte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void cbStrasseActionPerformed(ActionEvent evt) {
        if (this.isEditor() && this.getCidsBean() != null && this.getCidsBean().getProperty(FIELD__STRASSE_SCHLUESSEL) != null) {
            this.cbHNr.setSelectedItem(null);
            this.cbHNr.setEnabled(true);
            this.refreshHnr();
        }
    }

    public boolean isEditor() {
        return this.editor;
    }

    private void refreshHnr() {
        String schluessel;
        if (this.getCidsBean() != null && this.getCidsBean().getProperty(FIELD__STRASSE_SCHLUESSEL) != null && (schluessel = this.getCidsBean().getProperty(FIELD__STRASSE_SCHLUESSEL).toString()) != null) {
            this.hnrSearch.setKeyId(Integer.valueOf(Integer.parseInt(schluessel.replaceFirst("0*", ""))));
            this.hnrSearch.setKeyId(Integer.valueOf(Integer.parseInt(schluessel)));
            this.initComboboxHnr();
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor()) {
                this.cbHNr.removeActionListener(this.hnrActionListener);
                if (this.getCidsBean() != null) {
                    LOG.info((Object)("remove propchange spst_anlage: " + this.getCidsBean()));
                    this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("add propchange spst_anlage: " + this.getCidsBean()));
                this.getCidsBean().addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.setMapWindow();
            this.bindingGroup.bind();
            if (this.isEditor()) {
                this.checkGeom();
                if (this.getCidsBean() != null && this.getCidsBean().getProperty(FIELD__STRASSE) != null) {
                    this.cbHNr.setEnabled(true);
                } else {
                    this.cbHNr.setEnabled(false);
                }
                this.cbHNr.addActionListener(this.hnrActionListener);
                this.refreshHnr();
            }
            this.setTitle(this.getTitle());
            try {
                if (this.getCidsBean().getPrimaryKeyValue() == -1) {
                    this.getCidsBean().setProperty(FIELD__VEROEFFENTLICHT, (Object)false);
                    this.getCidsBean().setProperty(FIELD__UEBERPRUEFT, (Object)false);
                    this.getCidsBean().setProperty(FIELD__ORT, (Object)"Wuppertal");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"default values not set", (Throwable)ex);
            }
            this.beanHNr = (CidsBean)this.getCidsBean().getProperty(FIELD__HNR);
        }
        catch (Exception ex) {
            LOG.error((Object)"Bean not set", (Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            this.lblGeom.setVisible(this.isEditor());
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtOrt);
            RendererTools.makeReadOnly(this.ftxtPlz);
            RendererTools.makeReadOnly(this.cbArt);
            RendererTools.makeReadOnly((JComponent)this.cbHNr);
            RendererTools.makeReadOnly((JComponent)this.cbStrasse);
            RendererTools.makeReadOnly(this.taBemerkung);
            RendererTools.makeReadOnly(this.cbGeom);
            RendererTools.makeReadOnly(this.chUeberprueft);
            RendererTools.makeReadOnly(this.chVeroeffentlicht);
        }
    }

    public void setMapWindow() {
        CidsBean cb = this.getCidsBean();
        try {
            String mapUrl = null;
            try {
                mapUrl = SpstConfProperties.getInstance().getUrlKarte();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Get no conf properties.", (Throwable)ex);
            }
            if (cb.getProperty(FIELD__GEOREFERENZ) != null) {
                this.panPreviewMap.initMap(cb, FIELD__GEOREFERENZ__GEO_FIELD, 20.0, mapUrl);
            } else {
                int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
                BoundingBox initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
                Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();
                MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_GEOM, (ConnectionContext)this.getConnectionContext());
                CidsBean newGeom = geomMetaClass.getEmptyInstance(this.getConnectionContext()).getBean();
                newGeom.setProperty(FIELD__GEO_FIELD, (Object)centerPoint);
                this.panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, 20.0, mapUrl);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Can't load Overview.", (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE_NAME, (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_ANLAGE;
        }
        return this.getCidsBean().toString();
    }

    public void dispose() {
        if (this.isEditor()) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
            this.cbHNr.removeAll();
            if (this.getCidsBean() != null) {
                LOG.info((Object)("remove propchange spst_anlage: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.cbHNr.removeActionListener(this.hnrActionListener);
        }
        this.bindingGroup.unbind();
        super.dispose();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "<Error>";
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(FIELD__GEOREFERENZ)) {
            this.setMapWindow();
            this.checkGeom();
        }
        if (evt.getPropertyName().equals(FIELD__HNR)) {
            this.checkGeom();
        }
        if (evt.getPropertyName().equals(FIELD__STRASSE)) {
            this.checkGeom();
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_NONAME));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.getCidsBean().getProperty(FIELD__ART) == null) {
                LOG.warn((Object)"No art specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_NOART));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Art not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (!this.getGeomOkay().booleanValue()) {
                LOG.warn((Object)"geom not okay. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_GEOMOKAY));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"geom not okay.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.cbStrasse.getSelectedItem() == null) {
                LOG.warn((Object)"No strasse specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_NOSTREET));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"strasse not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.getCidsBean().getProperty(FIELD__GEOREFERENZ) == null) {
                LOG.warn((Object)"No geom specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_NOGEOM));
                save = false;
            } else {
                CidsBean geom_pos = (CidsBean)this.getCidsBean().getProperty(FIELD__GEOREFERENZ);
                if (!((Geometry)geom_pos.getProperty(FIELD__GEO_FIELD)).getGeometryType().equals(GEOMTYPE)) {
                    LOG.warn((Object)"Wrong geom specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_WRONGGEOM));
                    save = false;
                }
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.txtOrt.getText().trim().isEmpty()) {
                LOG.warn((Object)"No ort specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_NOORT));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Ort not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.ftxtPlz.getText().trim().isEmpty()) {
                LOG.warn((Object)"No plz specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_NOPLZ));
                save = false;
            } else if (this.getCidsBean().getProperty(FIELD__PLZ).toString().length() != 5) {
                LOG.warn((Object)"Wrong plz specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_WRONGPLZ));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"PLZ not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(SpstAnlageEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public boolean checkPointInsidePolygon(Point midpoint, Geometry geomArea) {
        return midpoint.intersects(geomArea);
    }

    private void checkNearBy(final Geometry adressGeom, final Point sportPoint) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return SpstAnlageEditor.this.checkPointInsidePolygon(sportPoint, adressGeom);
            }

            @Override
            protected void done() {
                try {
                    Boolean result = (Boolean)this.get();
                    if (!this.isCancelled()) {
                        SpstAnlageEditor.this.setGeomOkay(result);
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.warn((Object)"problem in Worker: check NearBy.", (Throwable)ex);
                }
            }
        };
        if (this.worker_geom != null) {
            this.worker_geom.cancel(true);
        }
        this.worker_geom = worker;
        this.worker_geom.execute();
    }

    private void checkGeom() {
        Point sportPoint = null;
        Geometry adressGeom = null;
        Double bufferHnr = 500.0;
        Double bufferStr = 50.0;
        try {
            bufferHnr = SpstConfProperties.getInstance().getBufferHnr();
            bufferStr = SpstConfProperties.getInstance().getBufferStr();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Get no conf properties.", (Throwable)ex);
        }
        try {
            CidsBean geom_pos;
            if (this.getCidsBean().getProperty(FIELD__GEOREFERENZ) != null && ((Geometry)(geom_pos = (CidsBean)this.getCidsBean().getProperty(FIELD__GEOREFERENZ)).getProperty(FIELD__GEO_FIELD)).getGeometryType().equals(GEOMTYPE)) {
                sportPoint = (Point)this.getCidsBean().getProperty(FIELD__GEOREFERENZ__GEO_FIELD);
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom for Check not given.", (Throwable)ex);
        }
        try {
            CidsBean geom_hnr;
            if (this.getCidsBean().getProperty(FIELD__HNR) != null) {
                geom_hnr = (CidsBean)this.getCidsBean().getProperty(FIELD__HNR_GEOREFERENZ);
                adressGeom = ((Geometry)geom_hnr.getProperty(FIELD__GEO_FIELD)).buffer(bufferHnr.doubleValue());
            } else if (this.getCidsBean().getProperty(FIELD__STRASSE) != null) {
                geom_hnr = (CidsBean)this.getCidsBean().getProperty(FIELD__STRASSE_GEOREFERENZ);
                adressGeom = ((Geometry)geom_hnr.getProperty(FIELD__GEO_FIELD)).buffer(bufferStr.doubleValue());
            }
            if (sportPoint != null && adressGeom != null) {
                this.checkNearBy(adressGeom, sportPoint);
            } else {
                this.setGeomOkay(false);
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom for Check not given.", (Throwable)ex);
        }
    }

    private void initComboboxHnr() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                SpstAnlageEditor.this.cbHNr.refreshModel();
                return null;
            }

            @Override
            protected void done() {
            }
        }.execute();
    }

    public Boolean getGeomOkay() {
        return this.geomOkay;
    }

    public void setGeomOkay(Boolean geomOkay) {
        this.geomOkay = geomOkay;
    }

    static {
        ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)SpstAnlageEditor.class.getSimpleName());
        MC__ART = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"SPST_ART", (ConnectionContext)connectionContext);
        ADRESSE_TOSTRING_FIELDS = new String[]{AdresseLightweightSearch.Subject.HNR.toString()};
        LOG = Logger.getLogger(SpstAnlageEditor.class);
    }

    class MustSetModelCb
    extends DefaultComboBoxModel {
        public MustSetModelCb() {
            super(new String[]{"Die Daten bitte zuweisen......"});
        }
    }

    class LoadModelCb
    extends DefaultComboBoxModel {
        public LoadModelCb() {
            super(new String[]{"Die Daten werden geladen......"});
        }
    }

    class RegexPatternFormatter
    extends DefaultFormatter {
        protected Matcher fillingMatcher;
        protected Matcher matchingMatcher;
        private Object lastValid = null;

        RegexPatternFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.lastValid = null;
                return null;
            }
            this.fillingMatcher.reset(string);
            if (!this.fillingMatcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String value = (String)super.stringToValue(string);
            this.matchingMatcher.reset(string);
            if (this.matchingMatcher.matches()) {
                this.lastValid = value;
            }
            return value;
        }

        public Object getLastValid() {
            return this.lastValid;
        }
    }
}

