/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.wunda_blau.search.server.RedundantObjectSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.BeforeSavingHook;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class UaFirmaEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
BeforeSavingHook,
SaveVetoable,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(UaFirmaEditor.class);
    public static final String REDUNDANT_TOSTRING_TEMPLATE = "%s";
    public static final String[] REDUNDANT_TOSTRING_FIELDS = new String[]{"name", "id"};
    public static final String REDUNDANT_TABLE = "ua_firma";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__ID = "id";
    public static final String TABLE_NAME = "ua_firma";
    public static final String FIELD__TEL = "telefon";
    public static final String BUNDLE_NONAME = "UaFirmaEditor.isOkForSaving().noName";
    public static final String BUNDLE_DUPLICATENAME = "UaFirmaEditor.isOkForSaving().duplicateName";
    public static final String BUNDLE_PANE_PREFIX = "UaFirmaEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "UaFirmaEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "UaFirmaEditor.isOkForSaving().JOptionPane.title";
    private static String TITLE_NEW_FIRMA = "eine neue Firma anlegen...";
    public static final Pattern TEL_FILLING_PATTERN = Pattern.compile("(|\\+(-|[0-9])*)");
    public static final Pattern TEL_MATCHING_PATTERN = Pattern.compile("\\+[0-9]{1,3}(-[0-9]+){1,}");
    private Boolean redundantName = false;
    private final boolean editor;
    private final RegexPatternFormatter telPatternFormatter = new RegexPatternFormatter(TEL_FILLING_PATTERN, TEL_MATCHING_PATTERN);
    private JFormattedTextField ftxtVTelefon;
    private JLabel lblAdresse;
    private JLabel lblAnsprechpartner;
    private JLabel lblName;
    private JLabel lblTelefon;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panName;
    private JTextField txtAdresse;
    private JTextField txtAnsprechpartner;
    private JTextField txtName;
    private BindingGroup bindingGroup;

    public UaFirmaEditor() {
        this(true);
    }

    public UaFirmaEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void beforeSaving() {
        RedundantObjectSearch firmaSearch = new RedundantObjectSearch(REDUNDANT_TOSTRING_TEMPLATE, REDUNDANT_TOSTRING_FIELDS, null, "ua_firma");
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add("name ilike '" + this.txtName.getText().trim() + "'");
        conditions.add("id <> " + this.getCidsBean().getProperty(FIELD__ID));
        firmaSearch.setWhere(conditions);
        try {
            this.redundantName = !SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)firmaSearch, this.getConnectionContext()).isEmpty();
        }
        catch (ConnectionException e) {
            LOG.warn((Object)"problem in check name Firma: load values.", (Throwable)e);
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(UaFirmaEditor.class, (String)BUNDLE_NONAME));
                save = false;
            } else if (this.redundantName.booleanValue()) {
                LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(UaFirmaEditor.class, (String)BUNDLE_DUPLICATENAME));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(UaFirmaEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(UaFirmaEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(UaFirmaEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panName = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblAdresse = new JLabel();
        this.txtAdresse = new JTextField();
        this.lblAnsprechpartner = new JLabel();
        this.txtAnsprechpartner = new JTextField();
        this.lblTelefon = new JLabel();
        this.ftxtVTelefon = new JFormattedTextField(this.telPatternFormatter);
        this.panFillerUnten1 = new JPanel();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtName, gridBagConstraints);
        this.lblAdresse.setFont(new Font("Tahoma", 1, 11));
        this.lblAdresse.setText("Adresse:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblAdresse, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.adresse}"), (Object)this.txtAdresse, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtAdresse, gridBagConstraints);
        this.lblAnsprechpartner.setFont(new Font("Tahoma", 1, 11));
        this.lblAnsprechpartner.setText("Ansprechpartner:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblAnsprechpartner, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.ansprechpartner}"), (Object)this.txtAnsprechpartner, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtAnsprechpartner, gridBagConstraints);
        this.lblTelefon.setFont(new Font("Tahoma", 1, 11));
        this.lblTelefon.setText("Telefon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblTelefon, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.telefon}"), (Object)this.ftxtVTelefon, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        this.ftxtVTelefon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                UaFirmaEditor.this.ftxtVTelefonFocusLost(evt);
            }
        });
        this.ftxtVTelefon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UaFirmaEditor.this.ftxtVTelefonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.ftxtVTelefon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void ftxtVTelefonFocusLost(FocusEvent evt) {
        this.refreshValidTel();
    }

    private void ftxtVTelefonActionPerformed(ActionEvent evt) {
        this.refreshValidTel();
    }

    private void refreshValidTel() {
        this.ftxtVTelefon.setValue(this.telPatternFormatter.getLastValid());
    }

    private void saveValidTel(Object okValue) {
        this.telPatternFormatter.setLastValid(okValue);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (cb != null) {
                DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            }
            this.bindingGroup.bind();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error setCidsBean.", (Throwable)ex);
        }
        this.saveValidTel(String.valueOf(this.cidsBean.getProperty(FIELD__TEL)));
    }

    private boolean isEditor() {
        return this.editor;
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtAdresse);
            RendererTools.makeReadOnly(this.txtAnsprechpartner);
            RendererTools.makeReadOnly(this.ftxtVTelefon);
        }
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_FIRMA;
        }
        return this.getCidsBean().toString();
    }

    public void setTitle(String string) {
    }

    class RegexPatternFormatter
    extends DefaultFormatter {
        protected Matcher fillingMatcher;
        protected Matcher matchingMatcher;
        private Object lastValid = null;

        public RegexPatternFormatter(Pattern fillingRegex, Pattern matchingRegex) {
            this.setOverwriteMode(false);
            this.fillingMatcher = fillingRegex.matcher("");
            this.matchingMatcher = matchingRegex.matcher("");
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.lastValid = null;
                return null;
            }
            this.fillingMatcher.reset(string);
            if (!this.fillingMatcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String value = (String)super.stringToValue(string);
            this.matchingMatcher.reset(string);
            if (this.matchingMatcher.matches()) {
                this.lastValid = value;
            }
            return value;
        }

        public Object getLastValid() {
            return this.lastValid;
        }

        public void setLastValid(Object okValue) {
            if (this.lastValid == null && !okValue.equals("null")) {
                this.lastValid = okValue;
            }
        }
    }
}

