/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.VermessungFlurstueckFinder;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class VermessungFlurstueckSelectionDialog
extends JDialog
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VermessungFlurstueckSelectionDialog.class);
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{"Wird geladen..."});
    private static final DefaultComboBoxModel NO_SELECTION_MODEL = new DefaultComboBoxModel<Object>(new Object[0]);
    private static final String CB_EDITED_ACTION_COMMAND = "comboBoxEdited";
    private List<CidsBean> currentListToAdd;
    private final boolean usedInEditor;
    private final ConnectionContext connectionContext;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnOK;
    private JComboBox cboFlur;
    private JComboBox cboFlurstueck;
    private JComboBox cboGemarkung;
    private JComboBox cmbVeraenderungsart;
    private JLabel lblFlur;
    private JLabel lblFlurstueck;
    private JLabel lblGemarkung;
    private JLabel lblGemarkungsname;
    private JLabel lblVeraenderungsart;
    private JPanel pnlContainer;
    private JPanel pnlControls;
    private JSeparator sepControls;

    public VermessungFlurstueckSelectionDialog() {
        this(true, ConnectionContext.createDeprecated());
    }

    public VermessungFlurstueckSelectionDialog(final boolean usedInEditor, ConnectionContext connectionContext) {
        this.usedInEditor = usedInEditor;
        this.connectionContext = connectionContext;
        this.setTitle("Bitte Flurst\u00fcck ausw\u00e4hlen");
        this.initComponents();
        this.setSize(419, 144);
        ListCellRenderer lcr = new ListCellRenderer(){
            DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = (JLabel)this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof LightweightMetaObject) {
                    LightweightMetaObject metaObject = (LightweightMetaObject)value;
                    result.setText(String.valueOf(metaObject.getLWAttribute("gemarkung")) + " - " + String.valueOf(metaObject.getLWAttribute("name")));
                }
                return result;
            }
        };
        this.cboGemarkung.setRenderer(lcr);
        CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cboGemarkung, true){

            @Override
            protected ComboBoxModel doInBackground() throws Exception {
                return new DefaultComboBoxModel<MetaObject>(VermessungFlurstueckFinder.getLWGemarkungen(VermessungFlurstueckSelectionDialog.this.getConnectionContext()));
            }

            @Override
            protected void done() {
                super.done();
                VermessungFlurstueckSelectionDialog.this.cboGemarkung.setSelectedIndex(0);
                VermessungFlurstueckSelectionDialog.this.cboGemarkung.requestFocusInWindow();
                ObjectRendererUtils.selectAllTextInEditableCombobox(VermessungFlurstueckSelectionDialog.this.cboGemarkung);
            }
        });
        CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cmbVeraenderungsart, false){

            @Override
            protected ComboBoxModel doInBackground() throws Exception {
                DefaultComboBoxModel<MetaObject> result = new DefaultComboBoxModel<MetaObject>(VermessungFlurstueckFinder.getVeraenderungsarten(VermessungFlurstueckSelectionDialog.this.getConnectionContext()));
                if (!usedInEditor) {
                    result.insertElementAt((MetaObject)"Alle", 0);
                }
                return result;
            }

            @Override
            protected void done() {
                super.done();
                VermessungFlurstueckSelectionDialog.this.cmbVeraenderungsart.setSelectedIndex(0);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        this.checkOkEnableState();
        super.setVisible(b);
    }

    public void setCurrentListToAdd(List<CidsBean> currentListToAdd) {
        this.currentListToAdd = currentListToAdd;
    }

    public List<CidsBean> getCurrentListToAdd() {
        return this.currentListToAdd;
    }

    private void initComponents() {
        this.pnlContainer = new JPanel();
        this.cboGemarkung = new JComboBox();
        this.pnlControls = new JPanel();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.btnApply = new JButton();
        this.cboFlur = new JComboBox(NO_SELECTION_MODEL);
        this.cboFlurstueck = new JComboBox(NO_SELECTION_MODEL);
        this.lblGemarkung = new JLabel();
        this.lblFlur = new JLabel();
        this.lblFlurstueck = new JLabel();
        this.lblGemarkungsname = new JLabel();
        this.sepControls = new JSeparator();
        this.lblVeraenderungsart = new JLabel();
        this.cmbVeraenderungsart = new JComboBox();
        this.setMinimumSize(new Dimension(419, 154));
        this.pnlContainer.setMaximumSize(new Dimension(250, 180));
        this.pnlContainer.setMinimumSize(new Dimension(250, 180));
        this.pnlContainer.setPreferredSize(new Dimension(250, 180));
        this.pnlContainer.setLayout(new GridBagLayout());
        this.cboGemarkung.setEditable(true);
        this.cboGemarkung.setMaximumSize(new Dimension(100, 18));
        this.cboGemarkung.setMinimumSize(new Dimension(100, 18));
        this.cboGemarkung.setPreferredSize(new Dimension(100, 18));
        this.cboGemarkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungFlurstueckSelectionDialog.this.cboGemarkungActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.cboGemarkung, gridBagConstraints);
        this.pnlControls.setLayout(new GridBagLayout());
        this.btnCancel.setText("Abbrechen");
        this.btnCancel.setToolTipText("Eingaben nicht \u00fcbernehmen und Dialog schlie\u00dfen");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungFlurstueckSelectionDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlControls.add((Component)this.btnCancel, gridBagConstraints);
        this.btnOK.setText("OK");
        this.btnOK.setToolTipText("Eingaben \u00fcbernehmen und Dialog schlie\u00dfen");
        this.btnOK.setMaximumSize(new Dimension(85, 23));
        this.btnOK.setMinimumSize(new Dimension(85, 23));
        this.btnOK.setPreferredSize(new Dimension(85, 23));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungFlurstueckSelectionDialog.this.btnOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlControls.add((Component)this.btnOK, gridBagConstraints);
        this.btnApply.setText("\u00dcbernehmen");
        this.btnApply.setToolTipText("Eingaben \u00fcbernehmen und Dialog ge\u00f6ffnet lassen");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungFlurstueckSelectionDialog.this.btnApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlControls.add((Component)this.btnApply, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.pnlControls, gridBagConstraints);
        this.cboFlur.setEditable(true);
        this.cboFlur.setEnabled(false);
        this.cboFlur.setMaximumSize(new Dimension(100, 18));
        this.cboFlur.setMinimumSize(new Dimension(100, 18));
        this.cboFlur.setPreferredSize(new Dimension(100, 18));
        this.cboFlur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungFlurstueckSelectionDialog.this.cboFlurActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlContainer.add((Component)this.cboFlur, gridBagConstraints);
        this.cboFlurstueck.setEditable(true);
        this.cboFlurstueck.setEnabled(false);
        this.cboFlurstueck.setMaximumSize(new Dimension(100, 18));
        this.cboFlurstueck.setMinimumSize(new Dimension(100, 18));
        this.cboFlurstueck.setPreferredSize(new Dimension(100, 18));
        this.cboFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungFlurstueckSelectionDialog.this.cboFlurstueckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.cboFlurstueck, gridBagConstraints);
        this.lblGemarkung.setText("Gemarkung");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.lblGemarkung, gridBagConstraints);
        this.lblFlur.setText("Flur");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.lblFlur, gridBagConstraints);
        this.lblFlurstueck.setText("Flurst\u00fcck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.lblFlurstueck, gridBagConstraints);
        this.lblGemarkungsname.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.lblGemarkungsname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlContainer.add((Component)this.sepControls, gridBagConstraints);
        this.lblVeraenderungsart.setText("Ver\u00e4nderungsart");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.lblVeraenderungsart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlContainer.add((Component)this.cmbVeraenderungsart, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlContainer, "Center");
    }

    private void cboGemarkungActionPerformed(ActionEvent evt) {
        Object selection = this.cboGemarkung.getSelectedItem();
        this.cboFlurstueck.setEnabled(false);
        this.btnOK.setEnabled(false);
        if (selection instanceof LightweightMetaObject) {
            LightweightMetaObject metaObject = (LightweightMetaObject)selection;
            final String gemarkung = String.valueOf(selection);
            CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cboFlur, CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())){

                @Override
                protected ComboBoxModel doInBackground() throws Exception {
                    return new DefaultComboBoxModel<MetaObject>(VermessungFlurstueckFinder.getLWFlure(gemarkung, VermessungFlurstueckSelectionDialog.this.getConnectionContext()));
                }
            });
            String gemarkungsname = String.valueOf(metaObject.getLWAttribute("name"));
            this.lblGemarkungsname.setText("(" + gemarkungsname + ")");
            this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.WHITE);
        } else {
            int foundBeanIndex = ObjectRendererUtils.findComboBoxItemForString(this.cboGemarkung, String.valueOf(selection));
            if (foundBeanIndex < 0) {
                if (this.usedInEditor) {
                    this.cboFlur.setModel(new DefaultComboBoxModel());
                    try {
                        Integer.parseInt(String.valueOf(selection));
                        this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.YELLOW);
                        this.cboFlur.setEnabled(true);
                        if (CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())) {
                            this.cboFlur.requestFocusInWindow();
                        }
                    }
                    catch (NumberFormatException notANumberEx) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(selection + " is not a number!"), (Throwable)notANumberEx);
                        }
                        this.cboFlur.setEnabled(false);
                        this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.RED);
                        this.lblGemarkungsname.setText("(Ist keine Zahl)");
                    }
                    this.lblGemarkungsname.setText(" ");
                } else {
                    this.cboGemarkung.getEditor().getEditorComponent().setBackground(Color.RED);
                    this.cboFlur.setEnabled(false);
                }
            } else {
                this.cboGemarkung.setSelectedIndex(foundBeanIndex);
                this.cboFlur.getEditor().getEditorComponent().setBackground(Color.WHITE);
                this.cboFlurstueck.getEditor().getEditorComponent().setBackground(Color.WHITE);
            }
        }
        this.checkOkEnableState();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.cancelHook();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.apply(false);
    }

    public void okHook() {
    }

    public void cancelHook() {
    }

    private void checkOkEnableState() {
        this.btnOK.setEnabled(this.cboFlurstueck.getSelectedItem() instanceof MetaObject);
    }

    private void cboFlurActionPerformed(ActionEvent evt) {
        Object selection = this.cboFlur.getSelectedItem();
        if (selection instanceof MetaObject) {
            final String gemarkung = String.valueOf(this.cboGemarkung.getSelectedItem());
            final StringBuffer flur = new StringBuffer(String.valueOf(this.cboFlur.getSelectedItem()));
            while (flur.length() < 3) {
                flur.insert(0, 0);
            }
            this.btnOK.setEnabled(false);
            this.cboFlur.getEditor().getEditorComponent().setBackground(Color.WHITE);
            CismetThreadPool.execute((Runnable)new AbstractFlurstueckComboModelWorker(this.cboFlurstueck, CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())){

                @Override
                protected ComboBoxModel doInBackground() throws Exception {
                    return new DefaultComboBoxModel<MetaObject>(VermessungFlurstueckFinder.getLWFurstuecksZaehlerNenner(gemarkung, flur.toString(), VermessungFlurstueckSelectionDialog.this.getConnectionContext()));
                }
            });
        } else {
            String userInput = String.valueOf(selection);
            while (userInput.length() < 3) {
                userInput = "0" + userInput;
            }
            int foundBeanIndex = ObjectRendererUtils.findComboBoxItemForString(this.cboFlur, userInput);
            if (foundBeanIndex < 0) {
                if (this.usedInEditor) {
                    this.cboFlur.getEditor().getEditorComponent().setBackground(Color.YELLOW);
                    this.cboFlurstueck.setModel(new DefaultComboBoxModel());
                    this.cboFlurstueck.setEnabled(true);
                    if (CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())) {
                        this.cboFlurstueck.requestFocusInWindow();
                        this.cboFlurstueck.setSelectedIndex(0);
                    }
                } else {
                    this.cboFlur.getEditor().getEditorComponent().setBackground(Color.RED);
                    this.cboFlurstueck.setModel(new DefaultComboBoxModel());
                    this.cboFlurstueck.setEnabled(false);
                }
            } else {
                this.cboFlur.setSelectedIndex(foundBeanIndex);
                this.cboFlurstueck.getEditor().getEditorComponent().setBackground(Color.WHITE);
            }
        }
        this.checkOkEnableState();
    }

    private void cboFlurstueckActionPerformed(ActionEvent evt) {
        this.btnOK.setEnabled(this.checkFlurstueckSelectionComplete());
        if (CB_EDITED_ACTION_COMMAND.equals(evt.getActionCommand())) {
            this.btnOK.requestFocusInWindow();
        }
        Component editor = this.cboFlurstueck.getEditor().getEditorComponent();
        if (this.cboFlurstueck.getSelectedItem() instanceof MetaObject) {
            editor.setBackground(Color.WHITE);
        } else {
            int foundBeanIndex;
            String flurstueck = String.valueOf(this.cboFlurstueck.getSelectedItem());
            if (!flurstueck.contains("/")) {
                flurstueck = flurstueck + "/0";
                if (editor instanceof JTextField) {
                    ((JTextField)editor).setText(flurstueck);
                }
            }
            if ((foundBeanIndex = ObjectRendererUtils.findComboBoxItemForString(this.cboFlurstueck, flurstueck)) < 0) {
                if (this.usedInEditor) {
                    this.cboFlurstueck.getEditor().getEditorComponent().setBackground(Color.YELLOW);
                } else {
                    this.cboFlurstueck.getEditor().getEditorComponent().setBackground(Color.RED);
                }
            } else {
                this.cboFlurstueck.setSelectedIndex(foundBeanIndex);
            }
        }
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        this.apply(true);
    }

    private boolean checkFlurstueckSelectionComplete() {
        if (this.cboFlur.isEnabled() && this.cboFlurstueck.isEnabled()) {
            Object flur = this.cboFlur.getSelectedItem();
            Object flurstueck = this.cboFlurstueck.getSelectedItem();
            if (flur != null && flurstueck != null && (this.usedInEditor || flurstueck instanceof MetaObject) && flur.toString().length() > 0 && flurstueck.toString().length() > 0) {
                return true;
            }
        }
        return false;
    }

    private CidsBean landParcelBeanFromComboBoxes(String zaehlerNenner) {
        int result = 0;
        try {
            HashMap<String, Object> newLandParcelProperties = new HashMap<String, Object>();
            String gemarkung = String.valueOf(this.cboGemarkung.getSelectedItem());
            String flur = String.valueOf(this.cboFlur.getSelectedItem());
            if (flur.length() != 3) {
                result = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Das neue Flurst\u00fcck entspricht nicht der Namenskonvention: Flur sollte dreistellig sein (mit f\u00fchrenden Nullen, z.B. 007). Datensatz trotzdem abspeichern?", "Warnung: Format", 0, 2);
            }
            if (result == 0) {
                MetaObject gemarkungMetaObject;
                String[] zaehlerNennerParts = zaehlerNenner.split("/");
                String zaehler = zaehlerNennerParts[0];
                String nenner = "0";
                if (zaehlerNennerParts.length == 2) {
                    nenner = zaehlerNennerParts[1];
                }
                if ((gemarkungMetaObject = VermessungFlurstueckFinder.getLWGemarkung(Integer.valueOf(gemarkung), this.getConnectionContext())) == null || gemarkungMetaObject.getBean() == null) {
                    LOG.error((Object)("Gemarkung '" + gemarkung + "' could not be found in teh cids system. Can't add this flurstueck."));
                    return null;
                }
                newLandParcelProperties.put("gemarkung", gemarkungMetaObject.getBean());
                newLandParcelProperties.put("flur", flur);
                newLandParcelProperties.put("zaehler", zaehler);
                newLandParcelProperties.put("nenner", nenner);
                MetaObject[] searchResult = VermessungFlurstueckFinder.getLWLandparcel(gemarkung, flur, zaehler, nenner, this.getConnectionContext());
                if (searchResult != null && searchResult.length > 0) {
                    return searchResult[0].getBean();
                }
                return CidsBeanSupport.createNewCidsBeanFromTableName("vermessung_flurstueck_kicker", newLandParcelProperties, this.getConnectionContext());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not find or create the landparcel corresponding to user's input.", (Throwable)ex);
        }
        return null;
    }

    private void apply(boolean visible) throws HeadlessException {
        int result;
        Object flurstueck = this.cboFlurstueck.getSelectedItem();
        Object veraenderungsart = this.cmbVeraenderungsart.getSelectedItem();
        CidsBean flurstueckBean = null;
        if (flurstueck instanceof LightweightMetaObject) {
            flurstueckBean = ((LightweightMetaObject)flurstueck).getBean();
        } else if (flurstueck instanceof String && this.usedInEditor && (result = JOptionPane.showConfirmDialog(this, "Das Flurst\u00fcck befindet sich nicht im Datenbestand der aktuellen Flurst\u00fccke. Soll es als historisch angelegt werden?", "Historisches Flurst\u00fcck anlegen", 0)) == 0 && 1 == (flurstueckBean = this.landParcelBeanFromComboBoxes(flurstueck.toString())).getMetaObject().getStatus()) {
            try {
                flurstueckBean = flurstueckBean.persist(this.getConnectionContext());
            }
            catch (Exception ex) {
                LOG.error((Object)"Could not persist new flurstueck.", (Throwable)ex);
                flurstueckBean = null;
            }
        }
        CidsBean veraenderungsartBean = null;
        if (veraenderungsart instanceof LightweightMetaObject) {
            veraenderungsartBean = ((LightweightMetaObject)veraenderungsart).getBean();
        }
        CidsBean flurstuecksvermessung = null;
        if (!(flurstueckBean == null || this.usedInEditor && veraenderungsartBean == null)) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("flurstueck", flurstueckBean);
            if (veraenderungsartBean != null) {
                properties.put("veraenderungsart", veraenderungsartBean);
            }
            try {
                flurstuecksvermessung = CidsBeanSupport.createNewCidsBeanFromTableName("vermessung_flurstuecksvermessung", properties, this.getConnectionContext());
            }
            catch (Exception ex) {
                LOG.error((Object)"Could not add new flurstueck or flurstuecksvermessung.", (Throwable)ex);
            }
        }
        if (flurstuecksvermessung != null && this.currentListToAdd != null) {
            int position = Collections.binarySearch(this.currentListToAdd, flurstuecksvermessung, AlphanumComparator.getInstance());
            if (position < 0) {
                this.currentListToAdd.add(-position - 1, flurstuecksvermessung);
            } else {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(VermessungFlurstueckSelectionDialog.class, (String)"VermessungFlurstueckSelectionDialog.apply(boolean).itemAlreadyExists.message"), NbBundle.getMessage(VermessungFlurstueckSelectionDialog.class, (String)"VermessungFlurstueckSelectionDialog.apply(boolean).itemAlreadyExists.title"), 2);
                return;
            }
        }
        this.okHook();
        this.setVisible(visible);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    abstract class AbstractFlurstueckComboModelWorker
    extends SwingWorker<ComboBoxModel, Void> {
        private final JComboBox box;
        private final boolean switchToBox;

        public AbstractFlurstueckComboModelWorker(JComboBox box, boolean switchToBox) {
            this.box = box;
            this.switchToBox = switchToBox;
            box.setVisible(true);
            box.setEnabled(false);
            box.setModel(WAIT_MODEL);
        }

        @Override
        protected void done() {
            try {
                this.box.setModel((ComboBoxModel)this.get());
                if (this.switchToBox) {
                    this.box.requestFocus();
                }
            }
            catch (InterruptedException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"There was an interruption while loading the values.", (Throwable)ex);
                }
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"An error occurred while loading the values.", (Throwable)ex);
            }
            finally {
                this.box.setEnabled(true);
                this.box.setSelectedIndex(0);
                ObjectRendererUtils.selectAllTextInEditableCombobox(this.box);
                VermessungFlurstueckSelectionDialog.this.checkOkEnableState();
            }
        }
    }
}

