/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.custom.objecteditors.wunda_blau.AbstractVermessungEditor;
import de.cismet.cids.custom.objectrenderer.utils.VermessungPictureFinderClientUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class VermessungGewannenEditor
extends AbstractVermessungEditor {
    private static final Logger LOG = Logger.getLogger(VermessungGewannenEditor.class);
    private JComboBox cmbGemarkung;
    private JComboBox cmbGeometrie;
    private JComboBox cmbGeometrieStatus;
    private Box.Filler gluGeneralInformationGap;
    private JLabel lblFlur;
    private JLabel lblGemarkung;
    private JLabel lblGeometrie;
    private JLabel lblGeometrieStatus;
    private JPanel panInformation;
    private JTextField txtKmquadrat;
    private BindingGroup bindingGroup;

    public VermessungGewannenEditor() {
        this(false);
    }

    public VermessungGewannenEditor(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.initComponents();
        super.initWithConnectionContext(connectionContext);
        if (this.isReadOnly()) {
            this.getGeneralInformationPanel().setVisible(false);
            this.cmbGeometrieStatus.setEditable(false);
            this.cmbGeometrieStatus.setEnabled(false);
            this.txtKmquadrat.setEditable(false);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panInformation = new JPanel();
        this.lblGeometrieStatus = new JLabel();
        this.cmbGeometrieStatus = new DefaultBindableReferenceCombo();
        this.lblGeometrie = new JLabel();
        if (!this.isReadOnly()) {
            this.cmbGeometrie = new DefaultCismapGeometryComboBoxEditor();
        }
        this.gluGeneralInformationGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.lblGemarkung = new JLabel();
        this.cmbGemarkung = new DefaultBindableReferenceCombo();
        this.lblFlur = new JLabel();
        this.txtKmquadrat = new JTextField();
        this.panInformation.setOpaque(false);
        this.panInformation.setLayout(new GridBagLayout());
        this.lblGeometrieStatus.setText(NbBundle.getMessage(VermessungGewannenEditor.class, (String)"VermessungGewannenEditor.lblGeometrieStatus.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panInformation.add((Component)this.lblGeometrieStatus, gridBagConstraints);
        this.cmbGeometrieStatus.setRenderer(new AbstractVermessungEditor.GeometrieStatusRenderer(this.cmbGeometrieStatus.getRenderer()));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geometrie_status}"), (Object)this.cmbGeometrieStatus, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cmbGeometrieStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VermessungGewannenEditor.this.cmbGeometrieStatusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 7);
        this.panInformation.add((Component)this.cmbGeometrieStatus, gridBagConstraints);
        this.lblGeometrie.setText(NbBundle.getMessage(VermessungGewannenEditor.class, (String)"VermessungGewannenEditor.lblGeometrie.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panInformation.add((Component)this.lblGeometrie, gridBagConstraints);
        if (!this.isReadOnly()) {
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.geometrie}"), (Object)this.cmbGeometrie, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cmbGeometrie).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (!this.isReadOnly()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            this.panInformation.add((Component)this.cmbGeometrie, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.panInformation.add((Component)this.gluGeneralInformationGap, gridBagConstraints);
        this.lblGemarkung.setLabelFor(this.cmbGemarkung);
        this.lblGemarkung.setText(NbBundle.getMessage(VermessungGewannenEditor.class, (String)"VermessungGewannenEditor.lblGemarkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panInformation.add((Component)this.lblGemarkung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gemarkung}"), (Object)this.cmbGemarkung, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panInformation.add((Component)this.cmbGemarkung, gridBagConstraints);
        this.lblFlur.setText(NbBundle.getMessage(VermessungGewannenEditor.class, (String)"VermessungGewannenEditor.lblFlur.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panInformation.add((Component)this.lblFlur, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.flur}"), (Object)this.txtKmquadrat, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 7);
        this.panInformation.add((Component)this.txtKmquadrat, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void cmbGeometrieStatusActionPerformed(ActionEvent evt) {
        CidsBean geometrieStatus;
        if (this.cmbGeometrieStatus.getSelectedItem() instanceof CidsBean && (geometrieStatus = (CidsBean)this.cmbGeometrieStatus.getSelectedItem()).getProperty("id") instanceof Integer) {
            this.cmbGeometrieStatus.setBackground((Color)COLORS_GEOMETRIE_STATUS.get((Integer)geometrieStatus.getProperty("id")));
        }
    }

    @Override
    protected String getDocumentFilename() {
        CidsBean cidsBean = this.getCidsBean();
        Boolean liste = (Boolean)cidsBean.getProperty("liste");
        Integer gemarkung = (Integer)cidsBean.getProperty("gemarkung.id");
        Integer kmquadrat = (Integer)cidsBean.getProperty("kmquadrat");
        return VermessungPictureFinderClientUtils.getGewannePictureFilename(liste != false ? gemarkung : kmquadrat, liste);
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        super.setCidsBean(cidsBean);
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.getConnectionContext());
            this.bindingGroup.bind();
            if (cidsBean.getProperty("geometrie_status") instanceof CidsBean && cidsBean.getProperty("geometrie_status.id") instanceof Integer) {
                this.cmbGeometrieStatus.setBackground((Color)COLORS_GEOMETRIE_STATUS.get((Integer)cidsBean.getProperty("geometrie_status.id")));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.bindingGroup.unbind();
        if (!this.isReadOnly()) {
            ((DefaultCismapGeometryComboBoxEditor)this.cmbGeometrie).dispose();
        }
    }

    @Override
    protected String generateTitle() {
        CidsBean cidsBean = this.getCidsBean();
        Integer kmquadrat = (Integer)cidsBean.getProperty("kmquadrat");
        String gemarkung = (String)cidsBean.getProperty("gemarkung.name");
        Boolean liste = (Boolean)cidsBean.getProperty("liste");
        if (Boolean.TRUE.equals(liste)) {
            return "Gemarkung " + (gemarkung != null ? gemarkung : "unbekannt");
        }
        return "\u1e31m-Quadrat " + (kmquadrat != null ? Integer.toString(kmquadrat) : "unbekannt");
    }

    @Override
    protected JPanel getInformationPanel() {
        return this.panInformation;
    }

    @Override
    protected String getVermessungName() {
        return "Gewanne";
    }

    @Override
    protected String findPicture() {
        CidsBean cidsBean = this.getCidsBean();
        Integer gemarkung = (Integer)cidsBean.getProperty("gemarkung.id");
        Integer kmquadrat = (Integer)cidsBean.getProperty("kmquadrat");
        Boolean liste = (Boolean)cidsBean.getProperty("liste");
        return VermessungPictureFinderClientUtils.findGewannePicture(liste != false ? gemarkung : kmquadrat, liste);
    }
}

